#include <QDir>
#include <QFileInfo>
#include <QMessageBox>
#include "pGIKObrowserParser.h"
#include "pGIKOacquiredParser.h"
#include "bbsTableParser.h"
#include "datFileUtil.h"

/*!
 *  RXgN^
 * 
 */
pGIKObrowserParser::pGIKObrowserParser()
 : mpBbsTableParser(0), mBbsTable(0), mLogPath(0)
{
    // ł͉Ȃ
}


/*!
 *  fXgN^
 * 
 */
pGIKObrowserParser::~pGIKObrowserParser()
{
    // ł͉Ȃ
}

/*!
 *   uEÛ̖
 * 
 */
QString pGIKObrowserParser::getBrowserName(void)
{
    QString name = "pGIKO";
    return (name);
}

/*!
 *   ǗpX̎w...
 * 
 */
void pGIKObrowserParser::setPath(QString &arPath)
{
    mLogPath = arPath;
}

/*!
 *   bbstable.html̎w...
 * 
 */
void pGIKObrowserParser::setBbsTable(bbsTableParser *apBbsTable, QString &arBbsTable)
{
    // BBS̓NX
    mpBbsTableParser = apBbsTable;

    // bbstable.html
    mBbsTable = arBbsTable;
}

/*!
 *   ͂̏...
 * 
 */    
bool pGIKObrowserParser::prepare(void)
{
    mDatNickName.clear();
    mDatFilePath.clear();
    mDatFileName.clear();
    mIdxFilePath.clear();
    mIdxTitle.clear();
    mIdxReadNumber.clear();
    mAcquiredNickName.clear();
    mAcquiredFileName.clear();
    clearAcquiredParser();

    bool ret = checkDirectory(mLogPath);
    return (ret);
}

/*!
 *   ͂̏(fBNg@...)
 * 
 */    
bool pGIKObrowserParser::checkDirectory(QString &arPath)
{
    QDir targetDir(arPath);
    QFileInfoList fileList = targetDir.entryInfoList();
    for (QFileInfoList::const_iterator ite = fileList.constBegin(); ite != fileList.constEnd(); ite++)
    {
        QFileInfo fileInfo = (*ite);
        if (fileInfo.isDir() == true)
        {
            QString filePath = fileInfo.absoluteFilePath();
            if (filePath.endsWith(".") != true)
            {
                checkDirectory(filePath);
            }
        }
        if (fileInfo.isFile() == true)
        {
            QString filePath = fileInfo.absolutePath();
            QString fileName = fileInfo.fileName();
            QString suffix   = fileInfo.suffix();
            if (suffix == "dat")
            {
                int pos  = filePath.lastIndexOf("/dat");
                int pos2 = filePath.lastIndexOf("/", (pos - 1));
                QString nickName = filePath.mid((pos2 + 1), (pos - pos2));
                mDatNickName.append(nickName);
                mDatFilePath.append(filePath);
                mDatFileName.append(fileName);
            }

            // ۂMR̃OǗf[^t@C...
            if (fileName == "acquired.txt")
            {
                QString idxFile = filePath + "/acquired.txt";
                int pos = filePath.lastIndexOf("/");
                QString nickName = filePath.mid(pos + 1) + "/";
                parseIndexFile(nickName, idxFile);
            }
        }
    }
    return (true);
}

/*!
 *  ۂMR̖ǈʒuǗt@C̓ǂݏo...
 * 
 * 
 */
void pGIKObrowserParser::parseIndexFile(QString &arNickName, QString &arFileName)
{
//    QMessageBox::information(0, "Info(index File)", arNickName + " | " + arFileName, QMessageBox::Ok);
    pGIKOacquiredParser *parser = new pGIKOacquiredParser();
    parser->parseFile(arFileName);

    mAcquiredNickName.append(arNickName);
    mAcquiredFileName.append(arFileName);
    mAcquiredParser.append(parser);

    return;
}

/*!
 * 
 * 
 */
int pGIKObrowserParser::datFileCount(void)
{
    return (mDatFilePath.size());
}

/*!
 *   ǗOdatt@C`FbN
 * 
 */
int  pGIKObrowserParser::checkUnmanagedDatFile(void)
{
    return (0);
}

/*!
 *   ǗOdatt@C擾
 * 
 */
QString pGIKObrowserParser::getUnmanagedDatFileName(int aIndex)
{
    return ("");
}

/*!
 *   ǗOdatNick擾
 * 
 */
QString pGIKObrowserParser::getUnmanagedDatNickName(int aIndex)
{
    return ("");
}

/*!
 *   datt@C(full path)𐶐
 * 
 */
QString pGIKObrowserParser::getFullPathDatFileName(QString &arNick, QString &arFileName)
{
    QString nick = arNick;
    nick.replace("/", "");
    QString pathName = mpBbsTableParser->getUrl(nick);
    pathName.replace("http:/", "");

    QString datName = mLogPath + pathName + "dat/" + arFileName;
    return (datName);
}

/*!
 *   datt@C(full path)𐶐
 * 
 */
QString pGIKObrowserParser::getReceiveDatFileName(QString &arNick, QString &arFileName)
{
    QString nick = arNick;
    nick.replace("/", "");

    QString pathName = mpBbsTableParser->getUrl(nick);
    pathName.replace("http:/", "");

    QString fileName = arFileName;
    int pos = arFileName.indexOf(".");
    fileName = arFileName.left(pos);

    QDir path(mLogPath);
    path.mkpath(mLogPath + pathName + "dat/");

    QString datName = mLogPath + pathName + "dat/" + fileName + ".dat";
    return (datName);
}

/*!
 *  datt@C擾
 * 
 */
QString pGIKObrowserParser::getDatFileName(int aIndex)
{
    if ((aIndex < 0)||(aIndex >= mDatFileName.size()))
    {
        return ("");
    }
    return (mDatFileName[aIndex]);    
}

/*!
 *  Nick擾
 * 
 */
QString pGIKObrowserParser::getBoardNick(int aIndex)
{
    if ((aIndex < 0)||(aIndex >= mDatFilePath.size()))
    {
        return ("");
    }
    QString filePath = mDatFilePath[aIndex];
    filePath.replace(QRegExp("/dat$"), "");
    int pos = filePath.lastIndexOf(QRegExp("[\\\\/]"));  // '\'  '/' Ƀ}b`...
    pos++;
    return (filePath.mid(pos) + "/");    
}

/*!
 *  ǈʒu̎擾
 * 
 */
int  pGIKObrowserParser::getReadPoint(int aIndex)
{
    if ((aIndex < 0)||(aIndex >= mDatFilePath.size()))
    {
        return (1);
    }
    QString nickName = mDatNickName[aIndex];
    int limit = mAcquiredNickName.size();
    for (int loop = 0; loop < limit; loop++)
    {
        if (mAcquiredNickName[loop] == nickName)
        {
            int index = (mAcquiredParser[loop])->exists(mDatFileName[aIndex]);
            if (index < 0)
            {
                return (1);
            }
            return ((mAcquiredParser[loop])->getCurrentMessage(index));
        }
    }
    return (1);
}

/*
 *   subject.txt̃t@C(full path)擾
 * 
 */
QString pGIKObrowserParser::getSubjectTxtFilePath(QString &arNick)
{
    QString nick = arNick;
    nick.replace("/", "");

    QString pathName = mpBbsTableParser->getUrl(nick);
    pathName.replace("http:/", "");

    QString datName = mLogPath + pathName + "subject.txt";
    return (datName);
}

/*!
 *  ŏIXVԂ̎擾
 * 
 */
qint64 pGIKObrowserParser::getLastUpdate(int aIndex)
{
    // ۂMR͊ǗĂȂ...0B
    return (0);
}

/*!
 *   datt@CM
 * 
 */
bool pGIKObrowserParser::receiveDatFile(QString &arNick, QString &arFile, QString &arDst, QString &arSrc, bool isSame, int aReadPoint, qint64 aLastUpdate)
{
//    QMessageBox::information(0, "Info(entry File)", arNick + " | " + arFile, QMessageBox::Ok);

    // t@Cړ
    datFileUtil util;
    util.moveDatFile(arSrc, isSame, arDst, true);

    // ǗXV
    return (updateInformations(arNick, arFile, arDst, arSrc, isSame, aReadPoint, aLastUpdate));
}

/*!
 *   datt@CRs[
 * 
 */
bool pGIKObrowserParser::copyDatFile(QString &arNick, QString &arFile, QString &arDst, QString &arSrc, bool isSame, int aReadPoint, qint64 aLastUpdate)
{
//    QMessageBox::information(0, "Info(copy File)", arNick + " | " + arFile + " - ", QMessageBox::Ok);

    // t@CRs[
    datFileUtil util;
    util.copyDatFile(arSrc, isSame, arDst, true);

    // ǗXV
    return (updateInformations(arNick, arFile, arDst, arSrc, isSame, aReadPoint, aLastUpdate));
}

/*!
 *   ǗXV
 * 
 */
bool pGIKObrowserParser::updateInformations(QString &arNick, QString &arFile, QString &arDst, QString &arSrc, bool isSame, int aReadPoint, qint64 aLastUpdate)
{
    // t@C擾
    datFileUtil datFileUtility;
    QString path = getReceiveDatFileName(arNick, arFile);
    QString target = "/" + arFile;
    path.replace(target, "");
    QString title = datFileUtility.pickupDatFileTitle(path, arFile);
    int    nofMsg = datFileUtility.checkResCount(path, arFile);

    pGIKOacquiredParser *parser = 0;
    int index = -1;
    int limit = mAcquiredNickName.size();
    for (int loop = 0; loop < limit; loop++)
    {
        if (mAcquiredNickName[loop] == arNick)
        {
            // łI
            parser = mAcquiredParser[loop];
            if (parser != 0)
            {
                index = parser->exists(arFile);

            }
            if (index >= 0)
            {
                // o^ς...XV
                parser->setCurrentMessage(index, aReadPoint);
                parser->setNofMessage(index, nofMsg);
            }
            break;
        }
    }

    if (index < 0)
    {
        if (parser == 0)
        {
            // acquired.txtǉ
            path   = getReceiveDatFileName(arNick, arFile);
            target = "dat/" + arFile;
            path.replace(target, "acquired.txt");
            parser = new pGIKOacquiredParser();
            parser->parseFile(path);
            mAcquiredNickName.append(arNick);
            mAcquiredFileName.append(path);
            mAcquiredParser.append(parser);
        }

        // ACeǉo^
        parser->appendData(arFile, title, nofMsg, aReadPoint);
    }
    return (true);
}

/*!
 *   Ƃ܂s (acquired.txt o͂...)
 * 
 */
bool pGIKObrowserParser::finalize(void)
{
   int limit = mAcquiredParser.size();
   for (int loop = 0; loop < limit; loop++)
   {
        mAcquiredParser[loop]->outputFile();
   }
   return (true);
}

/*!
 *   pGIKOacquiredParserNA
 * 
 */
void pGIKObrowserParser::clearAcquiredParser(void)
{
   int limit = mAcquiredParser.size();
   for (int loop = limit; loop > 0; loop--)
   {
        delete mAcquiredParser[loop];
   }    
   mAcquiredParser.clear();
   
   return;
}

/*
 *  a2BC : a2B Connectivity
 *  Copyright (C) 2006- NNsi Project
 *  (see a2BC-src.txt for detail.)
 */
