#ifndef PGIKOBROWSERPARSER_H
#define PGIKOBROWSERPARSER_H
#include <QString>
#include <QVector>
#include "a2BC_AbstractOtherBrowserParser.h"
#include "pGIKOacquiredParser.h"

/*
 * ۂMR̃f[^̓NX...
 * 
 */
class QString;
class bbsTableParser;
class pGIKObrowserParser : public a2BC_AbstractOtherBrowserParser
{

public:
    pGIKObrowserParser();
    virtual ~pGIKObrowserParser();

public:
    virtual QString getBrowserName(void);          // uEU
    virtual void setPath(QString &arPath);         // Oi[fBNg(̃[gfBNg)ݒ
    virtual void setBbsTable(bbsTableParser *apBbsTable, QString &arBbsTable); // BBSTABLE.HTML(Ƃꗗt@C)̊Ǘt@Cw
    virtual bool prepare(void);                   // Of[^̏BBB
    virtual int  datFileCount(void);              // Of[^

    virtual int     checkUnmanagedDatFile(void);                 // ǗOdatt@C`FbN
    virtual QString getUnmanagedDatFileName(int aIndex);       // ǗOdatt@C擾
    virtual QString getUnmanagedDatNickName(int aIndex);       // ǗOdatjbNl[擾
    virtual QString getFullPathDatFileName(QString &arNick, QString &arFileName);  // datt@C𐶐
    virtual QString getReceiveDatFileName(QString &arNick, QString &arFileName);   // Mpdatt@C𐶐
    virtual QString getDatFileName(int aIndex);                // datt@C擾
    virtual QString getBoardNick(int aIndex);                  // datt@C݂̑nick擾
    virtual bool isSameLogFormat(void) {return (true); };   // OtH[}bga2BƓH
    virtual int  getReadPoint(int aIndex);                    // ǂ񂾏ꏊ
    virtual qint64 getLastUpdate(int aIndex);                  // ŏIXVԂ擾

    virtual QString getSubjectTxtFilePath(QString &arNick);         // subject.txt̃t@C(full path)擾
    virtual bool receiveDatFile(QString &arNick, QString &arFile, QString &arDst, QString &arSrc, bool isSame, int aReadPoint, qint64 aLastUpdate);  // datt@CM
    virtual bool copyDatFile(QString &arNick, QString &arFile, QString &arDst, QString &arSrc, bool isSame, int aReadPoint, qint64 aLastUpdate);  // datt@CM
    virtual bool finalize(void);                             // nBBB

private:
    bool checkDirectory(QString &arPath);
    void parseIndexFile(QString &arNickName, QString &arFileName);
    void clearAcquiredParser(void);
    bool updateInformations(QString &arNick, QString &arFile, QString &arDst, QString &arSrc, bool isSame, int aReadPoint, qint64 aLastUpdate);

private:
    bbsTableParser      *mpBbsTableParser;
    QString              mBbsTable;
    QString              mLogPath;

    QVector<QString>              mDatNickName;
    QVector<QString>              mDatFilePath;
    QVector<QString>              mDatFileName;

    QVector<QString>              mIdxFilePath;
    QVector<QByteArray>           mIdxTitle;
    QVector<int>                  mIdxReadNumber;

    QVector<QString>               mAcquiredNickName;
    QVector<QString>               mAcquiredFileName;
    QVector<pGIKOacquiredParser *> mAcquiredParser;
};

#endif // #ifndef #ifndef PGIKOBROWSERPARSER_H
/*
 *  a2BC : a2B Connectivity
 *  Copyright (C) 2006- NNsi Project
 *  (see a2BC-src.txt for detail.)
 */
