/*============================================================================*
 *  $Id: damain.c,v 1.28 2008/03/13 14:22:50 mrsa Exp $
 *
 *  FILE: 
 *     damain.c
 *
 *  Description: 
 *     DAAvP[V
 *
 *===========================================================================*/
/********** Include Files **********/
#include "local.h"

#define NUMCATH(buf,num)   StrIToH(&(buf)[StrLen((buf))], (num))

void DAmain(void);
Err  SendToLocalMemopad(Char *title, Char *data);

static void ParseMessage(Char *buf, Char *src, UInt32 size, UInt16 kanjiCode);

// UTF8 -> Shift JISϊe[u (AMsoft̂cagp)
void StrNCopyUTF8toSJ(UInt8 *dst, UInt8 *src, UInt32 size, LocalID dbId);

static Boolean ConvertJIStoSJ(UInt8 *dst, UInt8 *ptr);
static Boolean ConvertEUCtoSJ(UInt8 *dst, UInt8 *ptr, UInt16 *copyByte);
static UInt16  Unicode11ToJisx0208(DmOpenRef dbRef, UInt8 utf8H, UInt8 utf8L);


static void NNsh_checkRefreshConnectionRequest(NNshSavedPref *NNshParam, NNshWorkingInfo *NNshGlobal);
#ifdef SUPPORT_BIZPOTAL
static void pickup_hostNameAndPortNum(Char *buf, NNshSavedPref *NNshParam,NNshWorkingInfo *NNshGlobal);
#endif // #ifdef SUPPORT_BIZPOTAL

#ifdef USE_REFERER
static void NNsh_MakeReferer(NNshSavedPref *NNshParam,NNshWorkingInfo *NNshGlobal);
#endif  // #ifdef USE_REFERER

#ifdef DEBUG_LOCALHOST_ADDRESS
#define  DEBUG_ADDRESS  "localhost"
#endif  // #ifdef DEBUG_LOCALHOST_ADDRESS
 
void doLogin_YahooBBmobile(NNshSavedPref *NNshParam,NNshWorkingInfo *NNshGlobal);
void Analysis_YahooBBLoginLink(NNshSavedPref *NNshParam, NNshWorkingInfo *NNshGlobal);
 
/*=========================================================================*/
/*   Function : startDA  (DAX^[gAbv)                                */
/*                                                                         */
/*=========================================================================*/
void startDA(void)
{
    FormType *frm;

    frm = FrmGetActiveForm();
    DAmain();
    FrmSetActiveForm(frm);

    return;
}

/*=========================================================================*/
/*   Function : DAmain  (DAC)                                     */
/*                                                                         */
/*=========================================================================*/
void DAmain(void)
{
    UInt16            size;
    NNshSavedPref    *NNshParam;
    NNshWorkingInfo  *NNshGlobal;

    //////////////////////////////////////////////////////////////////////////
    /////     Niݒ̕ۑj
    //////////////////////////////////////////////////////////////////////////
    // NNsiݒpi[̈̊m
    size      = sizeof(NNshSavedPref) + DBSIZE_SETTING;
    NNshParam = (NNshSavedPref *) MemPtrNew(size);
    if (NNshParam == NULL)
    {
        // ̈mۂɎsI(NȂ)
        FrmCustomAlert(ALTID_INFO, "Cannot Launch ",  "(DA)", " param");
        return;
    }        
    MemSet(NNshParam, size, 0x00);

    // Parameter pointerfeatureɃZbg
    FtrSet(SOFT_CREATOR_ID, SOFT_DB_ID, (UInt32) NNshParam);

    // NNsiO[öpi[̈̊m
    size       = sizeof(NNshWorkingInfo) + MARGIN;
    NNshGlobal = (NNshWorkingInfo *) MemPtrNew(size);
    if (NNshGlobal == NULL)
    {
        // ̈mۂɎsI(NȂ)
        FrmCustomAlert(ALTID_INFO, "Cannot Launch ",  "(DA)", " global");
        MEMFREE_PTR(NNshParam);
        return;
    }        
    MemSet(NNshGlobal, size, 0x00);

    // OSo[W̊mF
    FtrGet(sysFtrCreator, sysFtrNumROMVersion, &(NNshGlobal->palmOSVersion));

    // PalmOS v5.20ꍇɂ͋NȂ
    if (NNshGlobal->palmOSVersion < 0x05200000)
    {
        FrmCustomAlert(ALTID_INFO, "USE a PalmOS 5.2(or later)."," ","[mlDA]");
        return;
    }

    // NNsiݒ𕜋
    RestoreSetting_NNsh(sizeof(NNshSavedPref), NNshParam);

    //////////////////////////////////////////////////////////////////////////
    /////     ʃI[vic`̃Cj
    //////////////////////////////////////////////////////////////////////////

    //   Auto Exec.(s)Ƀ`FbNĂȂꍇɂ́AݒEBhE
    // \
    if (NNshParam->confirmationDisable == 0)
    {
        if (FrmGetActiveFormID() != 0)
        {
            NNshGlobal->previousForm = FrmGetActiveForm();
        }
        else
        {
            NNshGlobal->previousForm = NULL;
        }
        NNshGlobal->currentForm  = FrmInitForm(FRMID_MAIN);
        // FrmSetActiveForm(NNshGlobal->currentForm);

        if (StrLen(NNshParam->password[NNshParam->protocol]) == 0)
        {
            CtlSetLabel(FrmGetObjectPtr(NNshGlobal->currentForm, 
                                   FrmGetObjectIndex(NNshGlobal->currentForm, 
                                                           SELTRID_PASSWORD)), 
                        "(Empty)");
        }
        else
        {
            CtlSetLabel(FrmGetObjectPtr(NNshGlobal->currentForm, 
                                    FrmGetObjectIndex(NNshGlobal->currentForm,
                                                           SELTRID_PASSWORD)),
                        "* * *");
        }
        NNshWinSetPopItems (NNshGlobal->currentForm,
                            POPTRID_PROTOCOL, LSTID_PROTOCOL,
                            NNshParam->protocol);
        NNshWinSetFieldText(NNshGlobal->currentForm,
                            FLDID_USER,
                            NNshParam->userName[NNshParam->protocol],
                            BUFSIZE0);
        NNshWinSetFieldText(NNshGlobal->currentForm,
                            FLDID_PASSWORD, 
                            NNshParam->password[NNshParam->protocol],
                            BUFSIZE0);

        // ؒf̐ݒ
        CtlSetValue(FrmGetObjectPtr(NNshGlobal->currentForm,
                                  FrmGetObjectIndex(NNshGlobal->currentForm,
                                                           CHKID_DISCONNECT)),
                    (UInt16) (NNshParam->disconnect));

        // Cxgnh̐ݒ
        FrmSetEventHandler(NNshGlobal->currentForm, Handler_MainForm);
        NNshGlobal->btnId = FrmDoDialog(NNshGlobal->currentForm);
        if (NNshGlobal->btnId == BTNID_DIALOG_OK)
        {
            // s̃`FbN
            NNshParam->confirmationDisable = (UInt8)
                 CtlGetValue(FrmGetObjectPtr(NNshGlobal->currentForm,
                                    FrmGetObjectIndex(NNshGlobal->currentForm,
                                                              CHKID_CONFIRM)));
            // ؒf
            NNshParam->disconnect =
                 CtlGetValue(FrmGetObjectPtr(NNshGlobal->currentForm,
                                    FrmGetObjectIndex(NNshGlobal->currentForm,
                                                           CHKID_DISCONNECT)));
            // ʐMvgR̔f
            NNshParam->protocol = 
                 LstGetSelection(FrmGetObjectPtr(NNshGlobal->currentForm,
                                    FrmGetObjectIndex(NNshGlobal->currentForm,
                                                             LSTID_PROTOCOL)));
            NNshWinGetFieldText(NNshGlobal->currentForm, FLDID_USER,
                                NNshParam->userName[NNshParam->protocol],
                                BUFSIZE0);

            NNshWinGetFieldText(NNshGlobal->currentForm, FLDID_PASSWORD,
                                NNshParam->password[NNshParam->protocol],
                                BUFSIZE0);
        }
        // tH[̍폜
        if (NNshGlobal->previousForm != NULL)
        {
            FrmSetActiveForm(NNshGlobal->previousForm);
        }
        FrmDeleteForm(NNshGlobal->currentForm);
    }
    else
    {
        // sɂ́AOCs
        NNshGlobal->btnId = BTNID_DIALOG_OK;
    }

    //////////////////////////////////////////////////////////////////////////
    // OC̎s
    //////////////////////////////////////////////////////////////////////////
    if (NNshGlobal->btnId == BTNID_DIALOG_OK)
    {
        // Mobt@̊m
        NNshGlobal->sendBuf = MemPtrNew(NNshParam->bufferSize);
        if (NNshGlobal->sendBuf == NULL)
        {
            // ̈mێsAI
            goto FUNC_END;
        }
        MemSet(NNshGlobal->sendBuf, NNshParam->bufferSize, 0x00);
        NNshGlobal->recvBuf = MemPtrNew(NNshParam->bufferSize);
        if (NNshGlobal->recvBuf == NULL)
        {
            // ̈mێsAI
            MEMFREE_PTR(NNshGlobal->sendBuf);
            goto FUNC_END;
        }
        MemSet(NNshGlobal->recvBuf, NNshParam->bufferSize, 0x00);

        NNshGlobal->workBuf = MemPtrNew(((NNshParam->bufferSize) / 2));
        if (NNshGlobal->workBuf == NULL)
        {
            // ̈mێsAI
            MEMFREE_PTR(NNshGlobal->sendBuf);
            MEMFREE_PTR(NNshGlobal->recvBuf);
            goto FUNC_END;
        }
        MemSet(NNshGlobal->workBuf, ((NNshParam->bufferSize) / 2), 0x00);

        // BUSYEBhE\
        Show_BusyForm(NNshParam->hostName, NNshGlobal);    

        MemSet (NNshGlobal->tempBuf, BUFSIZE, 0x00);

        switch (NNshParam->protocol)
        {
          case ISP_YAHOO_BB_MOBILE:
            // Yahoo! BB Moblie ɃOC鏈s
            doLogin_YahooBBmobile(NNshParam, NNshGlobal);
            break;

          default:
            // zbgX|bg(Yahoo! BB MoblieȊO)ɃOC鏈s
            doLogin_HotSpot(NNshParam, NNshGlobal);
            break;
        }

        // ؒf(w莞)
        if (NNshParam->disconnect != 0)
        {
            // BUSYEBhE̕\ύX
            SetMsg_BusyForm(MSG_DISCONNECT);
            NNshNet_LineHangup();
        }
        // BUSYEBhEB
        Hide_BusyForm(NNshGlobal);

        // obt@NA
        MemSet(NNshGlobal->sendBuf, NNshParam->bufferSize, 0x00);

        // R[h̕\
        if (NNshGlobal->err == errNone)
        {
            // OCɐ
            StrCopy(NNshGlobal->sendBuf, MSG_SUCCESSLOGIN);
        }
        else
        {
            // G[
            StrCopy(NNshGlobal->sendBuf, MSG_ERROR);
        }

        // ʃ_CAO\
        if (FrmGetActiveFormID() != 0)
        {
            NNshGlobal->previousForm = FrmGetActiveForm();
        }
        else
        {
            NNshGlobal->previousForm = NULL;
        }
        NNshGlobal->currentForm  = FrmInitForm(FRMID_RESULT);
        // FrmSetActiveForm   (NNshGlobal->currentForm);

        // (OCʂt)
        NNshGlobal->tempPtr = StrStr(NNshGlobal->recvBuf, "\r\n\r\n");
        if (NNshGlobal->tempPtr == NULL)
        {
            // Mobt@̐擪\
            NNshGlobal->tempPtr = NNshGlobal->recvBuf;
        }
        else
        {
            // sR[h("\r\n\r\n")|C^i߂
            NNshGlobal->tempPtr = NNshGlobal->tempPtr + 4;
        }
        // tB[hɎMʂ\
        if ((StrLen(NNshGlobal->tempPtr) + StrLen(NNshGlobal->sendBuf)) <
            (NNshParam->bufferSize - 1))
        {
            NNshGlobal->err = StrLen(NNshGlobal->tempPtr);
        }
        else
        {
            NNshGlobal->err =
                     NNshParam->bufferSize - (StrLen(NNshGlobal->sendBuf) - 2);
        }
#ifdef USE_RAW_RECVDATA
        // Mf[^܂͂ɕ\
        StrNCopy(&NNshGlobal->sendBuf[StrLen(NNshGlobal->sendBuf)],
                 NNshGlobal->tempPtr, NNshGlobal->err);
#else
        // Mf[^HTMLf[^t@CƂ(ȒPɉ͂)\
        ParseMessage(&NNshGlobal->sendBuf[StrLen(NNshGlobal->sendBuf)],
                     NNshGlobal->tempPtr, NNshGlobal->err,
                     NNSH_KANJICODE_SHIFTJIS);
#endif
        NNshWinSetFieldText(NNshGlobal->currentForm, FLDID_INFOFIELD,
                            NNshGlobal->sendBuf, StrLen(NNshGlobal->sendBuf));

        FrmSetEventHandler(NNshGlobal->currentForm, Handler_MainForm);
        (void) FrmDoDialog(NNshGlobal->currentForm);

        // tH[̍폜
        if (NNshGlobal->previousForm != NULL)
        {
            FrmSetActiveForm(NNshGlobal->previousForm);
        }
        FrmDeleteForm(NNshGlobal->currentForm);

        // Mobt@̉
        MEMFREE_PTR(NNshGlobal->recvBuf);
        MEMFREE_PTR(NNshGlobal->sendBuf);
        MEMFREE_PTR(NNshGlobal->workBuf);

    }
FUNC_END:
    //////////////////////////////////////////////////////////////////////////
    /////     Iiݒ̕ۑj
    //////////////////////////////////////////////////////////////////////////

    // ݒ̕ۑ
    SaveSetting_NNsh(sizeof(NNshSavedPref), NNshParam);

    // ̈J
    MEMFREE_PTR(NNshParam);    
    MEMFREE_PTR(NNshGlobal);

    // Global̓o^
    FtrUnregister(SOFT_CREATOR_ID, SOFT_DB_ID);

    return;
}

/*=========================================================================*/
/*   Function : Handler_EditAction                                         */
/*                                        ҏWj[Iꂽ̏ */
/*=========================================================================*/
Boolean Handler_EditAction(EventType *event)
{
    FormType  *frm;
    FieldType *fldP;
    UInt16     frmId;
    
    // IĂtB[hǂ`FbN
    frm   = FrmGetActiveForm();
    frmId = FrmGetFocus(frm);
    if (frmId == noFocus)
    { 
        // tH[JXIĂȂ̂ŁAԂ
        return (false);
    }
    if (FrmGetObjectType(frm, frmId) != frmFieldObj)
    {
        // ItB[hł͂Ȃ̂ŁAԂ
        return (false);
    }
    fldP = FrmGetObjectPtr(frm, frmId);

    // ҏWj[{
    switch (event->data.menu.itemID)
    {
      case MNUID_EDIT_UNDO:
        FldUndo(fldP);
        break;
      case MNUID_EDIT_CUT:
        FldCut(fldP);
        break;
      case MNUID_EDIT_COPY:
        FldCopy(fldP);
        break;
      case MNUID_EDIT_PASTE:
        FldPaste(fldP);
        break;
      case MNUID_SELECT_ALL:
        FldSetSelection(fldP, 0, FldGetTextLength(fldP));
        break;
      default:
        // ȂɂȂAƂRRɂ͗Ȃ
        break;
    }
    return (false);
}

/*=========================================================================*/
/*   Function :   Hander_MainForm                                          */
/*                                       Cxgnh(ݒtH[p)  */
/*=========================================================================*/
Boolean Handler_MainForm(EventType *event)
{
    FieldType *fldP;
    UInt16    itemId;
    Char     *area;

    // p[^̎擾
    NNshSavedPref *NNshParam;
    FtrGet(SOFT_CREATOR_ID, SOFT_DB_ID, (UInt32 *)&NNshParam);

    // ݂̃tH[擾
    switch (event->eType)
    { 
      // j[I
      case menuEvent:
        itemId = event->data.menu.itemID;
        break;

      // L[
      case keyDownEvent:
        itemId = event->data.keyDown.chr;
        break;

      // ʃ^bv
      case ctlSelectEvent:
        itemId = event->data.ctlSelect.controlID;
        break;

      // ISPύX
      case popSelectEvent:
        itemId = event->data.popSelect.listID;
        break;

      case penDownEvent:
      default: 
        return (false);
        break;
    }
    switch (itemId)
    {
      case MNUID_VERSION:
        // o[W\
        ShowVersion_NNsh();
        break;

      case SELTRID_PASSWORD:
        // pX[h
        area = MemPtrNew(BUFSIZE);
        if (area == NULL)
        {
            return (true);
        }
        MemSet(area, (BUFSIZE), 0x00);
        NNshWinGetFieldText(FrmGetActiveForm(), FLDID_PASSWORD,
                                                          area, (BUFSIZE));
        if (InputDialog("Input Password", area, (BUFSIZE)) == true)
        {
            NNshWinSetFieldText(FrmGetActiveForm(), FLDID_PASSWORD, area,
                                                                (BUFSIZE));

        }
        if (StrLen(area) == 0)
        {
            CtlSetLabel(FrmGetObjectPtr(FrmGetActiveForm(), 
                                        FrmGetObjectIndex(FrmGetActiveForm(),
                                                          SELTRID_PASSWORD)), 
                        "(Empty)");
        }
        else
        {
            CtlSetLabel(FrmGetObjectPtr(FrmGetActiveForm(), 
                                        FrmGetObjectIndex(FrmGetActiveForm(),
                                                          SELTRID_PASSWORD)), 
                        "* * *");
        }
        MEMFREE_PTR(area);
        break;

      case vchrPageDown:
      case chrDownArrow:
      case vchrJogDown:
        // XN[
        if (FrmGetActiveFormID() == FRMID_RESULT)
        {
          fldP = FrmGetObjectPtr(FrmGetActiveForm(), 
                                 FrmGetObjectIndex(FrmGetActiveForm(),
                                                   FLDID_INFOFIELD));
          FldScrollField(fldP, 5, winDown);
        }
        break;

      case vchrPageUp:
      case chrUpArrow:
      case vchrJogUp:
        // XN[
        if (FrmGetActiveFormID() == FRMID_RESULT)
        {
          fldP = FrmGetObjectPtr(FrmGetActiveForm(), 
                                 FrmGetObjectIndex(FrmGetActiveForm(),
                                                   FLDID_INFOFIELD));
          FldScrollField(fldP, 5, winUp);
        }
        break;


      case LSTID_PROTOCOL:
        // IISPXV
        NNshWinGetFieldText(FrmGetActiveForm(), FLDID_USER,
                            NNshParam->userName[NNshParam->protocol],
                            BUFSIZE0);

        NNshWinGetFieldText(FrmGetActiveForm(), FLDID_PASSWORD,
                            NNshParam->password[NNshParam->protocol],
                            BUFSIZE0);

        NNshParam->protocol = event->data.popSelect.selection;

        // IISP̏ʂɕ\
        NNshWinSetFieldText(FrmGetActiveForm(),
                            FLDID_USER,
                            NNshParam->userName[NNshParam->protocol],
                            BUFSIZE0);

        NNshWinSetFieldText(FrmGetActiveForm(),
                            FLDID_PASSWORD, 
                            NNshParam->password[NNshParam->protocol],
                            BUFSIZE0);

        // pX[h̕\XV
        if (StrLen(NNshParam->password[NNshParam->protocol]) == 0)
        {
            CtlSetLabel(FrmGetObjectPtr(FrmGetActiveForm(), 
                                        FrmGetObjectIndex(FrmGetActiveForm(), 
                                                          SELTRID_PASSWORD)), 
                                                          "(Empty)");
        }
        else
        {
            CtlSetLabel(FrmGetObjectPtr(FrmGetActiveForm(), 
                                        FrmGetObjectIndex(FrmGetActiveForm(), 
                                                          SELTRID_PASSWORD)), 
                                                          "* * *");
        }
        return (false);
        break;

      case BTNID_DIALOG_OK:
      case BTNID_DIALOG_CANCEL:
      default:
        return (false);
        break;
    }
    return (true);
}

/*=========================================================================*/
/*   Function :   NNshRestoreNNsiSetting                                   */
/*                                                     NNsiݒ̓ǂݍ  */
/*=========================================================================*/
void RestoreSetting_NNsh(UInt16 size, NNshSavedPref *prm)
{
    Err           ret;
    UInt32        offset;
    UInt16        cnt, nofRec;
    DmOpenRef     dbRef;
    Char         *ptr;

    // NNsiݒ̗̈
    nofRec = 0;

    if (size == sizeof(NNshSavedPref))
    {
        //  ݒ肳ꂽo[WƍNꂽo[Wэ\̃TCY
        // ꍇ̂݁ANNsiݒ𕜋B

        // ϐ 
        offset = 0;
        ptr    = (Char *) prm;

        // caANNsiݒǂݏo(R[h̓o^̌ˍŁAAA)
        OpenDatabase_NNsh(DBNAME_SETTING, DBVERSION_SETTING, &dbRef);
        GetDBCount_NNsh(dbRef, &nofRec);
        cnt = nofRec;
        while ((cnt != 0)&&(offset < sizeof(NNshSavedPref)))
        {
            ret = GetRecord_NNsh(dbRef,(cnt - 1),DBSIZE_SETTING, &ptr[offset]);
            if (ret != errNone)
            {
                // f[^ǂݏoɎs(̏ꍇANNsiݒ͏)
                nofRec = 0;
                break;
            }
            cnt--;
            offset = offset + DBSIZE_SETTING;
        }
        CloseDatabase_NNsh(dbRef);
    }
    if (nofRec == 0)
    {
        // ݒ
        prm->useKey.key1      = vchrHard1;
        prm->useKey.key2      = vchrHard2;
        prm->useKey.key3      = vchrHard3;
        prm->useKey.key4      = vchrHard4;
        prm->bufferSize       = WORKBUF_DEFAULT;
        prm->portNum          = 110;     // POP3|[gԍ
        prm->timeout          = SysTicksPerSecond() * NNSH_GETMAIL_TIMEOUT;
    }
    return;
}
/*-------------------------------------------------------------------------*/
/*   Function :   NNshSaveNNsiSetting                                      */
/*                                                         NNsiݒ̋L  */
/*-------------------------------------------------------------------------*/
void SaveSetting_NNsh(UInt16 size, NNshSavedPref *param)
{
    Err       ret;
    UInt32    offset;
    UInt16    nofRec;
    DmOpenRef dbRef;
    Char      *ptr;

    OpenDatabase_NNsh(DBNAME_SETTING, DBVERSION_SETTING, &dbRef);
    GetDBCount_NNsh(dbRef, &nofRec);
    while (nofRec != 0)
    {
        //  łNNsiݒ肪L^ĂꍇASR[h폜
        (void) DeleteRecordIDX_NNsh(dbRef, (nofRec - 1));
        nofRec--;
    }

    // NNsiݒDBɓo^(R[ho^̌ˍɒӁI)
    offset = 0;
    ptr    = (Char *) param;
    while (offset < sizeof(NNshSavedPref))
    {
        ret = EntryRecord_NNsh(dbRef, DBSIZE_SETTING, &ptr[offset]);
        if (ret != errNone)
        {
            break;
        }
        offset = offset + DBSIZE_SETTING;
    }
    CloseDatabase_NNsh(dbRef);

    return;
}


/*-------------------------------------------------------------------------*/
/*   Function : aplCompareF                                                */
/*                                                (\[eBOpr֐) */
/*                         DBotheroCgڂɁuŁvkey  */
/*                                                         ̂ƂB*/
/*-------------------------------------------------------------------------*/
static Int16 aplCompareF_Char(void *rec1, void *rec2, Int16 other,
                              SortRecordInfoPtr       rec1SortInfo,
                              SortRecordInfoPtr       rec2SortInfo, 
                              MemHandle               appInfoH)
{
    Char *str1, *str2;

    str1 = ((Char *) rec1) + other;
    str2 = ((Char *) rec2) + other;
    return (StrCompare(str1, str2));
}

/*-------------------------------------------------------------------------*/
/*   Function : aplCompareF_UInt32                                         */
/*                                                (\[eBOpr֐) */
/*                         DBotheroCgڂɁuUInt32Łvkey  */
/*                                                         ̂ƂB*/
/*-------------------------------------------------------------------------*/
static Int16 aplCompareF_UInt32(void *rec1, void *rec2, Int16 other,
                                SortRecordInfoPtr       rec1SortInfo,
                                SortRecordInfoPtr       rec2SortInfo, 
                                MemHandle               appInfoH)
{
    Char   *loc1,  *loc2;
    UInt32 *data1, *data2;

    loc1  = ((Char *) rec1) + other;
    loc2  = ((Char *) rec2) + other;

    data1 = (UInt32 *) loc1;
    data2 = (UInt32 *) loc2;

    return (*data1 - *data2);
}

/*-------------------------------------------------------------------------*/
/*   Function : aplCompareF_UInt16                                         */
/*                                                (\[eBOpr֐) */
/*                     key擪otheroCgڂuUInt16Łv  */
/*                                                         ̂ƂB*/
/*-------------------------------------------------------------------------*/
static Int16 aplCompareF_UInt16(void *rec1, void *rec2, Int16 other,
                                SortRecordInfoPtr       rec1SortInfo,
                                SortRecordInfoPtr       rec2SortInfo, 
                                MemHandle               appInfoH)
{
    Char   *loc1,  *loc2;
    UInt16 *data1, *data2;

    loc1  = ((Char *) rec1) + other;
    loc2  = ((Char *) rec2) + other;

    data1 = (UInt16 *) loc1;
    data2 = (UInt16 *) loc2;

    return (*data1 - *data2);
}

/*-------------------------------------------------------------------------*/
/*   Function : searchRecordSub                                            */
/*                                                        (R[h) */
/*-------------------------------------------------------------------------*/
static Err searchRecordSub(DmOpenRef dbRef, void *target, UInt16 keyType, 
                           UInt16   offset, UInt16 *idx,  MemHandle *hnd)
{
    UInt16     nofData, start, end, mid;
    Int16      chk;
    MemHandle  dataH;
    Char      *data;

    // 镶LXg
    data = (Char *)target;
    data = data + offset;

    // f[^[猟s
    nofData = DmNumRecords(dbRef);
    if (nofData == 0)
    {
        return (~errNone - 5);
    }

    // QŎw肳ꂽf[^o^Ă邩`FbN
    mid   = 0;
    start = 0;
    end   = nofData;
    while (start <= end)
    {
        mid = start + (end - start) / 2;
        dataH = DmQueryRecord(dbRef, mid);
        if (dataH == 0)
        {
            // ȂI (Ŕ͗l)
            return (~errNone);
        }

        // w肳ꂽL[ɂāA`FbN@ς
        data = (Char *) MemHandleLock(dataH);
        switch (keyType)
        {
          case NNSH_KEYTYPE_UINT32:
            chk  = *((UInt32 *) data) - *((UInt32 *) target);
            break;

          case NNSH_KEYTYPE_UINT16:
            chk  = *((UInt16 *) data) - *((UInt16 *) target);
            break;

          case NNSH_KEYTYPE_CHAR:
          default:
            chk  = StrCompare(data, (Char *) target);
            break;
        }
        if (chk == 0)
        {
            // I(f[^܂邲ƃRs[)
            MemHandleUnlock(dataH);
            *idx  = mid;
            *hnd  = dataH;
            return (errNone);
        }
        MemHandleUnlock(dataH);
        if (chk < 0)
        {
            start = mid + 1;
        }
        else
        {
            end   = mid - 1;
        }
    }
    return (~errNone - 4);
}

/*==========================================================================*/
/*  OpenDatabase_NNsh : f[^x[XANZX̏                        */
/*                                                                          */
/*==========================================================================*/
void OpenDatabase_NNsh(Char *dbName, UInt16 chkVersion, DmOpenRef *dbRef)
{
    LocalID dbId;
    UInt16  dbVersion;

    // f[^x[X݂邩mFB
    *dbRef    = 0;
    dbVersion = 0;
    dbId      = DmFindDatabase(0, dbName);
    if (dbId != 0)
    {
        // f[^x[X̃o[Wԍ擾
        (void) DmDatabaseInfo(0, dbId, NULL, NULL, &dbVersion, NULL, 
                              NULL, NULL, NULL, NULL, NULL, NULL, NULL);
        if (dbVersion < chkVersion)
        {
            // f[^x[X̃o[WÂƂ́Af[^x[X폜
            (void) DmDeleteDatabase(0, dbId);
            dbId = 0;
        }
    }

    // f[^x[X݂ȂƂ
    if (dbId == 0)
    {
        // f[^x[XVK쐬
        (void) DmCreateDatabase(0, dbName, 
                                SOFT_CREATOR_ID, SOFT_DBTYPE_ID, false);

        dbId      = DmFindDatabase(0, dbName);
        if (dbId != 0)
        {
            // DBɃo[Wԍݒ
            dbVersion = chkVersion;
            (void) DmSetDatabaseInfo(0, dbId, NULL,NULL, &dbVersion, NULL,
                                     NULL,NULL,NULL,NULL,NULL,NULL,NULL);
        }
    }

    // f[^x[X̃I[v
    *dbRef = DmOpenDatabase(0 , dbId, dmModeReadWrite);

    return;
}

/*==========================================================================*/
/*  closeDatabase_NNsh() : f[^x[XN[Y                       */
/*                                                                          */
/*==========================================================================*/
void CloseDatabase_NNsh(DmOpenRef dbRef)
{
    // DBI[vłĂCLOSEB
    if (dbRef != 0)
    {
        (void) DmCloseDatabase(dbRef);
        dbRef = 0;
    }
    return;
}

/*=========================================================================*/
/*   Function : QsortRecord_NNsh                                           */
/*                                                (R[h̃\[eBO) */
/*=========================================================================*/
void QsortRecord_NNsh(DmOpenRef dbRef, UInt16 keyType, UInt16 offset)
{

    // NCbN\[gd|
    switch (keyType)
    {

      case NNSH_KEYTYPE_UINT32:
        (void) DmQuickSort(dbRef, (DmComparF *) aplCompareF_UInt32, offset);
        break;

      case NNSH_KEYTYPE_UINT16:
        (void) DmQuickSort(dbRef, (DmComparF *) aplCompareF_UInt16, offset);
        break;

      case NNSH_KEYTYPE_CHAR:
      default:
        (void) DmQuickSort(dbRef, (DmComparF *) aplCompareF_Char, offset);
        break;
    }
    return;
}

/*=========================================================================*/
/*   Function : IsortRecord_NNsh                                           */
/*                                                (R[h̃\[eBO) */
/*=========================================================================*/
void IsortRecord_NNsh(DmOpenRef dbRef, UInt16 keyType, UInt16 offset)
{

    // }\[gd|
    switch (keyType)
    {
      case NNSH_KEYTYPE_UINT32:
        (void) DmInsertionSort(dbRef, (DmComparF *)aplCompareF_UInt32, offset);
        break;

      case NNSH_KEYTYPE_UINT16:
        (void) DmInsertionSort(dbRef, (DmComparF *)aplCompareF_UInt16, offset);
        break;

      case NNSH_KEYTYPE_CHAR:
      default:
        (void) DmInsertionSort(dbRef, (DmComparF *)aplCompareF_Char, offset);
        break;
    }
    return;
}

/*=========================================================================*/
/*   Function : EntryRecord_NNsh                                           */
/*                                               (ca̐擪Ƀf[^o^)  */
/*=========================================================================*/
Err EntryRecord_NNsh(DmOpenRef dbRef, UInt16 size, void *recordData)
{
    MemHandle  newRecH;
    UInt16     index;
    void      *dbP;

    // R[h̐VKǉ
    index   = 0;
    newRecH = DmNewRecord(dbRef, &index, size + sizeof(UInt32));
    if (newRecH == 0)
    {
        // R[hǉG[
        return (DmGetLastErr());
    }

    // R[hɃf[^
    dbP = MemHandleLock(newRecH);
    DmWrite(dbP, 0, recordData, size);
    MemHandleUnlock(newRecH);

    // R[hiύXIj
    DmReleaseRecord(dbRef, index, true);

    return (errNone);
}

/*=========================================================================*/
/*   Function : IsExistRecord_NNsh                                         */
/*                                                (R[h̑݃`FbN) */
/*=========================================================================*/
Err IsExistRecord_NNsh(DmOpenRef dbRef, void   *target,  UInt16 keyType,
                       UInt16 offset,   UInt16 *index)
{
    MemHandle  dataH;

    *index  = 0;
    dataH   = 0;
    return (searchRecordSub(dbRef, target, keyType, offset, index, &dataH));
}

/*=========================================================================*/
/*   Function : SearchRecord_NNsh                                          */
/*                                                        (R[h) */
/*=========================================================================*/
Err SearchRecord_NNsh(DmOpenRef dbRef, void *target, UInt16 keyType,
                      UInt16 offset, UInt16 size, void *matchedData,
                      UInt16 *index)
{
    Err        ret;
    UInt16     start;
    MemHandle  dataH;
    Char      *sc,  *ds;
    UInt32    *src, *dest;

    *index = 0;
    dataH  = 0;

    ret    = searchRecordSub(dbRef, target, keyType, offset, index, &dataH);
    if (ret != errNone)
    {
        // f[^炸
        return (ret);
    }
    if (dataH == 0)
    {
        // nhُ
        return ((~errNone) - 2);
    }

    src = (UInt32 *) MemHandleLock(dataH);
    if (src == NULL)
    {
        // |C^ُ
        return ((~errNone) - 3);
    }

    // f[^܂邲ƃRs[ĉ
    MemSet(matchedData, size, 0x00);
    dest   = (UInt32 *) matchedData;
    for (start = 0; start < (size - sizeof(UInt32));
         start = start + sizeof(UInt32))
    {
        *dest++ = *src++;
    }
    for (sc = (Char *) src, ds = (Char *) dest;start < size;
         start = start + sizeof(Char))
    {
         *ds++ = *sc++;
    }

    MemHandleUnlock(dataH);
    return (errNone);
}

/*=========================================================================*/
/*   Function : DeleteRecord_NNsh                                          */
/*                                                    (YR[h폜) */
/*=========================================================================*/
Err DeleteRecord_NNsh(DmOpenRef dbRef, void  *target,
                      UInt16 keyType,  UInt16 offset)
{
    Err       ret;
    UInt16    index;
    MemHandle dataH;

    index = 0;
    dataH = 0;
    ret = searchRecordSub(dbRef, target, keyType, offset, &index, &dataH);
    if (ret != errNone)
    {
        return (errNone + 1);
    }

    return (DmRemoveRecord(dbRef, index));
}

/*=========================================================================*/
/*   Function : DeleteRecordIDX_NNsh                                       */
/*                                                    (YR[h폜) */
/*=========================================================================*/
Err DeleteRecordIDX_NNsh(DmOpenRef dbRef, UInt16 index)
{
    // f[^I[oĂ邩mF
    if (index >= DmNumRecords(dbRef))
    {
        return (~errNone);
    }
    return (DmRemoveRecord(dbRef, index));
}

/*=========================================================================*/
/*   Function : GetRecord_NNsh                                             */
/*                                          (R[hCfbNXŊl) */
/*=========================================================================*/
Err GetRecord_NNsh(DmOpenRef dbRef, UInt16 index,
                   UInt16 size, void *matchedData)
{
    MemHandle  dataH;
    UInt16     start;
    UInt32    *src, *dest;
    Char      *sc,  *ds;

    // f[^I[oĂ邩mF
    if (index >= DmNumRecords(dbRef))
    {
        return (~errNone - 6);
    }

    dataH = DmQueryRecord(dbRef, index);
    if (dataH == 0)
    {
        // ȂI
        return (~errNone);
    }
    src = (UInt32 *) MemHandleLock(dataH);
    if (src == NULL)
    {
        // |C^ُ
        return ((~errNone) - 3);
    }

    // f[^܂邲ƃRs[ĉ
    MemSet(matchedData, size, 0x00);
    dest   = (UInt32 *) matchedData;
    for (start = 0; start < (size - sizeof(UInt32));
         start = start + sizeof(UInt32))
    {
        *dest++ = *src++;
    }
    for (sc = (Char *) src, ds = (Char *) dest;start < size;
         start = start + sizeof(Char))
    {
         *ds++ = *sc++;
    }
    MemHandleUnlock(dataH);
    return (errNone);
}

/*=========================================================================*/
/*   Function : GetRecordReadOnly_NNsh                                     */
/*                                          (R[hCfbNXŊl) */
/*=========================================================================*/
Err GetRecordReadOnly_NNsh(DmOpenRef dbRef, UInt16 index,
                           MemHandle *dataH, void **record)
{
    // f[^I[oĂ邩mF
    if (index >= DmNumRecords(dbRef))
    {
        return (~errNone - 6);
    }

    *dataH = DmQueryRecord(dbRef, index);
    if (*dataH == 0)
    {
        // ȂI
        return (~errNone);
    }

    // ̈bN
    *record = MemHandleLock(*dataH);
    if (record == NULL)
    {
        // |C^ُ
        return ((~errNone) - 3);
    }
    return (errNone);
}

/*=========================================================================*/
/*   Function : ReleaseRecordReadOnly_NNsh                                 */
/*                                                (R[hǂݏoI) */
/*=========================================================================*/
Err ReleaseRecordReadOnly_NNsh(DmOpenRef dbRef, MemHandle dataH)
{
    if (dataH != 0)
    {
        MemHandleUnlock(dataH);
    }
    return (errNone);
}

/*=========================================================================*/
/*   Function : UpdateRecord_NNsh                                          */
/*                                          (R[hCfbNXōXV) */
/*=========================================================================*/
Err UpdateRecord_NNsh(DmOpenRef dbRef, UInt16 index, 
                      UInt16 size, void *updateData)
{
    MemHandle recH;
    void     *dbP;

    recH = DmGetRecord(dbRef, index);
    if (recH == 0)
    {
        // R[hQƃG[
        return (DmGetLastErr());
    }

    // R[hɃf[^
    dbP = MemHandleLock(recH);
    DmWrite(dbP, 0, updateData, size);
    MemHandleUnlock(recH);

    // R[hiύXIj
    DmReleaseRecord(dbRef, index, true);

    return (errNone);
}

/*==========================================================================*/
/*  GetDBCount_NNsh : f[^x[Xɓo^Ăf[^      */
/*                                                                          */
/*==========================================================================*/
void GetDBCount_NNsh(DmOpenRef dbRef, UInt16 *count)
{
    *count = DmNumRecords(dbRef);
    return;
}

/*==========================================================================*/
/*  GetDBInfo_NNsh : f[^x[X̏̎擾                               */
/*                                                                          */
/*==========================================================================*/
Err GetDBInfo_NNsh(Char *dbName, NNshDBInfo *info)
{
    LocalID dbId;
    
    dbId = DmFindDatabase(0, dbName);

    // f[^x[X݂ȂƂ
    if (dbId == 0)
        return(~errNone);

    return(DmDatabaseInfo(0, dbId,
                          info->nameP, info->attributesP,
                          info->versionP, info->crDateP,
                          info->modDateP, info->bckUpDateP,
                          info->modNumP, info->appInfoIDP,
                          info->sortInfoIDP, info->typeP,
                          info->creatorP));
}


/*==========================================================================*/
/*  net_open() : lbg̃I[v                                           */
/*                                                                          */
/*==========================================================================*/
Err NNshNet_open(UInt16 *netRef)
{
    UInt16 ifErr;
    Err    ret;

    // ϐ̏
    ifErr = 0;

    // lbgCũI[v
    (void) SysLibFind("Net.lib", netRef);

    // lbg[Nnodm
    ret   = NetLibOpen(*netRef, &ifErr);
    if ((ret == errNone)||(ret == netErrAlreadyOpen))
    {
        if (ifErr == 0)
        {
            // open
            return (errNone);
        }
        (void) NetLibClose(*netRef, false);
        *netRef = 0;
        ret = ~errNone;
    }
    return (ret);
}

/*==========================================================================*/
/*  net_close() : lbg̃N[Y                                          */
/*                                                                          */
/*==========================================================================*/
Err NNshNet_close(UInt16 netRef)
{
    return (NetLibClose(netRef, false));
}

/*==========================================================================*/
/*  net_write() : f[^𑗐M                                          */
/*                                                                          */
/*==========================================================================*/
Err NNshNet_write(UInt16 netRef, NetSocketRef socketRef, UInt16 size, void *data, Int32 timeout)
{
    Err    err;
    Int16  ret;

    ret = NetLibSend(netRef, socketRef, data, size, 0, NULL, 0, timeout, &err);
    if (ret == -1)
    {
        return (err);
    }
    return (errNone);
}

/*==========================================================================*/
/*  net_read() : f[^M                                           */
/*                                                                          */
/*==========================================================================*/
Err NNshNet_read(UInt16 netRef, NetSocketRef socketRef, UInt16 size, void *data, UInt16 *readSize, Int32 timeout)
{
    Err    err;
    Int16  ret;
    UInt8 *ptr;

    *readSize = 0;
    ptr       = data;
    while (*readSize < size)
    {
        ret = NetLibReceive(netRef, socketRef, ptr, (size - *readSize),
                            0, NULL, 0, timeout, &err);
        if (ret == -1)
        {
            return (err);
        }
        if (ret == 0)
        {
            break;
        }

        *readSize = *readSize + ret;
        ptr = ptr + ret;
    }
    return (errNone);
}

/*==========================================================================*/
/*  net_disconnect() : zXg؂藣                                   */
/*                                                                          */
/*==========================================================================*/
Err NNshNet_disconnect(UInt16 netRef, NetSocketRef socketRef, Int32 timeout)
{
    Err    err;

    (void) NetLibSocketShutdown(netRef, socketRef, netSocketDirBoth, timeout, &err);
    (void) NetLibSocketClose(netRef, socketRef, timeout, &err);
    if (err == errNone)
    {
        socketRef = 0;
    }
    return (errNone);
}

/*==========================================================================*/
/*  net_connect() : zXgɐڑ                                            */
/*                                                                          */
/*==========================================================================*/
Err NNshNet_connect(NetSocketRef *socketRef, UInt16 netRef, Char *hostName,
                    UInt16 port, Int32 timeout)
{
    Err                  err;
    UInt8                openFlag;
    Int16                ret, addrLen;
    NetHostInfoPtr       hostIP;
    NetSocketAddrINType *addrType;
    NetSocketAddrType    addrBuf;
    NetHostInfoBufType  *infoBuff;

    // ڑXV(ǉ...)
    NetLibConnectionRefresh(netRef, true,  &openFlag, &ret);

    // obt@̈m
    infoBuff = MemPtrNew(sizeof(NetHostInfoBufType));
    if (infoBuff == NULL)
    {
        FrmCustomAlert(ALTID_INFO, "NNshNet_connect",  "MemPtrNew", "");
        return (~errNone);
    }

    // zXgIPAhX擾
    hostIP = NetLibGetHostByName(netRef, hostName, infoBuff, timeout, &err);
    if (hostIP == 0)
    {
        // zXgIP̎擾s
        err = NNSH_ERRORCODE_FAILURECONNECT;
        FrmCustomAlert(ALTID_INFO, "NNshNet_connect",  "NetLibGetHostByName :",  hostName);
        goto FUNC_END;
    }

    // \PbgOPEN
    *socketRef = NetLibSocketOpen(netRef, netSocketAddrINET, 
                                  netSocketTypeStream, netSocketProtoIPTCP,
                                  timeout, &err);
    if (*socketRef == -1)
    {
        // \PbgOPENُ
        FrmCustomAlert(ALTID_INFO, "NNshNet_connect",  "NetLibSocketOpen", "");
        *socketRef = 0;
        err = NNSH_ERRORCODE_FAILURECONNECT;
        goto FUNC_END;
    }

    // \PbgRlNg
    MemSet(&addrBuf, sizeof(NetSocketAddrType), 0x00);
    addrType = (NetSocketAddrINType *) &addrBuf;
    addrType->family = netSocketAddrINET;
    addrType->port   = NetHToNS(port);
    //addrType->addr   = infoBuff->address[0];
    MemMove(&(addrType->addr), *(hostIP->addrListP), hostIP->addrLen); 
    addrLen         = sizeof(NetSocketAddrType);
    err             = errNone;
    ret = NetLibSocketConnect(netRef, *socketRef,
                              (NetSocketAddrType *) &addrBuf,
                              addrLen, timeout, &err);
    if (ret == -1)
    {
        // \PbgRlNgُ
        FrmCustomAlert(ALTID_INFO, "NNshNet_connect",  "NetLibSocketConnect", "");
        (void) NetLibSocketClose(netRef, *socketRef, timeout, &err);
        err = NNSH_ERRORCODE_FAILURECONNECT;
        goto FUNC_END;
    }
    err = errNone;

FUNC_END:
    // obt@̈J
    (void) MemPtrFree(infoBuff);

    return (err);
}

/*==========================================================================*/
/*  NNshNet_LineHangup() : ؒf                                         */
/*                                                                          */
/*==========================================================================*/
void NNshNet_LineHangup(void)
{
   UInt16 netRef;

   (void) SysLibFind("Net.lib", &(netRef));

    // ؒf̊mF
    if (netRef != 0)
    {
        (void) NetLibClose(netRef, true);
        (void) NetLibFinishCloseWait(netRef);
    }
    return;
}

/*==========================================================================*/
/*  NNshSSL_callbackFunc() : SSL̃R[obN֐                          */
/*                                                                          */
/*==========================================================================*/
Int32 NNshSSL_callbackFunc(SslCallback *callbackStruct, Int32 command,
                           Int32 flavor, void *info)
{
  //  Ƃ肠AȂBBB
#ifdef DEBUG
    Char buffer[128];
    MemSet(buffer, sizeof(buffer), 0x00);
    NUMCATH(buffer, command);
    StrCat(buffer, " ");
    NUMCATH(buffer, flavor);    
    // R[obNĂ΂ꂽ...
    FrmCustomAlert(ALTID_INFO, "NNshSSL_callbackFunc()", " ", buffer);
    return (0);
#endif
#if 0
    SslVerify *verifyData;

    switch (command)
    {
      case sslCmdVerify:
        // 'verify callback'
        verifyData = (SslVerify *) info;
        // ̊֐̌ŋᖡ
        break;

      case sslCmdInfo:
        // FrmCustomAlert(ALTID_INFO,"SSL_callback"," Info:","sslCmdInfo");
        return (errNone);
        break;
      case sslCmdNew:
        // FrmCustomAlert(ALTID_INFO,"SSL_callback"," New:","sslCmdNew");
        return (errNone);
        break;
      case sslCmdReset:
        // FrmCustomAlert(ALTID_INFO,"SSL_callback"," Reset:","sslCmdReset");
        return (errNone);
        break;

      case sslCmdFree:
        // FrmCustomAlert(ALTID_INFO,"SSL_callback"," Free:","sslCmdFree");
        return (errNone);
        break;

      default:
        // FrmCustomAlert(ALTID_INFO, "SSL_callback", " cmd:", "???");
        return (errNone);
        break;
    }

    // Verify(certificate)
    // FrmCustomAlert(ALTID_INFO, "SSL_callback", " code:", "flavor");
    switch (flavor)
    {
      case sslErrBadDecode:
        // ܂ؖfR[hłȂ
      case sslErrCert:
        // ʓIȏؖG[
      case sslErrCertDecodeError:
        // ؖ̃fR[hɎs
      case sslErrUnsupportedCertType:
        // T[o킯̂킩iT|[gĂȂjؖ𑗂Ă
      case sslErrUnsupportedSignatureType:
        // T[o킯̂킩VOl`𑗂Ă
      case sslErrVerifyBadSignature:
        // ؖ̃VOl`
      case sslErrVerifyNoTrustedRoot:
        // ؖȂ
      case sslErrVerifyNotAfter:
        // ̗ؖL؂Ă
      case sslErrVerifyNotBefore:
        // ؖ̓tɂȂĂ
      case sslErrVerifyConstraintViolation:
        // ؖX509̊gɈᔽĂ
      case sslErrVerifyUnknownCriticalExtension:
        // X509gؖ`FbN[`ŉ߂łȂ
      case sslErrOk:
      default:
        // NULL
        break;
    }
#endif
    return (errNone);
}

/*==========================================================================*/
/*  NNshSSL_open() : SSLCũI[v                                */
/*                                                                          */
/*==========================================================================*/
Err NNshSSL_open(UInt16 sslMode, UInt16 *netRef,
                 UInt16 *sslRef, SslLib **template, SslContext **context)
{
    Err ret;

    // ϐ̏
    *netRef   = 0;
    *sslRef   = 0;
    *template = NULL;
    *context  = NULL;

    // NetCũI[v
    ret = NNshNet_open(netRef);
    if (ret != errNone)
    {
#ifdef DEBUG
        // fobO\BBB
        FrmCustomAlert(ALTID_INFO, "ERR>NNshNet_open()", " ", " ");
#endif
        *netRef = 0;
        return (ret);
    }

    if (sslMode == NNSH_SSLMODE_NOTSSL)
    {
        // SSL[hłȂA܂Ԃ
#ifdef DEBUG
        // fobO\BBB
        FrmCustomAlert(ALTID_INFO, "ERR>NOT SSL", " ", " ");
#endif
        return (ret);
    }

    // SSLCũI[v
    if (SysLibFind(kSslDBName, sslRef) != 0)
    {
        if (SysLibLoad(kSslLibType, kSslLibCreator, sslRef) != 0)
        {
#ifdef DEBUG
        // fobO\BBB
        FrmCustomAlert(ALTID_INFO, "ERR>SysLibLoad()", " ", " ");
#endif
            // [hsAG[
            *sslRef = 0;
            return (~errNone);
        }
    }
    ret = SslLibOpen(*sslRef);
    if (ret != errNone)
    {
#ifdef DEBUG
        // fobO\BBB
        FrmCustomAlert(ALTID_INFO, "ERR>SslLibOpen()", " ", " ");
#endif
        // SSLCuI[vsAAA
        (void) SslLibClose(*sslRef);
        *sslRef = 0;
        return (ret);
    }

    // generic SSL context̍쐬
    ret = SslLibCreate (*sslRef, template);
    if (ret != errNone)
    {
#ifdef DEBUG
        // fobO\BBB
        FrmCustomAlert(ALTID_INFO, "ERR>SslLibCreate()", " ", " ");
#endif
        (void) SslLibClose(*sslRef);
        *sslRef = 0;
        return (ret);
    }

    // Rp`tÕZbg
    // SslLibSet_Compat(*sslRef, *template, sslCompatAll);

    // SSL context̍쐬
    ret = SslContextCreate(*sslRef, *template, context);
    if (ret != errNone)
    {
#ifdef DEBUG
        // fobO\BBB
        FrmCustomAlert(ALTID_INFO, "ERR>SslContextCreate()", " ", " ");
#endif
        // generic SSL context̔p
        (void) SslLibDestroy(*sslRef, *template);
        (void) SslLibClose(*sslRef);
        *sslRef = 0;
        *template = NULL;
        return (ret);
    }
    return (ret);
}

/*==========================================================================*/
/*  NNshSSL_close() : SSLCũN[Y                               */
/*                                                                          */
/*==========================================================================*/
Err NNshSSL_close(UInt16 sslMode, UInt16 netRef,
                         UInt16 sslRef, SslLib *template, SslContext *context)
{
    if ((sslRef == 0)||(sslMode == NNSH_SSLMODE_NOTSSL))
    {
        NNshNet_close(netRef);
        return (errNone);
    }

    if (context != NULL)
    {
        (void) SslContextDestroy(sslRef, context);
    }

    if (template != NULL)
    {
        (void) SslLibDestroy(sslRef, template);
    }
    (void) SslLibClose(sslRef);

    (void) NNshNet_close(netRef);
    return (errNone);
}

/*==========================================================================*/
/*  NNshSSL_connect() : SSLڑ                                             */
/*                                                                          */
/*==========================================================================*/
Err NNshSSL_connect(UInt16 sslMode, UInt16 sslRef, SslContext *context,
                    NetSocketRef *socketRef, UInt16 netRef,
                    Char *hostName, UInt16 port, Int32 timeout)
{
    Err         ret;
    UInt16      sslFlags;
    SslCallback verifyCallback;

    // TCP/IPŃzXgɐڑ
    ret = NNshNet_connect(socketRef, netRef, hostName, port, timeout);
    if ((ret != errNone)||(sslMode == NNSH_SSLMODE_NOTSSL))
    {
#ifdef DEBUG
            // HTTPŒʐM邱Ƃ\
            FrmCustomAlert(ALTID_INFO, "NNshNet_connect()", " ", " ");
#endif
        return (ret);
    }

    // // VerifyR[obN֐ݒ肷
    MemSet(&verifyCallback, sizeof(SslCallback), 0x00);
    verifyCallback.callback = NNshSSL_callbackFunc;
    SslContextSet_VerifyCallback(sslRef, context, &verifyCallback);

    // contextZbg
//    SslContextSet_Mode(sslRef, context, SslContextGet_Mode(sslRef, context));


    // \PbgContextɐݒAzXgɐڑ
    //SslContextSet_Compat(sslRef, context, sslCompatAll);
    SslContextSet_Compat(sslRef, context, sslCompatBigRecords);
    SslContextSet_Socket(sslRef, context, *socketRef);
    ret = netErrTimeout;
    sslFlags = (sslOpenModeSsl)|(sslOpenUseDefaultTimeout);
//  sslFlags = (sslOpenModeSsl)|(sslOpenNewConnection)|(sslOpenUseDefaultTimeout);
    while (ret == netErrTimeout)
    {
        ret = SslOpen(sslRef, context, sslFlags, 0);
#ifdef DEBUG
        // fobO\BBB
        FrmCustomAlert(ALTID_INFO, "SslOpen()", " ", " ");
#endif
//        sslFlags = (sslOpenModeSsl)|(sslOpenUseDefaultTimeout);
//        sslFlags = sslOpenUseDefaultTimeout | sslOpenBufferedReuse;  // 2ڂ̌Ăяoɂ́AtONAAƁB
    }
    return (ret);
}

/*==========================================================================*/
/*  NNshSSL_disconnect() : SSLؒf                                          */
/*                                                                          */
/*==========================================================================*/
Err NNshSSL_disconnect(UInt16 sslMode, UInt16 sslRef, SslContext *context,
                       NetSocketRef socketRef, UInt16 netRef, Int32 timeout)
{
    Err ret;
    if (sslMode != NNSH_SSLMODE_NOTSSL)
    {
        ret = SslClose(sslRef, context, sslCloseUseDefaultTimeout, timeout);
    }
    ret = NNshNet_disconnect(netRef, socketRef, timeout);

    return (errNone);
}

/*==========================================================================*/
/*  NNshSSL_write() : f[^M(SSL)                                       */
/*                                                                          */
/*==========================================================================*/
Err NNshSSL_write(UInt16 sslMode, UInt16  netRef, NetSocketRef socketRef,
                  UInt16 sslRef, SslContext *context, UInt16 size, void *data,
                  Int32  timeout)
{
    Err   err;
    Int16 ret;

    // SSL[hłȂ΁Aʏ̏ݏs
    if (sslMode == NNSH_SSLMODE_NOTSSL)
    {
        return (NNshNet_write(netRef, socketRef, size, data, timeout));
    }

    // f[^
    ret = SslWrite(sslRef, context, data, size, &err);
    if (ret  == -1)
    {
        return (err);
    }
    return (errNone);
}

/*==========================================================================*/
/*  NNshSSL_read() : f[^M(SSL)                                        */
/*                                                                          */
/*==========================================================================*/
Err NNshSSL_read(UInt16 sslMode, UInt16  netRef, NetSocketRef socketRef,
                 UInt16 sslRef, SslContext *context,
                 UInt16 size, void *data, UInt16 *readSize, Int32 timeout)
{
    Err    err;
    Int16  ret;

    // SSL[hłȂ΁Aʏ̓ǂݏos
    if (sslMode == NNSH_SSLMODE_NOTSSL)
    {
        return (NNshNet_read(netRef, socketRef, size, data, readSize, timeout));
    }
    
    // f[^ǂݍ
    ret = SslRead(sslRef, context, data, size, &err);
    if (ret == -1)
    {
        return (err);
    }
    *readSize = ret;
    return (errNone);
}

/*==========================================================================*/
/*  NNshSSL_flush() : f[^obt@̃NA(SSL)                       */
/*                                                                          */
/*==========================================================================*/
Err NNshSSL_flush(UInt16 sslMode, UInt16  sslRef, SslContext *context)
{
    if (sslMode != NNSH_SSLMODE_NOTSSL)
    {
        // f[^obt@̃NAw
        SslContextSet_Mode(sslRef, context, (sslModeFlush));
    }
    return (errNone);
}

/*=========================================================================*/
/*   Function : SendToLocalMemopad                                         */
/*                    Exchange}l[WgpăɃf[^] */
/*                    (http://www.palmos.com/dev/support/docs/recipes/     */
/*                                    recipe_exg_mgr_send_local.html ) */
/*=========================================================================*/
Err SendToLocalMemopad(Char *title, Char *data)
{
    ExgSocketType *exgSocket;
    Char          exgName[] = "?_local:Msg.txt";
    UInt32        size, creatorId;
    Err           err;

    // f[^̏
    exgSocket = MemPtrNew(sizeof(ExgSocketType));
    if (exgSocket == NULL)
    {
        // ̈mێs
        return (~errNone);
    }
    MemSet(exgSocket, sizeof(ExgSocketType), 0x00);
    err  = errNone;
    size = StrLen(data) + 1;

    // X]ANȂ悤ɂ
    exgSocket->noGoTo      = 1;

    // X]\sȂ
    exgSocket->noStatus    = true;

    // will comm. with memopad app
    exgSocket->description = title;
    exgSocket->name        = exgName;
    exgSocket->type        = ".TXT";

    creatorId = 0;
    ExgGetDefaultApplication(&creatorId,  exgRegExtensionID , "txt");
    if (creatorId == 'DTGP')
    {
        // Palm TX́AȂ Docs To Go ɓnĂ܂̂...
        // ( memo (Vł̃)֓n悤ɂB
        exgSocket->target = 'PMem';
    }

    // set to comm. with local machine (PIM) only
    exgSocket->localMode = 1;

    err = ExgPut(exgSocket);
    if (err == errNone)
    {
        ExgSend(exgSocket, data, size, &err);
        ExgDisconnect(exgSocket, err);
    }

    // mۗ̈̉
    MEMFREE_PTR(exgSocket);

    return (err);
}

/*=========================================================================*/
/*   Function : ShowVersion_NNsh                                           */
/*                                                    o[W̕\ */
/*=========================================================================*/
void ShowVersion_NNsh(void)
{
    Char *buffer;
    
    buffer = MemPtrNew(BUFSIZE * 2);
    if (buffer == NULL)
    {
        // ̈mێs
        return;
    }
    MemSet (buffer, (BUFSIZE * 2), 0x00);
    StrCopy(buffer, SOFT_NAME);
    StrCat (buffer, "\n");
    StrCat (buffer, SOFT_VERSION);
    StrCat (buffer, SOFT_REVISION);
    StrCat (buffer, "\n(");
    StrCat (buffer, SOFT_DATE);
    StrCat (buffer, ")\n    ");
    StrCat (buffer, SOFT_INFO);
    FrmCustomAlert(ALTID_INFO, buffer, "", "");

    MEMFREE_PTR(buffer);
    return;
}

/*=========================================================================*/
/*   Function :  NNshWinSetFieldText                                       */
/*                                                tB[heLXg̍XV */
/*=========================================================================*/
void NNshWinSetFieldText(FormType *frm, UInt16 fldID, Char *msg, UInt32 size)
{
    MemHandle  txtH, oldTxtH;
    Char      *txtP;
    FieldType *fldP;

    // bZ[W\̈ɃRs[
    txtH = MemHandleNew(size + MARGIN);
    if (txtH == 0)
    {
        // ̈̊mۂɎs
        return;
    }
    txtP = (Char *) MemHandleLock(txtH);
    if (txtP == NULL)
    {
        // ̈̊mۂɎs
        MemHandleFree(txtH);
        return;
    }
    (void) MemSet(txtP,  size + MARGIN, 0x00);
    if (size != 0)
    {
        (void) StrNCopy(txtP, msg, size);
    }
    MemHandleUnlock(txtH);

    // tB[h̃IuWFNg|C^擾
    fldP = (FieldType *) FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, fldID));

    // tB[h̃eLXgnhւAÂ̂폜
    oldTxtH = FldGetTextHandle(fldP);
    FldSetTextHandle(fldP, NULL);
    FldSetTextHandle(fldP, txtH);
    if (oldTxtH != 0)
    {
        (void) MemHandleFree(oldTxtH);
    }

    // tH[̍ĕ`
    FrmDrawForm(frm);
    return;
}

/*=========================================================================*/
/*   Function :  NNshWinGetFieldText                                       */
/*                                                tB[heLXg̎擾 */
/*=========================================================================*/
void NNshWinGetFieldText(FormType *frm, UInt16 fldID, Char *area, UInt32 len)
{
    MemHandle  txtH;
    Char      *txtP;
    FieldType *fldP;

    // tB[hi[̈
    MemSet(area, len, 0x00);

    // tB[h̃IuWFNg|C^擾
    fldP = (FieldType *) FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, fldID));

    // tB[h̃eLXgnh擾
    txtH = FldGetTextHandle(fldP);
    if (txtH != 0)
    {
        txtP = MemHandleLock(txtH);
        if (txtP != NULL)
        {
            StrNCopy(area, txtP, (len - 1));
            MemHandleUnlock(txtH);
        }
    }
    return;
}

/*=========================================================================*/
/*   Function : NNshWinSetPopItems                                         */
/*                                          |bvAbvgK̃xݒ */
/*=========================================================================*/
void NNshWinSetPopItems(FormType *frm, UInt16 popId, UInt16 lstId, UInt16 item)
{
    ListType    *lstP;
    ControlType *ctlP;

    ctlP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, popId));
    lstP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, lstId));
                          
    LstSetTopItem  (lstP, item);
    LstSetSelection(lstP, item);
    CtlSetLabel    (ctlP, LstGetSelectionText(lstP, item));

    return;
}

/*=========================================================================*/
/*   Function : DataInputDialog                                            */
/*                                                NNsiʂ̓̓_CAO */
/*=========================================================================*/
Boolean InputDialog(Char *title, Char *area, UInt16 size)
{
    Boolean       ret = false;
    FormType     *prevFrm, *diagFrm;
    FieldType    *fldP;

    // ʂ
    ret     = false;
    prevFrm = FrmGetActiveForm();

    // _CAOtH[ANeBuɂ
    diagFrm  = FrmInitForm(FRMID_INPUTDIALOG);
    if (diagFrm == NULL)
    {
        return (false);
    }
    FrmSetActiveForm(diagFrm);

    // ^CgRs[
    FrmCopyTitle(diagFrm, title);

    // w肳ꂽEBhEɔf
    NNshWinSetFieldText(diagFrm, FLDID_INPUTFIELD, area, size);
    FrmSetFocus(diagFrm, FrmGetObjectIndex(diagFrm, FLDID_INPUTFIELD));

    fldP = FrmGetObjectPtr(diagFrm,
                           FrmGetObjectIndex(diagFrm, FLDID_INPUTFIELD));

    // IĂ
    FldSetSelection(fldP, 0, FldGetTextLength(fldP));

    // Cxgnh̐ݒ
    FrmSetEventHandler(diagFrm, Handler_EditAction);

    if (FrmDoDialog(diagFrm) == BTNID_DIALOG_OK)
    {
        // OK{^ꂽƂɂ́A擾
        NNshWinGetFieldText(diagFrm, FLDID_INPUTFIELD, area, size);
        ret = true;
    }
    FrmSetActiveForm(prevFrm);
    FrmDeleteForm(diagFrm);

    return (ret);
}

/*=========================================================================*/
/*   Function : SetMsg_BusyForm                                            */
/*                                                     BUSYeLXg̐ݒ  */
/*=========================================================================*/
void SetMsg_BusyForm(Char *msg)
{
    FormType *busyFrm;
    UInt16    length;

    // \镶񒷂̃`FbN
    length = StrLen(msg);
    length = (length > BUSYWIN_MAXLEN) ? BUSYWIN_MAXLEN : length;

    busyFrm = FrmGetActiveForm();
    NNshWinSetFieldText(busyFrm, FLDID_BUSY, msg, length);

    return;
}

/*=========================================================================*/
/*   Function : Show_BusyForm                                              */
/*                                                      BUSYtH[̕\ */
/*=========================================================================*/
void Show_BusyForm(Char *msg, NNshWorkingInfo *NNshGlobal)
{
    FormType  *busyFrm;
    UInt16    length;

    switch (FrmGetActiveFormID())
    {
      case FRMID_BUSY:
        // łBUSYEBhE\Ăꍇ
        return (SetMsg_BusyForm(msg));
        break;

      case 0:
        // EBhEJĂȂ
        NNshGlobal->prevBusyForm = NULL;
        break;

      default:
        // ݂̃EBhEL
        NNshGlobal->prevBusyForm = FrmGetActiveForm();
        break;
    }

    // tH[݂̌̏ԂL
    // MemSet(&(NNshGlobal->formState), sizeof(FormActiveStateType), 0x00);
    // FrmSaveActiveState(&(NNshGlobal->formState));
    // NNshGlobal->prevBusyForm = FrmGetActiveForm();

    // BUSY_CAOtH[𐶐AANeBuɂ
    busyFrm = FrmInitForm(FRMID_BUSY);
    FrmSetActiveForm(busyFrm);

    // \镶񒷂̃`FbN
    length = StrLen(msg);
    length = (length > BUSYWIN_MAXLEN) ? BUSYWIN_MAXLEN : length;

    // tB[hɕݒ
    NNshWinSetFieldText(busyFrm, FLDID_BUSY, msg, length);

    return;
}

/*=========================================================================*/
/*   Function : Hide_BusyForm                                              */
/*                                                      BUSYtH[̍폜 */
/*=========================================================================*/
void Hide_BusyForm(NNshWorkingInfo *NNshGlobal)
{
    FormType *frm;

    if (FrmGetActiveFormID() != FRMID_BUSY)
    {
        // Ȃ
        return;
    }

    // BUSYtH[폜
    frm = FrmGetActiveForm();
    if (NNshGlobal->prevBusyForm != NULL)
    {
        // Ȃł̂...
        FrmEraseForm (frm);
        FrmSetActiveForm(NNshGlobal->prevBusyForm);
    }
    FrmDeleteForm(frm);

    // FrmRestoreActiveState(&(NNshGlobal->formState));

    return;
}

/**----------------------------------------------------------------------**
 **   doLogin_HotSpot 
 **     (HotSpotɃOC)
 **                                            type : IISP
 **                                            msg  : OC{
 **----------------------------------------------------------------------**/
void doLogin_HotSpot(NNshSavedPref *NNshParam,NNshWorkingInfo *NNshGlobal)
{
    // ڑ́Ahttp://sourceforge.jp/ Ƃ  (x^ɋL...)
    MemSet(NNshParam->hostName, BUFSIZE, 0x00);
    StrCopy(NNshParam->hostName, "sourceforge.jp");

#ifdef DEBUG_LOCALHOST_ADDRESS
    // MfobOzXgɕύX...
    StrCopy(NNshParam->hostName, DEBUG_ADDRESS);
#endif  // #ifdef DEBUG_LOCALHOST_ADDRESS

    // |[gԍi[
    NNshParam->portNum = 80;

    // Cookie
    MemSet(NNshGlobal->cookie, (BUFSIZE + MARGIN), 0x00);

    // t@Ci[
    MemSet (NNshGlobal->reqAddress, (BUFSIZE * 2), 0x00); 
    StrCopy(NNshGlobal->reqAddress, "/");

#ifdef SUPPORT_BIZPOTAL
    // BizportalɃOCꍇ...
    if (NNshParam->protocol == ISP_BIZPORTAL)
    {
        //  bizportal ̃OCtH[ɔ΂...
        StrCopy(NNshParam->hostName, "www.bizportal.jp");
        StrCopy(NNshGlobal->reqAddress, "/en/login/login-01.php");
        NNshParam->portNum = 443;
    }
#endif // #ifdef SUPPORT_BIZPOTAL

    // bZ[W{fBȂ
    MemSet (NNshGlobal->workBuf, ((NNshParam->bufferSize) / 2), 0x00);
    StrCopy(NNshGlobal->workBuf, " ");

    // HTTP, GET\bhgp
    NNshGlobal->sendMethod = NNSILOGIN_GET_METHOD_HTTP;

    // bZ[W쐬
    NNsh_MakeHTTPmsg(NNshParam, NNshGlobal);

#ifdef DEBUG_SENDLOG
    // fobOpɑMf[^֏o͂
    SendToLocalMemopad("FIRST CONNECTION", NNshGlobal->sendBuf);
#endif

    // HTTPʐM{
    NNshHTTP_comm(NNshParam, NNshGlobal);
    if (NNshGlobal->err != errNone)
    {
#ifdef DEBUG
        // ʐMsAG[
        FrmCustomAlert(ALTID_INFO, "NNshHTTP_comm", " ", " ");
#endif
        return;
    }

#ifdef DEBUG
    // fobOpɎMf[^֏o͂
    StrCat(NNshGlobal->recvBuf, "\n\n>< >< ><\n(FIRST REPLY)\n");
    SendToLocalMemopad("FIRST REPLY(RX)", NNshGlobal->recvBuf);
#endif

    // MbZ[WɃ_CNg̎w邩A`FbNs
    NNshGlobal->err = ~errNone - 9;
    if ((StrStr(NNshGlobal->recvBuf, "HTTP/1.0 302") != NULL)||
        (StrStr(NNshGlobal->recvBuf, "HTTP/1.1 302") != NULL))
    {
        // _CNg̃zXgƃTCg𒊏o
        NNsh_check302URL(NNshParam, NNshGlobal);
    }
    else
    {
#ifdef DEBUG
        // _CNgȂƂ𑗐M
        FrmCustomAlert(ALTID_INFO, "DO NOT REDIRECT...", " ", " ");
#endif
    }

REDIRECT_AGAIN:
    if (NNshGlobal->err == errNone)
    {
#ifdef DEBUG_LOCALHOST_ADDRESS
    // _CNg̃AhX擾ł
        // MfobOzXgɕύX...
        StrCopy(NNshParam->hostName, DEBUG_ADDRESS);
#endif  // #ifdef DEBUG_LOCALHOST_ADDRESS

        // bZ[W쐬
        NNsh_MakeHTTPmsg(NNshParam, NNshGlobal);

#ifdef DEBUG
        // fobOpɑMf[^֏o͂
        SendToLocalMemopad("SEND(REDIRECT)", NNshGlobal->sendBuf);
#endif

        // _CNgɁiMvgRɍ킹āj
        if ((NNshGlobal->sendMethod & NNSHLOGIN_SSL_PROTOCOL) ==
                                                        NNSHLOGIN_SSL_PROTOCOL)
        {
#ifdef DEBUG
            // HTTPSŒʐM邱Ƃ\
            FrmCustomAlert(ALTID_INFO, "HTTPS(SSL) CONNECTION...", " ", " ");
#endif

            // httpsʐMv
            NNshHTTPS_comm(NNshParam, NNshGlobal);
        }
        else
        {
#ifdef DEBUG
            // HTTPSŒʐM邱Ƃ\
            FrmCustomAlert(ALTID_INFO, "HTTP CONNECTION...", " ", " ");
#endif

            // httpʐMv
            NNshHTTP_comm(NNshParam, NNshGlobal);
        }
        if (NNshGlobal->err != errNone)
        {
#ifdef DEBUG
            // ʐMsAG[ (1212)
            NUMCATH(NNshGlobal->referer, NNshGlobal->err);
            FrmCustomAlert(ALTID_INFO, "NNshHTTP_comm", NNshGlobal->referer, "(redirect)");
#endif
            return;
        }
#ifdef DEBUG
        // fobOpɎMf[^֏o͂
        StrCat(NNshGlobal->recvBuf, "\n\n>< >< ><\n(REDIRECT)\n");
        SendToLocalMemopad("REDIRECT(RX)", NNshGlobal->recvBuf);
#endif
    }

#if 1
    // 񃊃_CNgH
    if ((StrStr(NNshGlobal->recvBuf, "HTTP/1.0 302") != NULL)||
        (StrStr(NNshGlobal->recvBuf, "HTTP/1.1 302") != NULL))
    {
        if (NNshGlobal->isRedirect < 2)
        {
            // _CNg̃zXgƃTCg𒊏o
            NNsh_check302URL(NNshParam, NNshGlobal);
            (NNshGlobal->isRedirect)++;  // _CNg͂Q܂...
            goto REDIRECT_AGAIN;
        }
    }
#endif    //#if 0

    // LANyȂǁAēxy[WJȂĂ͂ȂȂꍇ...
    NNsh_checkRefreshConnectionRequest(NNshParam, NNshGlobal);
    if (NNshGlobal->err == errNone)
    {
#ifdef DEBUG
        // ēx_CNg邱Ƃ𑗐M
        FrmCustomAlert(ALTID_INFO, 
                       "REDIRECT AGAIN...(", NNshGlobal->reqAddress, ")");
#endif
        goto REDIRECT_AGAIN;
    }

ANALYSIS_LOGIN:
    // OCtH[̉͂ƑM{fB̍쐬
    Analysis_LoginForm(NNshParam, NNshGlobal);

#ifdef DEBUG_LOCALHOST_ADDRESS
    // MfobOzXgɕύX...
    StrCopy(NNshParam->hostName, DEBUG_ADDRESS);
#endif  // #ifdef DEBUG_LOCALHOST_ADDRESS

#ifdef DEBUG
    FrmCustomAlert(ALTID_INFO, "MAKE HTTP TO LOGIN", " ", NNshGlobal->workBuf);
#endif

    // OCp̃bZ[W쐬
    NNsh_MakeHTTPmsg(NNshParam, NNshGlobal);

#ifdef DEBUG_SENDLOG
    // fobOpɑMf[^֏o͂
    SendToLocalMemopad("SEND(DO LOGIN)", NNshGlobal->sendBuf);
#endif

    // OCbZ[W(MvgRɍ킹)M
    if ((NNshGlobal->sendMethod & NNSHLOGIN_SSL_PROTOCOL) == 
                                                        NNSHLOGIN_SSL_PROTOCOL)
    {
        // httpsʐMv
        NNshHTTPS_comm(NNshParam, NNshGlobal);
    }
    else
    {
        // httpʐMv
        NNshHTTP_comm(NNshParam, NNshGlobal);
    }
    if (NNshGlobal->err != errNone)
    {
#ifdef DEBUG
        // ʐMsAG[
        NUMCATH(NNshGlobal->referer, NNshGlobal->err);
        FrmCustomAlert(ALTID_INFO, "NNshHTTP_comm", NNshGlobal->referer, "(redirect)");
#endif
        return;
    }
#ifdef DEBUG
    // fobOpɎMf[^֏o͂
    StrCat(NNshGlobal->recvBuf, "\n\n>< >< ><\n(LOGIN DETAIL)\n");
    SendToLocalMemopad("LOGIN DETAIL(RX)", NNshGlobal->recvBuf);
#endif

    if (NNshGlobal->setPass == 0)
    {
        // pX[hݒł܂łAēxOCցBBB
        // MLCC...
        NNshGlobal->setPass = 1;
#ifdef DEBUG
        // ʐMsAG[
        FrmCustomAlert(ALTID_INFO, "NOT PASSWORD...", " ", "(redirect again)");
#endif
        goto ANALYSIS_LOGIN;
    }

#ifdef LOGIN_AFTER_REDIRECT
    // bizportalȂǁAOC̃y[W𓥂łOɏo悤ɂȂꍇ...
    if ((StrStr(NNshGlobal->recvBuf, "HTTP/1.0 302") != NULL)||
        (StrStr(NNshGlobal->recvBuf, "HTTP/1.1 302") != NULL))
    {
        // _CNg̃zXgƃTCg𒊏o
        NNsh_check302URL(NNshParam, NNshGlobal);

        // Mf[^NA
        NNshGlobal->workBuf[0] = '\0';

        // bZ[W쐬
        NNsh_MakeHTTPmsg(NNshParam, NNshGlobal);

#ifdef DEBUG
        // fobOpɑMf[^֏o͂
        SendToLocalMemopad("SEND(FINAL REDIRECT)", NNshGlobal->sendBuf);
#endif

        // _CNgɁiMvgRɍ킹āj
        if ((NNshGlobal->sendMethod & NNSHLOGIN_SSL_PROTOCOL) ==
                                                        NNSHLOGIN_SSL_PROTOCOL)
        {
#ifdef DEBUG
            // HTTPSŒʐM邱Ƃ\
            FrmCustomAlert(ALTID_INFO, "HTTPS(SSL) CONNECTION...", " ", " ");
#endif
            // httpsʐMv
            NNshHTTPS_comm(NNshParam, NNshGlobal);
        }
        else
        {
#ifdef DEBUG
            // HTTPŒʐM邱Ƃ\
            FrmCustomAlert(ALTID_INFO, "HTTP CONNECTION...", " ", " ");
#endif
            // httpʐMv
            NNshHTTP_comm(NNshParam, NNshGlobal);
       }
#ifdef DEBUG
       // fobOpɎMf[^֏o͂
       StrCat(NNshGlobal->recvBuf, "\n\n>< >< ><\n(FINAL LOGIN DETAIL)\n");
       SendToLocalMemopad("FINAL REDIRECT DETAIL(RX)", NNshGlobal->recvBuf);
#endif
    }
#endif  // #ifdef LOGIN_AFTER_REDIRECT

    // OC"s"ǂmF
    if (StrStr(NNshGlobal->recvBuf, "s") != NULL)
    {
        // sƂ񂪂ꍇɂ́AOCɎsƔF
        NNshGlobal->err = ~errNone;
    }
    if (StrStr(NNshGlobal->recvBuf, "res=failed") != NULL)
    {
        // "res=failed"Ƃ񂪂ꍇɂ́AOCɎsƔF
        NNshGlobal->err = ~errNone;
    }
    return;
}

/**----------------------------------------------------------------------**
 **    OCtH[̉͂ƑM{fB̉
 ** 
 **                NNshGlobal->recvBuf F M{fB
 **                NNshGlobal->workBuf F Mp{fB(ō쐬)
 **
 **                   NNshGlobal->err ɉR[hi[ďI 
 **----------------------------------------------------------------------**/
void Analysis_LoginForm(NNshSavedPref *NNshParam, NNshWorkingInfo *NNshGlobal)
{
    NNshGlobal->err = errNone;

    // NNshGlobal->sendBuf [Nobt@Ƃėp
    MemSet(NNshGlobal->sendBuf, NNshParam->bufferSize, 0x00);

    // CookieE
    pickup_cookie(NNshParam, NNshGlobal);

    // POSTy[W擾
    pickup_formTag(NNshParam, NNshGlobal);

    // f[^͈̉ʒu肷
    NNshGlobal->tempPtr = NNshGlobal->recvBuf;

    // Mpobt@NA
    MemSet (NNshGlobal->workBuf, ((NNshParam->bufferSize) / 2), 0x00);

    // tH[f[^𑗐M邽߂̃^O𒊏o
    while (NNshGlobal->tempPtr < (NNshGlobal->recvBuf + NNshParam->bufferSize))
    {

        NNshGlobal->tempPtr2 = StrStr(NNshGlobal->tempPtr,"<INPUT");
        if (NNshGlobal->tempPtr2 == NULL)
        {
            NNshGlobal->tempPtr2 = StrStr(NNshGlobal->tempPtr,"<input");
        }
        if ((NNshGlobal->tempPtr2 == NULL)||
            (NNshGlobal->tempPtr2 >= (NNshGlobal->recvBuf + NNshParam->bufferSize)))
        {
            // INPUT^OołȂAI
            break;
        }

        // INPUT^O̓e͂
        pickup_nameTag (NNshParam, NNshGlobal);
        pickup_valueTag(NNshParam, NNshGlobal);

        // key  value i[
        set_name_and_value(NNshParam, NNshGlobal);

        // inputtH[ֈړ
        NNshGlobal->tempPtr = NNshGlobal->tempPtr2 + sizeof("<INPUT");
    }
    return;
}

/**----------------------------------------------------------------------**
 **    MbZ[W̃_CNg(OCy[W)͂
 ** 
 **                    NNshGlobal->recvBuf F M{fB
 **
 **
 **
 **                   NNshGlobal->err ɉR[hi[ďI 
 **----------------------------------------------------------------------**/
void NNsh_check302URL(NNshSavedPref *NNshParam, NNshWorkingInfo *NNshGlobal)
{
    // CookieE
    pickup_cookie(NNshParam, NNshGlobal);

    NNshGlobal->tempPtr = StrStr(NNshGlobal->recvBuf, "http");
    if (NNshGlobal->tempPtr == NULL)
    {
        // RedirectzXg̓ǂݏos (URLw̌os)
        NNshGlobal->err = ~errNone;
        return;
    }

#ifdef USE_REFERER
    // _CNgꂽAhXRefererɐݒ肷
    NNsh_MakeReferer(NNshParam, NNshGlobal);
#endif  // #ifdef USE_REFERER

    // vgR̃`FbN
    NNshGlobal->sendMethod = 0;
    if (NNshGlobal->tempPtr[4] == 's')
    {
        // https (SSL)
        NNshGlobal->sendMethod = NNSILOGIN_GET_METHOD_OTHERSSL;
        if ((NNshParam->portNum == 0)||(NNshParam->portNum == 80))
        {
            // |[gԍw肳ĂȂꍇA|[gԍ
            NNshParam->portNum = 443;
#ifdef DEBUG
            FrmCustomAlert(ALTID_INFO, "Port ", " : ", "443");
#endif
        }
    }
    NNshGlobal->tempPtr = StrStr(NNshGlobal->tempPtr, "://");
    if (NNshGlobal->tempPtr == NULL)
    {
        // zXgoɎs
        NNshGlobal->err = ~errNone + 100;
        return;
    }
    NNshGlobal->tempPtr = NNshGlobal->tempPtr + 3;  // 3́AStrLen("://");

    if (NNshParam->portNum == 0)
    {
        // |[gԍw肳ĂȂꍇA|[gԍ
        NNshParam->portNum = 80;
#ifdef DEBUG
        FrmCustomAlert(ALTID_INFO, "Port ", " : ", "80");
#endif
    }

    // zXg̃Rs[
    MemSet(NNshParam->hostName, BUFSIZE, 0x00);
    for (NNshGlobal->loopCount = 0; 
         NNshGlobal->loopCount < (BUFSIZE - 1); 
         (NNshGlobal->loopCount)++)
    {
        if (*(NNshGlobal->tempPtr) == '/')
        {
            // zXg̏I[
            // (NNshGlobal->tempPtr)++;  // /͂߂...
            break;
        }
        if (*(NNshGlobal->tempPtr) == ':')
        {
            // |[gԍw肳Ă...
            NNshGlobal->sendMethod =
                       (NNshGlobal->sendMethod)|(NNSHLOGIN_CONNECT_PORT);
            (NNshGlobal->tempPtr)++;

            // |[gԍ̓
            NNshParam->portNum = 0;
            while ((*(NNshGlobal->tempPtr) >= '0')&&
                   (*(NNshGlobal->tempPtr) <= '9'))
            {
                NNshParam->portNum = NNshParam->portNum * 10 + 
                                         (*(NNshGlobal->tempPtr) - '0');
                (NNshGlobal->tempPtr)++;
            }
            //(NNshGlobal->tempPtr)++;  // /͂߂...
            break;
        }
        NNshParam->hostName[NNshGlobal->loopCount] = *(NNshGlobal->tempPtr);
        (NNshGlobal->tempPtr)++;
    }

    // ʐMt@C擾
    NNshGlobal->loopCount = 0; 
    if (*(NNshGlobal->tempPtr) != '/')
    {
        // ΃AhXȂ̂ŁA݂̗vpath𐶂悤ɂ
        NNshGlobal->loopCount = StrLen(NNshGlobal->reqAddress);
        while (NNshGlobal->loopCount != 0)
        {
            (NNshGlobal->loopCount)--;
            if (NNshGlobal->reqAddress[NNshGlobal->loopCount] == '/')
            {
                break;
            }
        }
        NNshGlobal->reqAddress[NNshGlobal->loopCount] = '/';
        (NNshGlobal->loopCount)++;
    }
    else
    {
        MemSet(NNshGlobal->reqAddress, (BUFSIZE * 2), 0x00); 
    }
    while (NNshGlobal->loopCount < (BUFSIZE - 1))
    {
        if (*(NNshGlobal->tempPtr) <= ' ')
        {
            break;
        }
        NNshGlobal->reqAddress[NNshGlobal->loopCount] = *(NNshGlobal->tempPtr);
        (NNshGlobal->tempPtr)++;
        (NNshGlobal->loopCount)++;
    }

    // AhXȂ / ɂ
    if (StrLen(NNshGlobal->reqAddress) == 0)
    {
        StrCopy(NNshGlobal->reqAddress, "/");
    }
#ifdef DEBUG
    // ͌ʂ̃Oo͂
    FrmCustomAlert(ALTID_INFO, NNshParam->hostName, " : ", NNshGlobal->reqAddress);
#endif

    // I
    NNshGlobal->err = errNone;
    return;
}

/**----------------------------------------------------------------------**
 **    MbZ[W̃_CNg(OCy[W)ēx͂
 ** 
 **                    NNshGlobal->recvBuf F M{fB
 **
 **
 **
 **                   NNshGlobal->err ɉR[hi[ďI 
 **                    (NnshGlobal->errerrNonêƂ͍ēxURL擾)
 **----------------------------------------------------------------------**/
static void NNsh_checkRefreshConnectionRequest(NNshSavedPref *NNshParam, NNshWorkingInfo *NNshGlobal)
{
    Char   *ptr;

    // CookieE
    pickup_cookie(NNshParam, NNshGlobal);

    // tbVwH
    if (StrStr(NNshGlobal->recvBuf, "http-equiv=\"Refresh\"") == NULL)
    {
        // Ȃꍇɂ́AȂɂȂ
        NNshGlobal->err = ~errNone;
        return;
    }
    if (NNshGlobal->isChecking != 0)
    {
        // x`FbNς݁AQxڂ͂ȂɂȂ
        NNshGlobal->err = ~errNone;
        return;
    }

    ptr = StrStr(NNshGlobal->recvBuf, "URL=");
    if (ptr == NULL)
    {
        ptr = StrStr(NNshGlobal->recvBuf, "url=");
    }
    if (ptr == NULL)
    {
        // URLEȂAI
        NNshGlobal->err = ~errNone;
        return;
    }
    ptr = ptr + sizeof("url");

    // vAhX̐擪T
    while ((*ptr != '/')&&(*ptr != '\0')&&(*ptr != '"'))
    {
        ptr++;
    }
    // XbV͐摗...
    while (*ptr == '/')
    {
        ptr++;
    }

    // URLwŃtZbgw肩ǂ`FbN
    NNshGlobal->tempPtr = StrStr(NNshGlobal->recvBuf, "://");
    if ((NNshGlobal->tempPtr == NULL)||(NNshGlobal->tempPtr > ptr))
    {
        //  tZbgwł͂ȂAzXg(ƃ|[gԍ)̐؂o
        // sȂ...
        goto GET_CONTENT_NAME;
    }

    // zXĝ肾s(zXg̃Rs[)
    MemSet(NNshParam->hostName, BUFSIZE, 0x00);
    for (NNshGlobal->isChecking = 0; 
         NNshGlobal->isChecking < (BUFSIZE - 1); 
         (NNshGlobal->isChecking)++)
    {
        if (*ptr == '/')
        {
            // zXg̏I[
            break;
        }
        if (*ptr == ':')
        {
            // |[gԍw肳Ă...
            NNshGlobal->sendMethod =
                       (NNshGlobal->sendMethod)|(NNSHLOGIN_CONNECT_PORT);
            ptr++;

            // |[gԍ̓
            NNshParam->portNum = 0;
            while ((*ptr >= '0')&&(*ptr <= '9'))
            {
                NNshParam->portNum = NNshParam->portNum * 10 + (*ptr - '0');
                ptr++;
            }
            break;
        }
        NNshParam->hostName[NNshGlobal->isChecking] = *ptr;
        ptr++;
    }

GET_CONTENT_NAME:
    // vAhXRs[
    NNshGlobal->isChecking = 0;
    while ((*ptr != '\0')&&(*ptr != '>')&&(*ptr != '"'))
    {
        NNshGlobal->reqAddress[NNshGlobal->isChecking] = *ptr;
        (NNshGlobal->isChecking)++;
        ptr++;
    }
    NNshGlobal->reqAddress[NNshGlobal->isChecking] = '\0';

    // łxOCtH[擾Ȃ
    NNshGlobal->err = errNone;
    return;
}

/**----------------------------------------------------------------------**
 **    HTTPSʐM(SSL){
 **                    NNshGlobal->workBuf F Mf[^
 **                    NNshGlobal->sendBuf F M{fB(HTTPwb_)
 **
 **                   NNshGlobal->err ɉR[hi[ďI 
 **----------------------------------------------------------------------**/
void NNsh_MakeHTTPmsg(NNshSavedPref *NNshParam,NNshWorkingInfo *NNshGlobal)
{
#ifdef USE_RESOURCE
    MemHandle  strH;
#endif
    Char *src, *dst;

    MemSet(NNshGlobal->sendBuf, NNshParam->bufferSize, 0x00);
    switch (NNshGlobal->sendMethod)
    {
      case NNSILOGIN_POST_METHOD_SSL:
        StrCopy(NNshGlobal->sendBuf, "POST ");
        NNshParam->portNum = 443;
        break;

      case NNSILOGIN_POST_METHOD_HTTP:
        StrCopy(NNshGlobal->sendBuf, "POST ");
        NNshParam->portNum = 80;
        break;

      case NNSILOGIN_GET_METHOD_SSL:
        StrCopy(NNshGlobal->sendBuf, "GET ");
        NNshParam->portNum = 443;
        break;

      case NNSILOGIN_GET_METHOD_HTTP:
        StrCopy(NNshGlobal->sendBuf, "GET ");
        NNshParam->portNum = 80;
        break;

      case NNSILOGIN_POST_METHOD_OTHER:
      case NNSILOGIN_POST_METHOD_OTHERSSL:
        StrCopy(NNshGlobal->sendBuf, "POST ");
        break;

      case NNSILOGIN_GET_METHOD_OTHER:
      case NNSILOGIN_GET_METHOD_OTHERSSL:
      default:
        StrCopy(NNshGlobal->sendBuf, "GET ");
        break;
    }

    if (NNshGlobal->reqAddress[0] != '/')
    {
        StrCat(NNshGlobal->sendBuf, "/");
    }

    dst = NNshGlobal->sendBuf + StrLen(NNshGlobal->sendBuf);

    // M|[gԍ...
    src = NNshGlobal->reqAddress;
    while (*src != '\0')
    {
        // f[^PRs[
        *dst = *src;
        dst++;
        src++;
    }
    //StrCat(NNshGlobal->sendBuf, NNshGlobal->reqAddress);
    StrCat(NNshGlobal->sendBuf, " HTTP/1.0\r\nHost: ");
    StrCat(NNshGlobal->sendBuf, NNshParam->hostName);

    // refererݒ肳Ăꍇɂ͕t
#ifdef USE_REFERER
    if (StrLen(NNshGlobal->referer) != 0)
    {
        StrCat(NNshGlobal->sendBuf, "\r\nReferer: ");
        StrCat(NNshGlobal->sendBuf, NNshGlobal->referer);
    }
#endif

    // {fBȂꍇɂ́AContent-Length, Content-TypeȂ
    if (StrLen(NNshGlobal->workBuf) > 1)
    {
        StrCat(NNshGlobal->sendBuf, "\r\nContent-Length: ");
        StrIToA(&NNshGlobal->sendBuf[StrLen(NNshGlobal->sendBuf)], 
                                      StrLen(NNshGlobal->workBuf));
        StrCat(NNshGlobal->sendBuf, "\r\nContent-Type: application/x-www-form-urlencoded");
    }

    // Cookieǉ
    if (NNshGlobal->cookie[0] != '\0')
    {
        StrCat(NNshGlobal->sendBuf, "\r\n");
        StrCat(NNshGlobal->sendBuf, NNshGlobal->cookie);
    }

    // wb_̎c蕔t
    StrCat(NNshGlobal->sendBuf, "\r\nAccept: text/html, */*\r\nUser-Agent: mlDA/1.02 (PDA; PalmOS/NNsi family)\r\nAccept-Encoding: identity\r\nAccept-Language: ja, en\r\nConnection: close\r\nPragma: no-cache\r\n\r\n");

    // StrCat(NNshGlobal->sendBuf, "\r\n\r\n");   //  \[Xŕt
    StrCat(NNshGlobal->sendBuf, NNshGlobal->workBuf);

    return;
}

/**----------------------------------------------------------------------**
 **    MAhX烊t@쐬
 ** 
 **----------------------------------------------------------------------**/
#ifdef USE_REFERER
static void NNsh_MakeReferer(NNshSavedPref *NNshParam,NNshWorkingInfo *NNshGlobal)
{
    MemSet(NNshGlobal->referer, BUFSIZE, 0x00);
    
    switch (NNshGlobal->sendMethod)
    {
      case NNSILOGIN_POST_METHOD_SSL:
      case NNSILOGIN_GET_METHOD_SSL:
      case NNSILOGIN_POST_METHOD_OTHERSSL:
      case NNSILOGIN_GET_METHOD_OTHERSSL:
        // SSLڑ̏ꍇ...
        StrCopy(NNshGlobal->referer, "https://");
        StrCat (NNshGlobal->referer, NNshParam->hostName);
        if (NNshParam->portNum != 443)
        {
            // |[gԍftHgƂ͈ꍇɂ̓zXg̖ɂ
            StrCopy(&(NNshGlobal->referer[StrLen(NNshGlobal->referer)]), ":");
            StrIToA(&(NNshGlobal->referer[StrLen(NNshGlobal->referer)]), NNshParam->portNum);
        }
        break;

      case NNSILOGIN_POST_METHOD_HTTP:
      case NNSILOGIN_GET_METHOD_HTTP:
      case NNSILOGIN_POST_METHOD_OTHER:
      case NNSILOGIN_GET_METHOD_OTHER:
      default:
        StrCopy(NNshGlobal->referer, "http://");
        StrCat (NNshGlobal->referer, NNshParam->hostName);
        if (NNshParam->portNum != 80)
        {
            // |[gԍftHgƂ͈ꍇɂ̓zXg̖ɂ
            StrCat(NNshGlobal->referer, ":");
            StrIToA(&(NNshGlobal->referer[StrLen(NNshGlobal->referer)]), NNshParam->portNum);
        }
        break;
    }

    // MAhXݒ肷
    if (NNshGlobal->reqAddress[0] != '/')
    {
        StrCat(NNshGlobal->referer, "/");
    }
    StrCat(NNshGlobal->referer, NNshGlobal->reqAddress);

    return;   
}
#endif // #ifdef USE_REFERER

/**----------------------------------------------------------------------**
 **    HTTPSʐM(SSL){
 **                                NNshGlobal->sendBuf F Mf[^
 **                                NNshGlobal->recvBuf F Mf[^
 **
 **                   NNshGlobal->err ɉR[hi[ďI 
 **----------------------------------------------------------------------**/
void NNshHTTPS_comm(NNshSavedPref *NNshParam, NNshWorkingInfo *NNshGlobal)
{
    // Mobt@̑|
    MemSet(NNshGlobal->recvBuf, NNshParam->bufferSize, 0x00);

#ifdef DEBUG
        FrmCustomAlert(ALTID_INFO, "SSL_START", "(open)", NNshParam->hostName);
#endif

    // SSL̃I[v
    NNshGlobal->err = 
          NNshSSL_open(NNSH_SSLMODE_DOSSL,    &(NNshGlobal->netRef), 
                       &(NNshGlobal->sslRef), &(NNshGlobal->sslTemplate),
                       &(NNshGlobal->sslContext));
    if (NNshGlobal->err != errNone)
    {
        // ڑɎs
#ifdef DEBUG
        FrmCustomAlert(ALTID_INFO, "SSL_open", " ", NNshParam->hostName);
#endif
        return;
    }

#ifdef DEBUG
        FrmCustomAlert(ALTID_INFO, "SSL_CONNECT", "(connect)", NNshParam->hostName);
#endif

    // SSL̃RlNg
    NNshGlobal->err = 
          NNshSSL_connect(NNSH_SSLMODE_DOSSL,     NNshGlobal->sslRef, 
                          NNshGlobal->sslContext, &(NNshGlobal->socketRef),
                          NNshGlobal->netRef,     NNshParam->hostName,
                          NNshParam->portNum,     NNshParam->timeout);
    if (NNshGlobal->err != errNone)
    {
        // ڑɎs
#ifdef DEBUG
        FrmCustomAlert(ALTID_INFO, "SSL_connect", " ", NNshParam->hostName);
#endif
        goto HTTPS_CLOSE;
    }

#ifdef DEBUG
        FrmCustomAlert(ALTID_INFO, "SSL_WRITE", "(write)", NNshParam->hostName);
#endif

    // v̑M
    NNshGlobal->err = 
        NNshSSL_write(NNSH_SSLMODE_DOSSL,       NNshGlobal->netRef, 
                      NNshGlobal->socketRef,    NNshGlobal->sslRef,
                      NNshGlobal->sslContext,   StrLen(NNshGlobal->sendBuf),
			NNshGlobal->sendBuf,      NNshParam->timeout);
    if (NNshGlobal->err != errNone)
    {
        // ڑɎs
#ifdef DEBUG
        FrmCustomAlert(ALTID_INFO, "SSL_write", " ", NNshParam->hostName);
#endif
        goto HTTPS_DISCONNECT;
    }

#ifdef DEBUG
        FrmCustomAlert(ALTID_INFO, "SSL_READ", "(read)", NNshParam->hostName);
#endif

    // ǂݍ
    NNshGlobal->err = 
          NNshSSL_read(NNSH_SSLMODE_DOSSL,
                       NNshGlobal->netRef, NNshGlobal->socketRef, 
                       NNshGlobal->sslRef, NNshGlobal->sslContext, 
                       NNshParam->bufferSize, NNshGlobal->recvBuf,
		       &(NNshGlobal->ret), NNshParam->timeout);
    if (NNshGlobal->err != errNone)
    {
        // ڑɎs
#ifdef DEBUG
        FrmCustomAlert(ALTID_INFO, "SSL_read", " ", NNshParam->hostName);
#endif
        goto HTTPS_DISCONNECT;
    }

HTTPS_DISCONNECT:

#ifdef DEBUG
        FrmCustomAlert(ALTID_INFO, "SSL_DISCONNECT", "(disconnect)", NNshParam->hostName);
#endif
    // ڑ؂
    NNshSSL_disconnect(NNSH_SSLMODE_DOSSL, NNshGlobal->sslRef,
                       NNshGlobal->sslContext,  NNshGlobal->socketRef,
                       NNshGlobal->netRef,      NNshParam->timeout);
HTTPS_CLOSE:

#ifdef DEBUG
        FrmCustomAlert(ALTID_INFO, "SSL_CLOSE", "(close)", NNshParam->hostName);
#endif
    // N[Y
    NNshSSL_close(NNSH_SSLMODE_DOSSL, NNshGlobal->netRef,
                  NNshGlobal->sslRef, NNshGlobal->sslTemplate,
                  NNshGlobal->sslContext);

    return;
}

/**----------------------------------------------------------------------**
 **    HTTPʐM{
 **                                NNshGlobal->sendBuf F Mf[^
 **                                NNshGlobal->recvBuf F Mf[^
 **
 **                   NNshGlobal->err ɉR[hi[ďI 
 **----------------------------------------------------------------------**/
void NNshHTTP_comm(NNshSavedPref *NNshParam, NNshWorkingInfo *NNshGlobal)
{
    // Mobt@̑|
    MemSet(NNshGlobal->recvBuf, NNshParam->bufferSize, 0x00);

    // lbgCuOPEN
    NNshGlobal->err = NNshNet_open(&(NNshGlobal->netRef));
    if (NNshGlobal->err != errNone)
    {
#ifdef DEBUG
        FrmCustomAlert(ALTID_INFO, "Net_open", " ", NNshParam->hostName);
#endif
        return;
    }
    // RlNg
    NNshGlobal->err = NNshNet_connect(&(NNshGlobal->socketRef), 
                                      NNshGlobal->netRef,
                                      NNshParam->hostName, 
                                      NNshParam->portNum,
                                      NNshParam->timeout);
    if (NNshGlobal->err != errNone)
    {
#ifdef DEBUG
        FrmCustomAlert(ALTID_INFO, "Net_connect", " ", NNshParam->hostName);
#endif
        goto HTTP_CLOSE;
    }

    // 
    NNshGlobal->err = NNshNet_write(NNshGlobal->netRef, 
                                    NNshGlobal->socketRef,
                                    StrLen(NNshGlobal->sendBuf), 
                                    NNshGlobal->sendBuf, 
                                    NNshParam->timeout);
    if (NNshGlobal->err != errNone)
    {
#ifdef DEBUG
        FrmCustomAlert(ALTID_INFO, "NNshNet_write",  "", "");
#endif
        goto HTTP_CLOSE;
    }

    // ǂݏo
    NNshGlobal->err = NNshNet_read(NNshGlobal->netRef,
                                   NNshGlobal->socketRef, 
                                   NNshParam->bufferSize, 
                                   NNshGlobal->recvBuf,
                                   &(NNshGlobal->ret), 
                                   NNshParam->timeout);
    if (NNshGlobal->err != errNone)
    {
        // ǂݏos
#ifdef DEBUG
        FrmCustomAlert(ALTID_INFO, "NNshNet_read",  "", "");
#endif
        goto HTTP_DISCONNECT;
    }
HTTP_DISCONNECT:
    // \Pbgؒf
    NNshNet_disconnect(NNshGlobal->netRef, NNshGlobal->socketRef, 
                                                        NNshParam->timeout);
HTTP_CLOSE:
    NNshNet_close(NNshGlobal->netRef);

    return;
}

/**----------------------------------------------------------------------**
 **    NAME^Ooł邩`FbN
 **
 **                  NNshGlobal->tempBufɌoʂi[
 **
 **                   NNshGlobal->err ɉR[hi[ďI 
 **----------------------------------------------------------------------**/
void pickup_nameTag(NNshSavedPref *NNshParam, NNshWorkingInfo *NNshGlobal)
{
    Char  *ptr;
    UInt16 loop;

    // f[^
    MemSet(NNshGlobal->tempBuf,  BUFSIZE, 0x00);
    loop = 0;
    ptr  = NNshGlobal->tempPtr2;

    // INPUT^O̓e͂
    while ((ptr < (NNshGlobal->recvBuf + NNshParam->bufferSize))&&(*ptr != '>'))
    { 
        // L[[hname
        if (((*(ptr + 0) == 'n')||(*(ptr + 0) == 'N'))&&
            ((*(ptr + 1) == 'a')||(*(ptr + 1) == 'A'))&&
            ((*(ptr + 2) == 'm')||(*(ptr + 2) == 'M'))&&
            ((*(ptr + 3) == 'e')||(*(ptr + 3) == 'E')))
        {
            // namef[^̐擪܂Ń|C^𑗂
            ptr = ptr + 5;
            if ((*ptr == '"')||(*ptr == '\'')||(*ptr == ' ')||(*ptr == '='))
            {
                ptr++;
            }
            // f[^tempBufɃRs[
            while ((*ptr != '"')&&(*ptr != '\'')&&(*ptr != ' ')&&
                   (*ptr != '>')&&(loop < (BUFSIZE - 1)))
            {
                NNshGlobal->tempBuf[loop] = *ptr;
                loop++;
                ptr++;
            }
            return;
        }
        ptr++;
    }
    return;
}

/**----------------------------------------------------------------------**
 **    VALUE^Ooł邩`FbN
 **
 **                  NNshGlobal->tempBuf2Ɍoʂi[
 **
 **                   NNshGlobal->err ɉR[hi[ďI 
 **----------------------------------------------------------------------**/
void pickup_valueTag(NNshSavedPref *NNshParam, NNshWorkingInfo *NNshGlobal)
{
    Char  *ptr;
    UInt16 loop;

    // f[^
    MemSet(NNshGlobal->tempBuf2,  BUFSIZE, 0x00);
    loop = 0;
    ptr  = NNshGlobal->tempPtr2;

    // INPUT^O̓e͂
    while ((ptr < (NNshGlobal->recvBuf + NNshParam->bufferSize))&&(*ptr != '>'))
    { 
        // L[[hvalueT
        if (((*(ptr + 0) == 'v')||(*(ptr + 0) == 'V'))&&
            ((*(ptr + 1) == 'a')||(*(ptr + 1) == 'A'))&&
            ((*(ptr + 2) == 'l')||(*(ptr + 2) == 'L'))&&
            ((*(ptr + 3) == 'u')||(*(ptr + 3) == 'U'))&&
            ((*(ptr + 4) == 'e')||(*(ptr + 4) == 'E')))
        {
            // value f[^̐擪܂Ń|C^𑗂
            ptr = ptr + 6;
            if ((*ptr == '"')||(*ptr == '\'')||(*ptr == ' ')||(*ptr == '='))
            {
                ptr++;
            }
            // f[^tempBuf2ɃRs[
            while ((*ptr != '"')&&(*ptr != '\'')&&(*ptr != ' ')&&
                   (*ptr != '>')&&(loop < (BUFSIZE - 1)))
            {
                NNshGlobal->tempBuf2[loop] = *ptr;
                loop++;
                ptr++;
            }
            return;
        }
        ptr++;
    }
    return;
}

/**----------------------------------------------------------------------**
 **    name  valueworkbufɊi[
 **
 **                   NNshGlobal->err ɉR[hi[ďI 
 **----------------------------------------------------------------------**/
void set_name_and_value(NNshSavedPref *NNshParam, NNshWorkingInfo *NNshGlobal)
{
    Char *value;

    // f[^l̏l tempBuf2
    value = NNshGlobal->tempBuf2;

    // [UH
    if (StrCaselessCompare(NNshGlobal->tempBuf, "username") == 0)
    {
        value = NNshParam->userName[NNshParam->protocol];
        goto ENTRY_DATA;
    }

    // [UH (M-zonȇΉ)
    if (StrCaselessCompare(NNshGlobal->tempBuf, "user") == 0)
    {
        value = NNshParam->userName[NNshParam->protocol];
        goto ENTRY_DATA;
    }

    // [UH (HotSpot̑Ή)
    if (StrCaselessCompare(NNshGlobal->tempBuf, "login_name") == 0)
    {
        value = NNshParam->userName[NNshParam->protocol];
        goto ENTRY_DATA;
    }

    // [UH (FON̑Ή)
    if (StrCaselessCompare(NNshGlobal->tempBuf, "login_email") == 0)
    {
        value = NNshParam->userName[NNshParam->protocol];
        goto ENTRY_DATA;
    }

    // [UH (YahooBB mobilȇΉ)
    if (StrCaselessCompare(NNshGlobal->tempBuf, "login") == 0)
    {
#ifdef SUPPORT_BIZPOTAL
        if (StrLen(value) == 0)
#endif  // #ifdef SUPPORT_BIZPOTAL
        {
            // bizportal...
            value = NNshParam->userName[NNshParam->protocol];
        }
        goto ENTRY_DATA;
    }

    // pX[hH
    if (StrCaselessCompare(NNshGlobal->tempBuf, "password") == 0)
    {
        value = NNshParam->password[NNshParam->protocol];
        NNshGlobal->setPass = 1;
        goto ENTRY_DATA;
    }

    // pX[hH (FON̑Ή)
    if (StrCaselessCompare(NNshGlobal->tempBuf, "login_password") == 0)
    {
        value = NNshParam->password[NNshParam->protocol];
        NNshGlobal->setPass = 1;
        goto ENTRY_DATA;
    }

    // pX[hH (YahooBB mobilȇΉ)
    if (StrCaselessCompare(NNshGlobal->tempBuf, "pw") == 0)
    {
        value = NNshParam->password[NNshParam->protocol];
        NNshGlobal->setPass = 1;
        goto ENTRY_DATA;
    }

ENTRY_DATA:
    if ((NNshGlobal->tempBuf[0] == '\0')||(*value == '\0'))
    {
        return;
    }

    // f[^擪ł͂Ȃ΁A "&" t
    if (StrLen(NNshGlobal->workBuf) != 0)
    {
        StrCat(NNshGlobal->workBuf, "&");
    }

    // name & value  i[
    StrCat(NNshGlobal->workBuf, NNshGlobal->tempBuf);
    if (*value != '\0')
    {
        StrCat(NNshGlobal->workBuf, "=");
        StrCat(NNshGlobal->workBuf, value);
    }
    return;
}


/**----------------------------------------------------------------------**
 **    FORM^Ooł邩`FbN
 **
 **                  NNshGlobal->tempBufɌoʂi[
 **
 **                   NNshGlobal->err ɉR[hi[ďI 
 **----------------------------------------------------------------------**/
void pickup_formTag(NNshSavedPref *NNshParam, NNshWorkingInfo *NNshGlobal)
{
    Char  *ptr;
    UInt16 loop;

    // FORM^O̐擪T
    NNshGlobal->tempPtr2 = StrStr(NNshGlobal->recvBuf, "<FORM");
    if (NNshGlobal->tempPtr2 == NULL)
    {
        NNshGlobal->tempPtr2 = StrStr(NNshGlobal->recvBuf, "<form");
    }
    if (NNshGlobal->tempPtr2 == NULL)
    {
        // FORM^O𔭌łȂAAA
        StrCopy(NNshGlobal->reqAddress, "/Authentication.php"); 
#ifdef DEBUG
        // IɃtH[ύXƂʒm
        FrmCustomAlert(ALTID_INFO, "FORCE Authentication.php", " ", " ");
#endif
        NNshGlobal->sendMethod = 
                               ((NNshGlobal->sendMethod)|(NNSHLOGIN_POST_METHOD));
        return;
    }
#ifdef DEBUG
        // otH[\
        FrmCustomAlert(ALTID_INFO, "FRM : ", NNshGlobal->tempPtr2, " ");
#endif

#ifdef FORCE_LOGINPAGE_MOBILEPOINT
    // Imobilepoint̃OCy[WݒƂ
    StrCopy(NNshGlobal->reqAddress, "/Authentication.php"); 
    NNshGlobal->sendMethod = 
                           ((NNshGlobal->sendMethod)|(NNSHLOGIN_POST_METHOD));
    return;
#endif

    // f[^
    MemSet(NNshGlobal->tempBuf, BUFSIZE, 0x00);

    loop = 0;
    ptr  = NNshGlobal->tempPtr2;

    // form^O̓e͂
    while ((ptr < (NNshGlobal->recvBuf + NNshParam->bufferSize))&&(*ptr != '>'))
    { 
        // L[[hname
        if (((*(ptr + 0) == 'a')||(*(ptr + 0) == 'A'))&&
            ((*(ptr + 1) == 'c')||(*(ptr + 1) == 'C'))&&
            ((*(ptr + 2) == 't')||(*(ptr + 2) == 'T'))&&
            ((*(ptr + 3) == 'i')||(*(ptr + 3) == 'I'))&&
            ((*(ptr + 4) == 'o')||(*(ptr + 4) == 'O'))&&
            ((*(ptr + 5) == 'n')||(*(ptr + 5) == 'N')))
        {
#ifdef DEBUG
            FrmCustomAlert(ALTID_INFO, "find action", " ", " ");
#endif

            // actionf[^̐擪܂Ń|C^𑗂
            ptr = ptr + 6;
            while (((*ptr == '"')||(*ptr == '\'')||(*ptr <= ' ')||
                   (*ptr == '='))&&(*ptr != '>')&&
                   ((ptr < (NNshGlobal->recvBuf + NNshParam->bufferSize))))
            {
                ptr++;
            }

            // f[^tempBufɃRs[
            while ((*ptr != '"')&&(*ptr != '\'')&&(*ptr > ' ')&&
                   (*ptr != '>')&&(loop < (BUFSIZE - 1)))
            {
                NNshGlobal->tempBuf[loop] = *ptr;
                loop++;
                ptr++;
            }
            NNshGlobal->tempBuf[loop] = '\0';
            loop++;
#ifdef DEBUG
            FrmCustomAlert(ALTID_INFO, "TMP BUFF:", NNshGlobal->tempBuf, " ");
#endif
            break;
        }
        ptr++;
    }

    // \bhPOSTɌ肷(̂肩...KvGETΉ...)
    NNshGlobal->sendMethod = 
                           ((NNshGlobal->sendMethod)|(NNSHLOGIN_POST_METHOD));

    // POSTy[W肷
    if (*(NNshGlobal->tempBuf) == '/')
    {
        MemSet (NNshGlobal->reqAddress, (BUFSIZE * 2), 0x00); 
        StrNCopy(NNshGlobal->reqAddress, NNshGlobal->tempBuf, (BUFSIZE * 2) - 1);
#ifdef DEBUG
        FrmCustomAlert(ALTID_INFO, "Req Addr:", NNshGlobal->reqAddress, " ");
#endif
        return;
    }
#ifdef DEBUG
    FrmCustomAlert(ALTID_INFO, "NEXT STEP :", NNshGlobal->reqAddress, " ");
#endif

#ifdef SUPPORT_BIZPOTAL
    // Ȃaction HTTPꍇ...
    ptr = StrStr(NNshGlobal->tempBuf, "http://");
    if (ptr != NULL)
    {
        // zXgƃ|[gԍ𒊏o...
        pickup_hostNameAndPortNum(ptr, NNshParam, NNshGlobal);
        
    }
    else
    {
        ptr = StrStr(NNshGlobal->tempBuf, "https://");
        if (ptr != NULL)
        {
            // zXgƃ|[gԍ𒊏o...
            pickup_hostNameAndPortNum(ptr, NNshParam, NNshGlobal);
        }
    }
#endif // #ifdef SUPPORT_BIZPOTAL

    // actionurlׂĂw肳ĂꍇBBB
    ptr = StrStr(NNshGlobal->tempBuf, "://");
    if (ptr != NULL)
    {
#ifdef DEBUG
        FrmCustomAlert(ALTID_INFO, "[FIND] ", ptr, " ");
#endif
        // zXgƃ|[gԍ͍...
        ptr = ptr + sizeof("://") - 1;
        while ((*ptr != '/')&&(*ptr != '"')&&(*ptr != '\0'))
        {
            ptr++;
        }
        while (*ptr == '/')
        {
            ptr++;
        }
        MemSet  (NNshGlobal->reqAddress, (BUFSIZE * 2), 0x00); 
        StrNCopy(NNshGlobal->reqAddress, ptr, (BUFSIZE * 2) - 1);
#ifdef DEBUG
        FrmCustomAlert(ALTID_INFO, "Req ADDR:", NNshGlobal->reqAddress, " ");
#endif
        return;
    }
    else
    {
#ifdef DEBUG
        FrmCustomAlert(ALTID_INFO, "COULD NOT FIND URL =>", NNshGlobal->tempBuf, " ");
#endif
    }

    // y[W͑΃AhXȂ̂ŁA݂̗vpath𐶂悤ɂ
    NNshGlobal->loopCount = StrLen(NNshGlobal->reqAddress);
    while (NNshGlobal->loopCount != 0)
    {
        (NNshGlobal->loopCount)--;
        if (NNshGlobal->reqAddress[NNshGlobal->loopCount] == '/')
        {
            break;
        }
    }
    NNshGlobal->reqAddress[NNshGlobal->loopCount] = '/';
    (NNshGlobal->loopCount)++;
    NNshGlobal->reqAddress[NNshGlobal->loopCount] = '\0';
    StrCat(NNshGlobal->reqAddress, NNshGlobal->tempBuf);
#ifdef DEBUG
    FrmCustomAlert(ALTID_INFO, "REQUEST ADDR:", NNshGlobal->reqAddress, " ");
#endif
    return;
}


/**************************************************************************/
/*   CookieE                                                         */
/*                                                                        */
/*                                                                        */
/**************************************************************************/
void pickup_cookie(NNshSavedPref *NNshParam, NNshWorkingInfo *NNshGlobal)
{
    Char *ptr;

    //MemSet(NNshGlobal->cookie, (BUFSIZE + MARGIN), 0x00);
    ptr = StrStr(NNshGlobal->recvBuf, "Set-Cookie");
    if (ptr == NULL)
    {
        // cookie̎w肪ȂAI
        return;
    }

    // Cookief[^Rs[
    ptr = ptr + StrLen("Set-");
    MemMove(NNshGlobal->cookie, ptr, BUFSIZE);
    ptr = NNshGlobal->cookie;
    while ((*ptr != ';')&&(*ptr != '\0'))
    {
        ptr++;
    }
    *ptr = '\0';
    return;
}

/*-------------------------------------------------------------------------*/
/*   Function : ParseMessage                                               */
/*                                                  (bZ[W̐`) */
/*                    buf : Rs[̈                                   */
/*                    src : Rs[̈                                   */
/*                   size : Rs[obt@TCY                         */
/*              kanjiCode : gp銿R[h                             */
/*-------------------------------------------------------------------------*/
static void ParseMessage(Char *buf, Char *src, UInt32 size, UInt16 kanjiCode)
{
    Boolean kanjiMode;
    UInt16  len;
    Char   *ptr, *dst, dataStatus;

    dataStatus = MSGSTATUS_NAME;
    kanjiMode = false;

    // x߃[`... (PÂp[X)
    dst  = buf;
    ptr  = src;

    while (ptr < (src + size))
    {
        // JISR[h̕ϊWbN
        if (kanjiCode == NNSH_KANJICODE_JIS)
        {
            // JISSHIFT JIS̃R[hϊ
            if ((*ptr == '\x1b')&&(*(ptr + 1) == '\x24')&&(*(ptr + 2) == '\x42'))
            {
                // [hɐ؂ւ
                kanjiMode = true;
                ptr = ptr + 3;
                continue;
            }
            if ((*ptr == '\x1b')&&(*(ptr + 1) == '\x28')&&(*(ptr + 2) == '\x42'))
            {
                // ANK[hɐ؂ւ
                kanjiMode = false;
                ptr = ptr + 3;
                continue;
            }
            if (kanjiMode == true)
            {
                // JIS > SJIS ϊ
                ConvertJIStoSJ(dst, ptr);
                ptr = ptr + 2;
                dst = dst + 2;
                continue;
            }
        }
        if (*ptr == '&')
        {
            // "&gt;"  '>' ɒu
            if ((*(ptr + 1) == 'g')&&(*(ptr + 2) == 't')&&(*(ptr + 3) == ';'))
            {
                *dst++ = '>';
                ptr = ptr + 4;   // StrLen(TAG_GT);
                continue;
            }
            // "&lt;"  '<' ɒu
            if ((*(ptr + 1) == 'l')&&(*(ptr + 2) == 't')&&(*(ptr + 3) == ';'))
            {
                *dst++ = '<';
                ptr = ptr + 4;   // StrLen(TAG_GT);
                continue;
            }
            // "&quot;"  '"' ɒu
            if ((*(ptr + 1) == 'q')&&(*(ptr + 2) == 'u')&&
                (*(ptr + 3) == 'o')&&(*(ptr + 4) == 't')&&(*(ptr + 5) == ';'))
            {
                *dst++ = '"';
                ptr = ptr + 6;    // StrLen(TAG_QUOT); 
                continue;
            }
            // "&nbsp;"  '    ' ɒu
            if ((*(ptr + 1) == 'n')&&(*(ptr + 2) == 'b')&&
                (*(ptr + 3) == 's')&&(*(ptr + 4) == 'p')&&(*(ptr + 5) == ';'))
            {
                *dst++ = ' ';
                *dst++ = ' ';
                *dst++ = ' ';
                *dst++ = ' ';
                ptr = ptr + 6;    // StrLen(TAG_QUOT); 
                continue;
            }
            // "&amp;"  '&' ɒu
            if ((*(ptr + 1) == 'a')&&(*(ptr + 2) == 'm')&&
                (*(ptr + 3) == 'p')&&(*(ptr + 4) == ';'))
            {
                *dst++ = '&';
                ptr = ptr + 5;    // StrLen(TAG_AMP);
                continue;
            }
            // ͂肦Ȃ͂...ꉞB
            *dst++ = '&';
            ptr++;
            continue;
        }
        if (*ptr == '<')
        {
            //  "<>" ́AZp[^(Ԃɂĕς)
            if (*(ptr + 1) == '>')
            {
                ptr = ptr + 2;   // StrLen(DATA_SEPARATOR);
                switch (dataStatus)
                {
                  case MSGSTATUS_NAME:
                    // Ő؂
                    *dst++ = ' ';
                    *dst++ = ' ';
                    *dst++ = ' ';
                    dataStatus = MSGSTATUS_EMAIL;
                    break;

                  case MSGSTATUS_EMAIL:
                    // e-mail̋؂
                    *dst++ = ' ';
                    dataStatus = MSGSTATUS_DATE;
                    *dst++ = '\n';
                    break;

                  case MSGSTATUS_DATE:
                    // NEԂтhc̋؂
                    *dst++ = '\n';
                    *dst++ = '\n';
                    dataStatus = MSGSTATUS_NORMAL;
                    if (*ptr == ' ')
                    {
                        // Xy[X͓ǂݔ΂
                        ptr++;
                    }
                    break;

                  case MSGSTATUS_NORMAL:
                  default:
                    // bZ[W̏I[
                    *dst++ = ' ';
                    *dst++ = '\0';
                    return;
                    break;
                }
                continue;
            }
            //  "<br>" ́Asɒu
            if (((*(ptr + 1) == 'b')&&(*(ptr + 2) == 'r')&&(*(ptr + 3) == '>'))||
                ((*(ptr + 1) == 'B')&&(*(ptr + 2) == 'R')&&(*(ptr + 3) == '>')))
            {
                // sƍs̃Xy[XĂ݂ꍇ
                if ((ptr > src)&&(*(ptr - 1) == ' '))
                {
                    dst--;
                }
                if (*(ptr + 4) == ' ')
                {
                    *dst++ = '\n';
                    ptr = ptr + 5;        // StrLen(DATA_NEWLINE);
                    continue;
                }
                *dst++ = '\n';
                ptr = ptr + 4;        // StrLen(DATA_NEWLINE);
                continue;
            }

            //  "<p*>" ́As2ɒu
            if ((*(ptr + 1) == 'p')||(*(ptr + 1) == 'P'))
            {
                *dst++ = '\n';
                *dst++ = '\n';
                ptr = ptr + 2;
                while ((*ptr != '>')&&(ptr < (src + size)))
                {
                    ptr++;
                }
                ptr++;
                continue;
            }

            // <li>^OsR[h:ɒu
            if (((*(ptr + 1) == 'l')&&(*(ptr + 2) == 'i')&&(*(ptr + 3) == '>'))||
                ((*(ptr + 1) == 'L')&&(*(ptr + 2) == 'I')&&(*(ptr + 3) == '>')))
            {
                *dst++ = '\n';
                *dst++ = '';
                ptr = ptr + 4;
                continue;
            }   

            //  "<hr>" ́As === s ɒu
            if (((*(ptr + 1) == 'h')&&(*(ptr + 2) == 'r')&&(*(ptr + 3) == '>'))||
                ((*(ptr + 1) == 'H')&&(*(ptr + 2) == 'R')&&(*(ptr + 3) == '>')))
            {
                *dst++ = '\n';
                *dst++ = '=';
                *dst++ = '=';
                *dst++ = '=';
                *dst++ = '\n';
                ptr = ptr + 4;        // StrLen(DATA_NEWLINE);
                continue;
            }

            //  "<dt>"́Asɒu
            if (((*(ptr + 1) == 'd')&&(*(ptr + 2) == 't')&&(*(ptr + 3) == '>'))||
                ((*(ptr + 1) == 'D')&&(*(ptr + 2) == 'T')&&(*(ptr + 3) == '>')))
            {
                if (*(dst - 1) != '\n')
                {
                    *dst++ = '\n';
                }
                ptr = ptr + 4;        // StrLen(DATA_NEWLINE);
                continue;
            }

            //  "</tr>"  "</td>" ́Asɒu
            if (((*(ptr + 1) == '/')&&(*(ptr + 2) == 't')&&(*(ptr + 3) == 'r')&&(*(ptr + 4) == '>'))||
                ((*(ptr + 1) == '/')&&(*(ptr + 2) == 'T')&&(*(ptr + 3) == 'R')&&(*(ptr + 4) == '>'))||
                ((*(ptr + 1) == '/')&&(*(ptr + 2) == 't')&&(*(ptr + 3) == 'd')&&(*(ptr + 4) == '>'))||
                ((*(ptr + 1) == '/')&&(*(ptr + 2) == 'T')&&(*(ptr + 3) == 'D')&&(*(ptr + 4) == '>')))
            {
                if (*(dst - 1) != '\n')
                {
                    *dst++ = '\n';
                }
                ptr = ptr + 5;        // StrLen(DATA_NEWLINE);
                continue;
            }

            //  "<dd>" ́AsƋ󔒂Qɒu
            if (((*(ptr + 1) == 'd')&&(*(ptr + 2) == 'd')&&(*(ptr + 3) == '>'))||
                ((*(ptr + 1) == 'D')&&(*(ptr + 2) == 'D')&&(*(ptr + 3) == '>')))
            {
                *dst++ = '\n';
                *dst++ = ' ';
                *dst++ = ' ';
                ptr = ptr + 4;        // StrLen(DATA_NEWLINE);
                continue;
            }

            //  "<h?" ́As + s ɒu
            if ((*(ptr + 1) == 'h')&&(*(ptr + 1) == 'H'))
            {
                *dst++ = '\n';
                *dst++ = '\n';
                ptr = ptr + 4;        // StrLen(DATA_NEWLINE);
                goto SKIP_TAG;
            }

            //  "</h?>" ́As + s ɒu
            if (((*(ptr + 2) == 'h')||(*(ptr + 2) == 'H'))&&(*(ptr + 1) == '/'))
            {
                *dst++ = '\n';
                *dst++ = '\n';
                ptr = ptr + 3;        // StrLen(DATA_NEWLINE);
                goto SKIP_TAG;
            }

            //  "</title>" ́As + s ɒu
            if ((*(ptr + 1) == '/')&&
                ((*(ptr + 2) == 't')||(*(ptr + 2) == 'T'))&&
                ((*(ptr + 3) == 'i')||(*(ptr + 3) == 'I'))&&
                ((*(ptr + 4) == 't')||(*(ptr + 4) == 'T'))&&
                ((*(ptr + 5) == 'l')||(*(ptr + 5) == 'L'))&&
                ((*(ptr + 6) == 'e')||(*(ptr + 6) == 'E')))
            {
                *dst++ = '\n';
                *dst++ = '\n';
                ptr = ptr + 7;        // StrLen(DATA_NEWLINE);
                goto SKIP_TAG;
            }

            // <tr>, <td> ̓Xy[XPɕϊ
            if (((*(ptr + 1) == 't')||(*(ptr + 1) == 'T'))&&
                ((*(ptr + 2) == 'r')||(*(ptr + 2) == 'R')||
                 (*(ptr + 2) == 'd')||(*(ptr + 2) == 'D')))
            {
                *dst++ = ' ';
                // continue͂ȂBB (^O͓ǂݔ΂)
            }
SKIP_TAG:
            // ̑̃^O͓ǂݔ΂
#ifdef USE_STRSTR
            ptr = StrStr(ptr, ">");
#else
            while ((*ptr != '>')&&(*ptr != '\0'))
            {
                ptr++;
            }
#endif
            ptr++;
            // *dst++ = ' ';   // ^O͊SƂB
            continue;
        }
        // R[hEUCꍇ...
        if (kanjiCode == NNSH_KANJICODE_EUC)
        {
            if (ConvertEUCtoSJ((UInt8 *) dst, (UInt8 *) ptr, &len) == true)
            {
                // EUC > SHIFT JISϊs
                dst = dst + len;
                ptr = ptr + 2;
                continue;
            }
            if (*ptr != '\0')
            {
                // ʂ̈ꕶ]
                *dst++ = *ptr;
            }
            ptr++;
            continue;
        }

        // Xy[XAĂꍇAPɌ炷
        if ((*ptr == ' ')&&(*(ptr + 1) == ' '))
        {
            ptr++;
            while ((*ptr == ' ')&&(ptr < (src + size)))
            {
                ptr++;
            }
            ptr--;
        }

        // NULL  0x0a, 0x0d, 0x09(^u) ͖
        if ((*ptr != '\0')&&(*ptr != 0x0a)&&(*ptr != 0x0d)&&(*ptr != 0x09))
        {
            // ʂ̈ꕶ]
            *dst++ = *ptr;
        }
        ptr++;
    }
    *dst++ = '\0';
    return;
}

/* --------------------------------------------------------------------------
 *   AMsoftUTF8ϊe[u𗘗pĎ
 *       (http://amsoft.minidns.net/palm/gfmsg_chcode.html)
 * --------------------------------------------------------------------------*/

/*=========================================================================*/
/*   Function : StrNCopyUTF8toSJ                                           */
/*                     ̃Rs[(UTF8SHIFT JISR[hւ̕ϊ{) */
/*=========================================================================*/
void StrNCopyUTF8toSJ(UInt8 *dst, UInt8 *src, UInt32 size, LocalID dbId)
{
    UInt8     buffer[2];
    UInt16    cnt, codes, ucode;
    Boolean   kanji;
    DmOpenRef dbRef;   

    // ϊe[u邩mF
    // dbId  = DmFindDatabase(0, "UnicodeToJis0208");
    if (dbId == 0)
    {
        return;
    }
    dbRef = DmOpenDatabase(0 , dbId, dmModeReadOnly);

    kanji = false; 
    cnt = 0;
    while ((*src != '\0')&&(cnt <size))
    {
        if (*src < 0x80)
        {
            // p[h...
            *dst = *src;
            dst++;
            cnt++;
            src++;
            continue;
        }

        ucode = ((*src & 0x0f) << 12);
        ucode = ucode | ((*(src + 1) & 0x3f) << 6);
        ucode = ucode | ((*(src + 2) & 0x3f));

        buffer[0] = ((ucode & 0xff00) >> 8);
        buffer[1] = ((ucode & 0x00ff));

        // R[h̕ϊ
        codes = Unicode11ToJisx0208(dbRef, buffer[0], buffer[1]);
        buffer[0] = ((codes & 0xff00) >> 8);
        buffer[1] = (codes & 0x00ff);
        ConvertJIStoSJ(dst, buffer);

        dst = dst + 2;
        src = src + 3;
        cnt = cnt + 2;
    }
    *dst = '\0';

    DmCloseDatabase(dbRef);
    return;
}

/* --------------------------------------------------------------------------
 *  Unicode11ToJisx0208()
 *                                                       (Unicode > JIS0208)
 * --------------------------------------------------------------------------*/
static UInt16 Unicode11ToJisx0208(DmOpenRef dbRef, UInt8 utf8H, UInt8 utf8L)
{
    MemHandle            recH;
    UInt16               num, col, code = 0x0000;
    UnicodeToJis0208Rec *rec;

    // f[^x[X̃R[hȂƂ...
    if (dbRef == 0)
    {
        // G[...
        return (0x2121);
    }
    num  = utf8H;

    // 킹
    if (utf8L < 0x80)
    {
        num = (utf8H * 2);
        col = utf8L;
    }
    else
    {
        num = (utf8H * 2) + 1;
        col = utf8L - 0x80;
    }
    
    recH = DmQueryRecord(dbRef, num);
    if (recH == 0)
    {
        // G[...
        return (0x2122);
    }
    rec = (UnicodeToJis0208Rec *) MemHandleLock(recH);
    if (rec->size > 0)
    {
        // f[^L
        code  = rec->table[col];
    }
    else
    {
        // f[^Ȃ
        code = 0x2121;
    }
    MemHandleUnlock(recH);
    return (code);
}

/*=========================================================================*/
/*   Function : ConvertJIStoSJ                                             */
/*                            JISR[hSHIFT JISR[hɕϊ */
/*=========================================================================*/
static Boolean ConvertJIStoSJ(UInt8 *dst, UInt8 *ptr)
{
    UInt8 upper, lower;

    // 8rbg/8rbgϐɃRs[
    upper = *ptr;
    lower = *(ptr + 1);

    // CɂASYT(p.110)̃R[hg킹Ă
    if ((upper & 1) != 0)
    {
        if (lower < 0x60)
        {
            lower = lower + 0x1f;
        }
        else
        {
            lower = lower + 0x20;
        }
    }
    else
    {
        lower = lower + 0x7e;
    }   
    if (upper < 0x5f)
    {
        upper = (upper + 0xe1) >> 1;
    }
    else
    {
        upper = (((upper + 0x61) >> 1)|(0x80));
    }
    *dst = upper;
    dst++;
    *dst = lower;

    return (true);
}

/*=========================================================================*/
/*   Function : ConvertEUCtoSJ                                             */
/*                                  R[hEUCSHIFT JISɕϊ */
/*=========================================================================*/
static Boolean ConvertEUCtoSJ(UInt8 *dst, UInt8 *ptr, UInt16 *copyByte)
{
    UInt8 temp[2];

    *copyByte = 0;
    if (*ptr == 0x8e)
    {
        // pJiR[h
        ptr++;
        *dst = *ptr;
        *copyByte = 1;
        return (true); 
    }
    if ((*ptr >= ((0x80)|(0x21)))&&(*ptr <= ((0x80)|(0x7e))))
    {
        // EUCR[hƔAJISR[hɈxϊĂSHIFT JISɕϊ
        temp[0] = ((*ptr)&(0x7f));
        ptr++;
        temp[1] = ((*ptr)&(0x7f));
        (void) ConvertJIStoSJ(dst, temp);
        *copyByte = 2;
        return (true);
    }
    return (false);
}


/**----------------------------------------------------------------------**
 **   doLogin_YahooBBmobile 
 **     (YahooBB mobileɃOC)
 **                                            type : IISP
 **                                            msg  : OC{
 **----------------------------------------------------------------------**/
void doLogin_YahooBBmobile(NNshSavedPref *NNshParam,NNshWorkingInfo *NNshGlobal)
{
    // ڑ́Ahttp://sourceforge.jp/ Ƃ  (x^ɋL...)
    MemSet(NNshParam->hostName, BUFSIZE, 0x00);
    StrCopy(NNshParam->hostName, "sourceforge.jp");

#ifdef DEBUG_LOCALHOST_ADDRESS
    // MfobOzXgɕύX...
    StrCopy(NNshParam->hostName, DEBUG_ADDRESS);
#endif  // #ifdef DEBUG_LOCALHOST_ADDRESS

    // |[gԍi[
    NNshParam->portNum = 80;

    // Cookie
    MemSet(NNshGlobal->cookie, (BUFSIZE + MARGIN), 0x00);

    // t@Ci[
    MemSet (NNshGlobal->reqAddress, (BUFSIZE * 2), 0x00); 
    StrCopy(NNshGlobal->reqAddress, "/");

    // bZ[W{fBȂ
    MemSet (NNshGlobal->workBuf, ((NNshParam->bufferSize) / 2), 0x00);
    StrCopy(NNshGlobal->workBuf, " ");

    // HTTP, GET\bhgp
    NNshGlobal->sendMethod = NNSILOGIN_GET_METHOD_HTTP;

    // bZ[W쐬
    NNsh_MakeHTTPmsg(NNshParam, NNshGlobal);

#ifdef DEBUG_SENDLOG
    // fobOpɑMf[^֏o͂
    SendToLocalMemopad("FIRST CONNECTION", NNshGlobal->sendBuf);
#endif

    // HTTPʐM{
    NNshHTTP_comm(NNshParam, NNshGlobal);
    if (NNshGlobal->err != errNone)
    {
#ifdef DEBUG
        // ʐMsAG[
        FrmCustomAlert(ALTID_INFO, "NNshHTTP_comm", " ", " ");
#endif
        return;
    }

#ifdef DEBUG
    // fobOpɎMf[^֏o͂
    StrCat(NNshGlobal->recvBuf, "\n\n>< >< ><\n(FIRST REPLY)\n");
    SendToLocalMemopad("FIRST REPLY(RX)", NNshGlobal->recvBuf);
#endif

    // MbZ[WɃ_CNg̎w邩A`FbNs
    NNshGlobal->err = ~errNone - 9;
    if ((StrStr(NNshGlobal->recvBuf, "HTTP/1.0 302") != NULL)||
        (StrStr(NNshGlobal->recvBuf, "HTTP/1.1 302") != NULL))
    {
        // _CNg̃zXgƃTCg𒊏o
        NNshParam->portNum = 0;
        NNsh_check302URL(NNshParam, NNshGlobal);
    }
    else
    {
#ifdef DEBUG
        // _CNgȂƂ𑗐M
        FrmCustomAlert(ALTID_INFO, "DO NOT REDIRECT...", " ", " ");
#endif
    }

    // t@NA
    MemSet(NNshGlobal->referer, BUFSIZE, 0x00);

REDIRECT_AGAIN:
    if (NNshGlobal->err == errNone)
    {
#ifdef DEBUG_LOCALHOST_ADDRESS
    // _CNg̃AhX擾ł
        // MfobOzXgɕύX...
        StrCopy(NNshParam->hostName, DEBUG_ADDRESS);
#endif  // #ifdef DEBUG_LOCALHOST_ADDRESS

        // bZ[W쐬
        NNsh_MakeHTTPmsg(NNshParam, NNshGlobal);

#ifdef DEBUG
        // fobOpɑMf[^֏o͂
        SendToLocalMemopad("SEND(REDIRECT)", NNshGlobal->sendBuf);
#endif

        // _CNgɁiMvgRɍ킹āj
        if ((NNshGlobal->sendMethod & NNSHLOGIN_SSL_PROTOCOL) ==
                                                        NNSHLOGIN_SSL_PROTOCOL)
        {
#ifdef DEBUG
            // HTTPSŒʐM邱Ƃ\
            FrmCustomAlert(ALTID_INFO, "HTTPS(SSL) CONNECTION...", " ", " ");
#endif

            // httpsʐMv
            NNshHTTPS_comm(NNshParam, NNshGlobal);
        }
        else
        {
#ifdef DEBUG
            // HTTPSŒʐM邱Ƃ\
            FrmCustomAlert(ALTID_INFO, "HTTP CONNECTION...", " ", " ");
#endif

            // httpʐMv
            NNshHTTP_comm(NNshParam, NNshGlobal);
        }
        if (NNshGlobal->err != errNone)
        {
#ifdef DEBUG
            // ʐMsAG[
            FrmCustomAlert(ALTID_INFO, "NNshHTTP_comm", " ", "(redirect)");
#endif
            return;
        }
#ifdef DEBUG
        // fobOpɎMf[^֏o͂
        StrCat(NNshGlobal->recvBuf, "\n\n>< >< ><\n(REDIRECT)\n");
        SendToLocalMemopad("REDIRECT(RX)", NNshGlobal->recvBuf);
#endif
    }

#if 1
    // 񃊃_CNgH
    if ((StrStr(NNshGlobal->recvBuf, "HTTP/1.0 302") != NULL)||
        (StrStr(NNshGlobal->recvBuf, "HTTP/1.1 302") != NULL))
    {
        if (NNshGlobal->isRedirect < 2)
        {
            // _CNg̃zXgƃTCg𒊏o
            NNsh_check302URL(NNshParam, NNshGlobal);
            (NNshGlobal->isRedirect)++;  // _CNg͂Q܂...
            goto REDIRECT_AGAIN;
        }
    }
#endif    //#if 0

    // LANyȂǁAēxy[WJȂĂ͂ȂȂꍇ...
    NNsh_checkRefreshConnectionRequest(NNshParam, NNshGlobal);
    if (NNshGlobal->err == errNone)
    {
#ifdef DEBUG
        // ēx_CNg邱Ƃ𑗐M
        FrmCustomAlert(ALTID_INFO, 
                       "REDIRECT AGAIN...(", NNshGlobal->reqAddress, ")");
#endif
        goto REDIRECT_AGAIN;
    }

    Analysis_YahooBBLoginLink(NNshParam, NNshGlobal);
    if (NNshGlobal->err == errNone)
    {
#ifdef DEBUG
        // OCtH[J悤M
        FrmCustomAlert(ALTID_INFO, 
                       "OPEN LOGIN FORM...(", NNshGlobal->reqAddress, ")");
#endif
        goto REDIRECT_AGAIN;
    }

ANALYSIS_LOGIN:
    // OCtH[̉͂ƑM{fB̍쐬
    Analysis_LoginForm(NNshParam, NNshGlobal);

#ifdef DEBUG_LOCALHOST_ADDRESS
    // MfobOzXgɕύX...
    StrCopy(NNshParam->hostName, DEBUG_ADDRESS);
#endif  // #ifdef DEBUG_LOCALHOST_ADDRESS

#ifdef DEBUG
    FrmCustomAlert(ALTID_INFO, "MAKE HTTP TO LOGIN", " ", NNshGlobal->workBuf);
#endif

    // OCp̃bZ[W쐬
    NNsh_MakeHTTPmsg(NNshParam, NNshGlobal);

#ifdef DEBUG_SENDLOG
    // fobOpɑMf[^֏o͂
    SendToLocalMemopad("SEND(DO LOGIN 1)", NNshGlobal->sendBuf);
#endif

    // OCbZ[W(MvgRɍ킹)M
    if ((NNshGlobal->sendMethod & NNSHLOGIN_SSL_PROTOCOL) == 
                                                        NNSHLOGIN_SSL_PROTOCOL)
    {
        // httpsʐMv
        NNshHTTPS_comm(NNshParam, NNshGlobal);
    }
    else
    {
        // httpʐMv
        NNshHTTP_comm(NNshParam, NNshGlobal);
    }
    if (NNshGlobal->err != errNone)
    {
#ifdef DEBUG
        // ʐMsAG[
        FrmCustomAlert(ALTID_INFO, "NNshHTTP_comm", " ", "(redirect)");
#endif
        return;
    }
#ifdef DEBUG
    // fobOpɎMf[^֏o͂
    StrCat(NNshGlobal->recvBuf, "\n\n>< >< ><\n(LOGIN DETAIL)\n");
    SendToLocalMemopad("LOGIN DETAIL(RX)", NNshGlobal->recvBuf);
#endif

    if (NNshGlobal->setPass == 0)
    {
        // pX[hݒł܂łAēxOCցBBB
        // MLCC...
        NNshGlobal->setPass = 1;
#ifdef DEBUG
        // ʐMsAG[
        FrmCustomAlert(ALTID_INFO, "NOT PASSWORD...", " ", "(redirect again)");
#endif
        goto ANALYSIS_LOGIN;
    }


    if ((StrStr(NNshGlobal->recvBuf, "HTTP/1.0 302") != NULL)||
        (StrStr(NNshGlobal->recvBuf, "HTTP/1.1 302") != NULL))
    {
        // _CNg̃zXgƃTCg𒊏o
        NNshParam->portNum = 0;
        NNsh_check302URL(NNshParam, NNshGlobal);
    }
    else
    {
#ifdef DEBUG
        // _CNgȂƂ𑗐M
        FrmCustomAlert(ALTID_INFO, "DO NOT REDIRECT...", " ", " ");
#endif
    }

    // bZ[W쐬
    NNsh_MakeHTTPmsg(NNshParam, NNshGlobal);

#ifdef DEBUG
    // fobOpɑMf[^֏o͂
    SendToLocalMemopad("SEND(FINAL REDIRECT)", NNshGlobal->sendBuf);
#endif

    // _CNgɁiMvgRɍ킹āj
    if ((NNshGlobal->sendMethod & NNSHLOGIN_SSL_PROTOCOL) ==
                                                        NNSHLOGIN_SSL_PROTOCOL)
    {
#ifdef DEBUG
        // HTTPSŒʐM邱Ƃ\
        FrmCustomAlert(ALTID_INFO, "HTTPS(SSL) CONNECTION...", " ", " ");
#endif

        // httpsʐMv
        NNshHTTPS_comm(NNshParam, NNshGlobal);
    }
    else
    {
#ifdef DEBUG
        // HTTPSŒʐM邱Ƃ\
        FrmCustomAlert(ALTID_INFO, "HTTP CONNECTION...", " ", " ");
#endif

        // httpʐMv
        NNshHTTP_comm(NNshParam, NNshGlobal);
    }

#ifdef DEBUG
    // fobOpɎMf[^֏o͂
    StrCat(NNshGlobal->recvBuf, "\n\n>< >< ><\n(--LOGIN--)\n");
    SendToLocalMemopad("LOGIN DETAIL(Final RedirectRX)", NNshGlobal->recvBuf);
#endif

    // OC"s"ǂmF
    if (StrStr(NNshGlobal->recvBuf, "s") != NULL)
    {
        // sƂ񂪂ꍇɂ́AOCɎsƔF
        NNshGlobal->err = ~errNone;
    }
    return;
}

#ifdef SUPPORT_BIZPOTAL
/**----------------------------------------------------------------------**
 **   URLw肩zXgURL𒊏o
 ** 
 **----------------------------------------------------------------------**/
static void pickup_hostNameAndPortNum(Char *buf, NNshSavedPref *NNshParam,NNshWorkingInfo *NNshGlobal)
{
    Char *ptr;

    ptr = StrStr(buf, "://");
    if (ptr == NULL)
    {
        // URLw肪ȂAI
        return;
    }
    ptr = ptr + sizeof("://") - 1;

    // zXg̃Rs[
    MemSet(NNshParam->hostName, BUFSIZE, 0x00);
    for (NNshGlobal->loopCount = 0; 
         NNshGlobal->loopCount < (BUFSIZE - 1); 
         (NNshGlobal->loopCount)++)
    {
        if (*ptr == '/')
        {
            // zXg̏I[
            break;
        }
        if (*ptr == ':')
        {
            // |[gԍw肳Ă...
            NNshGlobal->sendMethod =
                       (NNshGlobal->sendMethod)|(NNSHLOGIN_CONNECT_PORT);
            ptr++;

            // |[gԍ̓
            NNshParam->portNum = 0;
            while ((*ptr >= '0')&&(*ptr <= '9'))
            {
                NNshParam->portNum = NNshParam->portNum * 10 + (*ptr - '0');
                ptr++;
            }
            break;
        }
        NNshParam->hostName[NNshGlobal->loopCount] = *ptr;
        ptr++;
    }
    return;
}
#endif // #ifdef SUPPORT_BIZPOTAL

/**----------------------------------------------------------------------**
 **    OCtH[̉͂ƑM{fB̉
 ** 
 **                NNshGlobal->recvBuf F M{fB
 **                NNshGlobal->workBuf F Mp{fB(ō쐬)
 **
 **                   NNshGlobal->err ɉR[hi[ďI 
 **----------------------------------------------------------------------**/
void Analysis_YahooBBLoginLink(NNshSavedPref *NNshParam, NNshWorkingInfo *NNshGlobal)
{
    Char *ptr, *dst;

    // R[h
    NNshGlobal->err = errNone;

    // NNshGlobal->sendBuf [Nobt@Ƃėp
    MemSet(NNshGlobal->sendBuf, NNshParam->bufferSize, 0x00);

    // CookieE
    pickup_cookie(NNshParam, NNshGlobal);

    ptr = StrStr(NNshGlobal->recvBuf, "href=\"mobile_login.jsp");
    if (ptr == NULL)
    {
        // w肪ȂAI
        NNshGlobal->err = ~errNone;
        return;
    }
    ptr = ptr + sizeof("href=\"") - 1;

    dst = NNshGlobal->sendBuf;
    while ((*ptr != '\"')&&(*ptr != '\0'))
    {
        *dst = *ptr;
        dst++;
        ptr++;
    }

    // Yahoo! BB Mobile̐ݒ...
    ptr = StrStr(NNshGlobal->sendBuf, "?ID=");
    if (ptr != NULL)
    {
        StrCopy(ptr, "?ID=ybbm&oID=1");    
    }

    // ʐMt@C擾
    NNshGlobal->tempPtr = NNshGlobal->sendBuf;
    NNshGlobal->loopCount = 0; 
    if (*(NNshGlobal->tempPtr) != '/')
    {
        // ΃AhXȂ̂ŁA݂̗vpath𐶂悤ɂ
        NNshGlobal->loopCount = StrLen(NNshGlobal->reqAddress);
        while (NNshGlobal->loopCount != 0)
        {
            (NNshGlobal->loopCount)--;
            if (NNshGlobal->reqAddress[NNshGlobal->loopCount] == '/')
            {
                break;
            }
        }
        NNshGlobal->reqAddress[NNshGlobal->loopCount] = '/';
        (NNshGlobal->loopCount)++;
    }
    else
    {
        MemSet(NNshGlobal->reqAddress, (BUFSIZE * 2), 0x00); 
    }
    while (NNshGlobal->loopCount < (BUFSIZE - 1))
    {
        if (*(NNshGlobal->tempPtr) <= ' ')
        {
            break;
        }
        NNshGlobal->reqAddress[NNshGlobal->loopCount] = *(NNshGlobal->tempPtr);
        (NNshGlobal->tempPtr)++;
        (NNshGlobal->loopCount)++;
    }

    // AhXȂ / ɂ
    if (StrLen(NNshGlobal->reqAddress) == 0)
    {
        StrCopy(NNshGlobal->reqAddress, "/");
    }
#ifdef DEBUG
    // ͌ʂ̃Oo͂
    FrmCustomAlert(ALTID_INFO, NNshParam->hostName, " : ", NNshGlobal->reqAddress);
#endif

    return;
}
