/*============================================================================*
 *  FILE:  
 *     main.c
 *
 *  Description: 
 *     main source code for Palm application.
 *     (This file includes in "skeleton.c".)
 *
 *===========================================================================*/
#define MAIN_C

#include "machine.c"

// external functions
extern Err     OpenForm_NNshMessage (FormType  *frm);
extern void   OpenForm_ThreadMain  (FormType  *frm);
extern void   OpenForm_WriteMessage(FormType  *frm);
extern void   OpenForm_SelectBBS   (FormType  *frm);
extern void   OpenForm_newThread   (FormType  *frm);
extern Err     OpenForm_NNshSetting (FormType  *frm);
extern Err     OpenForm_NNsiSetting2(FormType  *frm);
extern Err     OpenForm_NNsiSetting3(FormType  *frm);
extern Err     OpenForm_NNsiSetting4(FormType  *frm);
extern Err     OpenForm_NNsiSetting5(FormType  *frm);
extern Err     OpenForm_NNsiSetting6(FormType  *frm);
extern Err     OpenForm_NNsiSetting7(FormType  *frm);
extern Err     OpenForm_NNsiSetting8(FormType  *frm);
extern Err     OpenForm_NNsiSetting9(FormType  *frm);
extern Err     OpenForm_NNsiSettingA(FormType  *frm);
extern Err     OpenForm_FavorTabSet (FormType  *frm);
extern Err     OpenForm_NNsiDummy   (FormType  *frm);

extern Boolean Handler_ThreadMain   (EventType *event);
extern Boolean Handler_NNshMessage  (EventType *event);
extern Boolean Handler_WriteMessage (EventType *event);
extern Boolean Handler_SelectBBS    (EventType *event);
extern Boolean Handler_NNshSetting  (EventType *event);
extern Boolean Handler_FavorTabSet  (EventType *event);
extern Boolean Handler_newThread    (EventType *event);
extern Boolean Handler_NNsiDummy    (EventType *event);


/*=========================================================================*/
/*   Function :   MyApplicationDispatchEvent                               */
/*                                                fBXpb`Cxg */
/*=========================================================================*/
static Boolean MyApplicationDispatchEvent(EventType *event)
{
    UInt16 *command;

    //  "n[hL[䂷"@w肪AL[̓CxgȂ
    // tH[̏{
    if ((NNshParam->useHardKeyControl != 0)&&(event->eType == keyDownEvent))
    {
        if (event->data.keyDown.chr >= vchrHardKeyMin)
        {
            // n[hL[R[h̊mF
            switch (event->data.keyDown.chr)
            {
              case vchrHard1:
                // n[hL[P
                command = &(NNshParam->useKey.key1);
                break;

              case vchrHard2:
                // n[hL[Q
                command = &(NNshParam->useKey.key2);
                break;

              case vchrHard3:
                // n[hL[R
                command = &(NNshParam->useKey.key3);
                break;

              case vchrHard4:
                // n[hL[S
                command = &(NNshParam->useKey.key4);
                break;

              case vchrCapture:
                // CLIE NX Lv`{^
                command = &(NNshParam->useKey.clieCapture);
                break;

              default:
                //  imȂjn[hL[͂sꂽƂAL[R[h
                // \
                NNsh_DebugMessage(ALTID_INFO, "Hard Key Event ", " chrID:",
                                  event->data.keyDown.chr);
                return (false);
                break;
            }
            // R}h̔
            switch (*command)
            {
              case HARDKEY_FEATURE_CONTROLNNSI:
                // NNsiŐ(n[hL[ꂽƂ̏s)
                FrmDispatchEvent(event);
                return (true);
                break;

              case HARDKEY_FEATURE_TRANSJOGPUSH:
                // Cxg̃L[R[h𖳗JOG PUSH(LineFeed)ɏ
                event->data.keyDown.chr = chrLineFeed;
                break;

              case HARDKEY_FEATURE_TRANSJOGBACK:
                // Cxg̃L[R[h𖳗JOG BACK(ESC)ɏ
                event->data.keyDown.chr = chrEscape;
                break;

              case HARDKEY_FEATURE_DONOTHING:
              default:
                // Ȃ
                break;
            }
        }
    }
    return (false);
}

/*=========================================================================*/
/*   Function :   MyApplicationHandleEvent                                 */
/*                                                                         */
/*=========================================================================*/
static Boolean MyApplicationHandleEvent(EventType *event)
{
    FormType  *frm;
    TableType *tableP;
    UInt16     rowNum, fieldFont, objFont;

    // SONYVNsꍇ̉ʍXV
#ifdef USE_CLIE
    if ((NNshGlobal->silkRef != 0)&&
        (NNshGlobal->updateHR == NNSH_UPDATE_DISPLAY))
    {
         // SILK}l[W̕\ɂ킹ʂ̍XVs
        frm = FrmGetActiveForm();
        FrmEraseForm(frm);
        NNsi_FrmDrawForm(frm, true);
        NNshGlobal->updateHR = NNSH_NOT_EFFECTIVE;
    }
#endif

    // NotifyCxg̎Mʉ߂
    if (NNshGlobal->notifyUpdate != 0)
    {
        switch (NNshGlobal->notifyUpdate)
        {
          case NNSH_VFS_MOUNTED:
            // VFSmountꂽƂ[Uɒʒm
            NNsh_InformMessage(ALTID_WARN, MSG_VFS_MOUNTED, MSG_WARN_VFS_UPDATE, 0);
            break;

          case NNSH_VFS_UNMOUNTED:
            // VFSunmountꂽƂ[Uɒʒm
            NNsh_InformMessage(ALTID_WARN, MSG_VFS_UNMOUNTED, " ", 0);
            break;

          case NNSH_VFS_UNMOUNTED_WRITE:
            // VFSunmountꂽƂ[Uɒʒm
            NNsh_InformMessage(ALTID_WARN, MSG_VFS_UNMOUNTED, MSG_WARN_BACK_THREAD, 0);

            // WRITEʂꗗʂɈړ
            SaveWritingMessage();
            FrmEraseForm(FrmGetActiveForm());
            FrmGotoForm (FRMID_THREAD);
            break;

          case NNSH_VFS_UNMOUNTED_OTHER:
            // VFSunmountꂽƂ[Uɒʒm
            NNsh_InformMessage(ALTID_WARN, MSG_VFS_UNMOUNTED, MSG_WARN_BACK_THREAD, 0);

            // ꗗʂɈړ
            FrmEraseForm(FrmGetActiveForm());
            FrmGotoForm (FRMID_THREAD);
            break;

          case NNSH_VFS_UNMOUNTED_MESSAGE:
            // VFSunmountꂽƂ[Uɒʒm
            NNsh_InformMessage(ALTID_WARN, MSG_VFS_UNMOUNTED, MSG_WARN_BACK_THREAD, 0);

            // QƉʂꗗʂɈړ
            ReadMessage_Close(FRMID_THREAD);
            break;

          default:
            break;
        }
        NNshGlobal->notifyUpdate = 0;
    }

    // ŁA(tH[[h)CxgM̏LqB
    switch (event->eType)
    {
      // tH[Jevent
      case frmLoadEvent:
        // gptHgݒ肷
        fieldFont = NNshParam->currentFont;
        FntSetFont(fieldFont);
        objFont   = NNshParam->currentFont;

        // tH[ 
        frm = FrmInitForm(event->data.frmLoad.formID);
#ifdef USE_HANDERA
        if (NNshGlobal->device == NNSH_DEVICE_HANDERA)
        {
            VgaFormModify(frm, vgaFormModify160To240);
        }
#endif
#ifdef USE_CLIE
        NNshGlobal->tempStatus = 0;
#endif
        // tH[JăCxgnhݒ肷
        FrmSetActiveForm(frm);
        switch (event->data.frmLoad.formID)
        {
          // Xꗗ
          case FRMID_THREAD:
            // OtBeBGAŏĉʂTCYAtHgύX
            (void) NNshSilkMinimize(frm);

            // tH[JāACxgnhݒ肷
            OpenForm_ThreadMain(frm);
            FrmSetEventHandler(frm, Handler_ThreadMain);

            // OpenForm_ThreadMain()ŉʂ`悷邽߁Aɔ
            return (true);
            break;

          // XQƉ
          case FRMID_MESSAGE:
            // OtBeBGAŏĉʂTCYAtHgύX
            (void) NNshSilkMinimize(frm);
            FldSetFont(FrmGetObjectPtr(frm, 
                            FrmGetObjectIndex(frm, FLDID_MESSAGE)), fieldFont);
#ifdef USE_GLUE
            CtlGlueSetFont(FrmGetObjectPtr(frm,
                       FrmGetObjectIndex(frm, SELTRID_THREAD_TITLE)), objFont);
#endif
            // tH[JāACxgnhݒ肷
            OpenForm_NNshMessage(frm);
            FrmSetEventHandler(frm, Handler_NNshMessage);

            // OpenForm_NNshMessage()ŉʂ`悷邽߁Aɔ
            return (true);
            break;
 
          // X݉
          case FRMID_WRITE_MESSAGE:
            // OtBeBGAő剻ĉʂTCYAtHgύX
            FldSetFont(FrmGetObjectPtr(frm,
                         FrmGetObjectIndex(frm, FLDID_WRITE_NAME)), fieldFont);
            FldSetFont(FrmGetObjectPtr(frm, 
                        FrmGetObjectIndex(frm, FLDID_WRITE_EMAIL)), fieldFont);
            FldSetFont(FrmGetObjectPtr(frm, 
                      FrmGetObjectIndex(frm, FLDID_WRITE_MESSAGE)), fieldFont);
            (void) NNshSilkMaximize(frm);

            // tH[JāACxgnhݒ肷
            OpenForm_WriteMessage(frm);
            FrmSetEventHandler(frm, Handler_WriteMessage);
            break;

          // BBSǗ
          case FRMID_MANAGEBBS:
            // OtBeBGAŏĉʂTCY
            if (NNshSilkMinimize(frm) == errNone)
            {
                // ̈TCY߂
                tableP = FrmGetObjectPtr(frm, 
                                 FrmGetObjectIndex(frm, TBLID_BBS_SELECTION));
                for (rowNum = 0; rowNum < TblGetNumberOfRows(tableP); rowNum++)
                {
                    TblSetRowHeight(tableP, rowNum, 15);
                }
            }
            // tH[JāACxgnhݒ肷
            OpenForm_SelectBBS(frm);
            FrmSetEventHandler(frm, Handler_SelectBBS);
            break;

          // NNsiݒ
          case FRMID_CONFIG_NNSH:
            // OtBeB̈ő剻AtH[JăCxgnhݒ
            (void) NNshSilkMaximize(frm);
            OpenForm_NNshSetting(frm);
            FrmSetEventHandler(frm, Handler_NNshSetting);
            break;

          // NNsiݒ-2
          case FRMID_NNSI_SETTING2:
            // OtBeB̈ő剻AtH[JăCxgnhݒ
            (void) NNshSilkMaximize(frm);
            OpenForm_NNsiSetting2(frm);
            FrmSetEventHandler(frm, Handler_NNshSetting);
            break;

          // NNsiݒ-3
          case FRMID_NNSI_SETTING3:
            // OtBeB̈ő剻AtH[JăCxgnhݒ
            (void) NNshSilkMaximize(frm);
            OpenForm_NNsiSetting3(frm);
            FrmSetEventHandler(frm, Handler_NNshSetting);
            break;

          // NNsiݒ-4
          case FRMID_NNSI_SETTING4:
            // OtBeB̈ő剻AtH[JăCxgnhݒ
            (void) NNshSilkMaximize(frm);
            OpenForm_NNsiSetting4(frm);
            FrmSetEventHandler(frm, Handler_NNshSetting);
            break;

          // NNsiݒ-5
          case FRMID_NNSI_SETTING5:
            // OtBeB̈ő剻AtH[JăCxgnhݒ
            (void) NNshSilkMaximize(frm);
            OpenForm_NNsiSetting5(frm);
            FrmSetEventHandler(frm, Handler_NNshSetting);
            break;

          // NNsiݒ-6
          case FRMID_NNSI_SETTING6:
            // OtBeB̈ő剻AtH[JăCxgnhݒ
            (void) NNshSilkMaximize(frm);
            OpenForm_NNsiSetting6(frm);
            FrmSetEventHandler(frm, Handler_NNshSetting);
            break;

          // NNsiݒ-7
          case FRMID_NNSI_SETTING7:
            // OtBeB̈ő剻AtH[JăCxgnhݒ
            (void) NNshSilkMaximize(frm);
            OpenForm_NNsiSetting7(frm);
            FrmSetEventHandler(frm, Handler_NNshSetting);
            break;

          // NNsiݒ-8
          case FRMID_NNSI_SETTING8:
            // OtBeB̈ő剻AtH[JăCxgnhݒ
            (void) NNshSilkMaximize(frm);
            OpenForm_NNsiSetting8(frm);
            FrmSetEventHandler(frm, Handler_NNshSetting);
            break;

          // NNsiݒ-9
          case FRMID_NNSI_SETTING9:
            // OtBeB̈ő剻AtH[JăCxgnhݒ
            (void) NNshSilkMaximize(frm);
            OpenForm_NNsiSetting9(frm);
            FrmSetEventHandler(frm, Handler_NNshSetting);
            break;

          // NNsiݒ(T)
          case FRMID_NNSI_SETTING_ABSTRACT:
            // OtBeB̈ő剻AtH[JăCxgnhݒ
            (void) NNshSilkMaximize(frm);
            OpenForm_NNsiSettingA(frm);
            FrmSetEventHandler(frm, Handler_NNshSetting);
            break;

          // Cɓݒ
          case FRMID_FAVORSET_DETAIL:
            // OtBeB̈ő剻AtH[JăCxgnhݒ
            (void) NNshSilkMaximize(frm);
            OpenForm_FavorTabSet(frm);
            FrmSetEventHandler(frm, Handler_FavorTabSet);
            break;

          // NNsiN(DUMMY)
          case FRMID_NNSI_DUMMY:
            // OtBeBGAŏĉʂTCYAtHgύX
            (void) NNshSilkMinimize(frm);
            OpenForm_NNsiDummy(frm);
            FrmSetEventHandler(frm, Handler_NNsiDummy);
            break;

          // Xĉ
          case FRMID_NEW_THREAD:
            // OtBeB̈ő剻AtH[JăCxgnhݒ
            (void) NNshSilkMaximize(frm);
            OpenForm_newThread(frm);
            FrmSetEventHandler(frm, Handler_newThread);
            break;

          default:
            // "tH[JCxg"\Ă݂B(fobO)
            NNsh_DebugMessage(ALTID_INFO, "frmLoadEvent()", " formID:",
                              event->data.frmLoad.formID);
            break;
        }
        // ʂ`悷
        NNsi_FrmDrawForm(frm, true);
        break;
#if 0
      // tH[Jevent
      case frmOpenEvent:
        break;

      // tH[event
      case frmCloseEvent:
        break;
#endif
      default:
        // T|[gĂȂCxgMB
        break;
    }
    return (false);
}

/*=========================================================================*/
/*   Function :   MyApplicationHandleNotifications                         */
/*                                Notification                         */
/*=========================================================================*/
static UInt32  MyApplicationHandleNotifications(SysNotifyParamType *notifyParamsP)
{ 
  // PilotMainĂCode Resourcȅꍇ͂Notification̂ʓI
  // ĂȂꍇSysNotifyRegisterfunction pointernĂ

  switch(notifyParamsP->notifyType)
  {
    case sysNotifyVolumeUnmountedEvent:
        VFSUnmountNotify(notifyParamsP);
        break;

    case sysNotifyVolumeMountedEvent:
        VFSMountNotify(notifyParamsP);
        break;     
  }
  
  return 0;
}

/*=========================================================================*/
/*   Function :   myStartApplication                                       */
/*                                 X^[g(vO)  */
/*=========================================================================*/
static UInt16 MyStartApplication(void)
{
    Int16                   ret;
    UInt16                  size;
    NNshSoftwareVersionInfo verInfo;
#ifdef USE_ARMLET
    UInt32                  processorType;
#endif
    UInt32                  osVersion;

    // NNsiݒo[W̊mF
    //   (VersionmFpPreferencemFAύXȂΕ)
    size = sizeof(NNshSoftwareVersionInfo);
    MemSet(&verInfo, sizeof(NNshSoftwareVersionInfo), 0x00);
    ret  = PrefGetAppPreferences(SOFT_CREATOR_ID, SOFT_PREFID, 
                                 &verInfo, &size, false);

    // NNsiݒpi[̈̊m
    size = sizeof(NNshSavedPref) + DBSIZE_SETTING;
    NNshParam = (NNshSavedPref *) MemPtrNew(size);
    if (NNshParam == NULL)
    {
        // ̈mۂɎsI(NNsi͋NȂ)
        NNsh_ErrorMessage(ALTID_ERROR, MSG_NNSI_CANNOT_LAUNCH,
                          "(NNsiSet)\nsize:", size);
        return (0);
    }
    MemSet(NNshParam, size, 0x00);

    // NNsiO[öpi[̈̊m
    size       = sizeof(NNshWorkingInfo) + MARGIN;
    NNshGlobal = (NNshWorkingInfo *) MemPtrNew(size);
    if (NNshGlobal == NULL)
    {
        // ̈mۂɎsI(NNsi͋NȂ)
        NNsh_ErrorMessage(ALTID_ERROR, MSG_NNSI_CANNOT_LAUNCH,
                          "(NNsiGbl)\nsize:", size);
        return (0);
    }        
    MemSet (NNshGlobal, size, 0x00);
    StrCopy(NNshGlobal->dummyBuffer, " ");

    // OSo[W̊mF
    if (FtrGet(sysFtrCreator, sysFtrNumROMVersion, &osVersion) == errNone)
    {
        NNshGlobal->palmOSVersion = osVersion;
    }

    // NNsiݒ𕜋
    (void) NNshRestoreNNsiSetting(ret, verInfo.prefSize, NNshParam);

    // fobO[h̏𕜋
    NNshParam->debugMessageON = verInfo.debugMode;

    // VFS@\Ȃݒ肾ꍇɂ́AUVFSp[^NAB
    if (NNshParam->useVFS == NNSH_NOTSUPPORT_VFS)
    {
        NNshParam->useVFS = NNSH_VFS_DISABLE;
    }
    // VFST|[g̐ݒ
    checkVFSdevice_NNsh();

    // VFS ɃobNAbvꂽDB΁ARs[邩ǂ
    if ((NNshParam->useVFS & (NNSH_VFS_ENABLE | NNSH_VFS_DBIMPORT)) ==
        (NNSH_VFS_ENABLE | NNSH_VFS_DBIMPORT))
    {
        UInt16 backup;
        
        backup = NNshParam->confirmationDisable;
        NNshParam->confirmationDisable = NNSH_OMITDIALOG_NOTHING;

        // VFS  DB Rs[
        RestoreDBtoVFS(false);
        if (NNshGlobal->restoreSetting)
        {
            // NNsiݒ𕜋
            (void) NNshRestoreNNsiSetting(ret, verInfo.prefSize, NNshParam);
        }
        else
        {
            NNshParam->confirmationDisable = backup;
        }
    }

#ifdef USE_CLIE
    // Silk̐ݒ𔽉f
    NNshGlobal->notUseSilk = NNshParam->notUseSilk;

    // CLIET|[g̐ݒ
    setCLIESupport_NNsh();
#endif  // #ifdef USE_CLIE

#ifdef USE_HANDERA
    // HandEraT|[g̐ݒ
    setHandEraSupport_NNsh();
#endif // #ifdef USE_HANDERA

#ifdef USE_HIGHDENSITY
    // 𑜓xT|[g/J[T|[g̃`FbN
    setDoubleDensitySupport_NNsh();
#else
    // 𑜓xT|[gݒ
    NNshGlobal->os5HighDensity = (UInt32) kDensityLow;
#endif    // #ifdef USE_HIGHDENSITY

#ifdef USE_ARMLET
    // ARMletgpۂ̃`FbN
    FtrGet(sysFileCSystem, sysFtrNumProcessorID, &processorType);
    if (sysFtrNumProcessorIsARM(processorType))
    {
        // ARMletgp\foCXB
        // NNshParam->useARMlet = NNSH_ENABLE;  // ARMlet͎gpݒɕύX
    }
    else
#endif
    {
        // ARMlet͎gpȂݒɂ
        NNshParam->useARMlet = NNSH_DISABLE;
    }

    // WebBrowser̃CXg[`FbN
    checkInstalledWebBrowser();

    // ݒ肳Ăꍇ
    if (NNshParam->useBookmark != 0)
    {
        // ݒL̈mۂ
        NNshGlobal->bookmarkFileName = MemPtrNew(MAX_THREADFILENAME);
        if (NNshGlobal->bookmarkFileName != NULL)
        {
            NNshGlobal->bookmarkNick = MemPtrNew(MAX_NICKNAME);
            if (NNshGlobal->bookmarkNick == NULL)
            {
                MemPtrFree(NNshGlobal->bookmarkFileName);
                NNshGlobal->bookmarkFileName = NULL;
            }
        }
        if (NNshParam->lastFrmID == NNSH_FRMID_MESSAGE)
        {
            // 肪ݒ肳Ăꍇɂ́AJꏊw
            if (NNshParam->bookMsgNumber != 0)
            {
                NNshParam->openMsgIndex = NNshParam->bookMsgIndex;
            }
        }
    }

    // NGݒ̕`FbN
    if (NNshParam->useRegularExpression != 0)
    {
        SeparateWordList(NNshParam->hideWord1, &(NNshGlobal->hide1));
        SeparateWordList(NNshParam->hideWord2, &(NNshGlobal->hide2));
    }

    // ^CgR[h̎w肪ُ̏ꍇAR[hԍ
    if ((NNshParam->startTitleRec == NNshParam->endTitleRec)&&
        (NNshParam->startTitleRec == 0))
    {
        NNshParam->startTitleRec = 0xffff;
    }

    // NɋN[hݒ肳ĂꍇA_~[ʂJ
    if (StrLen(NNshParam->launchPass) != 0)
    {
        return (FRMID_NNSI_DUMMY);
    }

    // VFSOFFꍇɂ́AmFbZ[W\B
    if (NNshParam->useVFS == NNSH_VFS_DISABLE)
    {
        NNsh_WarningMessage(ALTID_WARN, MSG_USE_VFS_WARNING1,
                            MSG_USE_VFS_WARNING2, 0);
    }

    // ŏɃI[vtH[IDB
    return (ConvertFormID(NNshParam->lastFrmID));
}

/*=========================================================================*/
/*   Function :   myStopApplication                                        */
/*                                 Xgbv(vO)  */
/*=========================================================================*/
static void MyStopApplication(void)
{
    UInt16                  savedParam, frmId;
    NNshSoftwareVersionInfo verInfo;

    frmId = FrmGetActiveFormID();
    switch (frmId)
    {
      case FRMID_WRITE_MESSAGE:
        //  ݉ʂŃAv悤Ƃꍇ
        // (ݓeۑ邩mF)
        SaveWritingMessage();
        break;

      default:
        break;
    }

    // X^Cg\폜
    ClearMsgTitleInfo();

    // e|t@C̍폜(DEBUG[hɂ͎cĂ)
    if (NNshParam->debugMessageON == 0)
    {
        (void) DeleteFile_NNsh(FILE_SENDMSG, NNSH_VFS_DISABLE);
        (void) DeleteFile_NNsh(FILE_RECVMSG, NNSH_VFS_DISABLE);
    }

    // NNsiIɉؒf
    if (NNshParam->disconnectNNsiEnd != 0)
    {
        // vOIɂ́Auؒfv̊mFbZ[W͏oȂB
        savedParam = NNshParam->confirmationDisable;
        NNshParam->confirmationDisable = NNSH_OMITDIALOG_ALLOMIT;
        NNshNet_LineHangup();
        NNshParam->confirmationDisable = savedParam;
    }

#ifdef USE_CLIE
    // CLIET|[gJ
    resetCLIESupport_NNsh();
#endif

    // VFS Notification̉
    resetVFSNotifications();

    // NNsiݒVersionmFpPreference̕ۑ(Debug[h͂ŋL)
    verInfo.NNsiVersion = SOFT_PREFVERSION;
    verInfo.prefSize    = sizeof(NNshSavedPref);
    verInfo.prefType    = NNSH_PREFERTYPE;
    verInfo.debugMode   = (NNshParam != NULL) ? NNshParam->debugMessageON : 0;
    PrefSetAppPreferences(SOFT_CREATOR_ID, SOFT_PREFID, SOFT_PREFVERSION,
                          &verInfo, sizeof(NNshSoftwareVersionInfo), false);

    // NNsiݒ̕ۑ(NNsi̋Nɐ̂)
    if (NNshParam != NULL)
    {
        // Silk̐ݒ𔽉f
#ifdef USE_CLIE
        NNshParam->notUseSilk = NNshGlobal->notUseSilk;
#else
        NNshParam->notUseSilk = 0;
#endif
        NNshSaveNNsiSetting(NNSH_PREFERTYPE, sizeof(NNshSavedPref), NNshParam);

        // NNsiIɃf[^x[XVFSɃobNAbv
        if ((NNshParam->useVFS & (NNSH_VFS_DBBACKUP)) != 0)
        {
            BackupDBtoVFS(NNSH_DISABLE);
        }
    }

    // uݒvݒ蒆̏ꍇ
    if ((NNshParam->useBookmark != 0)&&
        (NNshParam->bookMsgNumber != 0)&&
        (NNshGlobal->bookmarkFileName != NULL))
    {
        // ݒ(indexԍ)L
        (void) GetSubjectIndex(NNshGlobal->bookmarkNick,
                               NNshGlobal->bookmarkFileName,
                               &(NNshParam->bookMsgIndex));
    }

    // (mۍς݂Ȃ)NGݒ̗̈J
    ReleaseWordList(&(NNshGlobal->hide1));
    ReleaseWordList(&(NNshGlobal->hide2));

    // (mۍς݂Ȃ)ݒ֘Ä̗NA
    MEMFREE_PTR(NNshGlobal->bookmarkFileName);
    MEMFREE_PTR(NNshGlobal->bookmarkNick);

    // NNsĩO[öJ
    if (NNshGlobal != NULL)
    {
        NNshClearGlobal(NNshGlobal);
        MEMFREE_PTR(NNshGlobal);
        NNshGlobal = NULL;
    }

    // gp̈̊J
    MEMFREE_PTR(NNshParam);
    NNshParam = NULL;

    return;
}
