
/////////////////////////
///// カルテからの継承値 ///

function noa(){
    if (window.opener.name == "noa"){
        return window.opener;
    } else if (window.opener.name == "tools"){
        return window.opener.top.noa;
    } else if (window.top.noa){
        return window.top.noa;
    } else {
        alert("ERROR *** groupMenuEditor.js: window.opener としての NOA が見つかりません");
        return null;
    }
}

// owner(), tag() などは他とカブりエラーになるので noa().owner() のような使い方

///// カルテからの継承値 ///
/////////////////////////

function savedGroupMenuEditor(answer){
    //alert(answer); //##
    // CellEditor を再描画
    noa().setEditorId(null);
    noa().openEditor(noa().currentDate(), noa().currentTag());
}
function saveGroupMenuEditor(){
    // 確定ボタン：グループ・メニュ内容ーをサーバへ保存
    var obj = groupMenuObject();
    
    var subItems = new Object();
    var menuItem = "";
    for (tag in obj){
        if (tag == noa().currentTag()) menuItem = obj[tag];
        
        // グループメニューを持つ cell も meuItem と重複するがsubItems に取込む
        subItems[tag] = obj[tag];
    }
    
    //alert("saveGroupMenuEditor->"+encodeObject(subItems)); return; //##

    if (menuItem.length)
        NRPutGroupMenu(noa().owner(), menuItem, "0", subItems, savedGroupMenuEditor);
    else
        alert("グループ名となる「主訴」が空欄です。やり直してください");
}

function groupMenuObject(){
    // サーバへ書き戻すためのグループメニュー・データ
    //alert("groupMenuObject"); //##
    
    var obj = new Object();
    // 選択されているメニュー項目名
    var array = noa().progressTagArray();
    //alert("groupMenuObject-> "+encodeObject(array)); //##
    
    for (num in array){
        var tag = array[num];
        var val = document.getElementById(tag+"F").value;
        obj[tag] = val;
    }
    obj['freq'] = document.getElementById("freqF").value;

    return obj;
}

function groupMenuHelp(){
	// ヘルプパネルを表示
    window.open("./groupPrefHelp.html","Help"
                ,"width=450,height=700,scrollbars=yes,resizable=yes");
}

function openGroupMenuEditor(){
    // GROUP MENU EDITOR を生成
    var elm = document.getElementById("groupEditorArea");
    if (elm.innerHTML.length){
        elm.innerHTML = "";
        return;
    }
    
    elm.innerHTML = "";
    var td = newTD(elm, "groupMenuEditorArea", "");
    td.setAttribute("colspan", "2");
    var tbl = newTABLE(td, "base-table");
    tbl.style.fontSize = "9pt";
    tbl.style.margin = "3px 3px";
    
    var tr = newTR(tbl, "gmenuArea", "");

    // 選択されているメニュー項目名
    var itemElm = document.getElementById("menuItem");
    var selectedItem = (itemElm) ? itemElm.value : "";
    
    var array = noa().progressTagArray();
    for (num in array){
        var tag = array[num];
        var label = noa().fieldForTag(tag).label;
        var tr = newTR(tbl, "", "");
        var td = newTD(tr, "", label);
        td.style.verticalAlign = "top";
        var td = newTD(tr, "", "");
        if (tag == noa().currentTag()){
            // 主訴欄：グループ・メニュー名
            var fd = newFIELD(td, tag+"F", "", 40, selectedItem);
            fd.style.backgroundColor = "#ffa";
            fd.setAttribute("required"); // 入力必須を指定
            // 頻度
            var freq = freqForItem(selectedItem);
            var fd = newFIELD(td, "freqF", "頻度", 5, freq);
        } else {
            var value = "";
            for (n in _menuArray){
                var rec = _menuArray[n];
                if (rec.menu == selectedItem) value = rec[tag];
            }
            var fd = newTEXTAREA(td, tag+"F", 40, 4, value);
        }
    }
    
    var tr = newTR(tbl, "", "");
    var td = newTD(tr, "", "");
	var im = newIMAGE(td, "", "./Help.png", "?");
	im.setAttribute("onclick", "groupMenuHelp()");
	im.style.height = "18px";
	im.style.verticalAlign = "bottom";
    var td = newTD(tr, "", "");
    var bt = newBUTTON(td, "", "グループ・メニュー編集内容を確定");
    bt.setAttribute("onclick", "saveGroupMenuEditor()");
}

function showGroupMenuEditor(){
    // GROUP MENU の開閉ボタンを表示
    var elm = document.getElementById("groupMenuEditorArea");
    if (!elm) return;
    
    elm.innerHTML = "";
    var tbl = newTABLE(elm, "base-table");
    tbl.style.fontSize = "9pt";
    tbl.style.margin = "3px 3px";
    
    var tr = newTR(tbl, "gmenuArea", "");
}

function closeGroupMenuEditor(){
    var elm = window.top.tools.document.getElementById("base");
	elm.innerHTML = "";
}
function initGroupMenuEditor(){
    // グループメニュー・エディターを単独で開く場合に起動
    // cellPreference から使う場合は initGroupMenuEditor() は使わない
    var elm = window.top.tools.document.getElementById("base");
	elm.innerHTML = "";
    var div = newDIV(elm, "");
    div.style.fontSize = "10pt";
    div.style.backgroundColor = "#ff0";
    
    // TITLE
    var dv = newDIV(div, "yellow-bar");
    var sp = newSPAN(dv, "");
    sp.style.paddingRight = "5px";
    var im = newIMAGE(sp, "icon", "./close.png", "X");
    im.style.width = "12px";
    im.setAttribute("onclick", "closeGroupMenuEditor()");
    var sp = newSPAN(dv, "");
    
    sp.innerHTML = "グループ・メニューへ新規メニュー追加";
    
    var dv = newDIV(div, "groupEditorArea");
    dv.style.backgroundColor = "#ffa";
    dv.style.border = "thin solid #aaa";
    openGroupMenuEditor();
    window.top.tools.document.getElementById(noa().currentTag()+"F").focus();
}


