
/////////////////////////////////////////////
///// NOA からの継承値 /////////////////////////

// NOA 組込みの場合は patientId() などを直接取得できるが
// 外付けツールにも出来るようあえて以下の仕組みを使う

function noa(){
    if (window.opener.name == "noa"){
        return window.opener;
    } else if (window.opener.name == "tools"){
        return window.top.tools;
    } else if (window.top.noa){
        return window.top.noa;
    } else {
        alert("ERROR *** tools.js: window.opener としての NOA が見つかりません");
        return null;
    }
}

///// NOA からの継承値 /////////////////////////
//////////////////////////////////////////////



function toolMenutHelp(){
	window.open("./toolMenuHelp.html","Help"
				,"width=450,height=700,scrollbars=yes,resizable=yes");
}

function initTools(){
	var elm = document.getElementById("base");
	elm.innerHTML = "";
    
    // HEADER AREA
    var dv = newDIV(elm, "");
	var tbl = newTABLE(dv, "base-table");
	var tr = newTR(tbl, "title-bar", "");
    // TITLE
    var td = newTD(tr, "left-side", "TOOL MENU");
    // HELP ICON
    var td = newTD(tr, "right-side", "");
	var img = newIMAGE(td, "", "./Help.png", "?");
	img.style.height = "16px";
	img.setAttribute("onclick", "toolMenutHelp()");
    
    // CONTENTS
    var dv = newDIV(elm, "menuArea");

    // FOOTER
    var dv = newDIV(elm, "");
    dv.innerHTML = "";
    var tbl = newTABLE(dv, "base-table");
    var tr = newTR(tbl, "title-bar", "");
    // LEFT
    var td = newTD(tr, "left-side", version());
    // RIGHT
    var td = newTD(tr, "right-side", "");
    if (noa().isSuperUser()){
        var img = newIMAGE(td, "", "./hammer.png", "X");
        img.style.height = "15px";
        img.setAttribute("onclick", "openToolLayout()");
    }
    
    showMenu();

    function showMenu(){
        // メニューを表示
        var elm = document.getElementById("menuArea");
        elm.innerHTML = "";
        elm.style.padding = "5px 5px";
        var tbl = newTABLE(elm, "base-table");
        tbl.style.fontSize = "9pt";
        
        _initDebug(false); //##
        _debug("showMenu"); //##
        
        var valueTD;

        // ### TOOL MENU は toolEditor と異なり NOA に依存するので
        // ### toolMenuObj() でなく noa().menuStructure() を使う
        var array = noa().menuStructure();
        for (num in array){
            var cell = array[num];
            _debug("->"+encodeObject(cell)); //##
            
            if (cell.menuType * 1 != _tool) continue;
            if (cell.disabled * 1) continue;

            if (!dv || (cell.subTitle * 1)) {
                // グループ行とサブ・タイトルを生成
                var tr = newTR(tbl, "", "");
                // LABEL
                var td = newTD(tr, "/label", cell.label);
                // URL AREA
                valueTD = newTD(tr, "", "");
            } else {
                // メニュー項目を生成
               if (cell.url){
                    if (! noa().isSuperUser()){
                        // superUser でなければ実行できないメニューをスキップ
                        if (cell.url.indexOf("layout.php") >= 0) continue;
                    }
                   _debug("label->"+cell.label+"->"+cell.window); //##
                   
                   // url による action を伴う
                   if (!valueTD){
                       var tr = newTR(tbl, "", "");
                       var td = newTD(tr, "/label", cell.label);
                       valueTD = newTD(tr, "", "");
                   }

                    var sp = newSPAN(valueTD, cell.id);
                   _debug("valueTD->"+sp); //##
                   
                    sp.setAttribute("class", "menu-item");
                    sp.innerHTML = cell.label;
                   var action = "noa().kickMenuCell('"+cell.url+"','"+cell.window+"')";
                    sp.setAttribute("onclick", action);
                   
                   _debug("cell.label->"+cell.label); //##
                   
                } else {
                    // label のみの表示
                    var sp = newSPAN(valueTD, cell.id);
                    sp.setAttribute("class", "menu-item-disabled");
                    sp.innerHTML = cell.label;
                }
            }
        }
    }
}

function version(){
    return "Ver.121020";
}

