

/////////////////////////
///// カルテからの継承値 ///

function noa(){
    if (window.opener.name == "noa"){
        return window.opener;
    } else if (window.opener.name == "tools"){
        return window.opener.top.noa;
    } else if (window.top.noa){
        return window.top.noa;
    } else {
        alert("ERROR *** archiveer.js: window.opener としての NOA が見つかりません");
        return null;
    }
}

function patientId(){
    if (noa()){
        if (noa().noaType())
            return noa().patient_id(); // 第８世代 NOA
        else
            return noa().patientId(); // 第７世代 NOA
    }
    
    return "";
}
function container(){
    // サーバ側で画像ファイルを入れるフォルダー
    switch (source() * 1){
        case TMP:
            return "tmp";
        case TEMPLATE:
            return "TEMPLATES";
        default:
            if (patientId().length)
                return patientId();
            else
                return "tmp";
    }
}

function currentDate(){
    if (noa())
        return noa().currentDate();
    else
        return "";
}

function owner(){
    if (noa())
        return noa().owner();
    else
        return null;
}

///// カルテからの継承値 ///
/////////////////////////

var drawFlag = false;
var hasInfomation;
var oldX = 0;
var oldY = 0;
var beginX;
var beginY;
var cursorh; // = 80; // カーソルの初期値
var cursorw; // カーソルの初期値

var width = 600;
var height = 500; //300;

var colorList = {
	"black"   : {"r":0,"g":0,"b":0},
	"blue"    : {"r":0,"g":0,"b":255},
	"red"     : {"r":255,"g":0,"b":0},
	"orange"  : {"r":255,"g":165,"b":81},
	"magenta" : {"r":255,"g":0,"b":255},
	"green"   : {"r":0,"g":255,"b":0},
	"cyan"    : {"r":0,"g":255,"b":255},
	"yellow"  : {"r":255,"g":255,"b":0},
	"white"   : {"r":255,"g":255,"b":255}
}
function color(name){
    // 色を返す
    var obj = colorList[name];
    return "rgba(" + obj.r + "," + obj.g + "," + obj.b + "," + alpha() + ")";
}

var _canvas;
function setCanvas(cv){
    _canvas = cv;
}
function canvas(){
    return _canvas;
}

var _tool;
var _oldTool;
function setTool(val){
    _tool = val;
    showPenAttributes(); // ペンのサイズや透明度の設定ペーンを開閉
    
    if (_tool == "Text"){
        var st = prompt("文字を入力");
        setText(st);
    }
    _oldTool = _tool;
}
function tool(){
    return _tool;
}

var SAVE = 0;
var LOAD = 1;
var UPLOAD = 2;
var _mode;
function setMode(mode){
    // saveReadWriteUpload(mode);
    _mode = mode;
}
function mode(){
    // SAVE LOAD UPLOAD
    return _mode;
}

var _penSize = 1.5;
function changePenSize(){
    _penSize = penSizeBar.value * 1;
    showIndicator();
}
function penSize(){
    return _penSize;
}

var _alpha = 1;
function changeAlpha(){
    // 透明度を変える
    _alpha = alphaBar.value * 1;
    
    showIndicator();
}
function alpha(){
    // 透明度
    return _alpha;
}

var _penColor;
function setPenColor(name){
    // カラーパレットから選択された色を penColor に設定
    _penColor = name;
    showIndicator();
}
function penColor(flag){
    if (flag){
        // 透明度を反映しない
        var obj = colorList[_penColor];
        return "rgb(" + obj.r + "," + obj.g + "," + obj.b + ")";
    } else {
        // 透明度を反映
        return color(_penColor);
    }
}

var _text;
function setText(st){
    _text = st;
}
function text(){
    return _text;
}

function isSafari(){
    // Safari かどうかを検証
    if (navigator.userAgent.indexOf("Safari") >= 0){
        if (navigator.userAgent.indexOf("Chrome") < 0){
            return true;
        }
    }
    return false;
}

var TMP = 0;
var TEMPLATE = 1;
var EMR = 2;
var _src;
function setSource(val, status){
    window.localStorage["sourceOfDraw"] = val;
    _src = val;
    switch (status){
        case LOAD: showTab("+LOAD+"); break;
    }
}
function source(){
    // 画像テンプレートのモード
    return _src;
}

var _viewMode;
function setViewMode(mode){
    window.localStorage["viewMode"] = mode;
    _viewMode = mode;
}
function viewMode(){
    // 水平表示か縦横表示かを返す
    if (!_viewMode){
        _viewMode = window.localStorage["viewMode"];
        if (!_viewMode) _viewMode = "水平表示";
    }
    return _viewMode;
}


function canvasPos(key){
    // canvasArea の X, Y 座標を返す
    var elm = document.getElementById("canvasArea");
    if (key == "x") return getPosition(elm).x;
    else if (key == "y") return getPosition(elm).y;
    else return null;
    /*
    var x = getPosition(elm).x;
    var y = getPosition(elm).y;
     */
}


function fadeOutMessage(id, fadeout, message){
    // id のエレメントに message を表示し fadeout 時間でフェードアウトさせる
    var elm = document.getElementById(id);
    elm.innerHTML = message;
    
	if (fadeout && (fadeout > 0)){
		// パネルをフェードアウト
		setInfoTip(elm); // フェードアウト後 elm を削除するために必要
		setFadeOutTime(fadeout);
		setFadeOutElement(elm);
		setOpacityValue(1);
		fadeOut();
	}
}

///////////////////////////
/// Ajax による処理 /////////

function savedData(answer){
    // データ保存後、画像一覧を表示
    showTab("+LOAD+"); // 再表示
    
    fadeOutMessage("fadeOutArea", 800, answer);
}
function saveData(){
    // 画像をサーバへ名前をつけて保存
    var can = canvas();
    var imageSrc = can.toDataURL();
    imageSrc = imageSrc.replace('data:image/png;base64,',''); // 頭の不要部分を削除
    
    //alert(container()+"->"+imageSrc); return; //##
    
    NRPutObject("ohashi", "PUT_IMAGE", imageSrc, container(), savedData);

    closeThumbNailGallery();
}

function gotDirectory(answer){
    // サムネイルのリストを表示
	var obj = eval('(' + answer + ')');
    
    if (viewMode() == "縦横表示")
        showIconsVertical(obj.path, obj.files); 
    else 
        showIconsHorizontal(obj.path, obj.files); 
}
function getDirectory(){
    // 保存されたファイル名リストをリクエスト
    //alert("getDirectory container->"+container()); //##
    
    NRPutObject("ohashi", "GET_DIRECTORY", "", container(), gotDirectory);
}

function removeImage(path, filename){
    // filename を削除
    if (confirm("この画像をサーバから削除しますか")){
        var url = path + "/" + filename;
        
        NRPutObject("ohashi", "REMOVE_IMAGE", url, container(), gotDirectory);
    }
}

function gotThumbNail(answer){
	//alert("gotThumbNail ---\n"+answer); //##
	// 設定を反映させるため NOA 画面を reload
    noa().location.reload();
    closeFloatPanel();
}
function putThumbNailSize(size){
    // 画面に貼り付けるサムネイルのサイズをサーバへ記憶
	// ### menuItem が MenuTable に存在しない場合 menuItem の新規登録も行う
    //alert("putThumbNailSize:"+owner()+"->"+size); //return; //##
    if (!owner()){
        alert("NOA から Draw を開かないと、サムネイルのサイズを記憶できません");
        return;
    }
	NRPutMenu(owner(), "ThumbNail", "size" , "", "", "", size, gotThumbNail);
}

/// Ajax による処理 /////////
///////////////////////////


function changeFrame(elm){
    // 画像ギャラリーの形態を変更
    setViewMode(elm.value);
    getDirectory();
}

function closeThumbNailGallery(){
    // thumbNailGallery を閉じる
	document.getElementById("radioButtonArea").innerHTML = "";
	document.getElementById("thumbNailGallery").innerHTML = "";
    cursorh = canvasPos('y'); // canvas 上端の位置
}

function radioSelected(mode){
    // radio button が選択された
    var num = checkedRADIO("sourceRadio");
    
    //alert("radioSelected->"+num+" mode->"+mode);
    
    if (!mode)
        mode = LOAD;
    
    setSource(num, mode); // container を決定

    switch (mode * 1){
        case LOAD:
            getDirectory();
            break;
        case SAVE:
            // SAVE button を表示
            var elm = document.getElementById("saveButtonArea");
            elm.innerHTML = "";
            var tx = newTEXT(elm, " へ ");
            var bt = newBUTTON(elm, "", "保存");
            bt.setAttribute("onclick", "saveData()");
            break;
        case UPLOAD:
            openUploadPanel(num);
            break;
    }
}
function makeSourceRadio(elm, num){
    // データ・ソース選択ラジオボタンを生成
    var sp = newSPAN(elm, "");
    var names = (patientId().length) ? ["臨時","図版","カルテ"] : ["臨時","図版"];
    var item = (num != null) ? "" + num : "";
    var bt= newRADIO(sp, "sourceRadio", "sourceGroup", names, item);
    sp.setAttribute("onclick", "radioSelected('"+mode()+"')");
    
    cursorh = canvasPos('y'); // canvas 上端の位置
}
function showRadioButtons(num, status){
    // ラジオボタンを表示
    var elm = document.getElementById("radioButtonArea");
    elm.innerHTML = "";
    
    var tbl = newTABLE(elm, "baseTable");
    var tr = newTR(tbl, "", "");
    // close box
    var td = newTD(tr, "", "");
    td.style.width = "12px";
    var img = newIMAGE(td, "", "./close.png", "close");
    img.style.width = "12px";
    img.setAttribute("onclick", "closeThumbNailGallery()");
   
    // radio buttons
    var td = newTD(tr, "", "");
    newTEXT(td, " 読込むファイルの種類 ");
    td.style.color = "brown";
    makeSourceRadio(td, num);
    // path area を生成
    newTEXT(td, "　");
    var sp = newSPAN(td, "pathArea");
    sp.style.color = "#aaa";
    
    // 画像表示切り替えポップアップ
    var td = newTD(tr, "", "");
    td.style.textAlign = "right";
    
	var pu = makePopupMenu(td, "", ["水平表示","縦横表示"], viewMode());
    pu.setAttribute("onchange", "changeFrame(this)");
}
function showTab(selectMode){
    // 選択されたラジオボタンにより決められた動作を行う
    // selectMode: LOAD, SAVE, UPLOAD

    //alert("showTab->"+selectMode); //##

    if (selectMode == null)
        selectMode = LOAD;
    setMode(selectMode);
    
    closeThumbNailGallery();

    switch (selectMode * 1){
        case LOAD:
            var mode = window.localStorage["sourceOfDraw"];
            if (mode){
                // LOAD の時のみ localStorage に記憶したソースから読み出し表示
                showRadioButtons(mode, true);
                setSource(mode, 0);
                getDirectory();
            } else {
                showRadioButtons(source());
                if (source() != null) 
                    getDirectory();
            }
            break;
        case SAVE:
            var elm = document.getElementById("thumbNailGallery");
            // close box
            var dv = newDIV(elm, "");
            var img = newIMAGE(dv, "", "./close.png", "close");
            img.style.width = "11px";
            img.setAttribute("onclick", "closeThumbNailGallery()");
            // message
            newTEXT(dv, " 以下の画像の保存先を選択してください");
            dv.style.color = "brown";
            makeSourceRadio(elm);
            // button
            var sp = newSPAN(elm, "saveButtonArea");
            break;
        case UPLOAD:
            closeThumbNailGallery();
            var elm = document.getElementById("radioButtonArea");
            // close box
            var dv = newDIV(elm, "");
            var img = newIMAGE(dv, "", "./close.png", "close");
            img.style.width = "11px";
            img.setAttribute("onclick", "closeThumbNailGallery()");
            // message
            newTEXT(dv, " アップロードするファイルの保存先 ");
            dv.style.color = "brown";
            makeSourceRadio(dv);
            break;
    }
}

function getWindowSize(){
	// DocMaker のウインドー位置とサイズをサーバへリクエスト
    var val = window.localStorage["windowSizeOfDraw"];
    var args = val.split(",");
    var x = args[0];
    var y = args[1];
    var w = args[2];
    var h = args[3];
    // resize を先にしておかないと元が大きいサイズだった場合 moveTo しよう
    // としてもウインドー境界の制限で移動できない場合がある
    window.resizeTo(w, h);
    window.moveTo(x, y);
}
function putWindowSize(){
	// DocMaker のウインドー位置とサイズをサーバへ記憶
	var x = window.screenLeft;
	var y = window.screenTop - 22;
	var w = window.outerWidth;
	var h = window.outerHeight;
    var val = x+","+y+","+w+","+h;
    window.localStorage["windowSizeOfDraw"] = val;
}

function copyToCanvas(path){
    // 選択されたサムネールを CANVAS に貼り付ける
    if (hasInfomation){
        // 初めての draw の時のみ canvas をクリアして information 表示を削除
        clearDraw();
        hasInfomation = false;
    }
    
    var can = canvas();
    var context = can.getContext("2d");
    var target = new Image();
    target.src = path;
    context.drawImage(target, 0, 0);
}

function showContents(url){
	// url 内容を別ウインドーに表示
	var sfx = suffix(url);
	if (sfx == "zip"){
		if (!confirm("この圧縮ファイルを、ダウンロード・フォルダーへ解凍しますか")) return;
    }
    // window を url ごとに一枚ずつ開く
	window.open(url, url, "width=600,height=600");
}

// 描画処理


function showIndicator(){
    // pen の色やサイズを表示
    var can = document.getElementById("indCanvas");
    var context = can.getContext("2d");

    var w = can.width;
    var h = can.height;
    context.clearRect(0, 0, w, h);

    var startAngle = 0;
    var endAngle = 360 * Math.PI / 180;
    var x = w / 2;
    var y = h / 2;
    context.strokeStyle = "#ccc";
    context.fillStyle = penColor();
    context.beginPath();
    var size = penSize() * 0.8; // ペンのサイズを縮小して indicator に表示
    context.arc(x, y, size, startAngle, endAngle, false);
    context.fill();
    context.closePath();
    context.stroke();
}

function circle(context, x, y, diameter, color){
    // 円を描く
    var startAngle = 0;
    var endAngle = 360 * Math.PI / 180;
    context.fillStyle = color;
    context.beginPath();
    context.arc(x, y, diameter, startAngle, endAngle, false);
    context.fill();
}

function rectangle(context, x, y, w, h, fillColor){
    // 矩形を描く
    context.strokeStyle = color("black");
    context.beginPath();
    // context.lineWidth = lineWidth;
    context.rect(x, y, w, h);
    context.closePath();
    context.stroke();
    if (fillColor){
        context.fillStyle = fillColor;
        context.fill();
    }
}

function drawLine(x, y, color){
    // beginX,beginY から x,y へ線を引く
    var can = canvas();
    var context = can.getContext("2d");

    circle(context, beginX, beginY, 3, color); // ドット・サイズ固定

    context.strokeStyle = "#000";; //color("black");
    context.lineWidth = 0.5;
    context.beginPath();
    context.moveTo(beginX, beginY);
    context.lineTo(x, y);
    context.closePath();
    context.stroke();
}

function drawText(text, x, y){
    // 文字を描く
    if (hasInfomation){
        // 初めての draw の時のみ canvas をクリアして information 表示を削除
        clearDraw();
        hasInfomation = false;
    }

    var can = canvas();
    var context = can.getContext("2d");
    context.font = "14px 'Times New Roman'";
    context.fillStyle = penColor(true);
    context.fillText(text, x, y, 1);
}

function complement(newX, newY){
    // x, y, oldX, oldY の距離が一定以上開いたら間を補完
    var range = penSize() / 5;
    var can = canvas();
    var context = can.getContext("2d");
    
    var xforward = (newX > oldX) ? true : false; // x 座標が前進するか否か
    var yforward = (newY > oldY) ? true : false;
    var xdistance = Math.abs(oldX - newX); // x 座標の移動距離
    var ydistance = Math.abs(oldY - newY);
    var len = Math.sqrt(Math.pow(xdistance,2) + Math.pow(ydistance,2));
    len = Math.round(len); // ２点間の距離
    var count = Math.round(len / range); // ２点間を補完する回数
    var sizex = xdistance / count; // １補完における x 座標の移動距離
    var sizey = ydistance / count;
    
    if (count > 1){
        var x = oldX;
        var y = oldY;
        circle(context, x, y, penSize(), penColor()); // begin
        
        for (var i=0; i < count; i++){
            x = (xforward) ? x + sizex : x - sizex;
            y = (yforward) ? y + sizey : y - sizey;
            circle(context, x, y, penSize(), penColor());
        }
        
        circle(context, x, y, penSize(), penColor()); // end
    }
}

function draw(e){
    if (!drawFlag) return;
    if (isTouchDevice()) e = e.touches[0];
    
    if (hasInfomation){
        // 初めての draw の時のみ canvas をクリアして information 表示を削除
        clearDraw("no confirm");
        hasInfomation = false;
    }
    
    var x = e.clientX - cursorw;
    var y = e.clientY - cursorh;
    var can = canvas();
    var context = can.getContext("2d");
    context.strokeStyle = penColor();

    if (tool() == "Pen"){
        circle(context, x, y, penSize(), penColor());
        complement(x, y);
    } else if (tool() == "ToothPaste"){
         // ドットをカーソルで移動させる：ドットの軌跡は以前描かれたものを削除しつつ移動
        circle(context, oldX, oldY, penSize() - 1.2, color("white"));
        circle(context, x, y, penSize(), penColor());
    }

    oldX = x;
    oldY = y;
}

function FileDrop(e, el){
    // el にドロップされた画像を描画
    if (isSafari()){
        alert('Safari は FileReader() 未対応です。\nGoogle Chrome をお使いください。');
        return;
    }
    
    var file = e.dataTransfer.files[0];
    if (!file) {
        alert('画像ファイルの実体がないのでドロップできません');
        return; // file の実体がないとドロップできない
    }
    
    if(!file.type.match(/image\/\w+/)){
        alert('画像をドロップしてください。');
        return;
    }
    
    hasInfomation = false;
    
    var img = document.createElement("img");
    var reader = new FileReader(); // ### Safari には実装されていない
    
    reader.onload = function(e) {
        img.src = e.target.result;
    }
    // el.appendChild(img);
    
    // canvas へ描画
    var can = canvas();
    var context = can.getContext("2d");
    
    img.onload = function() {
        context.drawImage(img, 0, 0);    
    }
    
    reader.readAsDataURL(file);
}

function clearDraw(){
    // 画面をクリアー
    var can = canvas();
    var context = can.getContext("2d");
    var w = can.width;
    var h = can.height;
    context.clearRect(0, 0, w, h);
}

function showIconsHorizontal(path, files){
	// 添付ファイルをサムネールとして水平表示
	var elm = document.getElementById("thumbNailGallery");
	elm.innerHTML = "";
    // ### エレメント内のスクロールは DIV エレメントでないと効かないようだ ###
    var dv = newDIV(elm, "");
    dv.style.overflow = "auto"; // elm のコンテンツがあふれたら elm 内容を scroll
    dv.style.width = width + "px";
    
    for (num in files){
        var file = files[num];
        var url = path + "/" + file;
        var td = newTD(dv, "", "");
        td.style.backgroundColor = "#fff";
        td.style.border = "thin solid #ddd";
        td.style.padding = "0px 3px";
        
        // show image
        var sfx = suffix(file);
        if ((sfx != "pdf") && (sfx != "PDF") && isImageFile(url)){
            // image file 以外はサムネイルを直接クリックで内容表示
            var img = newIMAGE(td, "", "./add.png", "add");
            img.style.width = "11px";
            img.style.height = "11px";
            img.setAttribute("onclick", "copyToCanvas('" + url + "')");
            newTEXT(td, " ");
        }
        
        // remove image
        var img = newIMAGE(td, "", "./remove.png", "remove");
        img.style.width = "11px";
        img.style.height = "11px";
        img.setAttribute("onclick", "removeImage('"+path +"','"+file+"')");
        
        // image: thumb nail
        makeImagePane(td, path, file, 50);
    }
    cursorh = canvasPos('y'); // canvas 上端の位置
}
function showIconsVertical(path, files){
	// 添付ファイルをサムネールとして縦横表示
	var td = document.getElementById("thumbNailGallery");
	td.innerHTML = "";
	var tbl = newTABLE(td, "iconTable");
	
	// image ファイル名の配列を生成
	//var path = "/NOA_ARCHIVE/"+patientId()+"/";
	var c=0,r=0,cols=4;
	var filename;
	for (num in files){
		filename = files[num];
		if (filename.charAt(0) == ".") continue;
		if (c == 0) var tr1 = newTR(tbl, "", "");
		var td1 = newTD(tr1, "", "");
		var tbl2 = newTABLE(td1, "iconTable");
		var url = path + "/" + filename;
		
        // イメージを表示
		var tr = newTR(tbl2, "", "");
		var td = newTD(tr, "", "");
		td.style.fontSize = "8pt";
        
        // 編集エリアへイメージを追加ボタン
        var sfx = suffix(filename);
        if ((sfx != "pdf") && (sfx != "PDF") && isImageFile(url)){
            // image file 以外はサムネイルを直接クリックで内容表示
            var img = newIMAGE(td, "", "./add.png", "add");
            img.style.width = "11px";
            img.style.height = "11px";
            img.setAttribute("onclick", "copyToCanvas('" + url + "')");
            newTEXT(td, " ");
        }
        
        // イメージを削除ボタン
		var img = newIMAGE(td, "", "./remove.png", "");
        img.setAttribute("onclick", "removeImage('"+path +"','"+filename+"')");
		img.style.height = "12px";
		
        // image のクリックで別パネルに image 表示
        makeImagePane(td, path, filename, 100);

		if (c < cols - 1){
			c++;
		} else {
			c = 0;
			r++;
		}
	}
}
function makeImagePane(elm, path, file, height){
    // path からイメージを生成し elm へ表示
    var url = path + "/" + file;
    var sfx = suffix(file);
    var dv = newDIV(elm, url);
    dv.style.textAlign = "center";
    
    if ((sfx == "pdf") || (sfx == "PDF")){
        var img = "<IMG SRC=pdf.jpg HEIGHT=" + height + ">";
    } else if (isImageFile(url)){
        var img = "<IMG SRC="+url+" HEIGHT=" + height + ">";
    } else if (isMovieFile(url)){
        var img = "<IMG SRC=movie.jpg HEIGHT=" + height + ">";
    } else if (sfx == "zip"){
        var img = "<IMG SRC=folder.jpg HEIGHT=" + height + ">";
    } else if (sfx == "txt"){
        var img = "<IMG SRC=text.png HEIGHT=" + height + ">";
    } else {
        var img = "<IMG SRC=file.png HEIGHT=" + height + ">";
    }
    
    // copy image
    dv.setAttribute("onclick", "showContents('"+url+"')");
    dv.innerHTML = img;

    // カルテに埋め込むためのタグを生成
    //var path = "/NOA_ARCHIVE/"+patientId()+"/";
    var tag = "<IMG:" + url + ">";
    dv.addEventListener("dragstart", 
                        function(ev) {
                        var dt = ev.dataTransfer;
                        dt.setData("text/plain", tag);
                        return true;
                        }, 
                        false);
    
    var dv = newDIV(elm, "");
    dv.innerHTML = file;
}

function help(){
	var win = window.open("./help.html","Help"
						  ,"width=450,height=700,scrollbars=yes,resizable=yes");
	win.focus();
}

function file_append(){
	// ファイル選択ボタンを増やす
	var dv = document.getElementById("file");
	var ub = newUploadBUTTON(dv, "", "files[]");
	newBR(dv);
}

function openUploadPanel(num){
    // ファイル・アップロードのパネルを開く
    closeThumbNailGallery();
	var elm = document.getElementById("radioButtonArea");
	elm.innerHTML = "";
	//elm.style.fontSize = "11pt";
	elm.style.color = "#a30"; //brown
    
    // メッセージ
	var dv = newDIV(elm, "");
	dv.innerHTML = "選択したファイルをサーバへアップロードし保存します";
    dv.style.paddingTop = "5px";
    dv.style.paddingLeft = "5px";
	var dv = newDIV(elm, "");
	dv.innerHTML = "画像・PDF・動画・テキスト・圧縮ファイルなどをアップロードできます";
    dv.style.padding = "0px 5px";
    dv.style.paddingBottom = "5px";

    // FORM を生成
	var dv = newDIV(elm, "");
	var fm = newFORM(dv, "server.php"); // submit で起動される URL

	// ファイル・アップロード・ボタン
	var dv = newDIV(fm, "file");
    dv.style.padding = "0px 5px";
	var ub = newUploadBUTTON(dv, "", "files[]");
	newBR(dv);

    // more FILES
	var dv = newDIV(fm, "");
	dv.style.padding = "0px 10px";
    dv.style.textAlign = "left";
	var a = newA(dv, "ファイルをもうひとつ選択", "#", "");
	a.setAttribute("onclick", "file_append();");
	a.style.fontSize = "9pt";
	newBR(dv);
    
	// key 
	var fd = newFIELD(fm, "key", "", "", "SAVE_IMAGE");
	fd.setAttribute("NAME", "key"); // form で送られるパラメータ
	fd.setAttribute("type", "hidden");
	// patientId 
	var fd = newFIELD(fm, "container", "", "", container());
	fd.setAttribute("NAME", "container"); // form で送られるパラメータ
	fd.setAttribute("type", "hidden");
	// imageId 
	var fd = newFIELD(fm, "imageId", "", "", todayAndTimeId());
	fd.setAttribute("NAME", "imageId"); // form で送られるパラメータ
	fd.setAttribute("type", "hidden");

	// submit(ファイル・アップロード)ボタン
    var label = "臨時";
    if (num == 1)
        label = "図版";
    else if (num == 2)
        label = "カルテ";
	var dv = newDIV(fm, "");
    dv.innerHTML = "「" + label + "」へ ";
	dv.style.padding = "5px 5px";
	var sb = newSubmitBUTTON(dv, "", "ファイルをアップロード");
    
    // UPLOAD とりやめボタン
    var bt = newBUTTON(dv, "", "とりやめ");
	bt.setAttribute("onclick", "closeThumbNailGallery()");
}

function openPenSize(){
    var tr = document.getElementById("penSizeArea");
    tr.style.display = ""; // expand
    cursorh = canvasPos('y'); // canvas 上端の位置
}
function closePenSize(){
    var tr = document.getElementById("penSizeArea");
    tr.style.display = "none"; // shrink
    cursorh = canvasPos('y'); // canvas 上端の位置
}
function showPenAttributes(){
    // ペンの太さや透明度などの設定領域を 展開 / 縮小
    var tr = document.getElementById("penSizeArea");
    
    if ((tool() == "Pen") || (tool() == "ToothPaste"))
        openPenSize(); // expand
    else
        closePenSize(); // shrink
}

function toolSelected(elm){
    // TOOL POPUP が選択された
    setTool(elm.value);
}

var _tnSize = {"250":"大","150":"中","50":"小"};
function putSelectedThumbNailSize(){
    // 選択された「大、中、小」に対応するサイズを返す
	var name = document.getElementById("sizePopup").value;
    for (size in _tnSize){
        var label = _tnSize[size];
        if (label == name){
            putThumbNailSize(size);
            return;
        }
    }
    
    putThumbNailSize(50); // default size
}
function showPreference(){
    // 初期設定パネルを開く
    if (!owner()){
        alert("NOA から Draw を開かないと、初期設定はできません");
        return;
    }
	var elm = document.getElementById("_floatPanel");
	elm.innerHTML = "";
	var tbl = newTABLE(elm, "");
	tbl.style.fontSize = "9pt";
	tbl.style.textAlign = "right";
	
    // サムネイルの表示サイズを設定
    var size = noa().thumbNailSize(); // noa.js
    var label = (size) ? _tnSize[size] : "";
    
	// infoPanel 表示・非表示の設定
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "", "カルテに貼り付けるサムネイルのサイズ ");
	td.style.padding = "10px 10px";
	td.style.color = "#a63"; //brown
	var array = ["大","中","小"];
	var pu = makePopupMenu(td, "sizePopup", array, label);
	var bt = newBUTTON(td, "", "設定");
    bt.setAttribute("onclick", "putSelectedThumbNailSize()");
    
	openFloatPanel(tbl, 0, 0, "初期設定パネル");
}

function test(){
    // テストしたい機能を埋め込む
    if (window.event.shiftKey){
        // shift + ラベルクリックで CellEditor が立ち上がる
        alert("hello ");
    }
}

function initDraw(){
    // Draw を初期化
	window.document.title = "Draw";
    
    if (noa())
        window.document.title += " ("+ patientId() + "　" + currentDate() + ")";

    var elm = document.getElementById("base");
    if (elm.innerHTML.length > 0) return; // 再読込をしない
    elm.innerHTML = "";
  
    // HEADER //////////////////////////////////////////////
    var dv0 = newDIV(elm, ""); // control area
    var tbl = newTABLE(dv0, "");
    tbl.style.width = (width + 5) + "px";
    var tr = newTR(tbl, "", "");
    ////// COLOR INDICATOR ////////////////////////
    var td = newTD(tr, "", "");
    //td.style.border = "thin solid #ddd";
    td.style.width = "50px";
    td.style.textAlign = "center";
    var cvs = newCANVAS(td, "indCanvas", 50, 50, draw);
    
   ////// 2 LAYERS ///////////////////////////////
    var td = newTD(tr, "", "");
    td.style.border = "thin solid #ddd";
    td.style.verticalAlign = "top";
    var tbl1 = newTABLE(td, "baseTable");
     // 1st Layer ////////////////////
    var tr1 = newTR(tbl1, "", "");
    var td = newTD(tr1, "", "");
    var tbl2 = newTABLE(td, "frameTable");
    tbl2.style.width = "100%";
    var tr2 = newTR(tbl2, "", "");
    // COLOR PALLET /////////
    var td2 = newTD(tr2, "", "");
    for (name in colorList){
        var td = newTD(tr2, "", "　");
        td.style.border = "thin solid #ddd";
        td.style.backgroundColor = color(name);
        td.style.width = "15px";
        td.setAttribute("onclick", "setPenColor('" + name + "')");
    }
    // TOOL POPAUP //////////
    var td = newTD(tr2, "", "");
    td.style.width = "100px";
    td.style.textAlign = "center";
    var array = ["Pen","ToothPaste","Line","Text"];
    var pm = makePopupMenu(td, "toolPopup", array, array[0]);
    pm.setAttribute("onchange", "toolSelected(this)");
    var td2 = newTD(tr2, "", "");
    td2.style.textAlign = "right";
    // 読込
    var bt = newBUTTON(td2, "", "読込");
    bt.setAttribute("onclick", "showTab("+LOAD+")");
    // 保存
    var bt = newBUTTON(td2, "", "保存");
    bt.setAttribute("onclick", "showTab("+SAVE+")");
    // 保存
    var bt = newBUTTON(td2, "", "アップロード");
    bt.setAttribute("onclick", "showTab("+UPLOAD+")");
    // ZOOM ICON
    var td = newTD(tr2, "", "");
    td.style.width = "10px";
    td.style.textAlign = "center";
	var img = newIMAGE(td, "icon", "./zoomfit.png", "zoom");
	img.setAttribute("onclick","putWindowSize()");
	img.style.height = "16px";
	img.style.verticalAlign = "middle";
    // HELP
    var td = newTD(tr2, "", "");
    td.style.width = "8px";
    td.style.textAlign = "center";
    var im = newIMAGE(td, "", "./Help.png", "?");
    im.setAttribute("onclick", "help()");
    im.style.height = "18px";
    im.style.verticalAlign = "text-bottom";

    // 2nd Layer ////////////////////
    var tr1 = newTR(tbl1, "penSizeArea", "");
    var td = newTD(tr1, "", "");
    var tbl2 = newTABLE(td, "baseTable");
    tbl2.style.width = "100%";
    var tr2 = newTR(tbl2, "", "");
    var td = newTD(tr2, "", "");
    td.style.padding = "0px 10px";
    var img = newIMAGE(td, "", "./close.png", "close");
    img.style.width = "11px";
    img.setAttribute("onclick", "closePenSize()");    
    // ペンのサイズ
    var td = newTD(tr2, "", "太さ");
    td.style.textAlign = "right";
    newSlider(td, "penSizeBar", 0.1, penSize(), 30, 0.1, "changePenSize()");
    // 透明度 
    var tx = newTEXT(td, " 透明度");
    newSlider(td, "alphaBar", 0.01, alpha(), 1, 0.01, "changeAlpha()");
    
    // FADOUT MESSAGE AREA //////////////////////////////////
    var dv = newDIV(elm, "fadeOutArea");
    dv.style.color = "#f09";
    dv.style.fontSize = "10pt";

    // SUMB NAIL GALLERY ////////////////////////////////////
    var dv1 = newDIV(elm, "thumbNailsArea");
    dv1.style.width = width + "px";
    dv1.style.fontSize = "10pt";
    dv1.style.backgroundColor = "#ffc";
    var dv = newDIV(dv1, "radioButtonArea");
    var td = newTD(dv1, "thumbNailGallery", "");

    // REMOVE ICON ////
    var dv1 = newDIV(elm, "");
    var td = newTD(dv1, "", "");
    td.setAttribute("onclick", "clearDraw()");
    td.style.fontSize = "9pt";
    td.style.color = "#aaa";
    var im = newIMAGE(td, "", "./remove.png", "remove");
    im.style.height = "11px";
    var tx = newTEXT(td, " 下の画像をクリア");
    // CANVAS ///////////////////////////////////////////////
    var dv2 = newDIV(elm, "canvasArea"); // canvas area
    var cv = newCANVAS(dv2, "myCanvas", width, height, draw);
    setCanvas(cv);
    
    // FOOTER ///////////////////////////////////////////////
    var dv2 = newDIV(elm, "");
    dv2.style.width = width + "px";
    var tbl = newTABLE(dv2, "baseTable");
    var tr = newTR(tbl, "footer", "");
    var td = newTD(tr, "left", version());
    td.setAttribute("onclick","test()");
    // PREFERENCE 
    var td = newTD(tr, "right", "");
    var img = newIMAGE(td, "", "./hammer.png", "close");
    img.style.width = "20px";
    img.setAttribute("onclick", "showPreference()");    
    
    setPenColor("blue"); // indCanvas が必要
    changePenSize(); // indCanvas が必要
    setTool('Pen');
    if (isSafari() == false)
        drawText("ここにファインダーやデスクトップなどから画像をドロップできます", 10, 30); // penColor が必要
    hasInfomation = true; // canvas に information が表示されている

    // ウインドー上の Canvas のオフセットによりカーソル初期値を決定
    cursorw = canvasPos('x'); // canvas 上端の位置
    cursorh = canvasPos('y'); // canvas 上端の位置

	// ウインドー・サイズをサーバから読み込みサイズ調整
	getWindowSize();
    
    showTab();
}

window.onload = function(){
    // window を初期化
    // window.onload と window.addEventListener はどちらが先に起動されるかわからない
    initDraw(); // 画面初期化はここで実行
   
    // canvas を画像ドロップ・エリアと兼用にする
    // そうでない場合は <div> id="dropArea">ここにドロップしてください</div> のようにする
    var target = canvas();
    
    target.ondrop=function(e){
        e.preventDefault();
        FileDrop(e, target);
        // FileDrop(e.dataTransfer.files[0], target);
    };
    
    target.ondragover=function(e){
        e.preventDefault();
    };
}

window.addEventListener("load", function(){
                        // イベント・リスナーを初期化
                        // window.onload と window.addEventListener はどちらが
                        // 先に起動されるかわからないので夫々に initDraw() を設定
                        initDraw(); // 画面初期化はここで実行
                        
                        var can = canvas();
                        can.addEventListener("mousemove", draw, true);
                        can.addEventListener("mousedown", function(e){
                                             drawFlag = true;
                                             beginX = e.clientX - cursorw;   
                                             beginY = e.clientY - cursorh;
                                             oldX = beginX;
                                             oldY = beginY;
                                             }, false);
                        can.addEventListener("mouseup", function(e){
                                             drawFlag = false;
                                             var x = e.clientX - cursorw;   
                                             var y = e.clientY - cursorh; 
                                             if (tool() == "Line"){
                                             drawLine(x, y, penColor());
                                             } else if (tool() == "Text"){
                                             drawText(text(), x, y);
                                             }
                                             }, false);
                        }, true);


function version(){
    return "Ver.1201006";
}