
<?php
    
    function decodeSTRING($val){
        // #, &, +  < > などが URI 送信で化けるため encode して送られたものを decode
        $array = explode("%x0;", $val);
        $val = implode("#", $array);
        $array = explode("%x1;", $val);
        $val = implode("&", $array);
        $array = explode("%x2;", $val);
        $val = implode("+", $array);
        $array = explode("%x3;", $val);
        $val = implode("<", $array);
        $array = explode("%x4;", $val);
        $val = implode(">", $array);
        $array = explode("%x5;", $val);
        $val = implode(" ", $array);
        $array = explode("%x6;", $val);
        $val = implode("\n", $array);
        $array = explode("%x7;", $val);
        $val = implode("\"", $array);
        $array = explode("%x8;", $val);
        $val = implode("$", $array);
        $array = explode("%x9;", $val);
        $val = implode("\'", $array);
        return $val;
    }

    function decodeURL($val){
        // #, &, +  < > などが URI 送信で化けるため encode して送られたものを decode
        $array = explode("&lt;", $val);
        $val = implode("<", $array);
        $array = explode("&gt;", $val);
        $val = implode(">", $array);
        $array = explode("&quot;", $val);
        $val = implode('"', $array);
        return $val;
    }

    function leftBrackets(){
        // $leftBrackets = "\^\[\^" では誤作動
        return "^[^"; // encode 中で使う '(' -- クライアント側との約束 lib.js
    }
    function rightBrackets(){
        return "^]^"; // encode 中で使う '(' -- クライアント側との約束 lib.js
    }
    function decodeObject($buff){
        // "key(value)" 形式の文字列を OBJECT に decode して返す
        $obj = array();
        //	echo "decodeObject ===\n$buff\n"; //##
        for ($p=$begin=$nest=0, $len=strlen($buff); $p < $len; $p++){
            $ch = substr($buff, $p, 1);
            if (strcmp($ch, "(") == 0){
                if ($nest == 0){
                    $key = trim(substr($buff, $begin, $p - $begin)); // key 終端
                    $begin = $p + 1; // value 開始位置
                }
                $nest++;
            } else if (strcmp($ch, ")") == 0){
                if (--$nest == 0){
                    if ($nest == 0){
                        // value 終端 ( trim しない )
                        $value = substr($buff,$begin,$p-$begin);
                        $begin = $p + 1; // key 開始位置
                    }
                    if (ereg(")", $value)){ // まだ入れ子になっているなら
                        $obj[$key] = decodeObject($value);
                    } else {
                        // 特定文字を "(", ")" へ戻す
                        $array = explode(leftBrackets(), $value);
                        $value = join("(", $array);
                        $array = explode(rightBrackets(), $value);
                        $value = join(")", $array);
                        
                        $obj[$key] = $value;
                    }
                    //echo "$key{".$obj[$key]."}\n"; //##
                }
            }
        }
        return $obj;
    }

    function defaultPath($owner, $menu){
        // INFO_BOARD の存在する path を返す
        if ($menu)
            return "../Users/$owner/INFO_BOARD/MENU";
        else
            return "../Users/$owner/INFO_BOARD";
    }
	
	function fileBox($owner, $menu, $filename){
        // $dir が無ければ作成
        $dir = defaultPath($owner, $menu);
        
        if (! file_exists($dir)){
            // $dir が無ければ作成
            echo "($dir) is not exist, so I'll make directory. \n"; //##
            mkdir($dir);
        }
        return "$dir/$filename";
    }

    function putFile($path, $contents){
        // $path へ $contents を書込む
        echo "SAVE: $path \n"; //##
        
        if (!$handle = fopen($path, 'w')) {
            echo "ファイルが開けません ($path)";
            return;
        } else {
            // オープンしたファイルに$buffを書き込む
            if (fwrite($handle, $contents) === FALSE) {
                echo "($path）へ保存できませんでした";
                return;
            }
            fclose($handle);
            echo "<SEPARATOR>";
            echo "($path) へ保存しました　...\n";
        }
    }



    $command = $_GET['command']; $command=htmlspecialchars($command);
    $value = $_GET['value']; $value=htmlspecialchars($value);
    $value = decodeSTRING($value);

    if (strcmp($command,"GET_FILE") == 0){
        $args = decodeObject($value);
        $owner = $args['owner'];
        $menu = $args['menu'];
        $filename = $args['filename'];
        $path = fileBox($owner, $menu, $filename);
        
        echo "GET_FILE path: $path \n";

        $handle = @fopen($path, "r");
        if ($handle) {
            echo "<SEPARATOR>";
            while (!feof($handle)) {
                $buffer = fgets($handle, 4096);
                // ## ブラウザーの設定により好みのコードに変更可
                //$buffer = mb_convert_encoding($buffer, "SJIS", "UTF-8");
                echo "$buffer";
            }
            fclose($handle);
        }
        else
            echo "$filename cannot find";
    } else if (strcmp($command,"PUT_FILE") == 0){
        // contents を filename で書込む
        $args = decodeObject($value);
        $owner = $args['owner'];
        $filename = $args['filename'];
        $menu = $args['menu'];
        $backup = $args['backup'];
        $contents = $args['contents'];
        $contents = stripslashes($contents);
        $contents = decodeURL($contents);
        
        // $filename を書込む
        $path = fileBox($owner, $menu, $filename);
        putFile($path, $contents);
        
        // バックアップを書込む
        if ($backup){
            $now = date("YmdHi",time());
            $path = fileBox($owner, $menu, "$now$filename");
            putFile($path, $contents);
        }
    } else if (strcmp($command,"REMOVE_FILE") == 0){
        $args = decodeObject($value);
        $owner = $args['owner'];
        $menu = $args['menu'];
        $filename = $args['filename'];
        
        $path = fileBox($owner, $menu, $filename);
        //$path = "./FILES/$filename";
        echo "REMOVE: $path \n"; //##
        
        $msg = (unlink($path)) ? "を削除しました" : "を削除できませんでした";
        echo "<SEPARATOR>";
        echo "$filename $msg";
    } else if (strcmp($command,"GET_DIR") == 0){
        // INFO_BOARD 中のファイル名の配列を返す
        $args = decodeObject($value);
        $owner = $args['owner'];
        $menu = $args['menu'];
        $suffix = $args['suffix'];

        $path = defaultPath($owner, $menu);
        $files = scandir($path, 1); // 1:降順に取り出す
        
        echo "GET_DIR path: $path \n";
        
        // html のファイルだけを取り出す
        $array = array();
        for ($i=0,$ct=count($files); $i < $ct; $i++){
            $file = $files[$i];
            $ary = explode(".", $file);
            if (!$suffix)
                $array[] = $file;
            else if ((count($ary) > 1) && (strcmp($ary[1], $suffix) == 0)) 
                $array[] = $file;
        }
        
        echo "<SEPARATOR>";
        echo json_encode($array);
    } else if (strcmp($command,"GET_PATH") == 0){
        // INFO_BOARD のある path を返す
        $args = decodeObject($value);
        $menu = $args['menu'];
        $owner = $args['owner'];
        
        echo defaultPath($owner, $menu);
    } else {
        echo "*** unknown command: $command ***";
    }
    
?>