
/////////////////////////////////////////////
///// NOA からの継承値 /////////////////////////

// NOA 組込みの場合は patientId() などを直接取得できるが
// 外付けツールにも出来るようあえて以下の仕組みを使う

function _noa(){
    if (window.opener && (window.opener.name == "noa")){
        return window.opener;
    } else if (window.opener && (window.opener.name == "tools")){
        return window.top.noa;
    } else if (window.opener && (window.top.noa)){
        return window.top.noa;
    } else {
        //alert("親として NOA が見つかりません");
        return null;
    }
}

function patientId(){
    var noa = _noa();
    
    return (noa.noaType() == "NOA8G") ? noa.patient_id() : noa.patientId();

}

///// NOA からの継承値 /////////////////////////
/////////////////////////////////////////////


function calendarDateClicked(yymmdd){
    // newDatePopUp() のレシーバで、そのオブジェクトが生成された段階で呼ばれる
    if (!yymmdd)
        yymmdd = document.getElementById("birthDayPop").value;
    var array = yymmdd.split("-");
	var yy = array[0];
	var mm = array[1];
	var dd = array[2];
	
	// 年齢計算
	var elm = document.getElementById("result");
    if (elm){
        var array = age(yy, mm, dd, true);
        var y = array[0];
        var m = array[1];
        var d = array[2];
        elm.innerHTML = y + "才 " + m + "ケ月 "+ d + "日";
    }
}

function makeContents(){
	var elm = document.getElementById("contents");
	var tbl = newTABLE(elm, "baseTable");
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "", "誕生");
    td.style.padding = "0px 5px";
    td.style.width = "30px";
	var td1 = newTD(tr, "datePopupArea", "");
    
	// result
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "", "年齡");
    td.style.padding = "0px 5px";
	var td2 = newTD(tr, "result", "");
    td2.style.padding = "0px 5px";
    
    // newDatePopUp() が生成された段階で calendarDateClicked が呼ばれるので
    // calendarDateClicked が答えを表示するのに必要な td2 は先に作成しておく
    
    if (_noa()){
        var date = birthDateWithPatientId(patientId());
        var ary = date.split("-");
        var yy = ary[0] * 1;
        var mm = ary[1] * 1;
        var dd = ary[2] * 1;
    } else {
        var date = new Date();
        var yy = date.getYear();
        var mm = date.getMonth() + 1;
        var dd = date.getDate();
        if (yy < 2000) { yy += 1900; }
        yy -= 30; // 30歳を default とする
    }
    //alert("makeContents->"+yy+"/"+mm+"/"+dd); //##
    
    newDatePopUp(td1, "birthDayPop", "", yy, mm, dd, false, calendarDateClicked);
    
    if (_noa()){
        // NOA から起動されていれば NOA の生年月日を使う
        // ## この処理は window.opener が valueForTag() メッソッドを持たない場合コケル
        var date = window.opener.valueForTag("PatientTable.birthDate");
        array = date.split("-");
        var yy = array[0];
        var mm = array[1];
        var dd = array[2];
        td1.innerHTML = "";
        newDatePopUp(td1, "birthDayPop", "", yy, mm, dd, false, calendarDateClicked);
    }
}

function initAge(){
	// obj で得られたレイアウトを表示
	var elm = document.getElementById("base");
	var tbl = newTABLE(elm, "baseTable");
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "title", "生年月日から年齢計算");
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "contents", "");
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "title", version());
    
	makeContents();
}

function version(){
	return "Ver.121005";
}

