<?php
    
    function decodeSTRING($val){
        // #, &, +  < > などが URI 送信で化けるため encode して送られたものを decode
        $array = explode("%x0;", $val);
        $val = implode("#", $array);
        $array = explode("%x1;", $val);
        $val = implode("&", $array);
        $array = explode("%x2;", $val);
        $val = implode("+", $array);
        $array = explode("%x3;", $val);
        $val = implode("<", $array);
        $array = explode("%x4;", $val);
        $val = implode(">", $array);
        $array = explode("%x5;", $val);
        $val = implode(" ", $array);
        $array = explode("%x6;", $val);
        $val = implode("\\n", $array);
        $array = explode("%x7;", $val);
        $val = implode("\"", $array);
        $array = explode("%x8;", $val);
        $val = implode("$", $array);
        $array = explode("%x9;", $val);
        $val = implode("\'", $array);
        return $val;
    }
    
    function leftBrackets(){
        // $leftBrackets = "\^\[\^" では誤作動
        //	return "\^\[\^"; // encode 中で使う '(' -- クライアント側との約束 lib.js
        return "^[^"; // encode 中で使う '(' -- クライアント側との約束 lib.js
    }
    function rightBrackets(){
        return "^]^"; // encode 中で使う '(' -- クライアント側との約束 lib.js
        //	return "\^\]\^"; // encode 中で使う '(' -- クライアント側との約束 lib.js
    }
    function decodeObject($buff){
        // "key(value)" 形式の文字列を OBJECT に decode して返す
        $obj = array();
        //	echo "decodeObject ===\n$buff\n"; //##
        for ($p=$begin=$nest=0, $len=strlen($buff); $p < $len; $p++){
            $ch = substr($buff, $p, 1);
            if (strcmp($ch, "(") == 0){
                if ($nest == 0){
                    $key = trim(substr($buff, $begin, $p - $begin)); // key 終端
                    $begin = $p + 1; // value 開始位置
                }
                $nest++;
            } else if (strcmp($ch, ")") == 0){
                if (--$nest == 0){
                    if ($nest == 0){
                        // value 終端 ( trim しない )
                        $value = substr($buff,$begin,$p-$begin);
                        $begin = $p + 1; // key 開始位置
                    }
                    if (ereg(")", $value)){ // まだ入れ子になっているなら
                        $obj[$key] = decodeObject($value);
                    } else {
                        // 特定文字を "(", ")" へ戻す
                        $array = explode(leftBrackets(), $value);
                        $value = join("(", $array);
                        $array = explode(rightBrackets(), $value);
                        $value = join(")", $array);
                        
                        $obj[$key] = $value;
                    }
                    //echo "$key{".$obj[$key]."}\n"; //##
                }
            }
        }
        return $obj;
    }
    
    function fwrite_stream($fp, $string) {
        for ($written = 0; $written < strlen($string); $written += $fwrite) {
            $fwrite = fwrite($fp, substr($string, $written));
            if ($fwrite === false) {
                return $written;
            }
        }
        return $written;
    }
    


    /* ########################################
     ### 以下でも $_POST['key'] と同じに機能する ###
     if (isset($_REQUEST['key'])) { 
     $key = $_REQUEST['key']; 
     } 
     ########################################## */
    
    $command = $_POST['command'];
    $patientId = $_POST['patientId'];
    $filename = $_POST['filename'];
    $value = $_POST['value'];
    $value = decodeSTRING($value);
    $value = base64_decode($value, FALSE);
    
    if ($command == "PUT_IMAGE"){
        if ($value){
            $dir = "../NOA_ARCHIVE";
            if (! file_exists($dir)) mkdir($dir);
            $dir = "../NOA_ARCHIVE/$patientId";
            if (! file_exists($dir)) mkdir($dir);
            $dir = "../NOA_ARCHIVE/$patientId/Insurance";
            if (! file_exists($dir)) mkdir($dir);

            $path = "$dir/$filename";
            
            echo "path: $path \n";
            
            // もし同一名のファイルがあればファイル名を変更しバックアップとして保存
            if (is_readable($path)){
                $newPath = "$dir/_$filename";
                // ファイル名の頭に削除マーク "_" を付ける
                rename($path, $newPath);
            }

            $fp = fopen($path, 'w');
            $size = fwrite_stream($fp, $value);
            fclose($fp);
            // echo "<img src=$path><br>";
            echo "<SEPARATOR> Saved size( $size )\n Path( $path )";
        } else {
            echo "<SEPARATOR>Has no base64 \nval($value)";
        }
    } else if ($command == "REMOVE_IMAGE"){
        $dir = "../NOA_ARCHIVE/$patientId/Insurance";
        $oldPath = "$dir/$filename";
        $newPath = "$dir/_$filename";

        // ファイル名の頭に削除マーク "_" を付ける
        rename($oldPath, $newPath);
		echo "<SEPARATOR>";
		echo "$filename は削除されました";
    } else {
        echo "<p>key( $command ) is wrong *****</p>";
    }
    
?>
