<?php
	
	////////////////////////////////
	// print ALL PAGES with FPDF  //
	////////////////////////////////
	
	define('FPDF_FONTPATH','/Applications/MAMP/htdocs/FPDF/fpdf153/font/');
	require('../FPDF/fpdf153/mbfpdf.php');
	require("printLib.php");
	
	$GLOBALS = array();
	
	function headerWidth(){
		return 160;
	}
	
	function leftMargin(){
		return 10;
	}
	
	function lineHeight(){
		return 5;
	}
	
	function labelWidth(){
		return 10;	
	}
	
	function showCell($pdf, $x, $y, $record, $tag){
		$st = $record[$tag];
		if (strlen(trim($st)) == 0) return; 
		
		$y = $pdf->GetY();
		$pdf->Line($x, $y, $x + headerWidth(), $y);
		
		$label = labelForTag("ProgressSection.$tag");
		$pdf->Text($x, $y + lineHeight() - 2, $label);
        
		$st = mb_convert_encoding($st, "SJIS", "UTF-8");
        
		$pdf->SetXY($x + labelWidth(), $y);
		$w = headerWidth() - labelWidth() - 5;
		$pdf->MultiCell($w, lineHeight(), $st, 0, 'J');
	}
    
	function putLabelForTag($label, $tag){
		$GLOBALS['LABEL'][$tag] = $label;
	}
	function labelForTag($tag){
		$val = $GLOBALS['LABEL'][$tag];
		return mb_convert_encoding($val, "SJIS", "UTF-8");
	}
    
	function checkData($array){
		while (list($fname, $val) = each ($array)){
			if (strcmp(gettype($val), 'array') == 0){
				checkData($val);
			} else if (strcmp($fname, 'label') == 0){
				if (strlen($val) > 0){
					$tag = $array['tag'];
					putLabelForTag($val, $tag);
				}
			}
		}
	}
	
	class _MBFPDF extends MBFPDF
	{
		function Header(){
			$headerHeight = 8;
			
			$y = $this->GetY();
			$this->SetXY(labelWidth(), $y);
			
			$this->SetFont(KOZMIN,'B', 12);
			$name = $_GET['patientKanjiName'];
			$name = mb_convert_encoding($name, "SJIS", "UTF-8");
			$title = "$patientId $name l";
			$this->Cell(headerWidth(), $headerHeight, $title, 0, 0, 'L');
			
			$this->SetFont(KOZMIN,'B', 8);
			$this->SetXY(labelWidth(), $y + 2);
			$pageNum = 'Page '.$this->PageNo();
			$this->Cell(headerWidth(), 5, $pageNum, 0, 0,'R');
            
			$this->SetDrawColor(0, 0, 0);
			$x = leftMargin();
			$y = $this->GetY() + $headerHeight - 2;
			$this->Line($x, $y, $x + headerWidth(), $y);
            
			// Line break
			$this->Ln($headerHeight + 2);
		}
	}
	
	$db=mysql_connect("localhost","root","root") or error_func();
	$db_select=mysql_select_db("NOA");
	mysql_query("set names utf8");
	openDB();
    
	$pdf = new _MBFPDF('P', 'mm', array(180, 256)); // B5
    
	// header()
	$pdf->SetTopMargin(15);
	$pdf->SetAutoPageBreak(true, 15);
	
	$pdf->AddMBFont(KOZMIN ,'SJIS');
	$pdf->AddMBFont(GOTHIC ,'SJIS');
	$pdf->AddMBFont(BIG5, 'SJIS');
    
	$pdf->SetFont(KOZMIN,'B', 8);
    
	$pdf->Open();
	$pdf->AddPage();
    
	$x = leftMargin();
	$y = $pdf->GetY();
	$pdf->SetXY($x, $y);
	
	$patientId= $_GET['patientId'];
	$owner = $_GET['owner'];
    $birthDate = $_GET['birthDate'];
	$fromDate = $_GET['fromDate'];
	$toDate = $_GET['toDate'];
	$array = pr_cellForId($owner, "0");
	checkData($array);
	//	exit;
	
	$array = entryDates($patientId);
	while (list($entryDate, $record) = each ($array)){
        if ($fromDate && (strcmp($entryDate, $fromDate) < 0)) continue;
        if ($toDate && (strcmp($toDate, $entryDate) < 0)) continue;
        
		$pdf->SetFont(KOZMIN,'B', 10);
		$age = age($birthDate, $entryDate);
		$st = showDayTitle($entryDate)." ( $age  ) ";
		$pdf->SetDrawColor(180, 180, 180);
		$pdf->MultiCell(headerWidth(), lineHeight()+2, $st, 1, 'L');
		
		$pdf->SetFont(KOZMIN,'B', 8);
		showCell($pdf, $x, $y, $record, 'subject');
		showCell($pdf, $x, $y, $record, 'object');
		showCell($pdf, $x, $y, $record, 'assessment');
		showCell($pdf, $x, $y, $record, 'plan');
		showCell($pdf, $x, $y, $record, 'disease');
		showCell($pdf, $x, $y, $record, 'examination');
		showCell($pdf, $x, $y, $record, 'prescription');
		showCell($pdf, $x, $y, $record, 'treatment');
		
		$pdf->Ln(5);
	}
	
	$pdf->Output(); 
    
    
?>