
/////////////////////////////////////////////
///// NOA からの継承値 /////////////////////////

function noa(){
    if (window.opener.name == "noa"){
        return window.opener;
    } else if (window.opener.name == "tools"){
        return window.top.noa;
    } else if (window.top.noa){
        return window.top.noa;
    } else {
        alert("ERROR *** window.opener としての NOA が見つかりません");
        return null;
    }
}

function owner(){
    return noa().owner();
}

function cellText(){
    // CellEditor の入力部分を返す
    var eid = noa().editorId();
    return noa().document.getElementById(eid + ".text");
}

///// NOA からの継承値 /////////////////////////
/////////////////////////////////////////////

function gotSuffixMenu(answer){
    // サーバから接尾語リストを取得
    //alert("gotSuffixMenu->"+answer); //##
    var obj = JSON.parse(answer);
    setSuffixMenus(obj); // 接尾語メニューを記憶
    showDiseases(); // 病名リストを表示
}
function gotPrefixMenu(answer){
    // サーバから接頭語リストを取得
    //alert("gotPrefixMenu->"+answer); //##
    var obj = JSON.parse(answer);
    setPrefixMenus(obj); // 接頭語メニューを記憶
    NRGetMenu(noa().owner(), _suffix, gotSuffixMenu);
}
function gotDisesesMenu(answer){
    // サーバから病名リストを取得
    //alert("gotDisesesMenu->"+answer); //##
    var obj = JSON.parse(answer);
    setMenus(obj); // メニューを記憶
    NRGetMenu(noa().owner(), _prefix, gotPrefixMenu);
}

var _prefix = "接頭語";
var _suffix = "接尾語";

var _menus
function setMenus(obj){
    //alert("setMenus->"+encodeObject(obj)); //##
    _menus = [""];
    for (num in obj){
        var rec = obj[num];
        if (rec.menu.length)
            _menus.push(rec.menu);
    }
    _menus.push("...その他");
}
function menus(){
    return _menus;
}

var _prefixMenus
function setPrefixMenus(obj){
    //alert("setPrefixMenus->"+encodeObject(obj)); //##
    _prefixMenus = [""];
    for (num in obj){
        var rec = obj[num];
        if (rec.menu.length)
            _prefixMenus.push(rec.menu);
    }
    _prefixMenus.push("...その他");
}
function prefixMenus(){
    // 接頭語メニュー配列を返す
    return _prefixMenus;
}

var _suffixMenus
function setSuffixMenus(obj){
    //alert("setPrefixMenus->"+encodeObject(obj)); //##
    _suffixMenus = [""];
    for (num in obj){
        var rec = obj[num];
        if (rec.menu.length)
            _suffixMenus.push(rec.menu);
    }
    _suffixMenus.push("...その他");
}
function suffixMenus(){
    // 接尾語メニュー配列を返す
    return _suffixMenus;
}

var _diseases;
function setDiseases(buff){
    // buff を日付ごとのオブジェクトに展開して記憶
    _diseases = new Array();
    if (trim(buff).length == 0) return;
    
    var records = buff.split("<br>");
    for (num in records){
        var ln = trim(records[num]); // 開始日 病名 -- 終了日 転帰" 型式
        if (ln.length == 0) continue;
        
        var rec = new Object();
        var array = ln.split("--");
        
        // 開始日と病名
        var leftSide = trim(array[0]); // " -- " の余白を削除
        var cols = leftSide.split(" ");
        if (cols.length < 2){
            alert(leftSide + " には「開始日」か「病名」が欠けています");
            continue; // 開始日・病名 の両方がなければ無視
        }
        
        rec.start = cols[0]; // 開始日
        cols.shift(); // 開始日を削除
        rec.name = cols.join(" "); // 病名
        
        // 終了日と転帰
        rec.end = ""; // 終了日
        rec.conclusion = ""; // 転帰
        if (array.length > 1){
            var rightSide = trim(array[1]); // " -- " の余白を削除
            var cols = rightSide.split(" ");
            rec.end = cols[0]; // 終了日
            rec.conclusion = (cols.length > 1) ? cols[1] : ""; // 転帰
        }
        _diseases.push(rec);
    }
}
function diseases(){
    return _diseases;
}
function diseaseAt(row){
    // row 番目の病名オブジェクトを返す
    if (row < _diseases.length)
        return _diseases[row];
    else
        return null;
}

function diseasesToString(){
    // 病名オブジェクトを NOA 病名欄用の文字列にして返す
    var array = new Array();
    for (num in _diseases){
        var rec = _diseases[num];
        if (rec.name.length == 0) continue; // 病名が空ならスキップ
        
        var ary = new Array();
        ary.push(rec.start);
        ary.push(rec.name);
        if (rec.end.length > 5) ary.push("--"); // 終了日とのセパレータ
        ary.push(rec.end);
        ary.push(rec.conclusion);
        array.push(ary.join(" "));
    }
    return array.join("<br>");
}
function addDisease(){
    // 新規病名行を追加
    var rec = new Object();
    rec.start = shortDate(today());
    rec.name = "";
    rec.end = "";
    rec.conclusion = "";
    _diseases.push(rec);
    
    // リスト内容を更新
    var row = _diseases.length - 1;
    makeDiseseRow(row); // row が指定されていると floatPanel 立ち上がる
}
function removeDisease(num){
    // num 番目の病名オブジェクトを削除
    var rec = _diseases[num];
    _diseases.splice(num, 1);
    
    // リスト内容を更新
    makeDiseseRow();
}

////////////////////////////////////////////////////////
///// DRAG and DROP ////////////////////////////////////

function f_dragstart(event){
    // ドラッグ開始時の処理
    // ドラッグするデータのid名をDataTransferオブジェクトにセット
    event.dataTransfer.setData("text", event.target.id);
}

function f_dragover(event){
    // ドラッグ要素がドロップ要素に重なっている間の処理
    //　dragoverイベントをキャンセルして、ドロップ先の要素がドロップを受け付けるようにする
    event.preventDefault();
}

function f_drop(event){
    // ドロップ時の処理
    // ドラッグされたデータのid名をDataTransferオブジェクトから取得
    var id_name = event.dataTransfer.getData("text");
    
    //id名からドラッグされた要素を取得
    var drag_elm = document.getElementById(id_name);
    
    //ドロップ先にドラッグされた要素を追加
    // event.currentTarget.appendChild(drag_elm);
    moveTo(id_name, event.currentTarget);
    
    //エラー回避のため、ドロップ処理の最後にdropイベントをキャンセルしておく
    event.preventDefault();
}
function moveTo(drop_id, target_node){
    // ドロップされたエレメントをドロップされたターゲット・エレメント位置へ移動
    var target_id = target_node.id;
    if (drop_id == target_node.id) return; // 自分自身は無視
    
    // ドロップするオブジェクトを抜かした配列を生成
    var dropRec;
    var anArray = new Array();
    var recs = diseases();
    for (num in recs){
        var rec = recs[num];
        if (num == drop_id){
            dropRec = rec; // ドロップすべきオブジェクトを記憶
            continue;
        }
        anArray.push(rec);
    }
    
    // ドロップすべきオブジェクトをドロップする位置に挿入した配列を生成
    var newRecords = new Array();
    for (num in anArray){
        var rec = anArray[num];
        if (num == target_node.id)
            newRecords.push(dropRec);
        newRecords.push(rec);
    }
    if (target_node.id >= anArray.length)
        newRecords.push(dropRec);
    
    // レイアウトの mode() に該当する部分だけを newRecords 要素と置換
    _diseases = newRecords;
    
    // レイアウトを再表示
    makeDiseseRow();
}

///// DRAG and DROP ////////////////////////////////////
////////////////////////////////////////////////////////


function makeDiseseRow(editRow){
    // 病名リストを生成
    // editRow が指定されていると row 行の編集パネルが立ち上がる
	var elm = document.getElementById("editorArea");
    elm.innerHTML = "";
    var tbl = newTABLE(elm, "base-table");
    tbl.style.fontSize = "10pt";
    
    // タイトル
    var tr = newTR(tbl, "", "");
    tr.style.backgroundColor = "#eee";
    var td = newTD(tr, "/startDate", "開始日");
    var td = newTD(tr, "/name", "病名");
    var td = newTD(tr, "/endDate", "終了日");
    var td = newTD(tr, "/conclusion", "転帰");
    var td = newTD(tr, "/mark", "");
    
    // 病名リスト
    var array = diseases();
    for (num in array){
        // 一行分のエレメントを生成
        var rec = diseaseAt(num);
        
        var tr = newTR(tbl, num + ".row", "");
        // CSS ではうまく動かないので以下を設定
        tr.setAttribute("onmouseover", "setColor(this, '#ff0', '#00f')");
        tr.setAttribute("onmouseout", "resetColor(this, '#000', '#fff')");
        
        var td = newTD(tr, "/startDate", rec.start);
        td.setAttribute("onclick", "openFloatEditor(this,'" + num + "')");
        var td = newTD(tr, num+"/name", rec.name);
        td.setAttribute("onclick", "openFloatEditor(this,'" + num + "')");
        td.setAttribute("draggable", "true"); // HTML5: ドラッグ可能にする
        td.setAttribute("ondragstart", "f_dragstart(event)");
        td.setAttribute("ondragover", "f_dragover(event)");
        td.setAttribute("ondrop", "f_drop(event)");
        var td = newTD(tr, "/endDate", rec.end);
        td.setAttribute("onclick", "openFloatEditor(this,'" + num + "')");
        var td = newTD(tr, "/conclusion", rec.conclusion);
        td.setAttribute("onclick", "openFloatEditor(this,'" + num + "')");
        var td = newTD(tr, "/mark", "");
        var img = newIMAGE(td, "", "./remove-field.png", "remove");
        img.style.height = "13px";
        img.setAttribute("onclick", "removeDisease('" + num + "')");
    }
    
    // 新規病名挿入後の場合は editRow が指定されており、その編集パネルが立ち上がる
    if (editRow) openFloatEditor(td, num);
    
    // 新規病名追加
    var tr = newTR(tbl, "", "");
    var td = newTD(tr, "", "");
    var td = newTD(tr, "/addField", "病名を追加");
    td.setAttribute("onclick", "addDisease()");
}

function ok(){
    // 病名記入ツールの編集内容を NOA へ書き戻す
    cellText().innerHTML = diseasesToString();
    
    // 開いているエディター内容を保存し閉じる
    if (diseaseTouchAndGo() > 0)
        noa().closeEditor(noa().editorId(), true, false);
}

function diseaseHelp(){
	// 別途ヘルプをパネル表示
	window.open("./diseaseHelp.html","Help"
				,"width=450,height=700,scrollbars=yes,resizable=yes");
}

function showDiseases(){
    // 病名リストを表示するパネルを生成
	var base = document.getElementById("base");
    base.innerHTML = "";
    
    // ===== 病名 表示エリア ==========================
    var elm = newDIV(base, "");
    // === HEADER =======================
    var div = newDIV(elm, "tool-header");
    // --- LEFT SIDE ---
    var dv = newDIV(div, "/left-side");
    dv.style.width = "50%";
    var sp = newSPAN(dv, "");
    sp.innerHTML = "病名編集ツール";
    // --- RIGHT SIDE ---
    var dv = newDIV(div, "/right-side");
    // HELP ICON
	var im = newIMAGE(dv, "", "./Help.png", "?");
	im.setAttribute("onclick", "diseaseHelp()");
	im.style.height = "18px";
    
	// ===== 編集エリア ==================================
    var div = newDIV(elm, "editorArea");
    
    // === FOOTER =======================
    var div = newDIV(elm, "tool-footer");
    // --- LEFT SIDE ---
    var dv = newDIV(div, "/left-side");
    dv.style.width = "80px";
    dv.innerHTML = di_version();
    dv.style.position = "relative";
    dv.style.top = "3px";
    // --- RIGHT SIDE ---
    var dv = newDIV(div, "/right-side");
    // 確定保存チェックボックス
    var sp = newSPAN(dv, "");
    sp.style.marginRight = "10px";
    sp.style.position = "relative";
    sp.style.top = "1px";
    var cb = newCHECKBOX(sp, "touchAndGoCheck", " 確定保存", diseaseTouchAndGo());
    cb.setAttribute("onchange", "setDiseaseTouchAndGo(this)");
    // 確定ボタン
    var bt = newDIV(dv, "/whiteButton");
    bt.innerHTML = "確定";
    bt.setAttribute("onclick", "ok()");
    bt.style.position = "relative";
    bt.style.top = "2px";
    
    // NOA の病名欄を読込み、病名リストを表示
    var buff = cellText().innerHTML; // NOA の CellEditor の内容
    setDiseases(buff);
	makeDiseseRow();
}

function initDisease(){
    NRGetMenu(noa().owner(), "ProgressSection.disease", gotDisesesMenu);
}

function di_version(){
	return "Ver.130618";
}
