

var _counter;
function setCounter(array){
    // "[...]" 印のあるページの受診日の配列
    _counter = array;
}
function counter(){
    return _counter;
}
function hasCouner(date){
    // _counter に date が含まれれば true を返す
    for (num in _counter){
        var entryDate = _counter[num];
        if (isSameDate(date, entryDate)){
            if (entryDate.indexOf("START") >= 0)
                return 1;
            else
                return 2;
        }
    }
    return 0;
}
function isStartDate(date){
    // _counter に記憶した日付に "START" が入っていれば true を返す
    for (num in _counter){
        var entryDate = _counter[num];
        if (isSameDate(date, entryDate)){
            if (entryDate.indexOf("START") >= 0)
                return true;
        }
    }
    return false;
}

function pageScrollUp(date){
    // ページを画面上端にスクロール
    var obj = structure();
    for (entryDate in obj){
        if (isSameDate(date, entryDate)){
            pageScrollTo(entryDate);
            return; // 受診歴があったのでそのページにスクロール
        }
    }
    
    // 受診歴がなかった：すなわち予約日
    for (num in _bookingArray){
        var entryDate = _bookingArray[num];
        if (isSameDate(date, entryDate)){
            // 予約日の場合、そのページはまだ存在しないので
            // 代わりに予約ツールを開く
            window.open("../Booking","tools");
        }
    }
}

function hideCount(date){
    // マウスで指した日付の count を消す
    var array = date.split("-");
    var year = array[0];
    var month = array[1];
    var day = array[2];
    
	var elm = document.getElementById("calMessage"+year+month);
    elm.innerHTML = "";
}
function showCount(date){
    // マウスで指した日付の count を表示
    var array = date.split("-");
    var year = array[0];
    var month = array[1];
    var day = array[2];
	var elm = document.getElementById("calMessage"+year+month);
    elm.style.paddingLeft = "10px";
    
    var counter = 0;
    var ct = _counter.length;
    for (var num=ct-1; num >= 0; num--){
        var entryDate = _counter[num];
        if (entryDate.indexOf("START") > 0)
            counter = 1;
        else
            counter++;
        if (isSameDate(date, entryDate)){
            elm.innerHTML = counter + " 回目";
        }
    }
}
function showMonth(year, month){
    // その月のカレンダーを表示
    _debug("== showMonth->"+year+"/"+month); //##
    
    var cal = document.getElementById(year + "_" + month + ".calendar");
    if (cal && cal.innerHTML.length){
        // すでにカレンダーが開いていれば閉じて終了
        cal.innerHTML = "";
        return;
    }
    
    var div = document.getElementById(year + "_" + month + ".bar");
    div.innerHTML = "";
    
    // div.innerHTML = "" を行うので、年月ラベルを再構築
    makeYearMonthLabel(div, year, month);
    
    // カレンダー本体
    var dv = newDIV(div, year + "_" + month + ".calendar");
    
    var tbl = newTABLE(dv, "calendarTable");
    
    // WEEK
    var tr = newTR(tbl, "", "");
    var array = weeks(); // lib.js
    for (num in array){
        var td = newTD(tr, "", array[num]);
        td.style.textAlign = "right";
    }
    
    // DAY
    var lastDay = getLastDate(year, month);
    var w = 0;
    if (calendarIsReverse() > 0){
        // 毎月のカレンダーを逆順に表示
        var lastWeek = weekOfDate(year + "-" + month + "-" + lastDay);
        var lastW = lastW(lastWeek);
        var day = lastDay * 1 - lastW * 1;
        var weekBeginDay = day; // 週開始の日付
        
        while (day > -7){
            if (w == 0)
                var tr = newTR(tbl, "", "");
            
            if (day > lastDay){
                var td = newTD(tr, "/dateTip", ""); // 空欄日付を表示
            } else if (day <= 0){
                var td = newTD(tr, "/dateTip", ""); // 空欄日付を表示
                day++;
            } else {
                var td = newTD(tr, "/dateTip", "" + day);
                var dd = (day * 1 < 10) ? "0" + day : day;
                var date = year + "-" + month + "-" + dd;
                td.setAttribute("onclick", "pageScrollUp('" + date + "')");
                day++;
            }
            
            // 日付にカラー・マーキング
            if (isVisitDate(date)){ // 受診した日付
                if (td.innerHTML.length == 0){
                    // do nothing
                } else {
                    // 2013-04-22 16:35:00 は 130422 形式で比較しないとうまくいかない
                    var status = hasCouner(date) * 1;
                    if (status == 1){ // カウント開始日
                        td.setAttribute("class", "orangeDateTip");
                        td.setAttribute("onmouseover", "showCount('" + date + "')");
                        td.setAttribute("onmouseout", "hideCount('" + date + "')");
                    } else if (status == 2){ // カウントのある受診日
                        td.setAttribute("class", "yellowDateTip"); //##
                        td.setAttribute("onmouseover", "showCount('" + date + "')");
                        td.setAttribute("onmouseout", "hideCount('" + date + "')");
                    } else { // カウントのない受診日
                        td.setAttribute("class", "greenDateTip");
                    }
                }
            }
            
            if ((date > today()) && isBookingDate(date))
                td.setAttribute("class", "pinkDateTip");
            
            if (++w == 7){
                if (day <= 8) break;
                
                w = 0;
                day = weekBeginDay - 7;
                weekBeginDay = day;
            }
        }
    } else {
        var firstWeek = weekOfDate(year + "-" + month + "-01");
        var day = 0;
        
        while (day <= lastDay){
            if (w == 0)
                var tr = newTR(tbl, "", "");
            
            if (day == 0){
                if (firstWeek == weeks()[w]){
                    // 曜日が月初の曜日と一致したなら１日に設定
                    day = 1;
                } else {
                    // そうでなければ空欄日付を表示
                    w++;
                    var td = newTD(tr, "/dateTip", "");
                    continue;
                }
            }
            var td = newTD(tr, "/dateTip", "" + day);
            var dd = (day * 1 < 10) ? "0" + day : day;
            var date = year + "-" + month + "-" + dd;
            td.setAttribute("onclick", "pageScrollUp('" + date + "')");
            
            // 日付にカラー・マーキング
            if (isVisitDate(date)){ // 受診した日付
                if (td.innerHTML.length == 0){
                    // do nothing
                } else {
                    var status = hasCouner(date) * 1;
                    if (status == 1){ // カウント開始日
                        td.setAttribute("class", "orangeDateTip");
                        td.setAttribute("onmouseover", "showCount('" + date + "')");
                        td.setAttribute("onmouseout", "hideCount('" + date + "')");
                    } else if (status == 2){ // カウントのある受診日
                        td.setAttribute("class", "yellowDateTip"); //##
                        td.setAttribute("onmouseover", "showCount('" + date + "')");
                        td.setAttribute("onmouseout", "hideCount('" + date + "')");
                    } else { // カウントのない受診日
                        td.setAttribute("class", "greenDateTip");
                    }
                }
            }

            if ((date > today()) && isBookingDate(date))
                td.setAttribute("class", "pinkDateTip");

            day++;
            if (day > lastDay) break;
            if (++w > 6) w = 0;
        }
    }
    
    // keyCount モードのカウント数を表示するエリア
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "calMessage"+year+month, "");
	td.setAttribute("colspan", "7");
	td.style.color = "#00f"; //blue
    
    
    function setMarkAttribute(td, date){
        // 日のエレメントにカウント・マークを設定
        if (!_markStartDate){
            // カウント開始マークがなければカウントのない受診日
            td.setAttribute("class", "greenDateTip");
            return;
        }
        
        var dt = shortDate(date);
        var sdt = shortDate(_markStartDate);
        var gdt = shortDate(_markGoalDate);
        if (dt == sdt){ // カウント開始日
            td.setAttribute("class", "orangeDateTip");
            td.setAttribute("onmouseover", "showCount('" + date + "')");
            td.setAttribute("onmouseout", "hideCount('" + date + "')");
        } else if ((dt <= gdt) && (dt > sdt)){ // カウントのある受診日
            td.setAttribute("class", "yellowDateTip");
            td.setAttribute("onmouseover", "showCount('" + date + "')");
            td.setAttribute("onmouseout", "hideCount('" + date + "')");
        } else { // カウントのない受診日
            td.setAttribute("class", "greenDateTip");
        }
    }
    
    function isVisitDate(date){
        // year, month, day が受診日なら true を返す
        var array = history();
        for (num in array){
            var entryDate = array[num];
            if (isSameDate(date, entryDate)) return true;
        }
        return false;
    }
    
    function isBookingDate(date){
        // year, month, day が予約日なら true を返す
        for (num in _bookingArray){
            var entryDate = _bookingArray[num];
            
            if (isSameDate(date, entryDate)) return true;
        }
        return false;
    }
    
    function lastW(weekSt){
        // 曜日に対応する数値を返す
        var array = weeks();
        for (num in array){
            if (array[num] == weekSt)
                return num;
        }
        return 0;
    }
}

function makeYearMonthLabel(div, year, month){
    // 年月 ラベル
    var dv = newDIV(div, "/calYearMonthLabel");
    dv.innerHTML = year + " " + month;
    dv.setAttribute("onclick", "showMonth('"+year+"','"+month+"')");
}

function showMonthlyCalendar(){
    // 各月のカレンダーを表示
    _debug("== showMonthlyCalendar =="); //##
    
	var elm = document.getElementById("contentsArea");
	elm.innerHTML = "";

    // 予約日があればそれをマージ
    var dateArray = history();
    _debug("-- dateArray->"+dateArray); //##
    
    if (_bookingArray){
        dateArray = _bookingArray.concat(dateArray);
    }
    
    if (calendarIsReverse() == 0){
        // 正順にソート
        dateArray = dateArray.reverse();
    }
    
    var year;
    var month;
    for (num in dateArray){
        // rec は ProgressSection と NameSection のデータを保有
        var entryDate = dateArray[num];
        var st = entryDate.substr(0,10);
        var ary = st.split("-");
        
        _debug("-- entryDate->"+entryDate+" currentDate->"+currentDate()); //##
        
        if ((year != ary[0]) || (month != ary[1])){
            year = ary[0];
            month = ary[1];
            var div = newDIV(elm, year + "_" + month + ".bar");
            
            _debug("-- year/month->"+year+"->"+month); //##
            
            div.setAttribute("class", "yearMonthRow");
            
            // 年月 ラベル
            makeYearMonthLabel(div, year, month); // float:left
            
            _debug("-- makeYearMonthLabel->"+isSameMonth(entryDate, currentDate())); //##
            
            // calendarToExpand か 参照中の受診日と同月なら カレンダーを開く
            if ((calendarToExpand()*1 > 0) || (isSameMonth(entryDate, currentDate()))){
               showMonth(year, month);
            }
        }
    }
    _debug("-- showMonthlyCalendar->end"); //##
}

var _bookingArray;
function gotBooking(answer){
    // 予約日リストが answer として返される
    alert("gotBooking->"+answer); //##
    _bookingArray = JSON.parse(answer);
    _debug("gotBooking->"+encodeObject(_bookingArray)); //##
    
    // 各月のカレンダーを表示
    showMonthlyCalendar();
    _debug("-- gotBooking->end"); //##
}

var _markStartDate;
var _markGoalDate;
function getCounter(){
    // [candida治療] などの印のついた受診日の配列を返す
    var counter = new Array();
    var obj = structure();
    for (entryDate in obj){
        var rec = obj[entryDate];
        var cell = rec['ProgressSection.subject'];
        if (!cell) continue;
        
        var val = cell.trimValue;
        if (val.length == 0) continue;
        if (! hasCountForm(val)) continue; // [...] 型式でなければスキップ
        
        if (val.indexOf(":開始]") >= 0)
            // "[...:開始]" があれば起点とする
            counter.push(entryDate + "START");
        else if (val.indexOf(":終了]") >= 0){
            // "[...:終了]" があれば終点とする
            counter.push(entryDate + "END");
        } else {
            counter.push(entryDate);
        }
    }
    return counter;
    
    
    function hasCountForm(buff){
        // buff に "[...]" が含まれれば true を返す
        if (buff == null) return false;
        if (buff.indexOf("[") < 0) return false;
        if (buff.indexOf("]") < 0) return false;
        return true;
    }
    
    function getCountKey(buff){
        // buff 中の "[..." を key として返す
        var array = buff.split("[");
        var st = array[1];
        array = st.split("]");
        st = array[0];
        array = st.split(":");
        
        return "[" + array[0];
    }
}

function expandCalendar(){
    // calendar を展開する
	var elm = document.getElementById("arrowArea");
    elm.innerHTML = "";
    elm.setAttribute("onclick", "foldCalendar()");
	var img = newIMAGE(elm, "", "./reduce.png", "reduce");
	img.style.height = "12px";
    img.setAttribute("class", "expandIcon");
    img.style.position = "relative";
    img.style.top = "5px";
    setCalendarToExpand(true); // localStorage.js に記憶

    showMonthlyCalendar();
}
function foldCalendar(){
    // problemList を折畳む
	var elm = document.getElementById("arrowArea");
    elm.innerHTML = "";
    elm.style.padding = "0 0";
    elm.style.position = "relative";
    elm.style.bottom = "-2px";
    elm.setAttribute("onclick", "expandCalendar()");
	var img = newIMAGE(elm, "", "./expand.png", "expand");
	img.style.height = "12px";
    img.setAttribute("class", "expandIcon");
    img.style.position = "relative";
    img.style.top = "5px";
    setCalendarToExpand(false); // localStorage.js に記憶

    showMonthlyCalendar();
}

function checkReverse(elm){
    // 逆順チェック・ボックスがチェックされた
    setCalendarIsReverse(elm);
    initCalendar();
}

function calendarHelp(){
    // HELP を開く
	// 別途ヘルプをパネル表示
	window.open("./calendarHelp.html","Help"
				,"width=450,height=700,scrollbars=yes,resizable=yes");
}

function openCalendar(array){
    _bookingArray = array;

	var elm = document.getElementById("calendarArea");
	elm.innerHTML = "";
    
    //_initDebug(true); //##
    
    // HEADER
    var div = newDIV(elm, "/clearfix");
    // --- LEFT SIDE ----------
    var dv = newDIV(div, "/left-side");
    dv.style.width = "50px"; // left-side は width を指定しておく必要あり
    dv.style.height = "23px";
    // ARROW ICON
    var sp = newDIV(dv, "arrowArea");
    
    // --- RIGHT SIDE ----------
    var dv = newDIV(div, "/right-side");
    dv.style.paddingRight = "0";
    var img = newIMAGE(dv, "", "Help.png", "icon");
    img.setAttribute("onclick", "calendarHelp()");
    img.setAttribute("class", "expandIcon");
    img.style.height = "15px";
    
    // CONTENTS
    var div = newDIV(elm, "contentsArea");

    // FOOTER
    var div = newDIV(elm, "");
    div.style.clear = "both";
    div.style.paddingTop = "5px";
    div.style.fontSize = "10pt";
    div.style.color = "#666";
    var cb = newCHECKBOX(div, "", "逆順に表示", calendarIsReverse());
    cb.setAttribute("onchange", "checkReverse(this)");

    // [candida治療] などの印をカウントし配列に記憶
    setCounter(getCounter());
    
    // 各月のカレンダーを表示
    if (calendarToExpand() * 1 > 0)
        expandCalendar();
    else
        foldCalendar();
}


