
/////////////////////////////////////////////
///// NOA からの継承値 /////////////////////////

// NOA 組込みの場合は patientId() などを直接取得できるが
// 外付けツールにも出来るようあえて以下の仕組みを使う

function noa(){
    if (window.opener.name == "noa"){
        return window.opener;
    } else if (window.opener.name == "tools"){
        return window.top.noa;
    } else if (window.top.noa){
        return window.top.noa;
    } else {
        alert("ERROR *** tools.js: window.opener としての NOA が見つかりません");
        return null;
    }
}

///// NOA からの継承値 /////////////////////////
//////////////////////////////////////////////

function get_problems(){
    // problemList を生成
    var problems = new Array();
    
    var records = noa().noaStructure().ProgressSection;
    for (num in records){
        var rec = records[num];
        
        pickupProblems(rec, problems);
    }
    return problems;


    function pickupProblems(rec, problems){
        // subject 欄のデータから problem とその children を抽出し problems に追加し
        // subject 以外の欄から children を抽出し problems に追加
        var dateTime = rec.date; // 受診日
        var val = trim(rec.subject); // subject 欄データ
        if (trim(val).length){
            var array = val.split('\n');
            var objNumber = "";
            if (array.length >= 1){
                for (num in array){
                    var st = trim(array[num]); // subject 欄の各行
                    if (st.length == 0) continue;
                    
                    if (st.charAt(0) == '#'){ // # ではじまる行
                        var pos = st.indexOf(' ');
                        if (pos > 0){
                            objNumber = st.substr(0, pos);
                            
                            if (!problems[objNumber]){
                                var pobj = new Object();
                                pobj.number = objNumber;
                                pobj.problem = st.substr(pos);
                                problems[objNumber] = pobj; // プロブレム・オブジェクト
                            }
                        }
                    } else { // 行頭に # がない行
                        var pobj = problems[objNumber];
                        if (pobj){
                            if (! pobj.child) pobj.child = new Object();
                            if (! pobj.child[dateTime]) pobj.child[dateTime] = st;
                        }
                    }
                }
            }
        }
        // subject 欄以外の欄もスキャン
        problemsInAnotherSection(rec.object, problems);
        problemsInAnotherSection(rec.assessment, problems);
        
        
        function problemsInAnotherSection(val, problems){
            // subject 以外の欄の内容から problem の子コメントをピックアップ
            if (trim(val).length){
                // subject 以外の欄の内容から problem の子コメントをピックアップ
                var array = val.split('\n');
                var st = trim(array[0]); // 一行目のみを取り出す
                if (st.charAt(0) == '#'){ // # ではじまる行
                    var objNumber = "";
                    var pos = st.indexOf(' ');
                    if (pos > 0) objNumber = st.substr(0, pos);
                    var pobj = problems[objNumber];
                    if (pobj){
                        if (! pobj.child) pobj.child = new Object();
                        var ln = st.substr(pos);
                        if (! pobj.child[dateTime]) pobj.child[dateTime] = ln;
                    }
                }
            }
        }
    }
}

function getProblems(){
    // problemList を生成
    if (noa().debugMode()){
        return get_problems();
    }
    _initDebug(false); //##
    _debug("getProblems"); //##
    
    var problems = new Array();
    var obj = noa().structure();
    _debug("obj->"+encodeObject(obj)); //##

    for (dateTime in obj){
        var rec = obj[dateTime];
        
        _debug("------- "+dateTime);
        
        for (tag in rec){
            var cell = rec[tag];
            var val = cell.trimValue;
            if (trim(val).length == 0) continue;
            
            if (tag == 'ProgressSection.disease'){
                // do nothing
            } else if (tag == 'ProgressSection.examination'){
                    // do nothing
            } else if (tag == 'ProgressSection.treatment'){
                // do nothing
            } else if (tag == 'ProgressSection.pageHeader'){
                // do nothing
            } else if (tag == 'ProgressSection.subject'){
                // subject 欄の内容から problem をピックアップ
                var array = val.split('\n');
                var objNumber = "";
                if (array.length >= 1){
                    for (num in array){
                        var st = trim(array[num]); // subject 欄の各行
                        if (st.length == 0) continue;
                        
                        if (st.charAt(0) == '#'){ // # ではじまる行
                            var pos = st.indexOf(' ');
                            if (pos > 0){
                                objNumber = st.substr(0, pos);
                                
                                if (!problems[objNumber]){
                                    var pobj = new Object();
                                    pobj.number = objNumber;
                                    pobj.problem = st.substr(pos);
                                    problems[objNumber] = pobj;
                                    
                                    _debug(objNumber+"->"+pobj.problem); //##
                                }
                            }
                        } else { // 行頭に # がない行
                            var pobj = problems[objNumber];
                            if (pobj){
                                if (! pobj.child) pobj.child = new Object();
                                if (! pobj.child[dateTime]) pobj.child[dateTime] = st;
                            }
                        }
                    }
                }
            } else { // subject 以外の CELL
                // subject 以外の欄の内容から problem の子コメントをピックアップ
                var array = val.split('\n');
                var st = trim(array[0]); // 一行目のみを取り出す
                if (st.charAt(0) == '#'){ // # ではじまる行
                    var objNumber = "";
                    _debug(tag +"->"+st);
                    var pos = st.indexOf(' ');
                    if (pos > 0) objNumber = st.substr(0, pos);
                    var pobj = problems[objNumber];
                    if (pobj){
                        if (! pobj.child) pobj.child = new Object();
                        var ln = st.substr(pos);
                        if (! pobj.child[dateTime]) pobj.child[dateTime] = ln;
                        _debug(dateTime +"->"+ln);
                    }
                }
            }
        }
    }

    return problems;
}

function foldChild(num){
    // num 番目の child を折畳む
    foldNode(num + ".child");
}

function pageScrollUp(date){
    // ページを画面上端にスクロール
    if (noa().debugMode()){
        var array = noa().history();
        for (num in array){
            var entryDate = array[num];
            if (isSameDate(date, entryDate))
                noa().pageScroll_to(entryDate);
        }
    } else {
        var obj = noa().structure();
        for (entryDate in obj){
            if (isSameDate(date, entryDate))
                noa().pageScrollTo(entryDate);
        }
    }
}

function showProblemList(nodeId){
	// problemList を作成し elm に表示
	var elm = document.getElementById(nodeId); 
	elm.innerHTML = "";

    // CONTENTS
    var div = newDIV(elm, "contentsArea");
    div.style.padding = "5px";
	var tbl = newTABLE(div, "base-table");
    tbl.style.fontSize = "9pt";

    var inactives = new Array();
    var records = getProblems();
    
    for (num in records){
        var pobj = records[num];
        var tr = newTR(tbl, "", "");
        
        // NUMBER
        var td = newTD(tr, "", pobj.number);
        td.style.verticalAlign = "top";
        td.style.width = "20px";
        
        // PROBLEM
        var td = newTD(tr, "", "");
        var sp = newSPAN(td, "");
        sp.innerHTML = pobj.problem;
        sp.setAttribute("onclick", "foldChild('" + num + "')");
        setChangeColor(sp, '#000', '#fff');
        
        if (pobj.child){
            // CHILD
            var tr = newTR(tbl, num + ".child", "");
            if (! isActiveProblem(pobj.problem)){
                // "(...)" でくくられた active でない node の id を配列に記憶
                inactives.push(num + ".child");
            }
            var td = newTD(tr, "", "");
            var td = newTD(tr, "", "");
            var tbl2 = newTABLE(td, "base-table");
            tbl2.style.fontSize = "9pt";
            
            for (date in pobj.child){
                var tr2 = newTR(tbl2, "", "");
                // DATE
                var td2 = newTD(tr2, "", shortDate(date));
                td2.style.width = "20px";
                td2.style.paddingRight = "5px";
                td2.style.verticalAlign = "top";
                
                // COMMENT
                var td2 = newTD(tr2, "", "");
                var a = newA(td2, pobj.child[date], "#", "");
                a.setAttribute("onclick", "pageScrollUp('" + date + "')");
            }
        }
    }
    
	// inactive なセルを折り畳む
	for (num in inactives)
		foldNode(inactives[num]);
    

	function isActiveProblem(problem){
		// #num (..) で括られた problem は表示対象外
		// $ln = "#4 problem" なら active
		// $ln = "#4 (problem)" なら inactive
		var begin = problem.indexOf(" ");
		var label = trim(problem.substr(begin + 1));
		if (label.charAt(0) == "("){
			if (label.charAt(label.length-1) == ")")
				return false;
		}
		return true;
	}
}

function problemListHelp(){
	window.open("./problemListHelp.html","Help"
				,"width=450,height=700,scrollbars=yes,resizable=yes");
}

function initProblemList(){
    // Problem List を表示
    var elm = document.getElementById("base");
    elm.innerHTML = "";
    
    // HEADER
    var div = newDIV(elm, "tool-header");
    // --- LEFT SIDE ---
    var dv = newDIV(div, "/left-side");
    dv.style.paddingTop = "2px";
    var bt = newSPAN(dv, "");
    bt.innerHTML = "PROBLEM LIST";
    // --- RIGHT SIDE ---
    var dv = newDIV(div, "/right-side");
    dv.style.marginRight = "10px";
    // HELP ICON
	var img = newIMAGE(dv, "", "./Help.png", "?");
	img.style.height = "18px";
	img.setAttribute("onclick", "problemListHelp()");
    
    // panelEditor からも使えるよう node-id を指定して開けるようになっている
    var div = newDIV(elm, "contents");
    showProblemList("contents");
    
    // FOOTER
    var div = newDIV(elm, "tool-footer");
    var dv = newDIV(div, "/left-side");
    dv.style.position = "relative";
    dv.style.top = "3px";
    dv.style.height = "22px";
    dv.innerHTML = version();
}

function version(){
    return "Ver.130412";
}


