

/////////////////////////////////////////////////
///// GROUP_TEMPLATE ////////////////////////////

var _templateTag = "GROUP_TEMPLATE";
var _groupTemplates;

function setGroupTemplates(answer){
    _groupTemplates = JSON.parse(answer);
    //alert("setGroupTemplates->"+encodeObject(_groupTemplates));
}
function groupTemplates(){
    // テンプレートの配列を返す
    return _groupTemplates;
}
function groupTemplateObjectForTitle(title){
    // title に対応するテンプレート・オブジェクトを返す
    for (num in _groupTemplates){
        var obj = _groupTemplates[num];
        if (title == obj.menu)
            return obj;
    }
    return null;
}
function groupTemplateMenus(){
    // テンプレートのメニュー配列を返す
    var array = new Array();
    for (num in _groupTemplates){
        var rec = _groupTemplates[num];
        array.push(rec.menu);
    }
    return array;
}



function addedGroupTemplate(answer){
    // 更新されたメニューを再表示
	NRGetMenu(owner(), _templateTag, setGroupTemplates);
}
function addGroupTemplate(){
	// テンプレート規定値を追加
    var title = window.prompt("この入力値セットのタイトルをつけてください", "");
    if (!title) return;
    
    // メニューに対応するオブジェクトに各欄の値を入れ、それを save する
    var obj = new Object();
    var array = layoutArray(_progress);
    for (num in array){
        var layoutObj = array[num];
        
        // 非表示セルはスキップ
        if (layoutObj.hitAndRun * 1) continue;
        
        var cell = cellFor(currentDate(), layoutObj.tag);
        var value = cell.trimValue;
        
        // 過去が透けて見えるセルは空データとする
        if (cell.isPast) value = "";
        
        if (cell) obj[cell.tag] = value;
    }
    //alert("addGroupTemplate->"+encodeObject(obj)); //##
    
    var val = encodeSTRING(encodeObject(obj));
    NRPutMenu(owner(), _templateTag, title, "", val, addedGroupTemplate);
}

function removedGroupTemplate(answer){
    // 更新されたメニューを再表示
	NRGetMenu(owner(), _templateTag, setGroupTemplates);
}
function removeGroupTemplate(label){
    // label に対応するメニューを削除
    if (confirm("「" + label + "」メニューを削除します")){
        NRRemoveMenu(owner(), _templateTag, label, removedGroupTemplate);
    }
}

function showAfterTemplate(answer){
    // テンプレート処理後のページを再表示
    var obj = JSON.parse(answer);
    var entryDate = currentDate();
    
    //alert("showAfterTemplate->"+encodeObject(obj)); //##
    
    // structure() を新しいページで更新しておく：でないと再表示でおかしな表示が出る
    var rec = new Object();
    var array = layoutArray(_progress);
    for (num in array){
        var layoutObj = array[num];
        var tag = layoutObj.tag;
        
        // 非表示セルはスキップ
        if (layoutObj.hitAndRun * 1) continue;

        var value = obj[tag];
        if (value)
            rec[tag] = setCell(entryDate, tag, value);
    }
    setStructureForDate(rec, entryDate);
    
    // entryDate のページを再表示
    openBasicEditor(entryDate);
}
function selectedGroupTemplate(answer){
    setEditorId(null);
    closeFloatPanel();
    
    var tags = progressTagArray().join(",");
    NRGetPage(owner(),patient_id(),currentDate(), "", tags, showAfterTemplate);
}
function selectGroupTemplate(elm){
    // テンプレート・メニューが選択された
    var title = elm.innerText;
    
    if (title == "...その他"){
        addGroupTemplate();
    } else {
        if (isReadOnly()){
            // readOnly モードなら警告パネルを開くだけで終了
            if (!confirm("過去カルテですが実行していいですか")) return;
        }
        
        // 選択されたテンプレートで各フィールドを上書きする
        var rec = groupTemplateObjectForTitle(title);
        if (rec){
            // 選択されたメニュー内容で各欄を上書きする
            var obj = decodeObject(rec.value);
            
            // 各欄の value 中の '(',')' が表示時 object に展開されないよう encode
            var rec = new Object();
            for (tag in obj){
                var val = obj[tag];
                if (typeof(val) == "object"){
                    val = encodeObject(val); // object を文字列にする
                    val = encodeValue(val); // '(',')' を encode
                }
                rec[tag] = val;
            }
            //alert("selectGroupTemplate->"+encodeObject(rec)); //##
            
            NRPutPage(owner(), patient_id(), currentDate(), timeLimit(), rec, selectedGroupTemplate);
        } else {
            alert(title + " に対応するメニュー・オブジェクトがありません");
        }
    }
}

function openTemplateHelp(){
    var url = "templateHelp.html";
    window.open(url,"Help","width=450,height=700,scrollbars=yes,resizable=yes");
}

function showGroupTemplates(){
    // テンプレート・パネルにメニューを表示
    var obj = groupTemplates();
    var templates = new Array();
    templates = templates.concat(obj);
    var rec = new Object();
    rec.menu = "...その他";
    templates.push(rec);
    
    var elm = document.getElementById("groupTemplateMenuArea");
    if (!elm) return; // Group CELL 編集モードではない場合
    
    elm.innerHTML = "";
    elm.style.padding = "5px 2px 0 5px";
    elm.style.fontSize = "9pt";
    
    var action = "selectGroupTemplate(this)";
    for (num in templates){
        var rec = templates[num];
        var div = newDIV(elm, "/clearfix");
        // --- LEFT ---
        var dv = newDIV(div, "/left-side");
        dv.style.padding = "2px 0px";
        dv.style.width = "80%";
        var bt = newDIV(dv, "/blueButton");
        bt.innerHTML = rec.menu;
        bt.setAttribute("onclick", action);
        // --- RIGHT ---
        var dv = newDIV(div, "/right-side");
        dv.style.padding = "2px 0px";
        if (num < templates.length - 1){
            var img = newIMAGE(dv, "icon", "./remove-field.png", "X");
            var act = "removeGroupTemplate('" + rec.menu + "')";
            img.setAttribute("onclick", act);
        }
    }
}
function showGroupTemplatePanel(button, title, helpAction){
    // テンプレートを各欄に挿入
    var pos = getPosition(button);
    var w = 150;
	var x = pos.x - w + 10; // 表示するx座標
	var y = pos.y; // 表示するy座標
    var elm = openSeeThroughPanel("_floatPanel", x, y, w, title, helpAction);
    var div = newDIV(elm, "groupTemplateMenuArea");
    
    showGroupTemplates();
}

///// GROUP_TEMPLATE ////////////////////////////
/////////////////////////////////////////////////

