
function name(){
    // 医薬品名
    return document.getElementById("_name").value;
}

function upload(){
    // form を submit
    var submitButton = document.getElementById("uploadForm");
    submitButton.submit();
    
    //document.getElementById("loadedMessageArea").innerHTML = "... 指定された画像を読込みました";
    showLoadMessage();
}

///////////////////////////////////////////////
/// Ajax による処理 /////////////////////////////

function gotPriceList(){
	// HTTP 通信の状態が変化したら呼び出される関数
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
		//alert("gotPriceList->"+value);
        
		var ary = value.split("<SEPARATOR>");
		if (ary.length > 1){
            var array = JSON.parse(ary[1]);
            //alert("getRecords->"+encodeObject(array));
            showList(array);
        } else {
            alert("gotPriceList->"+value);
        }
		document.getElementById("_debug").innerHTML = "";
	}
	else
		document.getElementById("_debug").innerHTML = "Loading data ...";
}
function getPriceList(key){
	// PHPサーバへリクエストを送り、データが返送されたら func() で受ける
	xmlHttpObject = createXMLHttpRequest(gotPriceList);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var st = "./priceListServer.php?command=GET_PRICE_LIST&value="+encodeSTRING(key);
		//alert("getPriceList->"+st); //------
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

function putted_PriceList(){
	// サーバから返された処理を実行
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
		//alert("putted_PriceList ===\n"+value);//##
		var array = value.split("<SEPARATOR>");
		if (array.length > 1){
            // memo 更新後のレコードを再表示
            searchPriceList();
            showCompleteMessage();
		}
		hideMessage("_message");
	} else
		showMessage("_message", "サーバで処理中です ...");
}
function put_PriceList(obj){ // globalList.js に putPriceList() あり
	// PriceList に薬剤レコードをマージ
	xmlHttpObject = createXMLHttpRequest(putted_PriceList);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var st = "./priceListServer.php?command=PUT_PRICE_LIST"
		+ "&value=" + encodeSTRING(encodeObject(obj));
		//alert(st); //return; //===
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

/// Ajax による処理 /////////////////////////////
///////////////////////////////////////////////

function showCompleteMessage(){
    // 画像のリンクが完了したメッセージを表示
    var dt = document.getElementById("completeMessageArea");
    dt.innerHTML = "";
    dt.innerHTML = "処方ツールに「" + name() + "」の添付書類が登録されました";
    var dd = newDD(dt, "");
    dd.innerHTML = "「処方ツール」を再読込後、そこで「" + name() + "」の <img src='info.png' style='height:18px;position:relative;top:3px'> をクリックしてみてください";
    dd.style.paddingLeft = "5px";
    dd.style.backgroundColor = "#ff0";
}

function showLoadMessage(){
    // 画像の読込が終了したメッセージを表示
    var dt = document.getElementById("linMessageArea");
    dt.innerHTML = "PriceList に画像とのリンクを登録";
    var dd = newDD(dt, "");
    var sp = newSPAN(dd, "");
    sp.innerHTML = "保存した添付書類画像を どの医薬品にリンクするかを決定します<br>";
    var fd = newFIELD(dd, "nameF", "医薬品名", 30, name());
    var bt = newBUTTON(dd, "", "検索");
    bt.setAttribute("onclick","searchPriceList()");
    var div = newDIV(dd, "resultsArea");
}

var _records;
function selectedTarget(num){
    var rec = _records[num];
    var memo = rec.memo;
    var imageId = document.getElementById("imageId").value;
    var url = "URL:" + imageId + ".pdf";
    
    if (memo.length > 0){
        if (memo.indexOf(url) == 0){
            alert(url + " はすでに登録されています");
            showCompleteMessage();
            return;
        } else {
            memo = "";
        }
    }
    
    // memo の先頭に URL を登録
    if (confirm("選択されたレコードに画像のリンクとして「" + url + "」を登録します")){
        rec.memo = url + " " + memo;
        put_PriceList(rec);
    }
}
function showList(array){
    // 検索にヒットした医薬品名をリスト・アップ
    _records = array;
    
    var elm = document.getElementById("resultsArea");
    elm.innerHTML = "";
    var tbl = newTABLE(elm, "base-table");

    // TITLE
    var tr = newTR(tbl, "yellow-bar", "");
    var td = newTD(tr, "", "code");
    var td = newTD(tr, "", "name");
    var td = newTD(tr, "", "alias");
    var td = newTD(tr, "", "memo");

    for (num in array){
        var rec = array[num];
        var tr = newTR(tbl, "/list-bar", "");
        tr.setAttribute("onclick","selectedTarget('" + num + "')");
        var td = newTD(tr, "", rec.code);
        var td = newTD(tr, "", rec.name);
        var td = newTD(tr, "", rec.alias);
        var td = newTD(tr, "", rec.memo);
    }
}

function searchPriceList(){
    var name = document.getElementById("nameF").value;
    getPriceList(name);
}

function makeFORM(elm){
    // === FORM を生成 =============================
    var fm = newFORM(elm, "pictServer.php"); // submit で起動される URL
    fm.setAttribute("id", "uploadForm");
    // ### iframe を使うにはここがキモ ###
    fm.setAttribute("target", "iframeElement"); // iframe を指定
    
    // === ファイル選択ボタン ========================
    var dv = newDIV(fm, "file");
    var bt = newUploadBUTTON(dv, "imageFile", "files[]");

    // === 転送データのコンテナー =====================
    // key
    var fd = newFIELD(fm, "key", "", "", "SAVE_IMAGE");
    fd.setAttribute("NAME", "key"); // form で送られるパラメータ
    fd.setAttribute("type", "hidden");
    // imageId
    var fd = newFIELD(fm, "imageId", "サーバへ保存するファイル名", 50, name());
    fd.setAttribute("NAME", "imageId"); // form で送られるパラメータ
    // fd.setAttribute("type", "hidden");
    
    // === アップロード・ボタン =======================
    // ### iframe を使うにはここがキモ ###
    // form を見せない形で処理するため submit-button 機能を別に作成
    var dv = newDIV(elm, "/clearfix");
    var bt = newDIV(dv, "/whiteButton");
    bt.innerHTML = "画像読込み";
    bt.setAttribute("onclick", "upload()");
    //var dv = newDIV(dv, "loadedMessageArea");
}

function initManTool(){
    // マニュアル取込ツールを開く
	var base = document.getElementById("base");
    base.innerHTML = "";
    
    // HEADER ===========================
    var div = newDIV(base, "title-bar");
    div.innerHTML = "添付文書の取込み"
    
    var div = newDIV(base, "/manToolComment");
    div.innerHTML = "処方ツールの「" + name() + "」に添付書類を組込みます<br>";
    div.innerHTML += "以下の順序に従い作業を進めてください";
    
    var dl = newDL(base, "");
    
    // 該当する薬剤を検索しダウンロード ===================
    var dt = newDT(dl, "");
    dt.innerHTML = "検索サイトから添付文書をダウンロード";
    var dd = newDD(dt, "");
    var a = newA(dd, "医薬品検索サイト", "http://database.japic.or.jp/ctrl/attDocsForm?targetDB=2&x=89&y=11", "_blank");
    var sp = newSPAN(dd, "");
    sp.innerHTML = " から ";
    var sp = newSPAN(dd, "");
    sp.innerHTML = name();
    sp.style.fontWeight = "bold";
    sp.style.fontFamily = "arial, Helvetica";
    sp.style.color = "#000";
    var sp = newSPAN(dd, "");
    sp.innerHTML = " を検索し添付文書の PDF をダウンロードしてください";
    var sp = newSPAN(dd, "");
    sp.innerHTML = "（ヒットしない場合は、単位などを省略し検索してみてください。";
    sp.innerHTML += "また「医薬品」のラジオボタンにチェックを入れてみてください）";
    
    // ダウンロードした PDF を保存 ======================
    var dt = newDT(dl, "");
    dt.innerHTML = "ダウンロードした PDF を一時保存";
    var dd = newDD(dt, "");
    var sp = newSPAN(dd, "");
    sp.innerHTML = "ダウンロードした PDF を適当なところへ一時的に保存してください<br>";
    sp.innerHTML += "この一時保存したファイルを次のステップの「ファイル選択」で選択します";
    
    // PDF にファイル名をつけ所定のフォルダーへ保存 =========
    var dt = newDT(dl, "");
    dt.innerHTML = "ダウンロードした PDF を所定のフォルダーへ保存";
    var dd = newDD(dt, "");
    makeFORM(dd);
    
    // データ戻り先として iframe を作成 
    // ### iframe を使うにはここがキモ ###
    var dv = newDIV(dd, "");
    dv.style.display = "none"; // 表示しない
    var fr = newIFRAME(dv, "iframeElement");

    // PriceList に URL を記載 ========================
    var dt = newDT(dl, "linMessageArea");
    //showLoadMessage(); //##
    var div = newDIV(dl, "resultsArea");
    
    // 画像リンクの終了メッセージ ========================
    var dt = newDT(dl, "completeMessageArea");
    //showCompleteMessage(); //##

    // FOOTER ===========================
    var div = newDIV(base, "title-bar");
    div.innerHTML = "Update: 2013-06-19";
}

function version(){
    return "Ver.130619";
}