
/////////////////////////
///// カルテからの継承値 ///

function patientId(){
    return (parent()) ? parent().patientId() : null;
}

function patientName(){
    return (parent()) ? parent().patientKanjiName() : null;
}

///// カルテからの継承値 ///
/////////////////////////

///////////////////////////////////
/// localStorage による処理 /////////

var _largeSize = 250;
var _middleSize = 80;
var _smallSize = 30;

function setThumbnailSize(elm){
    // サムネイル・サイズを変更
    if (elm.value == "大")
        window.localStorage["pictureThumbNailSize"] = _largeSize;
    else if (elm.value == "中")
        window.localStorage["pictureThumbNailSize"] = _middleSize;
    else
        window.localStorage["pictureThumbNailSize"] = _smallSize;
    
    // サムネイルを再表示
    getImages();
}

function thumbNailSize(){
    // サムネイル・サイズを返す
    var size = window.localStorage["pictureThumbNailSize"];
    return (size) ? size : _middleSize;
}

function thumbNailSizeName(){
    // サムネイル・サイズの名前を返す
    var size = thumbNailSize() * 1;
    switch(size){
        case _largeSize: return "大";
        case _smallSize: return "小";
        default: return "中";
    }
}

function getWindowSize(){
	// Picture tool のウインドー位置とサイズをサーバへリクエスト
    var size = window.localStorage["pictureToolWindowSize"];
    
	// サーバから得られたサイズにウインドーを調整する
	if (size){
		var args = size.split(",");
		var x = args[0] * 1;
		var y = args[1];
		var w = args[2];
		var h = args[3];
		// resize を先にしておかないと元が大きいサイズだった場合 moveTo しよう
		// としてもウインドー境界の制限で移動できない場合がある
		window.resizeTo(w, h);
		window.moveTo(x, y);
        
        //alert("getWindowSize->"+size); //##
	}
}
function putWindowSize(){
	// Picture tool のウインドー位置とサイズをサーバへ記憶
    if (window.name != "tools"){
        // tool area で開いた場合はサイズを記憶しない
        var x = window.screenLeft;
        var y = window.screenTop - 22;
        var w = window.outerWidth;
        var h = window.outerHeight;
        var array = [x, y, w, h];
        window.localStorage["pictureToolWindowSize"] = array.join(",");
        
        showFadeoutInfo("messageArea", "ウィンドー・サイズを記憶しました", 800);
    }
}

/// localStorage による処理 /////////
///////////////////////////////////



///////////////////////////
/// Ajax による処理 /////////

function gotImages(){
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
		//alert("gotImages ===\n"+value);//##
        
		var array = value.split("<SEPARATOR>");
		if (array.length > 1){
            var obj = JSON.parse(array[1]);
            
            showIconsVertical(obj.path, obj.files);
        }
		hideMessage("_message");
	} else
		showMessage("_message", "サーバで処理中です ...");
}
function getImages(){
    // 画像ファイルのリストをサーバへリクエスト
	xmlHttpObject = createXMLHttpRequest(gotImages);
	if (xmlHttpObject){
        // encodeURI は '&' をエンコードしてくれないのでこちら側でエンコード
        // ### send() に与える文字列:st 全体をエンコードしては駄目 ###
        var st = "key=GET_DIRECTORY";
        st += "&container=" + patientId();
        
        xmlHttpObject.open("POST", "pictServer.php", true);
        xmlHttpObject.setRequestHeader('Content-Type','application/x-www-form-urlencoded; charset=UTF-8');
		//alert("getImages ====\n"+st); //##
        xmlHttpObject.send(st);
	}
}

function removeImage(path, filename){
    // filename を削除
    if (! confirm(filename + "　の画像を削除します")){
        return;
    }
    
	xmlHttpObject = createXMLHttpRequest(gotImages);
	if (xmlHttpObject){
        // encodeURI は '&' をエンコードしてくれないのでこちら側でエンコード
        // ### send() に与える文字列:st 全体をエンコードしては駄目 ###
        var st = "key=REMOVE_IMAGE";
        st += "&container=" + patientId();
        st += "&value=" + path + "/" + filename;
        
        xmlHttpObject.open("POST", "pictServer.php", true);
        xmlHttpObject.setRequestHeader('Content-Type','application/x-www-form-urlencoded; charset=UTF-8');
		//alert("removeImage ====\n"+st); //##
        xmlHttpObject.send(st);
	}
}

/// Ajax による処理 /////////
///////////////////////////


function showIconsVertical(path, files){
	// 添付ファイルをサムネールとして縦横表示
	var div = document.getElementById("thumbNailGallery");
	div.innerHTML = "";
    var ul = newUL(div, "");
    ul.style.margin = "0";
    ul.style.paddingLeft = "8px";
	
	// image ファイル名の配列を生成
	//var path = "/NOA_ARCHIVE/"+patientId()+"/";
	var filename;
	for (num in files){
		filename = files[num];
		if (filename.charAt(0) == ".") continue;

        // image のクリックで別パネルに image 表示
        makeImagePane(ul, path, filename);
	}
}

/*
////////////////////////////////////////////////////////
///// DRAG and DROP ////////////////////////////////////

function f_dragover(event){
    // ドラッグ要素がドロップ要素に重なっている間の処理
    //　dragoverイベントをキャンセルして、ドロップ先の要素がドロップを受け付けるようにする
    event.preventDefault();
}

function f_dragstart(event, value){
    // ドラッグ開始時の処理
    
    // ドラッグするデータのid名をDataTransferオブジェクトにセット
//    event.dataTransfer.setData("text", value);
}

///// DRAG and DROP ////////////////////////////////////
////////////////////////////////////////////////////////
*/

function open_image(url){
    // 本文中の Image をクリックした時に呼ばれる
	var win = window.open("imageViewer.php?value=" + url, "ImageViewer"
                          ,"width=1700,height=1700,scrollbars=yes,resizable=yes");
	win.focus();
}

function makeImagePane(ul, path, file){
    // path からイメージを生成し elm へ表示
    var url = path + "/" + file;
    var sfx = suffix(file);
    var height = thumbNailSize();
    
    if ((sfx == "pdf") || (sfx == "PDF")){
        var img = "<IMG SRC=pdf.jpg HEIGHT=" + height + ">";
    } else if (isImageFile(url)){
        var img = "<IMG SRC="+url+" HEIGHT=" + height + ">";
    } else if (isMovieFile(url)){
        var img = "<IMG SRC=movie.jpg HEIGHT=" + height + ">";
    } else if (sfx == "zip"){
        var img = "<IMG SRC=zip.png HEIGHT=" + height + ">";
    } else if (sfx == "txt"){
        var img = "<IMG SRC=text.png HEIGHT=" + height + ">";
    } else {
        var img = "<IMG SRC=file.png HEIGHT=" + height + ">";
    }
    
    // === サムネイルを表示 ========================
    var div = newDIV(ul, "");
    var sp = newSPAN(div, "");
    sp.innerHTML = img;
    // url = "../NOA_ARCHIVE/03234200/20130527185022_0.png" 形式
    sp.setAttribute("onclick", "open_image('"+url+"')");
    if (pictureExpand())
        sp.setAttribute("class", "thumb-nail"); // マウスがのると画像が拡大
    // カルテに埋め込むためのタグを生成
    //var path = "/NOA_ARCHIVE/"+patientId()+"/";
    var tag = "<IMG:" + url + ">";
    sp.addEventListener("dragstart",
                        function(ev) {
                        var dt = ev.dataTransfer;
                        dt.setData("text/plain", tag);
                        return true;
                        },
                        false);

    // === 画像削除アイコンとファイル名を表示 ==========
    if (height * 1 > 90){
        var dv = newDIV(div, "");
        var sp = newSPAN(dv, "");
        sp.style.paddingLeft = "5px";
    } else { // サムネイルが小さい場合はファイル名を同じ行に表示
        var dv = div;
        var sp = newSPAN(div, "");
        sp.style.paddingLeft = "5px";
    }
    // ファイル名
    var sp = newSPAN(dv, "");
    sp.innerHTML = file;
    sp.style.margin = "0 5px";
    sp.style.fontSize = "9pt";

    // イメージを削除ボタン
    var img = newIMAGE(dv, "", "./remove-field.png", "");
    img.setAttribute("onclick", "removeImage('"+path +"','"+file+"')");
    img.style.height = "12px";
    img.style.position = "relative";
    img.style.bottom = "-3px";
}

function showContents(url){
	// url 内容を別ウインドーに表示
	var sfx = suffix(url);
	if (sfx == "zip"){
		if (!confirm("この圧縮ファイルを、ダウンロード・フォルダーへ解凍しますか")) return;
    }

	window.open(url, url, "width=600,height=600");
}

function file_append(){
	// ファイル選択ボタンを増やす
	var dv = document.getElementById("file");
	var ub = newUploadBUTTON(dv, "", "files[]");
	newBR(dv);
}

function upload(){
    // form を submit
    var submitButton = document.getElementById("uploadForm");
    submitButton.submit();
    
    putWindowSize(); // ウインドー・サイズを記憶
    
    setTimeout(getImages, 3000);
}

function pictureHelp(){
    // ヘルプを開く
	window.open("./pictureHelp.html","Help"
				,"width=450,height=700,scrollbars=yes,resizable=yes");
}

function closePicture(){
	var elm = document.getElementById("base");
	elm.innerHTML = "";
}

function submitFileSelectButton(){
    // ファイル選択ボタンを押す：call() から使うためのメソッド
    if (window.File && window.FileReader && window.FileList && window.Blob) {
        // Great success! All the File APIs are supported.
    } else {
        alert('このブラウザーでは File API のサポートが不十分です');
    }

    var bt = elmFor("imageFile");
    alert("submitFileSelectButton->"+bt); //##
    
    bt.click();
}

/////////////////////////////////////////////////////
///// dragAndDrop ///////////////////////////////////

var _image;
function setImage(img){
    _image = img;
}
function image(){
    return _image;
}

var _imageName;
function setImageName(name){
    _imageName = name;
}
function imageName(){
    return _imageName;
}

function FileDrop(e, can){
    // el にドロップされた画像を描画
    var file = e.dataTransfer.files[0];
    if (!file) {
        alert('画像ファイルの実体がないのでドロップできません');
        return; // file の実体がないとドロップできない
    }
    
    if(!file.type.match(/image\/\w+/)){
        alert('画像ファイルしか受けつけられません');
        return;
    }
    
    setImageName(file.name);
    
    var img = document.createElement("img");
    var reader = new FileReader(); 
    reader.onload = function(e) {
        img.src = e.target.result;
    }
    setImage(img);
    
    // canvas へ描画
    img.onload = function() {
        _scale = 1;
        _rotation = 0;
        _imageX = 0;
        _imageY = 0;
        clearDraw();
        
        var ctx = can.getContext("2d");
        
        // クリッピング領域で表示
        ctx.beginPath();
        ctx.moveTo(0,0);
        ctx.lineTo(clipWidth(), 0);
        ctx.lineTo(clipWidth(), clipHeight());
        ctx.lineTo(0, clipHeight());
        ctx.clip();
        
        ctx.drawImage(img, 0, 0);  
        
        // クリップ領域を青い枠で囲む
        drawFrame();
    }
    
    reader.readAsDataURL(file);
    
    // 画像アップロード用コントロール・エリアを開く
//    showSlider("newImage");
}
function clearDraw(){
    // イメージ画面をクリアー
    var can = canvas();
    var context = can.getContext("2d");
    context.clearRect(0, 0, can.width, can.height);
    
    return true;
}

///// dragAndDrop ///////////////////////////////////
/////////////////////////////////////////////////////

function changedPictureExpand(elm){
    // マウスで画像拡大チェック・ボックスが変更された
    setPictureExpand(elm); // localStorage.js
    window.location.reload(true);
}
function openCellPreference(){
    // 初期設定ペーンを表示
    var elm = elmFor("workArea");
    if (elm.innerHTML.length){
        elm.innerHTML = "";
        return;
    }
    elm.innerHTML = "";
    
    // === チェック・ボックス ======================
    var div = newDIV(elm, "");
    div.style.fontSize = "10pt";
    div.style.padding = "10px";
    var cb = newCHECKBOX(div, "expandCheckBox", "マウスで画像拡大", pictureExpand());
    cb.setAttribute("onchange", "changedPictureExpand(this)");
    
}

function handleDragOver(evt){
    // 画像がドラッグされた時に呼ばれる
    evt.stopPropagation();
    evt.preventDefault();
    evt.dataTransfer.dropEffect = 'copy'; // Explicitly show this is a copy.
}
function handleFileSelect(evt){
    // 画像がドラッグされた時に呼ばれる
    evt.stopPropagation();
    evt.preventDefault();
    
    var files = evt.dataTransfer.files; // FileList object.
    
    // files is a FileList of File objects. List some properties.
    var output = [];
    for (var i = 0, f; f = files[i]; i++) {
        output.push('<li><strong>', escape(f.name), '</strong> (', f.type || 'n/a', ') - ',
                    f.size, ' bytes, last modified: ',
                    f.lastModifiedDate.toLocaleDateString(), '</li>');
    }
    document.getElementById('list').innerHTML = '<ul>' + output.join('') + '</ul>';
}
function initPicture(){
	// テンプレートで FRONT のヘッダー部分を生成
    _initDebug(false); //##
    _debug("== initPicture =="); //##
    
	var elm = document.getElementById("base");
	elm.innerHTML = "";

    var div = newDIV(elm, "messageArea");
    div.style.fontSize = "9pt";

    // ===== HEADER ===================
    var div = newDIV(elm, "/tool-header");
    // === LEFT SIDE ===
    var dv = newDIV(div, "/left-side");
	dv.style.position = "/relative";
	dv.style.top = "4px";
	// カルテID・氏名
    var pid = "";
    var name = "";
    if (patientId()){
        pid = patientId();
        name = patientName();
    }
    var sp = newSPAN(dv, "patientIdArea");
    sp.innerHTML = pid;
    sp.style.paddingRight = "5px";
    var sp = newSPAN(dv, "");
    sp.innerHTML = name;
    // === RIGHT SIDE ===
    var dv = newDIV(div, "/right-side");
    // --- サムネイル・サイズ変更
    var sp = newSPAN(dv, "");
    sp.style.fontSize = "9pt";
    sp.innerHTML = "サムネイル";
    var sp = newSPAN(dv, "");
    sp.style.paddingRIght = "5px";
    var array = ["大","中","小"];
    var pm = newPopupMenu(sp, "", array, thumbNailSizeName());
    pm.setAttribute("onchange", "setThumbnailSize(this)");
    pm.style.position = "relative";
    pm.style.bottom = "2px";
	// --- ヘルプ・アイコン
	var im = newIMAGE(dv, "helpB", "./help.png", "?");
	im.setAttribute("onclick", "pictureHelp()");
	im.style.height = "18px";
	im.style.marginLeft = "5px";
	im.style.position = "relative";
	im.style.top = "4px";
    
    // ===== 画像ファイルをアップロード =========
    var div = newDIV(elm, "formArea");
    if (patientId()){
        var dv = newDIV(div, "");
        _debug("dv->"+dv); //##
        
        // === FORM を生成 =============================
        var fm = newFORM(dv, "pictServer.php"); // submit で起動される URL
        fm.setAttribute("id", "uploadForm");
        fm.setAttribute("name", "formForUpload"); // submit に必要
        // ### iframe を使うにはここがキモ ###
        fm.setAttribute("target", "iframeElement"); // iframe を指定
        
        // === ファイル選択ボタン ========================
        var dv = newDIV(fm, "file");
        var bt = newUploadBUTTON(dv, "imageFile", "files[]");
        // more FILES
        var dv = newDIV(fm, "");
        dv.style.fontSize = "9pt";
        var a = newA(dv, "ファイルをもうひとつ選択", "#", "");
        a.setAttribute("onclick", "file_append()");
        a.style.fontSize = "9pt";

        // === 転送データのコンテナー =====================
        var filename = todayAndTimeId();
        // key
        var fd = newFIELD(fm, "key", "", "", "SAVE_IMAGE");
        fd.setAttribute("NAME", "key"); // form で送られるパラメータ
        fd.setAttribute("type", "hidden");
        // patientId
        var fd = newFIELD(fm, "container", "", "", patientId());
        fd.setAttribute("NAME", "container"); // form で送られるパラメータ
        fd.setAttribute("type", "hidden");
        // imageId
        var fd = newFIELD(fm, "imageId", "", "", filename);
        fd.setAttribute("NAME", "imageId"); // form で送られるパラメータ
        fd.setAttribute("type", "hidden");
        
        // === アップロード・ボタン =======================
        // ### iframe を使うにはここがキモ ###
        // form を見せない形で処理するため submit-button 機能を別に作成
        var dv = newDIV(div, "");
        var bt = newDIV(dv, "/whiteButton");
        bt.innerHTML = "画像読込み";
        bt.setAttribute("onclick", "upload()");
        
        // === データ戻り先として iframe を作成 ===========
        // ### iframe を使うにはここがキモ ###
        var dv = newDIV(div, "");
		dv.style.display = "none"; // 表示しない
        var fr = newIFRAME(dv, "iframeElement");
    } else {
        var dv = newDIV(elm, "");
        dv.innerHTML = "カルテを開いてからやり直してください";
        dv.style.color = "#b86125";
        dv.style.fontSize = "9pt";
        dv.style.paddingLeft = "10px";
        return;
    }

    if (window.File && window.FileReader && window.FileList && window.Blob) {
        /*
        // Great success! All the File APIs are supported.
        // === 画像をドロップするエリア =================
        var div = newDIV(elm, "");
        var width = 150;
        var height = 150;
        
        // ### dragAndDrop ################
        var can = newCANVAS(div, "myCanvas", width, height, null);
        can.style.border = "thin solid #ccc";
        can.style.margin = "0 10px";
        cv.ondrop=function(e){
            FileDrop(e, cv);
            e.preventDefault();
        };
        
        cv.ondragover=function(e){
            e.preventDefault();
        };
        // ### dragAndDrop ################

        // encodeURI は '&' をエンコードしてくれないのでこちら側でエンコード
        var ctx = can.getContext("2d");
        var imgData = ctx.getImageData(0,0,width,height);
        
        // クリッピングした画像を一時置きする canvas を生成
        var elm = document.getElementById("_tmp");
        elm.innerHTML = "";
        var tmpCan = newCANVAS(elm,"",width,height,null);
        var ctx2 = tmpCan.getContext("2d");
        ctx2.putImageData(imgData, 0, 0);
        
        var imageSrc = tmpCan.toDataURL();
        imageSrc = imageSrc.replace('data:image/png;base64,',''); // 頭の不要部分を削除
        
//        NRPutInsImage(patientId(), filename, imageSrc, savedData);
         */
    } else {
        alert('このブラウザーでは File API のサポートが不十分です');
    }

    // === 画像表示：ギャラリーを生成 ===============
    var div = newDIV(elm, "thumbNailGallery");
    
    // FOOTER ===================================
    var div = newDIV(elm, "/tool-footer");
    div.style.marginTop = "5px";
    var dv = newDIV(div, "/left-side");
    dv.style.width = "60%";
    var img = newIMAGE(dv, "", "./hammer.png", "X");
    img.style.height = "15px";
    img.setAttribute("onclick", "openCellPreference()");
    img.setAttribute("class", "expandIcon");
    var dv = newDIV(div, "/right-side");
    var sp = newSPAN(dv, "/versionArea");
    sp.innerHTML = version();

    getWindowSize();
    
    // 画像ギャラリーを表示
    getImages();
}

function version(){
	return "Ver.131111";
}


