

/////////////////////////
///// カルテからの継承値 ///

function owner(){
    return parent().owner();
}

function labelTagValue(){
    // NOA の全 CELL のレイアウトを得る：全ラベル名を得るため
    var array = parent().layoutForMode(_progress_);
    array = array.concat(parent().layoutForMode(_basic_));
    array = array.concat(parent().layoutForMode(_ins_));
    
    var items = new Array();
    for (num in array){
        var rec = array[num];
        if (!rec) continue;
        
        //_debug(rec.label+"->"+rec.tag); //##
        
        items[rec.label] = rec.tag;
    }

    return items;
}

///// カルテからの継承値 ///
/////////////////////////


var _fieldName;
function setTagetField(fieldName){
	// calendar ツールを呼ぶ前に対象フィールドを記憶しておく
	_fieldName = fieldName;
}
function fieldname(){
	return _fieldName;
}

var _tagName;
function setTagName(tag){
	// 検索対象の tag を記憶しておく
	_tagName = tag;
}
function tagName(){
	return _tagName;
}

var _labelTable;
function setLabelTable(array){
	_labelTable = array;
}
function labelTable(){
	// array[label] = tag 形式の配列を返す
	return _labelTable;
}
function tagForLabel(label){
	// label に対する tag を返す
	return _labelTable[label];
}




////////////////////////////////
/// neuron.js による処理 /////////

var _targetY;
var _targetPid;
var _targetName;
var _targetDate;
function showInfo(answer){
	// 検索結果詳細を表示
	var obj = JSON.parse(answer);
	// objct: "{'table.field':{'entryDate':'','owner':'','value':''},,,}"
	
	showInfoPanel(_targetY, obj);
}
function getInfo(elm, pid, name, date, tag){
	// pid, date の情報をサーバへリクエスト
	var pos = getPosition(elm);
	var h =  elm.offsetHeight;
    //	_targetY = pos.y; // クリックされた行の位置を記憶
	_targetY = pos.y + h; // クリックされた行の位置を記憶
	_targetPid = pid; 
	_targetName = name;
    _targetDate = date;

    NRGetValueAPI(owner(), pid, date, "", tag, showInfo);
}

function found(answer){
	// 検索結果を表示
	var obj = JSON.parse(answer);
    
	showResults(obj);
}
function find(){
	// 検索を実行
    //_initDebug(true); //##
    _debug("== find"); //##
    
	var label = elmFor("labelName").value;
	var tag = tagForLabel(label);
    var pid = ""; // 不要
	var key = document.getElementById("key").value;
	var from = document.getElementById("from").value;
	var to = document.getElementById("to").value;
    
    _debug(tag+"/"+key+"/"+from+".."+to); //##
    
    // listMaker へ渡す情報を localStorage に記憶
    var st = "条件検索（ ";
    st += from + " から " + to + " までの期間で ";
    st += label + " に " + key + " を含む検索結果 ）";
    setListMakerHeader(st);

    // window size を記憶
    putFinderWindowSize();
    
	setTagName(tag); // 検索対象 tag を記憶
	NRFind(tag, pid, key, from, to, "on", found);
}

/// neuron.js による処理 /////////
////////////////////////////////

function showInfoPanel(cursorY, obj){
	// 検査結果詳細情報を表示
	// header
	var pid = _targetPid;
	var name = _targetName;
	var date = _targetDate;
	var label = window.document.getElementById("labelName").value;
	var tag = window.tagForLabel(label);
	var buff = obj[tag].value;
	
	// 保険情報の確認パネルを生成
	var elm = document.getElementById("_confirm");
	elm.innerHTML = "";
	var tbl = newTABLE(elm, "");
	tbl.style.fontSize = "10pt";
	
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "", "カルテ");
	var td = newTD(tr, "", pid + " " + name);
	
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "", "受診日");
	var td = newTD(tr, "", date);
	
	// ドキュメント表示エリア
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "", "");
	td.setAttribute("colspan","2");
	td.style.padding = "2px 5px";
	var hr = newHR(td);
	var array = buff.split("\n");
    for (num in array){
		var dv = newDIV(td, "");
		var tx = newTEXT(dv, array[num]);
	}
	
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "", "");
	td.style.textAlign = "right";
	td.setAttribute("colspan","2");
	var hr = newHR(td);
	var bt = newBUTTON(td, "", "このカルテを開く");
	var action = "parent().openChart('"+pid+"')";
	bt.setAttribute("onclick", action);
	var buff = elm.innerHTML;
	
	openFloatPanel(tbl, 5, cursorY, "データ確認パネル", "fixed");
}

function patientIdClicked(patientId){
	// カルテを開く
    parent().openChart(patientId);
}

function showResults(obj){
	// JSON obj を元に結果を表示
	// $rec[entryDate] = { 'patientId' = $pid, 'value' = $value } 形式で返す
    //alert("showResults->"+encodeObject(obj)); //##
    
	var isMultiPatient = true;
	
	var elm = parent().elmFor("workArea");
	elm.innerHTML = "";
    
	var tbl = newTABLE(elm, "/base-table");
	tbl.style.fontSize = "9pt"; // Firefox では CSS に書いても反映されない
	tbl.style.margin = "2px";
	
	// header
	var tr = newTR(tbl, "resultHeader", "");
    tr.style.background = "#eee";
	var td = newTD(tr, "dateHeader", "");
    var im = newIMAGE(td, "icon", "./close.png", "?");
    im.style.height = "12px";
    im.setAttribute("onclick", "closeWorkArea()");
    im.setAttribute("class", "expandIcon");
    var sp = newSPAN(td, "");
    sp.innerHTML = "受診日";
    sp.style.paddingLeft = "5px";
	if (isMultiPatient){
		var td = newTD(tr, "", "カルテID");
		var td = newTD(tr, "", "氏名");
	}
	var td = newTD(tr, "", "検索結果");
	
	// results
    var srcObj = new Object();
	var key = document.getElementById("key").value;
	var num=0;
	for (datetimeAndNum in obj){
		// datetimeAndNum には、同じ entryDate の患者を区別するための枝番号がついている
		// datetimeAndNum:"2009-03-10 10:44:00 8"
		var rec = obj[datetimeAndNum];
		var entryDate = datetimeAndNum.substr(0, 19);
		
		// 時刻を削除し日付のみ取り出す
		var array = datetimeAndNum.split(" ");
		var date = array[0];
		var dateTime = array[0] + " " + array[1];
		var pid = rec['patientId'];
		var name = (rec['name']) ? rec['name'] : "";
        
        srcObj[pid] = dateTime;
		
		// 検索キーに一致した部分以後一定の長さを取り出す
		var val = rec['value'];
		var pos = val.indexOf(key);
		val = val.substr(pos, 30);
		val = transferToCR(val);
		
		var tr = newTR(tbl, "", "");
		// 受診日
		var td = newTD(tr, "date", date);
		
		if (isMultiPatient){
			// カルテID
			var td = newTD(tr, "patientId/row", pid);
			var action = "parent().openChart('" + pid + "')";
			td.setAttribute("onclick", action);
			
			// 氏名
			var td = newTD(tr, "name", name);
		}
        
		// 検索結果
		var td = newTD(tr, "data/row", val);
		var action = "getInfo(this,'"+pid+"','"+name+"','"+entryDate+"','"+tagName()+"')";
		td.setAttribute("onclick", action);
		num++;
	}
	
    // listMaker へ渡す情報を localStorage に記憶
    setListMakerSrc(srcObj); 
    
	// 検索件数表示
	var tr = newTR(tbl, "", "");
    tr.style.background = "#eee";
	var td = newTD(tr, "buttonArea", "");
	td.style.fontSize = "10pt"; // Firefox では CSS に書いても反映されない
	td.setAttribute("colspan", "4");
    // listMaker を立ち上げるボタンを生成
    var img = newIMAGE(td, "outArrow", "./outArrow.png", "?");
    img.style.height = "14px";
    img.style.marginLeft = "5px";
    img.setAttribute("onclick", "openListMaker()");
    img.setAttribute("class", "expandIcon");
    //setInfoTip("outArrow", "検索結果を別パネルで詳細表示"); // INFO
    var sp = newSPAN(td, "");
    sp.innerHTML = num + " 件 みつかりました";
    sp.style.padding = "0 5px";
}

function tagMenuItems(){
	// array[ラベル名]=タグ名 の配列を返す
	var menuItems = new Array();
	var labelTable = new Array();
	var obj = labelTagValue();
    _debug("tagMenuItems: obj->"+obj); //##
    
	for (label in obj){
		if (label.length > 0){
			var tag = obj[label];
			menuItems.push(label);
			labelTable[label] = tag;
		}
	}
	setLabelTable(labelTable);
	return menuItems;
}

function showAnotherPanel(){
    // 別ウインドーに表示する
	window.open("./chartFinder.php","chartFinder"
				,"width=450,height=700,scrollbars=yes,resizable=yes");
}

function makeChartFinder(){
    // 条件検索画面を生成
    var elm = elmFor("chartFinderArea");
    elm.innerHTML = "";
    elm.style.marginBottom = "10px";
    elm.style.fontSize = "9pt";
    
    // 検索範囲
    var date = today(); // lib.js
    var array = date.split("-");
    var yy = array[0] * 1;
    var mm = array[1] * 1;
    var dd = array[2] * 1;
    
    var div = newDIV(elm, "");
    var label = nengou(yy-1); // 西暦に相当する年号
    newDatePopUp(div, "from", label, yy, 1, 1, false);
    var tx = newTEXT(div, "から");
    
    var div = newDIV(elm, "");
    var label = nengou(yy); // 西暦に相当する年号
    newDatePopUp(div, "to", label, yy, mm, dd, false);
    var tx = newTEXT(div, "まで");

    // tag
    var div = newDIV(elm, "");
    var tagItems = tagMenuItems();
    var pu = newPopupMenu(div, "labelName", tagItems, "主訴");
    var sp = newSPAN(div, "");
    sp.innerHTML = "欄に以下を含むものを";
    sp.style.paddingLeft = "5px";

    // 検索キー
    var div = newDIV(elm, "");
    div.style.marginTop = "2px";
    var fd = newFIELD(div, "key", "", 20, "");
    fd.setAttribute("onchange", "find()");
    fd.setAttribute("class", "searchField");
    fd.focus();
    // 検索ボタン
    var bt = newSPAN(div, "/searchButton");
    bt.innerHTML = "検索";
    bt.setAttribute("onclick", "find()");
}

function initChartFinder(){
    //_initDebug(true); //##
    
	var elm = document.getElementById("base");
    
    // === HEADER ==================
	var div = newDIV(elm, "/tool-header");
    // --- LEFT SIDE ---------------
    dv = newDIV(div, "/left-side");
    dv.innerHTML = "検索";
    dv.style.width = "20%";
    // --- RIGHT SIDE --------------
    if (window.name == "tools"){
        // 別ウインドーで開くアイコン
        dv = newDIV(div, "/right-side");
        dv.style.width = "60%";
        var img = newIMAGE(dv, "outArrowIcon", "outArrow.png", "out");
        img.setAttribute("onclick", "showAnotherPanel()");
        img.style.height = "15px";
        img.style.position = "relative";
        img.style.top = "2px";
        setInfoTip("outArrowIcon", "別ウインドーで開く"); // HELP
    }
    
    // === CONTENTS ================
	var div = newDIV(elm, "");
    div.style.padding = "10px 10px";
    
	var dv = newDIV(div, "chartFinderArea");

    // === FOOTER ==================
	var div = newDIV(elm, "/tool-footer");
    div.style.paddingLeft = "10px";
    div.innerHTML = version();    
    
    makeChartFinder();
}

function version(){
	return "Ver.1301111";
}

