
var _PATH = "/NOA/";
//var _PATH = "/X/NOA/";

// neuron.js は NOAシステム ３層構造の中間であるロジック層を形成
// dataCenter.js は色々なパラメータを記憶しておくクラス
// 基本的にすべて DB への依頼は neuron.js を通じて行われる
// 他から呼ばれ neuron.js で処理されるメソッドは他と区別するため頭に NR がつく


var _receiver;
function NRSendBack(){
	// サーバから返された処理を実行
    if (!_receiver){
		hideMessage("_message");
    }
    
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
		//alert("NRSendBack ===\n"+value);//##
		var array = value.split("<SEPARATOR>");
		if (array.length > 1){
            // ##### _receiver の処理でコケると _message が消えない #####
			_receiver(array[1]); // JSON
		}
		hideMessage("_message");
	} else
		showMessage("_message", "サーバで処理中です ... ");
}

function NR_debug(){
	// サーバから返された処理を実行
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
		alert("=== NR_debug ===\n"+value); //## 返されたメッセージを debug 用に表示
		var array = value.split("<SEPARATOR>");
		if (array.length > 1){
			_receiver(array[1]); // JSON
		}
		hideMessage("_message");
	} else
		showMessage("_message", "サーバで処理中です ...");
}

function NRNoAction(answer){
	// receiver として何も返す必要がないときに使う
}

function NRKickWindow(url, arguments, receiver){
    // receiver を間接的にキック
    // ##### PHP から呼んでもらえば外部ウインドーとして開く #####
    //xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		// サーバとの約束事
		var array = new Array();
		array["url"] = encodeSTRING(url);
		array["arguments"] = encodeSTRING(arguments);
        
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
        
        // FRONT など外部から使うには絶対パスの必要あり
		var st = _PATH + "server.php?command=KICK_WINDOW"
		+ "&value=" + encodeObject(array);
		//alert("NRKickWindow->"+st);
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}


///////////////////////////////////////////////////////////////
///// LOGIN 関連 ///////////////////////////////////////////////

function NRLogin(name, pwd, receiver){
	// login を支配
    //xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		// サーバとの約束事
		var array = new Array();
		array["loginName"] = name;
		array["passwd"] = pwd;
        
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
        
        // FRONT など外部から使うには絶対パスの必要あり
		var st = _PATH + "server.php?command=LOGIN"
		+ "&value=" + encodeObject(array);
		//alert("NRLogin->"+st);
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

function NRPutPassword(name, pwd, receiver){
    //xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		// サーバとの約束事
		var array = new Array();
		array["loginName"] = name;
		array["passwd"] = pwd;
		
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
		var st = "/NOA/server.php?command=PUT_PASSWD"
		+ "&value=" + encodeObject(array);
		
        //alert(st); return; //##
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}


///////////////////////////////////////////////////////////////
///// LAYOUT //////////////////////////////////////////////////

function NRGetLayout(owner, receiver){
	// TOOL MENU をサーバへリクエスト
    //xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var array = new Array();
		array["owner"] = owner;
        
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
        
        // FRONT など外部から使うには絶対パスの必要あり
		var st = _PATH + "server.php?command=GET_LAYOUT"
		+ "&value=" + encodeObject(array);
		//alert("NRGetLayout->"+st);
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}
function NRPostLayout(owner, value, receiver){
    // レイアウトをサーバへ保存："GET" では大きすぎてコケるので "POST" を使用
	//xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
        
        // encodeURI は '&' をエンコードしてくれないのでこちら側でエンコード
        // ### send() に与える文字列:st 全体をエンコードしては駄目 ###
        var st = "";
        st += "command=PUT_LAYOUT"
        st += "&owner=" + owner;
        st += "&value=" + encodeURI(encodeSTRING(value));
        
        //alert("NRPostLayout ====\n"+st); return; //##
        
        xmlHttpObject.open("POST", _PATH + "postServer.php", true);
        xmlHttpObject.setRequestHeader('Content-Type','application/x-www-form-urlencoded; charset=UTF-8');
        xmlHttpObject.send(st);
	}
}

function NRRemoveTagAndLabel(owner, receiver){
    // tag と label のレイアウトをサーバから削除
    //xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		// サーバとの約束事
		var array = new Array();
		array["owner"] = owner;
        
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
        
		var st = "./server.php?command=REMOVE_TAG_LABEL"
		+ "&value=" + encodeObject(array);
        
		//alert(st); //##
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}


///////////////////////////////////////////////////////////////
///// NOA STARTUP 関連 /////////////////////////////////////////

function NRStartupNOA(owner, hospitalId, receiver){
    // NOA 起動に必要な作業を実行
    //xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var array = new Array();
		array["owner"] = owner;
		array["hospitalId"] = hospitalId;
        
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
        
        // FRONT など外部から使うには絶対パスの必要あり
		var st = _PATH + "server.php?command=STARTUP_NOA"
		+ "&value=" + encodeObject(array);
		
        //alert("NRStartupNOA->"+st);
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}


function NRGetHospitalInfo(owner, hospitalId, receiver){
	// HospitalInfo をサーバへリクエスト
    //xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var array = new Array();
		array["hospitalId"] = hospitalId;
		array["owner"] = owner;
        
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
        
        // FRONT など外部から使うには絶対パスの必要あり
		var st = _PATH + "server.php?command=GET_HOSPITAL_INFO"
		+ "&value=" + encodeObject(array);
		//alert("NRGetHospitalInfo->"+st);
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

function NRGetUserTable(owner, receiver){
	// UserTable の内容をサーバへリクエスト
    //xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var array = new Array();
		array["logName"] = owner;
        
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
        
        // FRONT など外部から使うには絶対パスの必要あり
		var st = _PATH + "server.php?command=GET_USER_TABLE"
		+ "&value=" + encodeObject(array);
		//alert("NRGetUserTable->"+st);
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}


///////////////////////////////////////////////////////////////
///// CELL 初期設定 ////////////////////////////////////////////

function NRPutCellAttributes(owner,
							 tag,
							 buttonType,
							 menuType,
							 menuAction,
                             hitAndRun,
							 fieldType,
							 disabled,
							 editor,
                             id,
							 script,
							 bgcolor,
							 label,
                             numbering,
							 study,
							 fontSize,
							 fontFamily,
							 color,
                             groupObjct,
							 receiver){
    // CELL 属性をサーバへ保存：menuItem がなければ生成
	//xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var array = new Array();
		array["owner"] = owner;
		array["tag"] = tag;
		array["buttonType"] = buttonType;
		array["menuType"] = menuType;
		array["menuAction"] = menuAction;
		array["hitAndRun"] = hitAndRun;
		array["fieldType"] = fieldType;
		array["disabled"] = disabled;
		array["editor"] = editor;
		array["id"] = id;
		array["script"] = script;
		array["bgcolor"] = bgcolor;
		array["label"] = label;
		array["numbering"] = numbering;
		array["study"] = study;
		array["fontSize"] = fontSize;
		array["fontFamily"] = fontFamily;
		array["color"] = color;
        
        // groupObject はフラットに展開
        if (groupObjct){
            for (tag in groupObjct){
                array[tag] = groupObjct[tag];
            }
        }
		
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
		var val = encodeObject(array);
		var st = _PATH + "server.php?command=SET_CELL_ATTRIBUTES"
		+ "&value=" + encodeSTRING(val);
		
        //alert("NRPutCellAttributes ===\n"+st); return; //===
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}


///////////////////////////////////////////////////////////////
///// 患者登録 /////////////////////////////////////////////////

function NRPutPatient(own,pid,aid,rid,date,bdate,sex,kanji,kana,roma,receiver){
	// 新患登録
	//xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack); // global 変数で宣言
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var array = new Array();
		array["owner"] = own;
		array["patientId"] = pid;
		array["anotherId"] = aid;
		array["receiptId"] = rid;
		array["entryDate"] = date;
		array["birthDate"] = bdate;
		array["sex"] = sex;
		array["kanjiName"] = kanji;
		array["kanaName"] = kana;
		array["romajiName"] = roma;
		
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
        
        // ### FRONT からも利用
		var st = _PATH + "server.php?command=PUT_NEW_PATIENT"
		+ "&value=" + encodeObject(array);
        
		//alert("NRPutPatient->"+st); return; //##
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}


///////////////////////////////////////////////////////////////
///// FRONT ///////////////////////////////////////////////////

function NRPutFrontBooking(patientId, entryDate, reservedDate, receiver){
    // FRONT の予約状況を変更
	//xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack); // global 変数で宣言
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var array = new Array();
		array["patientId"] = patientId;
		array["entryDate"] = entryDate;
		array["reservedDate"] = reservedDate;
		
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
        
		var st = _PATH + "server.php?command=PUT_FRONT_BOOKING"
		+ "&value=" + encodeObject(array);
        
		//alert("NRPutFrontBooking->"+st); //##
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

function NRPutFrontEndTime(patientId, entryDate, endTime, receiver){
    // FRONT の診療終了状況を変更
	//xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack); // global 変数で宣言
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var array = new Array();
		array["patientId"] = patientId;
		array["entryDate"] = entryDate;
		array["endTime"] = endTime;
		
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
        
		var st = _PATH + "server.php?command=PUT_FRONT_END_TIME"
		+ "&value=" + encodeObject(array);
        
		//alert("NRPutFrontBooking->"+st); //##
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

function NRPutFrontTimestamp(patientId, entryDate, receiver){
    // FRONT の patientId, entryDate レコードに 診療終了時刻 endTime を刻印
	//xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack); // global 変数で宣言
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var array = new Array();
		array["patientId"] = patientId;
		array["entryDate"] = entryDate;
		
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
        
		var st = _PATH + "server.php?command=PUT_FRONT_TIMESTAMP"
		+ "&value=" + encodeObject(array);
        
		//alert("NRPutFrontTimestamp->"+st); //##
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}


///////////////////////////////////////////////////////////////
///// 検索 ////////////////////////////////////////////////////

function NRGetPatients(searchKey, receiver){
	// serchKey に一致する患者リストを返す
	// 検索キーにマッチしたカルテのリストを表示
    // ### FRONT からも利用される
    //xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
        var ch = searchKey.charAt(0);
        if (('0' <= ch) && (ch <='9'))
            var mode = "id";
        else if (('a' <= ch) && (ch <='z'))
            var mode = "roma";
        else if ('.' == ch){
            var mode = "anotherId";
            searchKey = searchKey.substr(1);
        } else
            var mode = "kanji";
        
		var array = new Array();
		array["key"] = mode;
		array["val"] = searchKey;
		
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
        
        // InfoViewer FRONT などから呼ばれるので絶対パスが必要
		var st = _PATH + "server.php?command=GET_PATIENTS"
		+"&value=" + encodeObject(array);
		
        //alert("NRGetPatients ====\n"+st); //##
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

function NRFind(tag, pid, key, from, to, unique, receiver){
	// 検索条件により検索
	//xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var array = new Array();
		array["tag"] = tag;
		array["patientId"] = pid;
		array["searchKey"] = key;
		array["from"] = from;
		array["to"] = to;
		array["unique"] = unique;
        
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
		var st = _PATH + "server.php?command=FIND"
		+ "&value=" + encodeObject(array);
        
		_debug("NRFind->"+st); //###
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

function NRGetSearchTable(owner, keyObj, receiver){
    // keyArray:entryDate, patientId の配列と tags に合致したレコードをリクエスト
	//xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var array = new Array();
		array["keys"] = keyObj;
		array["owner"] = owner;
        
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
		var st = _PATH + "server.php?command=GET_SEARCH_TABLE"
		+ "&value=" + encodeObject(array);
        
		//alert("NRGetSearchTable->"+st); //###
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}


///////////////////////////////////////////////////////////////
///// ページの取り扱い ///////////////////////////////////////////

function NRGetPages(owner, patientId, receiver){
    // カルテの全情報をサーバへリクエスト
    //xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		// サーバとの約束事
		var array = new Array();
		array["owner"] = owner;
		array["patientId"] = patientId;
		
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
		var st = _PATH + "server.php?command=GET_PAGES"
		+ "&value=" + encodeObject(array);
		
        //alert("NRGetPages->"+st); //return; //##
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}
function NRGetPage(owner, patientId, dateTime, receiver){
    // dateTime の情報をサーバへリクエスト
    //alert("NRGetPage->"+owner+"->"+patientId+"->"+dateTime); //##
    
    //xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		// サーバとの約束事
		var array = new Array();
		array["owner"] = owner;
		array["patientId"] = patientId;
		array["dateTime"] = dateTime;
		
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
		var st = _PATH + "server.php?command=GET_PAGE"
		+ "&value=" + encodeObject(array);
		
        //alert("NRGetPage->"+st); //return; //##
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}
function NRPutPage(owner,patientId,currentDate,timeLimit,container,receiver){
    // owner, patientId, entryDate の container をサーバへ保存
    // container = {"tag":"value",,,} 形式
    //xmlHttpObject = createXMLHttpRequest(NR_debug);
    xmlHttpObject = createXMLHttpRequest(NRSendBack);

	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var array = new Array();
		array["owner"] = owner;
		array["patientId"] = patientId;
		array["entryDate"] = currentDate;
		array["timeLimit"] = timeLimit;
		
		for (tag in container){
			// '#' が入るので encodeSTRING() 処理が必要
			array[tag] = encodeSTRING(container[tag]);
		}
        
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
		var st = _PATH + "server.php?command=PUT_PAGE"
		+ "&value=" + encodeObject(array);
        
		// alert("NRPutPage ===\n"+st); //return; //===
		
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}
function NRRemovePage(owner, patientId, dateTime, timeLimit, receiver){
	// owner, patientId, dateTime のページを削除
    //	xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var array = new Array();
		array["owner"] = owner;
		array["patientId"] = patientId;
		array["entryDate"] = dateTime;
		array["timeLimit"] = timeLimit;
        
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
		var st = "./server.php?command=REMOVE_PAGE"
		+ "&value=" + encodeObject(array);
		
		//alert("NRRemovePage =====\n" + st); //###
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}


///////////////////////////////////////////////////////////////
///// 予約業務：カレンダー表示にも使う //////////////////////////////

function NRGetBooking(patientId, dateTime, receiver){
    //xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var array = new Array();
		array["patientId"] = patientId;
		array["dateTime"] = dateTime;
        
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
		var st = _PATH + "server.php?command=GET_BOOKING"
		+ "&value=" + encodeObject(array);
		
        //alert("NRGetBooking->"+st); //return; //===
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}


///////////////////////////////////////////////////////////////
///// ACCEDD LOG //////////////////////////////////////////////

function NRGetAccessLog(owner, reverse, receiver){
    // owner のアクセス・ログをサーバへリクエスト
	//xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var array = new Array();
		array["owner"] = owner;
		array["reverse"] = reverse;
		
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
		var st = _PATH + "server.php?command=GET_ACCESS_LOG"
		+"&value=" + encodeObject(array);
		
        //alert("NRGetAccessLog ====\n"+st); //##
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}
function NRRemoveAccessLog(owner, patientId, receiver){
    // owner, patientId のアクセス・ログをサーバから削除
	//xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var array = new Array();
		array["owner"] = owner;
		array["patientId"] = patientId;
		
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
		var st = _PATH + "server.php?command=REMOVE_ACCESS_LOG"
		+"&value=" + encodeObject(array);
		
        //alert("NRGetAccessLog ====\n"+st); //##
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}


///////////////////////////////////////////////////////////////
///// MENU ////////////////////////////////////////////////////

function NRPutMenu(owner, tag, item, freq, value, receiver){
	if (!owner || owner.length == 0)
		alert("NRPutMenu: owner *** is null");
	
	//xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		// すでに同じメニューアイテムが存在すれば頻度をインクリメント
		var array = new Array();
		array["owner"] = owner;
		array["tag"] = tag;
		array["menuItem"] = encodeSTRING(item);
		array["freq"] = freq;
		array["val"] = encodeSTRING(value);
        
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
        
        // PickUp などからも呼ばれるので絶対パス
		var st = _PATH + "server.php?command=PUT_MENU"
		+ "&value=" + encodeObject(array);
        
		//_debug("NRPutMenu-> "+st); //return;//===
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}
function NRGetMenu(owner, tag, receiver){
	// ### groupMenu type の場合はサーバで判断し専用メニューを読み込み
    //xmlHttpObject = createXMLHttpRequest(NR_debug);
    xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var array = new Array();
		array["owner"] = owner;
		array["tag"] = tag;
		
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
        
        // PickUp などからも呼ばれるので絶対パス
		var st = _PATH + "server.php?command=GET_MENU"
		+ "&value=" + encodeObject(array);
		
        //alert("NRGetMenu->"+st);//===
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}
function NRRemoveMenu(owner, tag, menuItem, template, receiver){
	//xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var array = new Array();
		array["owner"] = owner;
		array["tag"] = tag;
		array["menuItem"] = encodeSTRING(menuItem);
		array["template"] = template;
		
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
		var st = _PATH + "server.php?command=REMOVE_MENU"
		+ "&value=" + encodeObject(array);
		
        //alert("NRRemoveMenu ==\n"+st); //return;//===
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

function NRPutGroupMenu(owner, item, freq, subItems, receiver){
	//xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		// すでに同じメニューアイテムが存在すれば頻度をインクリメント
		var array = new Array();
		array["owner"] = owner;
		array["menuItem"] = encodeSTRING(item);
		array["freq"] = freq;
        
        if (subItems){
            // subItems をフラットにする
            for (tag in subItems){
                array[tag] = encodeSTRING(subItems[tag]);
            }
        }
        
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
		var st = _PATH + "server.php?command=PUT_GROUP_MENU"
		+ "&value=" + encodeObject(array);
        
		//alert("NRPutGroupMenu ==\n"+st); //return;//===
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}
function NRGetGroupMenu(owner, receiver){
	//xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var array = new Array();
		array["owner"] = owner;
		
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
		var st = _PATH + "server.php?command=GET_GROUP_MENU"
		+ "&value=" + encodeObject(array);
		
        //alert("NRGetGroupMenu->"+st); //###
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

function NRGetAddress(owner, tag, receiver){
	// 住所メニューを読み込む
    //xmlHttpObject = createXMLHttpRequest(NR_debug);
    xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var array = new Array();
		array["owner"] = owner;
		array["tag"] = tag;
		array["isAddressMenu"] = 1;
		
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
        
        // tag は "品川区" のようになり tag で study を判断できないので
        // 住所メニューであることを明示する
		var st = _PATH + "server.php?command=GET_MENU"
		+ "&value=" + encodeObject(array);
		
        //alert("NRGetAddress->"+st);//===
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

function NRPutPublicMenu(owner, tag, publicMenus, receiver){
    // public menu の非表示設定
    //xmlHttpObject = createXMLHttpRequest(NR_debug);
    xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var array = new Array();
		array["owner"] = owner;
		array["tag"] = tag;
		array["publicMenus"] = publicMenus;
		
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
        
		var st = _PATH + "server.php?command=PUT_PUBLIC_MENU"
		+ "&value=" + encodeObject(array);
		
        //alert("NRPutPublicMenu->"+st);//===
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

///////////////////////////////////////////////////////////////
///// VIN ////////////////////////////////////////////////////

function NRGetVinHeader(containerObj, receiver){
	// onload で起動されるアクション：サーバにヘッダー部分の生成を依頼し表示
    //xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
        
		var st = _PATH + "vinServer.php?command=GET_VIN_HEADER"
		+ "&value=" + encodeObject(containerObj);
        
		//alert("NRGetVinHeader->"+st); //##
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

function NRPutDisaseToPriceList(disease, receiver){
	// PriceList の disease を保存する
    //xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
        
		var st = _PATH + "vinServer.php?command=GET_VIN_HEADER"
		+ "&value=" + encodeObject(containerObj);
        
		//alert("NRGetVinHeader->"+st); //##
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

function NRPutVinFilter(key, value, receiver){
    // VIN 用フィルターをサーバへ格納
    // ### value が null なら key のレコードを削除 ###
    //xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var array = new Array();
		array["key"] = key;
		array["value"] = (value) ? JSON.stringify(value) : "";
        
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
		var st = _PATH + "server.php?command=PUT_VIN_FILTER"
		+ "&value=" + encodeSTRING(encodeObject(array));
        
		//alert("NRPutVinFilter->"+st); //return; //===
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}
function NRGetVinFilter(receiver){
    // VIN 用フィルターをサーバから取り出す
    //xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
		var st = _PATH + "server.php?command=GET_VIN_FILTER";
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

function NRPutDiseaseToPriceList(name, disease, receiver){
	// PriceList の name に対応する disease を保存する
    //xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var array = new Array();
		array["name"] = encodeSTRING(name);
		array["disease"] = encodeSTRING(disease);

		_receiver = receiver; // 結果を受け付けるメソッドを記憶
        
		var st = _PATH + "server.php?command=PUT_DISEASE_TO_PRICELIST"
		+ "&value=" + encodeObject(array);
        
		//alert("NRPutDiseaseToPriceList->"+st); //##
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}
function NRGetDiseaseFromPriceList(name, receiver){
	// PriceList の name に対応する disease をサーバへリクエスト
    //xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var array = new Array();
		if (name) array["name"] = encodeSTRING(name);
        
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
        
		var st = _PATH + "server.php?command=GET_DISEASE_FROM_PRICELIST"
		+ "&value=" + encodeObject(array);
        
		//alert("NRPutDiseaseToPriceList->"+st); //##
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}
function NRRemoveDiseaseFromPriceList(name, receiver){
	// PriceList の name に対応する disease を削除
    //xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var array = new Array();
		array["name"] = encodeSTRING(name);
        
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
        
		var st = _PATH + "server.php?command=REMOVE_DISEASE_FROM_PRICELIST"
		+ "&value=" + encodeObject(array);
        
		//alert("NRPutDiseaseToPriceList->"+st); //##
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

function NRGetDiseaseFromHistory(name, receiver){
    // 過去１年間の全カルテ履歴から name とともに使われた病名を探して返す
    //xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var array = new Object();
		array["name"] = encodeSTRING(name);
        //var diff = -60 * 24 * 30; // ###
        var diff = -60 * 24 * 365; // １年前までの分
        array["fromDate"] = dateWthDiff(todayAndTime(), diff);

		_receiver = receiver; // 結果を受け付けるメソッドを記憶
        
		var st = _PATH + "server.php?command=GET_DISEASE_FROM_HOSTORY"
		+ "&value=" + encodeObject(array);
        
		//alert("NRPutDiseaseToPriceList->"+st); //##
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

///////////////////////////////////////////////////////////////
///// DB 操作 //////////////////////////////////////////////////

function NRCheckColumn(tableName, fieldName, receiver){
	// dbName, tableName, fieldName の有無をチェック
    //xmlHttpObject = createXMLHttpRequest(NR_debug);
    xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var array = new Array();
		array["tableName"] = tableName;
		array["fieldName"] = fieldName;
		
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
        
        // PickUp などからも呼ばれるので絶対パス
		var st = _PATH + "server.php?command=CHECK_COLUMN"
		+ "&value=" + encodeObject(array);
		
        //alert("NRGetMenu->"+st);//===
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

function NRCheckFrontTable(){
	// dbName, tableName, fieldName の有無をチェック
    //xmlHttpObject = createXMLHttpRequest(NR_debug);
    xmlHttpObject = createXMLHttpRequest(NRNoAction);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var st = _PATH + "server.php?command=CHECK_FRONT_TBALE";
        //alert("NRCheckFrontTable->"+st);//===
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

function NRCheckPriceList(){
	// dbName, tableName, fieldName の有無をチェック
    //xmlHttpObject = createXMLHttpRequest(NR_debug);
    xmlHttpObject = createXMLHttpRequest(NRNoAction);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var st = _PATH + "server.php?command=CHECK_PRICE_LIST";
        //alert("NRCheckPriceList->"+st);//===
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}


///////////////////////////////////////////////////////////////
///// TOOL MENU ///////////////////////////////////////////////

function NRGetToolMenu(owner, receiver){
    // TOOL MENU 構造をサーバへリクエスト
    //xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		// サーバとの約束事
		var array = new Array();
		array["owner"] = owner;
        
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
		// FRONT など他のアプリからも使えるよう server.php はフルパス指定
		var st = _PATH + "server.php?command=GET_TOOL_MENU"
		+ "&value=" + encodeObject(array);
		//alert("NRGetToolMenu->"+st);
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}
function NRPutToolMenu(owner, array, receiver){
    // TOOL_MENU のデータをサーバへ保存
    // array のデータ量が多いと転送エラーになるので POST 型式でサーバへ送る
	//xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
        
        // encodeURI は '&' をエンコードしてくれないのでこちら側でエンコード
        // ### send() に与える文字列:st 全体をエンコードしては駄目 ###
        var st = "";
        st += "command=PUT_TOOL_MENU"
        st += "&owner=" + owner;
        var value = encodeObject(array);
        value = encodeSTRING(value);
        st += "&value=" + encodeURI(value);
        
        //_debug("NRPutToolMenu ====\n"+st); return; //##
        
        xmlHttpObject.open("POST", "postServer.php", true);
        xmlHttpObject.setRequestHeader('Content-Type','application/x-www-form-urlencoded; charset=UTF-8');
        xmlHttpObject.send(st);
	}
}
function NRRemoveToolMenu(owner, id, label, receiver){
    // メニュー構造をサーバへリクエスト
    //xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		// サーバとの約束事
		var array = new Array();
		array["owner"] = owner;
		array["id"] = id;
		array["label"] = label;
        
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
		// FRONT など他のアプリからも使えるよう server.php はフルパス指定
		var st = _PATH + "server.php?command=REMOVE_TOOL_MENU"
		+ "&value=" + encodeObject(array);
        
		//alert(st); //##
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}


///////////////////////////////////////////////////////////////
///// 周辺ツール用 API //////////////////////////////////////////

function NRGetTemplateMenu(owner, receiver){
    // CellEditor の テンプレート・メニューをサーバへリクエスト
    //xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		// サーバとの約束事
		var array = new Array();
		array["owner"] = owner;
        
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
		// FRONT など他のアプリからも使えるよう server.php はフルパス指定
		var st = _PATH + "server.php?command=GET_MENU_TEMPLATE"
		+ "&value=" + encodeObject(array);
        
		//alert(st); //##
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

function NRPutMenuTemplate(owner, tag, item, tempName, freq, value, receiver){
    // FORM のテンプレート・メニューを登録
	if (!owner || owner.length == 0)
		alert("NRPutMenuTemplate: owner *** is null");
	
	//xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		// すでに同じメニューアイテムが存在すれば頻度をインクリメント
		var array = new Array();
		array["owner"] = owner;
		array["tag"] = tag;
		array["menuItem"] = encodeSTRING(item); // 伝票タイトル名
		array["tempName"] = encodeSTRING(tempName); // テンプレート・タイトル名
		array["freq"] = freq;
		array["val"] = encodeSTRING(value);
        
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
        
		var st = _PATH + "server.php?command=PUT_MENU_TEMPLATE"
		+ "&value=" + encodeObject(array);
        
		//alert("NRPutMenuTemplate-> "+st); return;//===
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

function NRRemoveMenuTemplate(owner, cellLabel, menuItem, menu, receiver){
    // FORM のテンプレート・メニューを削除
	//xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		// すでに同じメニューアイテムが存在すれば頻度をインクリメント
		var array = new Array();
		array["owner"] = owner;
		array["tag"] = cellLabel;
		array["menuItem"] = encodeSTRING(menuItem); // 伝票タイトル名
		array["tempName"] = encodeSTRING(menu); // テンプレート・タイトル名
        
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
        
        // 周辺ツールからも呼ばれても良いよう絶対パス
		var st = _PATH + "server.php?command=REMOVE_MENU_TEMPLATE"
		+ "&value=" + encodeObject(array);
        
		//alert("NRRemoveMenuTemplate ==\n"+st); return;//===
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}


///////////////////////////////////////////////////////////////
///// アーカイブ ////////////////////////////////////////////////

function NRPutArchive(owner, patientId, receiver){
    // xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var array = new Array();
		array["owner"] = owner;
		array["patientId"] = patientId;
        
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
		var st = _PATH + "server.php?command=PUT_ARCHIVE"
		+ "&value=" + encodeObject(array);
		
        //alert("NRPutArchive->"+st); //===
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}
function NRGetArchive(patientId, receiver){
    // xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var array = new Array();
		array["patientId"] = patientId;
		
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
		var st = _PATH + "server.php?command=GET_ARCHIVE"
		+ "&value=" + encodeObject(array);
		//alert(st); //===
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}
function NRMergeArchive(owner, pid, tag, entryDate, updateTime, val, receiver){
    //xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var array = new Array();
		array["owner"] = owner;
		array["patientId"] = pid;
		array["tag"] = tag;
		array["entryDate"] = encodeSTRING(entryDate);
		array["updateTime"] = encodeSTRING(updateTime);
		array["val"] = encodeSTRING(val);
		
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
		var st = _PATH + "server.php?command=MERGE_ARCHIVE"
		+ "&value=" + encodeObject(array);
		//alert("NRMergeArchive->"+st); return; //===
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

function NRPutArchiveFile(owner, folder, subfolder, array, receiver){
    // array を POST 型式でサーバへ転送し JSON 型式で保存
	//xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
        
        // encodeURI は '&' をエンコードしてくれないのでこちら側でエンコード
        // ### send() に与える文字列:st 全体をエンコードしては駄目 ###
        var st = "command=PUT_ARCHIVE_FILE"
        st += "&owner=" + owner;
        st += "&folder=" + folder;
        st += "&subfolder=" + subfolder;
        var value = encodeObject(array);
        value = encodeSTRING(value);
        st += "&value=" + value;
        
        //alert("NRPutArchiveFile ->"+st); //return; //##
        
        xmlHttpObject.open("POST", _PATH + "postServer.php", true);
        xmlHttpObject.setRequestHeader('Content-Type','application/x-www-form-urlencoded; charset=UTF-8');
        xmlHttpObject.send(encodeURI(st));
	}
}
function NRGetArchiveFile(owner, folder, filename, receiver){
    // ファイルをサーバへリクエスト
    //xmlHttpObject = createXMLHttpRequest(NR_debug);
    xmlHttpObject = createXMLHttpRequest(NRSendBack);
    if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var array = new Array();
		array["owner"] = owner;
		array["folder"] = folder;
		array["filename"] = filename;
        
        _receiver = receiver; // 結果を受け付けるメソッドを記憶
        var st = _PATH + "server.php?command=GET_ARCHIVE_FILE"
        + "&value=" + encodeObject(array);
        
        //alert("NRGetArchiveFile->"+st); //return; //##
        
        xmlHttpObject.open("GET", encodeURI(st), true);
        xmlHttpObject.send(null);
    }
}
function NRRemoveArchiveFile(owner, folder, filename, receiver){
    // TOOL MENU のバックアップファイルを削除
    //xmlHttpObject = createXMLHttpRequest(NR_debug);
    xmlHttpObject = createXMLHttpRequest(NRSendBack);
    if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var array = new Array();
		array["owner"] = owner;
		array["folder"] = folder;
		array["filename"] = filename;
        
        _receiver = receiver; // 結果を受け付けるメソッドを記憶
        var st = _PATH + "server.php?command=REMOVE_ARCHIVE_FILE"
        + "&value=" + encodeObject(array);
        
        //alert(st); //return; //##
        
        xmlHttpObject.open("GET", encodeURI(st), true);
        xmlHttpObject.send(null);
    }
}

function NRGetArchiveFiles(owner, folder, receiver){
    // TOOL MENU のバックアップファイル・リストをサーバへリクエスト
    //xmlHttpObject = createXMLHttpRequest(NR_debug);
    xmlHttpObject = createXMLHttpRequest(NRSendBack);
    if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var array = new Array();
		array["owner"] = owner;
		array["folder"] = folder;
        
        _receiver = receiver; // 結果を受け付けるメソッドを記憶
        var st = _PATH + "server.php?command=GET_ARCHIVE_FILES"
        + "&value=" + encodeObject(array);
        
        //alert(st); //return; //##
        
        xmlHttpObject.open("GET", encodeURI(st), true);
        xmlHttpObject.send(null);
    }
}


///////////////////////////////////////////////////////////////
///// 健康保険 /////////////////////////////////////////////////

function NRGetInsurance(ownerNumber, receiver){
	// 保険者番号から該当保険者レコードを検索：insurance.js
	xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var array = new Array();
		array["HealthInsurance.ownerNumber"] = ownerNumber;
		
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
		var st = _PATH + "server.php?command=GET_HEALTHINSURANCE_WITH_KEY"
		+ "&value=" + encodeObject(array);
		//alert(st); return; //===
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

function NRGetInsImage(patientId, receiver){
    // patientId に相当する保険証画像イメージがあればその URLリスト を返す
    //xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
        var args = new Array();
        args['patientId'] = trim(patientId);
        
        // FRONT など外部から使うには絶対パスの必要あり
        var st = _PATH + "server.php?command=GET_INS_IMAGE"
        + "&value=" + encodeObject(args);
        
        //alert("NRGetInsImage ->"+st); //return; //##
        
        xmlHttpObject.open("GET", encodeURI(st), true);
        xmlHttpObject.send(null);
	}
}
function NRPutInsImage(patientId, filename, imageSrc, receiver){
    // patientId(), filename, imageSrc 画像をサーバへ保存
    //xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
        
        var st = "command=PUT_INS_IMAGE";
        st += "&patientId=" + patientId;
        st += "&filename=" + filename;
        st += "&value=" + encodeURI(encodeSTRING(imageSrc));
        
        xmlHttpObject.open("POST", _PATH + "postServer.php", true);
        xmlHttpObject.setRequestHeader('Content-Type','application/x-www-form-urlencoded; charset=UTF-8');
		//alert("NRPutInsImage ->"+st); //##
        xmlHttpObject.send(st);
	}
}
function NRRemoveInsImage(patientId, filename, receiver){
    // patientId に相当する保険証画像イメージを削除マークのついたファイルにする
    //xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
        var args = new Array();
        args['patientId'] = trim(patientId);
        args['filename'] = filename;
        
        // FRONT など外部から使うには絶対パスの必要あり
        var st = _PATH + "server.php?command=REMOVE_INS_IMAGE"
        + "&value=" + encodeObject(args);
        
        alert("NRRemoveInsImage ->"+st); //return; //##
        
        xmlHttpObject.open("GET", encodeURI(st), true);
        xmlHttpObject.send(null);
	}
}


///////////////////////////////////////////////////////////////
///// POST IT /////////////////////////////////////////////////

function NRPutPostIt(owner, patientId, entryDate, type, val, receiver){
	// PostIt に value を与える（ value=="" ならレコード削除）
    // xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var array = new Array();
		array["owner"] = owner;
		array["patientId"] = patientId;
		array["entryDate"] = entryDate;
		array["type"] = type;
		array["val"] = encodeSTRING(val);
		
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
		var st = _PATH + "server.php?command=PUT_POST_IT"
		+ "&value=" + encodeObject(array);
		
		//alert("NRPutPostIt =====\n" + st); //###
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}


/////////////////////////////////////////////////////////
///// MESSENGER /////////////////////////////////////////

function NRGetMessageAndMenu(owner, receiver){
    // メッセージ・メニューをサーバへリクエスト
	//xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
        var array = new Array();
		array['owner'] = owner;
        
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
        
        // FRONT からも呼ばれる
		var st = _PATH + "server.php?command=GET_MESSAGE_AND_MENU"
		+ "&value=" + encodeObject(array);
		//alert(st); //return; //===
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

function NRRemoveMessage(owner, docId){
    // docId の MESSAGE レコードをサーバから消去
    //xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
        var array = new Array();
		array['owner'] = owner;
		array['docId'] = docId;
		var val = encodeObject(array);
		
		_receiver = closeMessage; // 結果を受け付けるメソッドを記憶
        
		var st = _PATH + "server.php?command=REMOVE_MESSAGE"
		+ "&value=" + val;
        
		//alert("NRRemoveMessage->"+st); //##
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

function NRPutMessage(sender, sendApp, receiver, recApp, message, docId, result){
    // メッセージを送信
	//xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
        var obj = new Object();
        obj["sender"] = sender + "@" + sendApp; // sender に格納
        obj["receiver"] = receiver + "@" + recApp; // mishuu に格納
        obj["message"] = message; // plan に格納
        obj["docId"] = docId; // rowid に相当
        
		_receiver = result; // 結果を受け付けるメソッドを記憶
        
        // FRONT からも呼ばれる
		var st = _PATH + "server.php?command=PUT_MESSAGE"
		+ "&value=" + encodeSTRING(encodeObject(obj));
		//_debug("NRPutMessage->"+st); //return; //===
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}


///////////////////////////////////////////////////////////////
///// 周辺ツール用 API //////////////////////////////////////////

function NRGetValueAPI(owner, patientId, currentDate, hospitalId, tags, receiver){
    // 現在開かれているカルテの与えられた tag 配列に該当するデータを返す
    //xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
        var obj = new Object();
        obj.owner = owner;
        obj.patientId = patientId;
        obj.currentDate = currentDate;
        obj.hospitalId = hospitalId;
		obj.tags = tags; // "table.field,table.field,,," 型式
        var st = encodeObject(obj);
		
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
        
        // ### 周辺ツールから呼ばれるので絶対パス /NOA を指定する必要あり ###
		var st = _PATH + "server.php?command=GET_VALUE_API"
		+ "&value=" + encodeSTRING(st);
		
        //alert("NRGetValueAPI ====\n"+st); //##
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

function NRGetConditionalPatient(fromDate, toDate, receiver){
    // fromDate, toDate の期間の受診者をリストアップ：lvdSearch で使われる
    //xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
        var obj = new Object();
        obj.fromDate = fromDate;
        obj.toDate = toDate;
        var st = encodeObject(obj);
		
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
        
        // ### 周辺ツールから呼ばれるので絶対パス /NOA を指定する必要あり ###
		var st = _PATH + "server.php?command=GET_CONDITIONAL_PATIENT"
		+ "&value=" + encodeSTRING(st);
		
        //alert("NRGetValueAPI ====\n"+st); //##
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

function NRGetUserList(receiver){
    // NOA ユーザの ログイン名 をリストアップ：lvdSearch で使われる
    //xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
        
        // ### 周辺ツールから呼ばれるので絶対パス /NOA を指定する必要あり ###
		var st = _PATH + "server.php?command=GET_USER_LIST";
		
        //alert("NRGetValueAPI ====\n"+st); //##
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

function NRGetRecordsForKeys(pid, owner, keys, receiver){
	// 配列 keys に含まれるキーを含む全てのレコードを返す
	// ## Pickup ツールで使用する
	//xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var array = new Array();
		array["patientId"] = pid;
		array["owner"] = owner;
		array["keys"] = keys; // 改行された文字列
		
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
		var st = _PATH + "server.php?command=GET_RECORDS_FOR_KEYS"
		+"&value=" + encodeObject(array);
		//alert("NRGetRecordsForKeys ====\n"+st); //##
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

function NRGetInsDirectory(patientId){
    // patientId の保険証画像のリストをリクエスト
	//xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		// サーバとの約束事
		var array = new Array();
		array["patientId"] = patientId();
		
		var st = "server.php?command=GET_DIRECTORY"
		+ "&value=" + encodeObject(array);
        //_debug("getFiles->"+st); //##
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

function NRputRemind(pid, type, owner, dataString, receiver){
	// pid,type,owner,dataString を UniversalSection に格納
	// ## Reminder ツールで使用する
	//xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var array = new Array();
		array["patientId"] = pid;
		array["owner"] = owner;
		array["type"] = type; // いずれ使うかも知れない
		array["dataString"] = dataString;
		
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
		var st = _PATH + "server.php?command=PUT_REMINDER"
		+"&value=" + encodeObject(array);
		//alert("NRGetPatients ====\n"+st); //##
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}
function NRgetRemind(pid, type, owner, receiver){
	// ## Reminder ツールで使用する
	// pid,type,owner に一致する UniversalSection のレコードを返す
	//xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var array = new Array();
		array["patientId"] = pid;
		array["owner"] = owner;
		array["type"] = type; // いずれ使うかも知れない
		
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
		var st = _PATH + "server.php?command=GET_REMINDER"
		+"&value=" + encodeObject(array);
		//alert("NRGetPatients ====\n"+st); //##
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

function NRGetCorrectionHistory(owner, patientId, entryDate, receiver){
    // 修正履歴をサーバへリクエスト：correctionHistory で使われる
    // xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var array = new Array();
		array["owner"] = owner;
		array["patientId"] = patientId;
		array["entryDate"] = entryDate;
		
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
		var st = _PATH + "server.php?command=GET_CORRECTION_HISTORY"
		+ "&value=" + encodeObject(array);
		
		//alert("NRGetCorrectionHistory =====\n" + st); //###
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

function NRGetViewer(owner, patientId, currentDate, receiver){
    // patientId currentDate のカルテ内容をサーバへリクエスト
    // FRONT の viewer.js から呼ばれる
    // xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var obj = new Object();
		obj['owner'] = owner;
		obj['patientId'] = patientId;
		obj['dateTime'] = currentDate;
		
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
		var st = _PATH + "server.php?command=GET_VIEWER"
		+ "&value=" + encodeObject(obj);
		_debug("NRGetViewer-> "+st); //return; //##
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}


///////////////////////////////////////////////////////////////
///// NOAManager //////////////////////////////////////////////

function NRGetImagFileBetween(from, to, receiver){
    // from to の期間にコピーした保険証画像を検索
	// NOAManager で使う
    //xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var array = new Array();
		array["fromDate"] = from;
		array["toDate"] = to;
		
        //document.getElementById("dataArea").innerHTML = "検索中：しばらくお待ちください";
        
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
		var st = _PATH + "server.php?command=GET_CONDITIONAL_INS_FILES"
		+ "&value=" + encodeObject(array);
		
        document.getElementById("_debug").innerHTML = st; //##
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}
function NRGetImageFile(patientId, filename, receiver){
    // filename のイメージファイルをリクエスト
    //xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var array = new Array();
		array["patientId"] = patientId;
		array["filename"] = filename;
		
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
		var st = _PATH + "server.php?command=GET_INS_IMAGE"
		+ "&value=" + encodeObject(array);
		
        //alert("NRGetImageFile->"+st); //##
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

function NRGetTableRecords(patientId, receiver){
	// 各テーブルごと patientId のレコード数を返す
	// NOAManager で使う
	//xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var array = new Array();
		array["patientId"] = patientId;
		
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
		var st = _PATH + "server.php?command=GET_TABLE_RECORDS"
		+"&value=" + encodeObject(array);
		//alert("NRGetTableRecords->"+st); //return; //##
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}
function NRRemovePatient(table, patientId, receiver){
	// table から patientId のレコード全てを削除
	// NOAManager で使う
	//xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var array = new Array();
		array["table"] = table;
		array["patientId"] = patientId;
        
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
		var st = _PATH + "server.php?command=REMOVE_TABLE_RECORDS"
		+ "&value=" + encodeObject(array);
		//alert(st); //return; //##
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

function NRRemoveFiles(files, receiver){
    // カンマで区切られたファイルをサーバから削除
    //xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){
		var array = new Array();
		array["files"] = encodeSTRING(files);
		
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
		var st = _PATH + "server.php?command=REMOVE_INS_IMAGES"
		+ "&value=" + encodeObject(array);
        
        //alert("NRRemoveFiles->"+st); //##
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}


/////////////////////////////////////////////////////////////
///// CALL //////////////////////////////////////////////////

function NRPutCalls(owner, type, name, calls, receiver){
    // call() 一括処理をサーバへ記憶
    //xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){
		var array = new Array();
		array["owner"] = owner;
		array["type"] = type;
		array["name"] = encodeSTRING(name);
		array["calls"] = (calls) ? encodeSTRING(calls) : null;
		
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
		var st = _PATH + "server.php?command=PUT_CALLS"
		+ "&value=" + encodeObject(array);
        
        //alert("NRPutCalls->"+st); //##
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

function NRGetCalls(owner, type, receiver){
    // call() 一括処理をサーバへ記憶
    //xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){
		var array = new Array();
		array["owner"] = owner;
		array["type"] = type;
		
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
		var st = _PATH + "server.php?command=GET_CALLS"
		+ "&value=" + encodeObject(array);
        
        //alert("NRGetCalls->"+st); //##
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

/////////////////////////////////////////////////////////////
///// STANDARD //////////////////////////////////////////////

function NRPutStandard(owner, item, value, receiver){
    // 基準値をサーバへ保存
    //xmlHttpObject = createXMLHttpRequest(NR_debug);
    xmlHttpObject = createXMLHttpRequest(NRSendBack);
    if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
        // すでに同じメニューアイテムが存在すれば頻度をインクリメント
        var array = new Array();
        array["owner"] = owner;
        array["item"] = encodeSTRING(item);
        if (value){
            array["value"] = encodeSTRING(value);
        }
        
        _receiver = receiver; // 結果を受け付けるメソッドを記憶
        
        // PickUp などからも呼ばれるので絶対パス
        var st = _PATH + "server.php?command=PUT_STANDARD"
        + "&value=" + encodeObject(array);
        
        //alert("NRPutStandard-> "+st); return;//===
        
        xmlHttpObject.open("GET", encodeURI(st), true);
        xmlHttpObject.send(null);
    }
}
function NRGetStandard(owner, receiver){
    // 基準値をサーバへリクエスト
    //xmlHttpObject = createXMLHttpRequest(NR_debug);
    xmlHttpObject = createXMLHttpRequest(NRSendBack);
    if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
        // すでに同じメニューアイテムが存在すれば頻度をインクリメント
        var array = new Array();
        array["owner"] = owner;
        _receiver = receiver; // 結果を受け付けるメソッドを記憶
        
        // PickUp などからも呼ばれるので絶対パス
        var st = _PATH + "server.php?command=GET_STANDARD"
        + "&value=" + encodeObject(array);
        
        //alert("NRGetStandard-> "+st); //return;//===
        
        xmlHttpObject.open("GET", encodeURI(st), true);
        xmlHttpObject.send(null);
    }
}


/////////////////////////////////////////////////////////////
///// PRESCRIPTION //////////////////////////////////////////

function NRGetPrescriptionHistory(patientId, receiver){
    // 処方箋の過去履歴をサーバへリクエスト
    //xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(NRSendBack);
	if (xmlHttpObject){
		var array = new Array();
		array["patientId"] = patientId;
		
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
		var st = _PATH + "server.php?command=GET_PRESCRIPTION_HISTORY"
		+ "&value=" + encodeObject(array);
        
        //alert("NRGetPrescriptionHistory->"+st); //##
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}


