
/*** 参考文献 ***
 キャンバスのレイヤー化によるレンダリングの最適化
 http://www.ibm.com/developerworks/jp/web/library/wa-canvashtml5layering/
 テキストを描画する領域のサイズを取得
 http://www.yoheim.net/blog.php?q=20130603
 ***************/

var _debugMode = false;
var _controlAreaWidth = 450;
var _controlAreaHeight = 90;
var _sliderMax = 30;
var _sliderMin = 0.1;
var _canvasBasePos;

////////////////////////////////////////////////
///// Ajax /////////////////////////////////////

function saveImage(){
    // 画像をサーバへ保存
    
    // 一時的 canvas を生成
    var elm = elmFor("_tmp");
    elm.innerHTML = "";
    var tmpCan = newCANVAS(elm, "", 700, 700, null);
    tmpCan.style.border = "thin solid #ddd";
    tmpCan.style.display = "none"; // 見えなくする
    var ctx = tmpCan.getContext("2d");
    
    // 作成した図形すべてを一時的 canvas へ転写
    for (id in _layers){
        var can = _layers[id];
        
        // 画像を表示するクリッピング領域を設定
        var width = tmpCan.width;
        var height = tmpCan.height;
        ctx.beginPath();
        ctx.moveTo(0,0);
        ctx.lineTo(width, 0);
        ctx.lineTo(width, height);
        ctx.lineTo(0, height);
        ctx.clip();
        
        // 頭の 'data:image/png;base64,' などの文字列は削除せず残す
        var img = document.createElement("img");
        img.src = can.toDataURL();
        
        // 画像の高さが can.height に収まるよう縮尺して表示
        ctx.drawImage(img, can.x, can.y, can.width, can.height);  
    }
    var src = tmpCan.toDataURL();
    
//    return; //###
    
    // イメージをサーバへ保存
    var pictureTool = window.opener;
    pictureTool.setImageSrc(src);
    pictureTool.setCanvas(tmpCan);
    pictureTool.saveImage();
}

///// Ajax /////////////////////////////////////
////////////////////////////////////////////////


///////////////////////
///// dragAndDrop /////

function graffitiDrop(e, can){
    // el にドロップされた画像を描画
    var file = e.dataTransfer.files[0];
    if (!file) {
        alert('画像ファイルの実体がないのでドロップできません');
        return; // file の実体がないとドロップできない
    }
    
    if(!file.type.match(/image\/\w+/)){
        alert('画像ファイルしか受けつけられません');
        return;
    }
    
    var img = document.createElement("img");
    var reader = new FileReader(); 
    reader.onload = function(e) {
        img.src = e.target.result;
        if (img.src.indexOf('data:image/tiff;') >= 0)
            alert("TIFF 型式の画像はサポートされていません");
    }
    can.image = img;
    
    // canvas へ描画
    img.onload = function() {
        // canvas に can.image のサイズで画像を表示
        draw_image(can, can.image.width, can.image.height);
    }
    reader.readAsDataURL(file);
}

function draw_image(can, width, height){
    // canvas に width, height のサイズで画像を表示
    var ctx = can.getContext("2d");
    
    // 再描画前に今までのイメージを消去
    ctx.clearRect(0, 0, can.width, can.height);
    
    // CANVAS のサイズをイメージ・サイズにする
    can.width = width;
    can.height = height;
    
    // 画像を表示するクリッピング領域を設定
    ctx.beginPath();
    ctx.moveTo(0,0);
    ctx.lineTo(can.width, 0);
    ctx.lineTo(can.width, can.height);
    ctx.lineTo(0, can.height);
    ctx.clip();
    
    // 画像の高さが can.height に収まるよう縮尺して表示
    ctx.drawImage(can.image, 0, 0, can.width, can.height);  
}

///// dragAndDrop /////
///////////////////////

////////////////////////////////////////////////////////////////
///// CANVAS をマウス・ドラッグで移動 //////////////////////////////

var _cursor_locked;
var _currentCanvas;

function editBoxChanged(elm){
    // 編集チェックボックスがクリックされた
    var can = _currentCanvas;
    if (elm.checked){
        can.style.border = "thin solid #00f";
        can.editMode = true;
    } else {
        can.style.border = "thin solid #ccc";
        can.editMode = false;
    }
}
function drowIsEditable(){
    // Pen ToothPaste Line が編集モードなら true を返す
    var cb = elmFor("drawEditBox");
    var can = _currentCanvas;
    
    if (can.type == "Text")
        return true;
    else if (cb && cb.checked){
        return true;
    } else {
        return false;
    }
}

function showLayerInfo(can){
    // レイヤー情報を表示
    
    // レイヤー・ポップアップを表示
    var popElm = elmFor("layerPopArea");
    popElm.innerHTML = "";

    // レイヤー情報を表示
    var elm = elmFor("layerInfoArea");
    elm.innerHTML = "";
    if (can){
        // type を表示
        var sp = newSPAN(elm, "");
        sp.innerHTML = can.type;
        sp.style.padding = "0 5px";
        var sp = newSPAN(elm, "");
        // 編集ボックスを生成
        if (isDrawType(can.type)){
            var status = (can.editMode) ? 1 : 0;
            var cb = newCHECKBOX(sp, "drawEditBox", "編集", status);
            cb.setAttribute("onchange", "editBoxChanged(this)");
            var sp = newSPAN(elm, "");
            sp.style.marginLeft = "5px";
        }
        // レイヤー削除アイコンを生成
        var im = newIMAGE(sp, "", "./remove-field.png", "?");
        im.setAttribute("onclick", "removeLayer('" + can.id + "')");
        im.style.marginRight = "5px";
        im.style.height = "12px";
        im.setAttribute("class", "expandIcon");
        // レイヤー情報を生成
        var sp = newSPAN(elm, "");
        sp.innerHTML = layerInfo(can);
        sp.style.padding = "0 5px";
    }
    // レイヤー選択ポップアップを生成
    var sp = newSPAN(popElm, "");
    sp.innerHTML = "階層";
    sp.style.paddingRight = "5px";
    var array = ["","選択解除"];
    for (id in _layers) array.push(id);
    var pu = newPopupMenu(popElm, "", array, "");
    pu.setAttribute("onchange", "selectLayer(this)");
    
    function layerInfo(can){
        // レイヤー情報を記した文字列を返す
        if (can){
            var context = can.getContext("2d");
            var st = "";
            if (can.text) st += "text(" + can.text + ") ";
            if (can.size) st += "size(" + can.size + ") ";
            if (can.alpha) st += "alpha(" + can.alpha + ") ";
            if (can.colorName) st += "color(" + can.colorName + ") ";
            return st;
        } else {
            return "";
        }
    }
}

function isDrawType(type){
    // 線描画タイプなら true を返す
    if ((type == "Pen") || (type == "ToothPaste") || (type == "Line"))
        return true;
    else
        return false;
}

function selectLayer(elm){
    // レイヤー選択ポップアップが選択された
    var id = elm.value;
    
    if ((id == "選択解除") || (id == "")){
        // 編集モードを抜ける
        _currentCanvas.style.border = "none";
        _currentCanvas.editMode = false;
        showLayerInfo();
        return;
    } else if (id.length > 0){
        var can = _layers[id];
    }
    
    // 選択されたレイヤーを選択編集モードにする
    cursor_lock(can);
    cursor_unlock();
    _mouse_down = false;
    
    // id のレイヤーを手前に移動
    pullLayer(id);
}

function pullLayer(id){
    // id のレイヤーを一番手前に移動
    if (id.length > 0){
        // 順番を変更して CANVAS を再表示
        var array = new Array();
        var index = 0;
        for (num in _layers){
            if (num == id) continue;
            
            // pullLayer() を命令したレイヤー以外を配列に入れる
            var can = _layers[num];
            array[index++] = can;
        }
        // pullLayer() を命令したレイヤーを配列の最初に入れる
        array[index] = _layers[id];
        
        array.sort();
        _layers = new Array();
        index = 0;
        for (num in array){
            var can = array[num];
            _layers.push(can);
            can.style.zIndex = index++;
        }
        showLayerInfo(can);
    }
}

var _drawMode;
var _lineStart;
function cursor_lock(can){
    // 画像が貼り付けられたレイアーの枠を表示
    if (can.empty) return; // 画像ドロップ用の初期レイヤーだった
    
    _toolType = can.type;
	_cursor_locked = true;
    _currentCanvas = can;

    if (can.editMode == true)
        can.style.border = "thin solid #00f";
    else
        can.style.border = "thin solid #ccc";
    
    if (can.type == "Line")
        _lineStart = true;

    // 他のレイアーの editMode があれば解除
    deselectAnotherLayers();
    
    // 道具選択ボタンを再描画
    showToolSelector();
    
    // 選択されたレイヤーの属性を各コントローラへ反映させる
    if (can.size) setPenSize(can.size); // ペン・サイズと透明度へ反映
    if (can.alpha) setAlpha(can.alpha);
    if (can.colorName) setPenColor(can.colorName); // カラー・パレットへ反映
}
function cursor_unlock(){
    // マウス・アップに反応 -- でなく canvas 外をクリックした時に発生するよう変更
    _cursor_locked = false;
    
    // 描画モード終了
    _drawMode =　false;
    
    if (_currentCanvas.editMode == false)
        showLayerInfo(_currentCanvas);
}

function deselectAnotherLayers(){
    // 他のレイヤーの選択を解除
    // 他のレイアーの editMode があれば解除
    for (id in _layers){
        var canvas = layerForId(id);
        if (canvas == _currentCanvas) continue;
        
        canvas.editMode = false;
        canvas.style.border = "none";
    }
}

var _startX;
var _startY;
var _lineStartX;
var _lineStartY;
var _mouse_down;
function mouse_down(evt){
    if (!_mouse_down){
        _mouse_down = true;
        
        // マウスが押された時のレイヤー上の位置を記憶
        _startX = evt.offsetX;
        _startY = evt.offsetY;
    }
    
    if (_lineStart){
        _lineStart = false;
        
        // Line の描画開始位置を記憶
        _lineStartX = evt.offsetX;
        _lineStartY = evt.offsetY;
    }
}
function mouse_up(evt){
    _mouse_down = false;
}
function mouse_move(evt){
	// マウスでパネルのタイトルを掴み移動させる
	/*** マウス座標をデバッグ領域へ リアルタイムに表示 ***
    if (_mouse_down){
        var st = "offsetX: "+ evt.offsetX + " clientX:" + evt.clientX + " _startX:" + _startX + "<br>";
        st += "offsetY: "+ evt.offsetY + " clientY:" + evt.clientY + " _startY:" + _startY;
        //st += "<br>_cursor_locked->" + _cursor_locked + " _currentCanvas:" + _currentCanvas;
        elmFor("_debug").innerHTML = st;
    }
     *********************************************/
    
    if (!_cursor_locked) return;
    
    // レイヤーの左上端を指定位置へ移動
	if (!isDrawType(_currentCanvas.type) || !_currentCanvas.editMode){
		_currentCanvas.style.left = evt.clientX - _startX; // 表示するx座標
		_currentCanvas.style.top = evt.clientY - _startY; // 表示するy座標
        
        // saveImage() のために canvas 左上端の xy 座標を記憶
		_currentCanvas.x = evt.clientX - _startX - _canvasBasePos.x;
		_currentCanvas.y = evt.clientY - _startY - _canvasBasePos.y;
	}
}

///// CANVAS をマウス・ドラッグで移動 //////////////////////////////
////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////
///// レイヤーの取り扱い //////////////////////////////////////////

var _layers;
function setLayers(array){
    _layers = array;
}
function setLayer(can){
    // 画像を持つ CANVAS レイヤーを配列に記憶
    if (!_layers) _layers = new Array();
    
    _layers[can.id] = can;
}
function layerForId(id){
    // id に対応する CANVAS レイヤーを返す
    return _layers[id]
}

function unselectLayer(){
    // レイヤーを非選択にする
    // 編集モードを抜ける
    _currentCanvas.style.border = "none";
    _currentCanvas.editMode = false;
    showLayerInfo();
}

function removeLayer(targetId){
    // targetId のレイヤーを削除して CANVAS を再表示
    var records = new Object();
    var index = 1;
    _canvasNum = 0;
    for (id in _layers){
        var can = _layers[id];
        if (id == targetId){
            // canvas をクリア
            var context = can.getContext("2d");
            context.clearRect(0, 0, can.width, can.height);
            continue;
        }
        
        // removeLayer() を命令したレイヤー以外を描画
        can.id = _canvasNum; // id を打ち直す
        can.index = can.style.zIndex = index++; // レイヤーを表示する階層を設定
        records[_canvasNum++] = can;
    }
    // 削除したレイヤーは最下層に置きインアクティブとする
    var can = _layers[targetId];
    can.index = can.style.zIndex = 0; // レイヤーを表示する階層を設定
    can.style.width = 0;
    can.style.height = 0;
	can.setAttribute("onmousedown", ""); 
	can.setAttribute("onmouseup", ""); 
    // 選択枠やコントローラを消去
    can.style.border = "none";
    showLayerInfo();
    
    setLayers(records);
}

///// レイヤーの取り扱い //////////////////////////////////////////
////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////
///// DRAW TOOLS ///////////////////////////////////////////////

var toolTypes = ["Pen","ToothPaste","Line","Text", "Image"];
var _toolType = toolTypes[0]; // default 値
var colorList = {
	"black"   : {"r":0,"g":0,"b":0},
	"blue"    : {"r":0,"g":0,"b":255},
	"red"     : {"r":255,"g":0,"b":0},
	"orange"  : {"r":255,"g":165,"b":81},
	"magenta" : {"r":255,"g":0,"b":255},
	"green"   : {"r":0,"g":255,"b":0},
	"cyan"    : {"r":0,"g":255,"b":255},
	"yellow"  : {"r":255,"g":255,"b":0},
	"white"   : {"r":255,"g":255,"b":255}
}
function color(name, noAlpha){
    // 色を返す
    var obj = colorList[name];
    if (noAlpha)
        return "rgb(" + obj.r + "," + obj.g + "," + obj.b + ")";
    else
        return "rgba(" + obj.r + "," + obj.g + "," + obj.b + "," + alpha() + ")";
}

function setToolType(type){
    // 道具を選択
    _toolType = type;

    var elm = elmFor("canvasBaseArea");
    _canvasBasePos = getPosition(elm); // このあたりで取得しないと正確に取得できない

    if (isDrawType(type)){
        var can = makeFirstCANVAS(500, 500); // 呪文な大きさで作成
        can.addEventListener("mousemove", draw, true);
        can.type = type;
        can.empty = false;
        // 画像の表示位置を調整
        adjustCanvasPosition(can);
    } else if (_toolType == "Text"){
        var st = prompt("文字を入力");
        if (st.length == 0) return;
        
        setText(st); // 文字入力パネルを表示
        var can = makeFirstCANVAS(600, 220); // 呪文な大きさで作成
        can.type = type;
        drawText(can, text());

        // 画像の表示位置を調整
        adjustCanvasPosition(can);
    } else if (_toolType == "Image"){
        var width = 400;
        var height = 200;
        var can = makeFirstCANVAS(width, height); // 画像をドロップするエリアを表示
        can.type = type;
        can.style.border = "thin solid #ccc";
        can.style.backgroundColor = "#fff";
        
        // CANVAS に文字を表示しておく
        var context = can.getContext("2d");
        context.font = "12px 'Times New Roman'";
        context.textAlign = "center"; // width / 2 を中心にする
        context.fillText("ここに画像をドロップ", width / 2, height / 2 + 6); 
        
        // 画像の表示位置を調整
        adjustCanvasPosition(can);
    } else {
        // インジケータにペンサイズを表示
        showIndicator();
    }
    
    if (can){
        // 新規レイヤーを手前に移動
        pullLayer(can.id);
        showLayerInfo(can);
    } else {
        showLayerInfo();
    }
    
    // 道具選択ボタンを再描画
    showToolSelector();
    
    function adjustCanvasPosition(can){
        _currentCanvas = can;

        // canvas 位置を初期位置に調整
        can.x = 20;
        can.y = 140;
        can.style.left = can.x + "px";
        can.style.top = can.y + "px";

        // saveImage() のために canvas 左上端の xy 座標を記憶
		can.x = can.x - _canvasBasePos.x; // 表示するx座標
		can.y = can.y - _canvasBasePos.y; // 表示するy座標
    }
}
function toolType(){
    // 道具の種類を返す
    return _toolType;
}

var _oldX = 0;
var _oldY = 0;
function draw(e){
    // Pen や ToothPaste の軌跡を描く
    var can = _currentCanvas;
    if (!_cursor_locked) return;
    if (can.editMode == false) return;

    var context = can.getContext("2d");
    context.strokeStyle = penColor();
    
    // 描画位置を canvas のシフト距離から調整
    var left = can.style.left; // "120px" を "120" にする
    var top = can.style.top;
    var x = e.clientX - left.substr(0, left.length - 2);
    var y = e.clientY - top.substr(0, top.length - 2);

    if (toolType() == "Pen"){
        circle(context, x, y, penSize(), penColor());
        //  complement(x, y);
    } else if (toolType() == "ToothPaste"){
        // ドットをカーソルで移動させる：ドットの軌跡は以前描かれたものを削除しつつ移動
        circle(context, _oldX, _oldY, penSize() - 1.2, color("white"));
        circle(context, x, y, penSize(), penColor());
    } else if (toolType() == "Line"){
        // _lineStartX,_lineStartY から x,y へ線を引く
        // canvas を一旦クリア
        context.clearRect(0, 0, can.width, can.height);
        
        // 開始点の小円を描く
        var diameter = penSize() / 2;
        circle(context, _lineStartX, _lineStartY, diameter, penColor());
        // 線を描く
        context.strokeStyle = penColor();
        context.lineWidth = penSize() / 3;
        context.beginPath();
        context.moveTo(_lineStartX, _lineStartY);
        context.lineTo(x, y);
        context.closePath();
        context.stroke();
    }
    
    _oldX = x;
    _oldY = y;
}

var _text;
function setText(st){
    _text = st;
}
function text(){
    return _text;
}

var _penSize = 1.9;
function changePenSize(){
    // slider のノブが移動した
    _penSize = penSizeBar.value * 1;
    
    if (toolType() == "Text"){
        redrawText();
    } else if (toolType() == "Image"){
        var can = _currentCanvas;
        
        var scale = _penSize / 10;
        if (scale < 0.1) scale = 0.1; // 1/10 倍より小さくはならない
        if (scale > 3) scale = 3.0; // ３倍より大きくはならない
        
        var width = can.image.width * scale;
        var height = can.image.height * scale;
        draw_image(can, width, height);
    } else {
        showIndicator();
    }
}
function setPenSize(size){
    _penSize = size;
    
    // ペン・サイズのスライダーを size に調整
    penSizeBar.value = size;
}
function penSize(){
    return _penSize;
}

var _alpha = 1;
function changeAlpha(){
    // 透明度を変える
    _alpha = alphaBar.value * 1;
    
    if (toolType() == "Text") 
        redrawText();
    else
        showIndicator();
}
function setAlpha(val){
    _alpha = val;
    
    // 透明度のスライダーを val に調整
    alphaBar.value = val * 1;
}
function alpha(){
    // 透明度
    return _alpha;
}

var _penColor = "black";
function setPenColor(name){
    // カラーパレットから選択された色を penColor に設定
    _penColor = name;
    showColorPallete();
    
    if (toolType() == "Text"){
        redrawText();
    } else {
        showIndicator();
    }
}
function penColor(flag){
    if (flag){
        // 透明度を反映しない
        var obj = colorList[_penColor];
        return "rgb(" + obj.r + "," + obj.g + "," + obj.b + ")";
    } else {
        // 透明度を反映
        return color(_penColor);
    }
}
function colorName(){
    // "white" などの色名を返す
    return _penColor;
}

function showIndicator(){
    // pen の色やサイズを表示
    var can = document.getElementById("indCanvas");
    var context = can.getContext("2d");
    
    // canvas を一旦クリア
    var w = can.width;
    var h = can.height;
    context.clearRect(0, 0, w, h);
    
    // ペン・サイズを表す円を描く
    var startAngle = 0;
    var endAngle = 360 * Math.PI / 180;
    var x = w / 2;
    var y = h / 2;
    context.strokeStyle = "#ccc";
    context.fillStyle = penColor();
    context.beginPath();
    var size = penSize() * 1; // ペンのサイズを縮小して indicator に表示
    context.arc(x, y, size, startAngle, endAngle, false);
    context.fill();
    context.closePath();
    context.stroke();
}

function redrawText(){
    // 文字を透明度やカラーパレット選択に伴い再描画
    var can = _currentCanvas;
    var context = can.getContext("2d");
    
    // canvas を一旦クリア
    var w = can.width;
    var h = can.height;
    context.clearRect(0, 0, w, h);
    
    // 太さスライダーのサイズを元にフォント・サイズを返す
    // スライダー default 値 1.9 が 14pt になるように計算
    var size = Math.round(penSize() * 7.5);
    
    context.font = size + "px 'Times New Roman'";
    context.fillStyle = penColor();
    context.fillText(can.text, 0, 0);
    
    // ペンのサイズ・カラー・透明度を CANVAS に記憶
    putAttributeTo(can);
}

function putAttributeTo(can){
    // レイヤーの属性を CANVAS に記憶
    can.size = penSize();
    can.colorName = colorName();
    can.alpha = alpha();
}

function showToolSelector(){
    // 道具選択ボタンを表示
    var elm = elmFor("toolSelectorArea");
    elm.innerHTML = "";
    for (num in toolTypes){
        var type = toolTypes[num];
        var dv = newSPAN(elm, "");
        dv.innerHTML = type;
        dv.style.display = "inline";
        dv.style.padding = "0 10px";
        if (type == toolType())
            dv.setAttribute("class", "blueActiveButton");
        else
            dv.setAttribute("class", "blueButton");
        dv.setAttribute("onclick", "setToolType('" + type + "')");
    }
    var dv = newSPAN(elm, "/clearButton");
    dv.innerHTML = "白紙";
    dv.style.display = "inline";
    dv.style.padding = "0 10px";
    dv.setAttribute("onclick", "clearAllCanvas()");
}

function showColorPallete(){
    // カラーパレットを表示
    var elm = elmFor("colorPalleteArea");
    elm.innerHTML = "";
    
    for (name in colorList){
        var dv = newDIV(elm, "/colorChip");
        dv.innerHTML = "　　"; // 倍角スペース：これがないとカラーチップの幅がでない
        dv.style.backgroundColor = color(name, true);
        dv.style.display = "inline";
        dv.setAttribute("onclick", "setPenColor('" + name + "')");
        if (name == colorName()){
            dv.setAttribute("class", "selectedColorChip");
        }
    }
}

function drawText(can, text){
    // 文字を描く
    can.empty = false; // 文字が描画され drag できるようになる
    can.text = text; // text を CANVAS に記憶
    
    // 太さスライダーのサイズを元にフォント・サイズを計算
    // スライダー default 値 1.9 が 14pt になるように計算
    var fontSize = Math.round(penSize() * 7.5);
    
    var context = can.getContext("2d");
    context.font = fontSize + "px 'Times New Roman'";
    context.fillStyle = penColor();
    context.textAlign = "left";
    context.textBaseline = "top";
    context.fillText(text, 0, 0);

    // ペンのサイズ・カラー・透明度を CANVAS に記憶
    putAttributeTo(can);
}

function clearAllCanvas(){
    // キャンバスをすべてクリア
    if (confirm("すべての画像を削除します")){
        elmFor("canvasBaseArea").innerHTML = "";
        _canvasNum = 0;
        setLayers([]);
        showLayerInfo();
    }
}

///// DRAW TOOLS ///////////////////////////////////////////////
////////////////////////////////////////////////////////////////

function graffitiHelp(){
    // ヘルプを開く
	window.open("./graffitiHelp.html","Help"
				,"width=450,height=700,scrollbars=yes,resizable=yes");
}

var _canvasNum = 0;
function makeFirstCANVAS(width, height){
    // 画像ドロップする CANVAS を生成
    var elm = elmFor("canvasBaseArea");
    var canvasId = _canvasNum++; // レイヤー番号を設定
    var can = newCANVAS(elm, canvasId, width, height, null);
    can.empty = true;
    can.editMode = true;
    can.style.border = "thin solid #00f";
    can.style.backgroundColor = "transparent"; // browser によっては必要?
    can.style.position = "absolute";
    
    // CANVAS をマウスで掴み可動にする
	can.setAttribute("onmousedown", "cursor_lock(this)"); 
	can.setAttribute("onmouseup", "cursor_unlock()"); 
	can.setAttribute("onDblClick", "unselectLayer()"); 
    _currentCanvas = can;

    // レイヤーを配列に記憶
    setLayer(can);

    // 他のレイヤーの選択を解除
    deselectAnotherLayers();

    can.ondrop = function(e){
        // 画像がドロップされた時の処理
        graffitiDrop(e, can);
        e.preventDefault();
        
        can.empty = false; // 画像が描画された：drag できるようになる
    };
    
    can.ondragover=function(e){
        e.preventDefault();
    };
    
    return can;
}

function initGraffiti(){
    // 落書帳を初期化
    var elm = elmFor("base");
    elm.innerHTML = "";   

    //_initDebug(true); //##

    // HEADER ===============================
    var div = newDIV(elm, "/yellow-header");
    var dv = newDIV(div, "/left-side");
    dv.style.width = "80%";
    var sp = newSPAN(dv, "");
    sp.innerHTML = parent().patientId();
    sp.style.paddingLeft = "10px";
    var sp = newSPAN(dv, "");
    sp.innerHTML = parent().patientKanjiName();
    sp.style.paddingLeft = "5px";
    var sp = newSPAN(dv, "");
    sp.innerHTML = parent().currentDate();
    sp.style.paddingLeft = "15px";
    // --- ヘルプ・アイコン
    var dv = newDIV(div, "/right-side");
    var sp = newSPAN(dv, "");
    sp.innerHTML = gr_version();
    sp.style.padding = "0 10px";
    sp.style.color = "#888";
    var im = newIMAGE(dv, "", "./help.png", "?");
    im.setAttribute("onclick", "graffitiHelp()");
    im.style.height = "18px";
    im.setAttribute("class", "expandIcon");
    
    // CONTROLLER ===========================
    var carea = newDIV(elm, "controllerArea/clearfix");
    carea.style.border = "thin solid #ccc";
    // PEN SIZE INDICATOR -------------------
    var height = _controlAreaHeight;
    var dv = newDIV(carea, "/left-side");
    dv.style.padding = "0";
    dv.style.width = height + "px";
    dv.style.height = height + "px";
    var cvs = newCANVAS(dv, "indCanvas", height, height, null);
    cvs.style.backgroundColor = "transparent"; // browser によっては必要?
    showIndicator(); // ペン・サイズ初期値を表示
    // CONTROLLER ---------------------------
    var cdiv = newDIV(carea, "/left-side");
    cdiv.style.width = _controlAreaWidth + "px";
    cdiv.style.height = _controlAreaHeight + "px";
    cdiv.style.fontSize = "9pt";
    cdiv.style.border = "thin solid #ccc"; //##
    // SPACER
    var div = newDIV(cdiv, "");
    div.style.height = "5px";
    // FIRST CONTROLLER -------------
    var div = newDIV(cdiv, "");
    // ペンのサイズ
    var sp = newSPAN(div, "");
    sp.innerHTML = "太さ";
    var sp = newSPAN(div, "penSizeArea");
    var max = _sliderMax;
    var min = _sliderMin;
    newSlider(sp, "penSizeBar", 0.1, penSize(), max, min, "changePenSize()");
    // 透明度 
    var sp = newSPAN(div, "");
    sp.innerHTML = "透明度";
    sp.style.paddingLeft = "10px";
    newSlider(div, "alphaBar", 0.01, alpha(), 1, 0.01, "changeAlpha()");
    // SECOND CONTROLLER -----------
    var div = newDIV(cdiv, "");
    div.style.display = "inline";
    var sp = newSPAN(div, "");
    sp.innerHTML = "色　";
    // COLOR PALLETE
    var sp = newSPAN(div, "colorPalleteArea");
    showColorPallete();
    // THIRD CONTROLLER -------------
    var div = newDIV(cdiv, "/clearfix");
    div.style.marginTop = "5px";
    var sp = newSPAN(div, "");
    sp.innerHTML = "道具";
    var sp = newSPAN(div, "toolSelectorArea");
    sp.style.paddingLeft = "10px";
    showToolSelector();
    // FOURTH CONTROLLER -----------
    var div = newDIV(cdiv, "");
    div.style.display = "inline";
    var sp = newSPAN(div, "layerPopArea");
    sp.style.paddingRight = "3px";
    var sp = newSPAN(div, "layerInfoArea");
    sp.style.color = "#00f";
    sp.style.fontSize = "9pt";
    // BUTTON AREA ---------------------------
    var bdiv = newDIV(carea, "/right-side");
    var div = newDIV(bdiv, "");
    div.style.paddingTop = "60px";
    var bt = newDIV(div, "/fixButton");
    bt.innerHTML = "保存";
    bt.setAttribute("onclick", "saveImage()");

    // CANVAS AREA ----------------
    var div = newDIV(elm, "canvasBaseArea");
    
	window.onmousemove = mouse_move; // マウスの位置を取得するようにする
	window.onmousedown = mouse_down; // マウスの位置を取得するようにする
	window.onmouseup = mouse_up; // マウスの位置を取得するようにする

    // マウス・クリックによる位置決めエリア =======
    var div = newDIV(elm, "backgroundArea");
    div.style.border = "thin solid #ccc";
    div.style.height = "600px";
}

function gr_version(){
    return "Ver.140414";
}
