
var _checkList;
function setCheckList(obj){
    _checkList = obj;
}
function checkList(){
    // {"name":{"code":40,"disease":"病名"},,} 型式のオブジェクト
    return _checkList;
}
function recordForName(name){
    // 診療行為名に対応する コード・病名 のレコードを返す
    return _checkList[name];
}

var _currentName;
function setCurrentName(name){
    _currentName = name;
}
function currentName(){
    // 選択されている診療行為名を返す
    return _currentName;
}


//////////////////////////////////////////////////////////////////
///// 病名チェック機能 //////////////////////////////////////////////

function changedDisease(diseaseCellValue){
    // サーバの病名欄を読込みメモリー上のものを置換するとともに病名欄に表示
    //_initDebug(true); //##
    _debug("changedDisease->"+diseaseCellValue); //##

    var container = new Object();
    var tag = "ProgressSection.disease";
    container[tag] = encodeSTRING(diseaseCellValue);
    container["owner"] = owner();
    container["patientId"] = parent().patientId();
    container["entryDate"] = parent().currentDate();
    container["timeLimit"] = parent().timeLimit();
    var noaString = encodeObject(container);

    var worker = new Worker('./cellEditorWorker.js');
    worker.postMessage(noaString); // ### worker に命令書 noaString を送る ###
    
    worker.onmessage = function (event) {
        // ### worker の処理したデータを受け取る ###
        var answer = event.data; // ### worker からの返答 ###
        //alert("worker.onmessage->"+answer); //##
        
		var array = answer.split("<SEPARATOR>");
		if (array.length > 1){
            // サーバから返されたデータから tag, dateTime, value を取り出す
            var obj = JSON.parse(array[1]);
            
            var dateTime = parent().currentDate();
            if (obj.entryDate)
                dateTime = obj.entryDate;
            else
                alert("kickEditorWorker: obj.entryDate->"+obj.entryDate); //##
            
            var value = "";
            for (key in obj){
                // closeCellEditor() でサーバへ送った key を基に処理
                if (key == "owner") continue;
                else if (key == "patientId") continue;
                else if (key == "timeLimit") continue;
                else if (key == "entryDate") continue; // dateTime = obj[key];
                else {
                    tag = key;
                    value = obj[key];
                    value = convertSTRING(value, '\n', '<br>');
                    //alert(tag+"->"+dateTime+"->"+value);//##
                    
                    parent().showCellValue(value, dateTime, tag);
                }
            }
		}
    }
}
function doCheckDiseases(){
    // 診療行為と病名の突き合わせ処理を実行
    //_debug("checkList->"+encodeObject(checkList())); //##
    
    // 診療行為をスキャンし、チェックリストに同じ行為がないか探す
    var items = new Array(); // チェック対象となる診療行為の配列
    var array = treatmentArray();
    for (num in array){
        var rec = array[num]; // 診療行為名：rec.name コード：rec.code
        //alert("rec->"+encodeObject(rec)); //##
        if (rec.isOwn * 1 > 0) continue; // 自費はスキップ
        
        for (name in checkList()){
            if (name == rec.name){
                // 診療行為に対応する病名があった
                items.push(name);
                break;
            }
        }
    }
    // 処方欄をスキャンし、チェックリストに同じ薬剤がないか探す
    var obj = parent().valueForTag("ProgressSection.prescription");
    var buff = obj.value;
    if (buff.indexOf("自費") < 0){ // 自費処方はノーチェック
        buff = convertSTRING(buff, "\n", "<br>");
        buff = convertSTRING(buff, "</span>", "<br>");
        var array = buff.split("<br>");
        for (num in array){
            var ln = array[num];
            if (ln.indexOf("---") >=0) continue; // 用法行はスキップ
            var ary = ln.split('('); // "薬剤名(投与量)" 型式以外はスキップ
            if (ary.length == 1) continue; // 薬剤名のみ取り出す
            
            var medicine = trim(ary[0]);
            for (name in checkList()){
                if (name == medicine){
                    // 診療行為に対応する病名があった
                    items.push(name);
                    break;
                }
            }
        }
    }
    if (items.length == 0) return; // 病名チェック不要
    
    // 病名欄で対応病名のいずれかの有無をチェック
    var obj = parent().valueForTag("ProgressSection.disease");
    var diseaseCellValue = obj.value;
    
    //_initDebug(true); //##
    _debug("病名欄->"+diseaseCellValue); //##
    
    var records = new Object(); // 新規追加すべき病名：重複を避けるため配列でなくオブジェクト
    for (num in items){
        var name = items[num]; // 診療行為名
        _debug("name->"+name); //##
        var rec = recordForName(name);
        var found = false;
        var ary = rec.disease.split(',');
        for (n in ary){
            var disease = ary[n];
            _debug(n+" -> "+disease); //##
            if (diseaseCellValue.indexOf(disease) >= 0)
                found = true; // 病名欄に name に対応する病名があった
        }
        
        // 対応病名がひとつも無ければ対応病名群から選択させる
        if (! found){
            var url = "vinCheckDialog.html";
            var options = "dialogWidth=300px;dialogHeight=200px;center=1;status=1;scroll=1;";
            var obj = new Object();
            obj.title = name + " に対応する病名を選択";
            obj.menus = ary;
            var returnValue = showModalDialog(url, obj, options);
            
            // 追加すべき病名を箇条書きにしておく
            if (returnValue) records[trim(returnValue)] = "";
        }
    }
    
    // 重複防止のためのオブジェクトを配列へ戻す
    var newDiseases = []; // 新規に追加すべき病名の配列
    for (name in records){
        newDiseases.push(name);
    }
    if (newDiseases.length == 0) return; // 追加すべき病名がなかった
    _debug("newDiseases->"+newDiseases); //##


    // 各病名に年月日をつける
    var array = new Array();
    var yymmdd = shortDate(parent().currentDate());
    for (num in newDiseases){
        array.push(yymmdd + " " + newDiseases[num]);
    }
    
    // 「病名欄」内容にこれらの病名を追加
    for (num in array)
        diseaseCellValue += "\n" + array[num];
    _debug("diseaseCellValue：\n"+diseaseCellValue); //##
    
    // diseaseCellValue をサーバの病名欄に収納
    // 編集内容をサーバへ保存
    var pid = parent().patientId();
    var dateTime = parent().currentDate();
    var timeLimit = parent().timeLimit();
    var tag = 'ProgressSection.disease';
    
    // この後の診療欄保存と contamination を生ずるので worker でマルチスレッド処理
    changedDisease(trim(diseaseCellValue));
}

///// 病名チェック機能 //////////////////////////////////////////////
//////////////////////////////////////////////////////////////////



function saveCheckList(){
    // 診療行為と病名のセットをサーバへ保存
    var name = elmFor("checkItemPop").value; // 診療行為名
    var disease = elmFor("diseaseF").value; // 病名
    
    // diseases から空アイテムや空文字を除去
    var newArray = Array();
    var array = disease.split(',');
    for (num in array){
        var st = trim(array[num]);
        if (st.length) newArray.push(st);
    }
    disease = newArray.join(',');
    
    NRPutDiseaseToPriceList(name, disease, showCheckList);
}

function removeCheckList(name){
    // 診療行為と病名のセットを削除
    if (confirm(name + " を削除していいですか"))
        NRRemoveDiseaseFromPriceList(name, openCalcChecker);
}

function showDisease(answer){
    // サーバから返された病名を病名欄に表示
//    alert("showDisease->"+answer); //##
    elmFor("diseaseF").value = answer;
}
function selectedCheckItem(elm){
    // 診療行為ポップアップが選択された
    NRGetDiseaseFromPriceList(elm.value, showDisease);
}

function changeDiseaseSource(elm){
    // 過去履歴からの病名リストのチェックボックスが変更された
    if (elm.checked){
        var name = elmFor("checkItemPop").value; // 診療行為名
        
        var elm = elmFor("diseasePopArea");
        elm.innerHTML = "";
        var sp = newSPAN(elm, "");
        sp.innerHTML = "Loading ...";
        sp.style.fontSize = "9pt";
        sp.style.color = "#f00";

        // 過去１年間の全カルテ履歴から name とともに使われた病名を探して返す
        NRGetDiseaseFromHistory(name, gotDiseseHistory)
    } else {
        NRGetMenu(owner(), "ProgressSection.disease", gotDisesesMenu);
    }
}

function selectedDisease(elm){
    // 病名が選択された
    var ary = elm.value.split('(');
    var disease = ary[0]; // "不全流産($gw w)" を "不全流産" にする
    var ta = elmFor("diseaseF");
    var val = ta.value;
    if (val.length == 0)
        ta.value = disease;
    else
        ta.value = trim(val) + "," + disease;
}

function selectedDiseaseTag(disease){
    // 病名が選択された
    var ta = elmFor("diseaseF");
    var val = ta.value;
    if (val.length == 0)
        ta.value = disease;
    else
        ta.value = trim(val) + "," + disease;
}

function gotDiseseHistory(answer){
    // 過去履歴からの病名リストを表示
    var array = JSON.parse(answer);
    //_initDebug(true); //##
    //_debug("gotDiseseHistory->"+encodeObject(array)); //##
    
    // 以下の処理がどうしても PHP 側ではうまくいかないのでこちら側で処理
    var obj = new Object();
    for (num in array){
        var buff = array[num];
        if (! buff) continue;
        if (buff.length == 0) continue;
        _debug("-- "+num+" buff->"+buff); //##

        buff = convertSTRING(buff, '\n', '<br>');
        buff = convertSTRING(buff, '</span>', '<br>');
        var rows = buff.split('<br>');
        for (row in rows){
            var ln = trim(rows[row]); // "131202 切迫流産( w)" 形式
            if (ln.length == 0) continue;
            if (ln.indexOf("style=") >= 0) continue;
            
            var ary = ln.split(' ');
            if (ary.length > 1){
                var st = ary[1]; // "切迫流産( w)" 形式
                var ar = st.split('(');
                obj[ar[0]] = ""; // "切迫流産" 形式
            }
        }
    }
    _debug("obj->"+encodeObject(obj)); //##

    var elm = elmFor("diseasePopArea");
    elm.innerHTML = "";
    // 病名ポップアップ・メニューを生成
    var div = newDIV(elm, "");
    var ul = newUL(div, "");
    ul.setAttribute("class", "listMembers");
    for (key in obj){
        if (key.length == 0) continue;
        
        var li = newLI(ul, key);
        li.setAttribute("class", "blueButton");
        li.setAttribute("onclick", "selectedDiseaseTag('" + key + "')");
    }
}
function gotDisesesMenu(answer){
    var obj = JSON.parse(answer);
    //_initDebug(true); //##
    _debug("gotDisesesMenu->"+encodeObject(obj)); //##
    
    var menus = [""];
    for (num in obj){
        var rec = obj[num];
        if (rec.menu.length){
            menus.push(rec.menu);
        }
    }
    
    var elm = elmFor("diseasePopArea");
    elm.innerHTML = "";
    // 病名ポップアップ・メニューを生成
    var div = newDIV(elm, "");
    var pm = newPopupMenu(div, "diseasePop", menus, "");
    pm.setAttribute("onchange", "selectedDisease(this)");
}

function got_item_meu(){
	// アイテムリストを表示する
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
		var array = value.split("<SEPARATOR>");
		if (array.length > 1){
			// "itemSelectorArea" の上にポップアップメニュー生成
			var obj = JSON.parse(array[1]);
            //alert("got_item_meu->"+encodeObject(obj)); //##
            
			// obj は {"再診料":"saishin",,} のようなオブジェクトの配列
			var items = [""];
			for (title in obj){
                if (title.length == 0) continue;
                
				items.push(title);  // title:"再診料"
			}
            
			// 病名入力エリア
			var elm = document.getElementById("diseaseArea");
			elm.innerHTML = "";
            
			// item 選択ポップアップを表示
			var pu = newPopupMenu(elm, "checkItemPop", items, currentName());
            pu.setAttribute("onchange", "selectedCheckItem(this)");
            
            // コメント
            var sp = newSPAN(elm, "");
            sp.innerHTML = "に対応する病名を以下で選択ください（複数選択可）";
            sp.style.fontSize = "9pt";
            sp.style.color = "brown";
            
            // チェックボックスを生成
            var div = newDIV(elm, "");
            var cb = newCHECKBOX(div, "", "過去履歴から病名を選択", 0);
            cb.setAttribute("onchange", "changeDiseaseSource(this)");
            cb.style.fontSize = "9pt";

            // 病名ポップアップ
            var div = newDIV(elm, "diseasePopArea");
            
            // 対応病名欄
            var div = newDIV(elm, "");
            var value = "";
            var ta = newTEXTAREA(div, "diseaseF", 30, 5, value);
            ta.style.fontSize = "10pt";
            
            if (currentName().length){
                // 診療行為名が指定されているなら対応病名を表示
                var obj = recordForName(currentName());
                ta.value = obj.disease;
            }
            
            NRGetMenu(owner(), "ProgressSection.disease", gotDisesesMenu);
		}
	}
}
function get_item_meu(code){
	// 診療行為マトリックスの選択で起動され、該当アイテムリストをリクエスト
	xmlHttpObject = createXMLHttpRequest(got_item_meu);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var st = "./vinServer.php?command=GET_CHILD_SELECTOR&value="+code;
		//alert("get_item_meu->"+st); //##
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

function openCheckEditor(td, name){
    // 行為エディターを開く
    
    // name があれば記憶しておく
    setCurrentName((name) ? name : "");

    var elm = elmFor("contentsArea");
    elm.innerHTML = "";
    var base = newTD(elm, "editorNode", "");

    base.setAttribute("colspan", "2");
    base.style.border = "thin solid #ccc";
    base.style.padding = "3px";
    base.style.backgroundColor = "#ffe";
    
    // 診療行為マトリックスを表示
    // obj = 一括(00) 初診(11) 再診(12) 診他(13) 内服(21) 屯服(22) 外用(23) 薬加(29) 皮注(31) 静注(32) 点滴(33) 処置(41) 処薬(48) 手術(51) 麻酔(52) 手薬(58) 検査(60) 判断(69) 画像(70) 其他(80) 入院(90) 入他(91)
    var div = newDIV(base, "");
    var ul = newUL(base, "");
    ul.setAttribute("class", "listMembers");
    
    var li = newLI(ul, "");
    li.style.display = "inline";
    li.style.paddingRight = "5px";
	var im = newIMAGE(li, "", "./close.png", "X");
	im.style.height = "12px";
    im.setAttribute("class", "expandIcon");
    im.setAttribute("onclick", "openCalcChecker()");

    var obj = medicalActions().itemMatrix; // vin.js
    for (key in obj){
        var code = obj[key];
        if (code * 1 == 0) continue;
        if (code.substr(0, 1) * 1 == 1) continue;
        if (code * 1 == 29) continue;
        if (code * 1 == 48) continue;
        if (code * 1 == 58) continue;
        if (code * 1 == 69) continue;
        if (code * 1 == 80) continue;
        if (code.substr(0, 1) * 1 == 9) continue;
        
        var li = newLI(ul, key);
        li.setAttribute("id", "item:"+code);
        li.setAttribute("class", "blueButton");
        li.setAttribute("onclick", "get_item_meu('" + code + "')");
    }
    
    // 病名入力エリア
    var div = newDIV(base, "diseaseArea");
    
    var div = newDIV(base, "");
    div.style.marginTop = "10px";
    div.style.marginBottom = "10px";
    div.style.textAlign = "right";
    if (name){
        var bt = newDIV(div, "/fixBUtton");
        bt.innerHTML = "削除";
        bt.setAttribute("onclick", "removeCheckList('" + name + "')");
    }
    var bt = newDIV(div, "/fixBUtton");
    bt.innerHTML = "確定";
    bt.setAttribute("onclick", "saveCheckList()");

    // name があれば name に相当するコントロールを表示
    if (name){
        var obj = recordForName(name);
        get_item_meu(obj.code);        
    }
}

function checkerHelp(){
	var win = window.open("./vinCalcCheckerHelp.html","Help"
						  ,"width=450,height=700,scrollbars=yes,resizable=yes");
	win.focus();
}

function showCheckList(answer){
    // チェックリストを表示
    if (answer){
        var obj = JSON.parse(answer);
        setCheckList(obj);
    } else {
        var obj = checkList(); // vin.js 立ち上げ時に読み込まれている
    }
    
    //_initDebug(true); //##
    _debug("showCheckList->"+encodeObject(obj)); //##
    
    var elm = elmFor("contentsArea");
    elm.innerHTML = "";
    var tbl = newTABLE(elm, "", "");
    tbl.style.fontSize = "9pt";
    tbl.style.width = "100%";
    
    // HEADER ==============================
    var tr = newTR(tbl, "", "");
    var td = newTD(tr, "/checkerTitleLabel", "診療行為");
    td.style.width = "30%";
    var td = newTD(tr, "/checkerTitleLabel", "対応病名");

    // LIST ================================
    for (name in obj){
        var rec = obj[name];
        var disease = rec.disease;
        
        var tr = newTR(tbl, "", "");
        var td = newTD(tr, "/checkerLabel", name);
        td.setAttribute("onclick", "openCheckEditor(this,'" + name + "')");
        var td = newTD(tr, "/checkerValue", disease);
    }

    // FOOTER ==============================
    var tr = newTR(tbl, "", "");
    // 追加ボタン
    var td = newTD(tr, "/checkerLabel", "");
    td.setAttribute("onclick", "openCheckEditor(this)");
	var im = newIMAGE(td, "", "./add-field.png", "?");
	im.style.height = "14px";
	im.style.position = "relative";
	im.style.top = "3px";
    var sp = newSPAN(td, "");
    sp.innerHTML = "追加";
    sp.style.paddingLeft = "5px";
    // チェック・ボックス
    var td = newTD(tr, "/checkerTitleLabel", "");
    var cb = newCHECKBOX(td, "", "診療費計算で病名チェック", checkDiseases());
    cb.setAttribute("onchange", "setCheckDiseases(this)");
    cb.style.fontSize = "9pt";
}

function openCalcChecker(){
    // 診療行為と病名の突合チェッカーを開く
    var w = 320;
	var x = 5; // 表示するx座標
	var y = 5; // 表示するy座標
    var title = "病名チェッカー";
    var elm = openSeeThroughPanel("_floatPanel", x, y, w, title, "checkerHelp()");
    if (!elm){
        alert("_floatPanel がないのでパネルを表示できません"); return;
    }
    elm.style.padding = "3px";
    var div = newDIV(elm, "contentsArea");
    div.style.backgroundColor = "#fff";
    div.style.borderRadius = "5px";
    
    showCheckList();
}

