
function owner(){
	return document.getElementById("_owner").value;
}

var _isDebugMode;
function setDebugMode(elm){
	_isDebugMode = (elm.checked) ? true : false;
	//document.getElementById("message").innerHTML = _isDebugMode;
}
function debugMode(){
	return _isDebugMode;
}

var _eid;
function setEditorId(id){
	_eid = id;
}
function editorId(){
	return _eid;
}
function editorIdForTag(tag, menu){
	return tag+"^"+menu;
}
function editorIdForRow(row){
	return "editor."+row;
}

var _userList;
function setUserList(obj){
	_userList = obj;
}
function userList(){
	// ユーザ名の配列 ["ohashi":"大橋克洋",,,]
	return _userList;
}
function userLognames(){
	// ["ohashi",,]
	var array = [""];
	for (loginame in _userList){
		array.push(loginame);
	}
	return array;
}



/////////////////////////////////////////////////////////
/// Ajax による処理 ///////////////////////////////////////

function gotUserList(answer){
    //alert("gotUserList->"+answer); //##
    var obj = JSON.parse(answer);
    //alert("gotUserList: obj->"+encodeObject(obj)); //##
    
    setUserList(obj);
    showUserSelector();
    showMessageBar("");
}
function selectUserAndLoadStructure(){
	// ユーザを選択し、そのユーザ用の structure を load
    _callServer("GET_USER_LIST", "sysServer.php", null, gotUserList);
}

function removedBackupFile(answer){
    alert(answer); // 削除メッセージ
}
function removeBackupFile(target){
    // 現在選択されているバックアップ・ファイルをサーバから削除
    var elm = document.getElementById("userPopup"); // PriceList では null
    var args = new Object();
    args["owner"] = (elm) ? elm.value : "";
    args["target"] = target;
    args["filename"] = document.getElementById("filePop").value;
    
    _callServer("REMOVE_BACKUP", "sysServer.php", args, removedBackupFile);
}

/// Ajax による処理 ///////////////////////////////////////
/////////////////////////////////////////////////////////

function suser(){
    if (window.event.shiftKey){
        var elm = document.getElementById("markArea");
        
        if (elm.innerHTML.length > 0)
            elm.innerHTML = "";
        else
            elm.innerHTML = "* ";
    }
}
function isSuser(){
    var elm = document.getElementById("markArea");
    return (elm.innerHTML.length > 0) ? true : false;
}

function showMessageBar(msg){
    document.getElementById("message").innerHTML = msg;
}

function showController(label){
    // 検索・削除・追加などのボタン行を生成
    //alert("showController->"+label); //##
    var elm = document.getElementById("controlArea");
    elm.innerHTML = "";
    var div = newDIV(elm, "controlSubArea");
    var tbl = newTABLE(div, "/base-table");
    tbl.style.fontSize = "10pt";
    
    // comment
    var tr = newTR(tbl, "", "");
    var td = newTD(tr, "controls", label);
    td.style.paddingLeft = "10px";
    td.style.paddingBottom = "5px";
    var tx = newTEXT(td, "　");
    var fd = newFIELD(td, "keyF", "", "20", "");
    fd.setAttribute("onchange", "find()"); // menuTable.js などに実装
    fd.focus();
    
    var bt = newBUTTON(td, "", "検索");
    bt.setAttribute("onclick", "find()");
    
    // 新規レコード追加ボタン
    var bt = newBUTTON(td, "", "新規レコードを追加");
    bt.setAttribute("onclick", "showNewEditor()");
    
    // 削除ボタン
    var bt = newBUTTON(td, "", "チェックしたレコードをすべて削除");
    bt.setAttribute("onclick","removeCheckedRecords()");
    
    // resultArea
    var tr = newTR(tbl, "", "");
    var td = newTD(tr, "resultArea", "");
    var sp = newSPAN(td, "");
    sp.innerHTML = " しばらくお待ちください...";
    sp.style.fontSize = "9pt";
    sp.style.color = "#00f";
}

function showUserSelector(){
	// ユーザ名の選択ポップアップを生成
	// obj = ["ohashi":"大橋 克洋",,]
	var elm = document.getElementById("userListArea");
	elm.innerHTML = "";
	var array = userLognames();
	array.push("public");
	var pu = newPopupMenu(elm, "userPopup", array, "");
    pu.setAttribute("onchange","userSelected(this)");
    
    // データソース・ポップアップを生成
    userSelected(pu);
}
function userSelected(elm){
	// ユーザポップアップが選択された
	var logname = elm.value;
	if (logname.length == 0){
		showSourceSelector(["テンプレート"]);
	} else {
		showSourceSelector(["データベース","バックアップ"]);
	}
    document.getElementById("fileNamesArea").innerHTML = "";
    document.getElementById("removeButtonArea").innerHTML = "";
}

function sourceSelected(elm){
    // バックアップが選択された場合、バックアップリストを表示
    if (elm.value == "バックアップ")
        // バックアップ・ファイルのリストを読込みポップアップ・メニューを生成
        loadBackupedArchive();
    else {
        document.getElementById("fileNamesArea").innerHTML = "";
        document.getElementById("removeButtonArea").innerHTML = "";
    }
}
function showSourceSelector(array){
    // データソース選択ポップアップを生成
    var elm = document.getElementById("sourceListArea");
    elm.innerHTML = "";
    //alert("showSourceSelector->"+elm); //##

    var pu = newPopupMenu(elm, "sourcePopup", array, "");
    pu.setAttribute("onchange", "sourceSelected(this)");
}

function userSelected2(elm){
	// セーブエリアのユーザポップアップが選択された
	var logname = elm.value;
	if (logname.length == 0){
        if (isSuser())
            showSourceSelector2(["テンプレート"]);
        else
            showSourceSelector2([]);
    } else {
		showSourceSelector2(["バックアップ","データベース"]);
    }
}

function showSourceSelector2(array){
	// データソース選択ポップアップを生成
	var td = document.getElementById("sourcePopup2Area");
	td.innerHTML = "";
	if (array.length){
		var tx = newTEXT(td, " の ");
		var pu = newPopupMenu(td, "sourcePopup2", array, "");
		pu.setAttribute("onchange","sourceSelected2(this)");
		var tx = newTEXT(td, " へ ");
		var bt = newBUTTON(td, "", "書込む");
		bt.setAttribute("onclick","save()");
		document.getElementById("saveCheckArea").innerHTML = "";
	}
}

function sourceSelected2(elm){
	// セーブする先が選択された
	var td = document.getElementById("saveCheckArea");
	td.innerHTML = "";
	
	var item = elm.value;
	if (item == "データベース"){
		var label = "データベースを上書き";
		var cb = newCHECKBOX(td, "isOverWrite", label, 0);
	}
}

function showSaveButtons(){
	// 保存ボタンを表示
	var elm = document.getElementById("saveButtonArea");
	elm.innerHTML = "";
	
    // ユーザリストを表示
    var array = userLognames();
    array.push("public");
    var pu = newPopupMenu(elm, "userPopup2", array, "");
    pu.setAttribute("onchange","userSelected2(this)");
    
    var sp = newSPAN(elm, "sourcePopup2Area");
    var tx = newTEXT(elm, " ");
    var sp = newSPAN(elm, "saveCheckArea");
    sp.style.fontSize = "10px";
    
    userSelected2(pu);
}

function closeEditor(){
	// レコード編集ペーンを閉じ、閉じたなら true を返す
    var elm = document.getElementById("newEditorArea");
    if (elm && elm.innerHTML.length){ // 新規レコードの場合
        elm.innerHTML = "";
        return true;
    }
    
	var eid = editorId();
	if (eid){
		var elm = document.getElementById(eid);
		if (elm && elm.innerHTML.length){
			elm.innerHTML = "";
			return true;
		}
    }
	return false;
}

function tableHelp(){
	window.open("./tableHelp.html","Help"
				,"width=450,height=700,scrollbars=yes,resizable=yes");
}


