
function patientId(){
    return elmFor("_patientId").value;
}

function copyIt(elm){
    // 選択された処方を診療入力ツールへコピー
    if (confirm("この内容を診療内容へ転記しますか")){
        var buff = elm.innerHTML;

        buff = convertSTRING(buff, "<div>", "");
        var records = buff.split("</div>");
        
        window.opener.putHistory(records);
        window.close();
    }
}

function gotVinHistory(answer){
    var obj = JSON.parse(answer);
    //alert("gotVinHistory->"+encodeObject(obj)); //##
    
    var elm = document.getElementById("contentsArea");
    elm.innerHTML = "";
    var tbl = newTABLE(elm, "");
    tbl.style.fontSize = "10pt";
    tbl.style.width = "100%";
    
    for (entryDate in obj){
        var rec = obj[entryDate];
        var tr = newTR(tbl, "", "");
        // 受診年月
        var td = newTD(tr, "", "");
        td.style.width = "85px";
        td.style.verticalAlign = "top";
        td.style.padding = "5px 10px";
        td.style.backgroundColor = "#aec";
        td.style.borderBottom = "thin solid #aaa";
        td.style.textAlign = "right";
        var dv = newDIV(td, "");
        dv.innerHTML = entryDate.substr(0,10);
        var dv = newDIV(td, "");
        dv.innerHTML = rec.owner;
        // 診療内容
        var td = newTD(tr, "/change-red", "");
        td.style.borderBottom = "thin solid #aaa";
        td.style.padding = "2px 10px";
        td.setAttribute("onclick", "copyIt(this)");
        var array = rec.treatment.split('\n');
        for (num in array){
            var st = array[num];
            var dv = newDIV(td, "");
            dv.innerHTML = st;
        }
    }
}

function vinHistoryHelp(){
    window.open("./vinHistoryHelp.html","Help"
                ,"width=450,height=700,scrollbars=yes,resizable=yes");
}

function initVinHistory(){
    var base = document.getElementById("base");
    base.innerHTML = "";
    var pframe = new PictureFrame(base, "80%", "80%");
    
    // HEADER ===========================================
    // -- LEFT ------------
    pframe.headerLeft.innerHTML = patientId() + " 診療入力 過去履歴";
    // -- RIGHT ----------
    // HELP
    var img = newIMAGE(pframe.headerRight, "", "Help.png", "Help");
    img.setAttribute("onclick","vinHistoryHelp()");
    img.style.width = "19px";
    img.setAttribute("class", "expandIcon");
    
    // docMaker BODY =====================================
    var div = pframe.body;
    div.setAttribute("id", "contentsArea");
    div.style.padding = "3px 0 5px 0";
    
    // FOOTER ==========================================
    pframe.footerLeft.innerHTML = version();
    
    
    var args = new Object();
    args["patientId"] = patientId();
    
    NRCall("GET_VIN_HISTORY", args, gotVinHistory);
}

function version(){
    // Development started at 2013-11-03.
    return "Ver.150925";
}

