

var _toolsObj; // ツール・エリアに開いたツールを登録
function addToolName(toolName){
    // _toolsObj にツールを登録
    // toolName の重複登録を避けるため Array() でなく Object() を使用
    if (!_toolsObj) _toolsObj = new Array();
    
    if (_toolsObj[toolName] == null){
        _toolsObj.push(toolName);
        //console.log("addToolName", toolName); //##
    }
    foldAllTools(toolName);
}
function foldAllTools(toolName){
    // 全てのツールを折り畳む
    //console.log("foldAllTools", toolName, _toolsObj); //##
  
    for (num in _toolsObj){
        var name = _toolsObj[num];
        if (name == toolName) continue; // 指定されたツールは折り畳まない
       
        var elm = elmFor(name);
        if (!elm) continue; // すでに削除されている場合がある
       
        if (elm.style.display != "none"){
            if (name == "insContentsArea")
                getInsurance();
            else
                elm.style.display = "none"; // 非表示
        }
    }

}

function clickedToolMenu(url, win){
    // TOOL MENU がクリックされた
    if (floatToolMenu())
        closeFloatPanel();
    
    kickMenuCell(url, win);
}

function showToolMenu(){
    // メニューを表示
    var elm = document.getElementById("toolMenuArea");
    elm.innerHTML = "";
    
    var menuRow;
    var array = toolMenus();
    for (num in array){
        var cell = array[num];
        if (cell.menuType * 1 != _tool) continue;
        if (cell.disabled * 1) continue;

        if (cell.subTitle * 1) {
            // グループ行とサブ・タイトルを生成
            // URL AREA
            menuRow = newDIV(elm, "/toolSection");
            menuRow.setAttribute("class", "clearfix");
            menuRow.style.padding = "2px 0";
            var bt = newDIV(menuRow, cell.id);
            bt.innerHTML = cell.label;
            // どういうわけか CSS がここでは機能しないので
            bt.style.float = "left";
            bt.style.fontSize = "9pt";
            bt.style.marginRight = "5px";
            bt.style.padding = "0 5px";
            bt.style.backgroundColor = "#ff8";
            bt.style.borderRadius = "10px";
            bt.style.border = "thin solid #aaa";
        } else {
            // メニュー項目を生成
            if (cell.url){
                if (! isSuperUser()){ // dataCenter.js
                    // superUser でなければ実行できないメニューをスキップ
                    if (cell.url.indexOf("layout.php") >= 0) continue;
                }
                
                // url による action を伴う
                if (!menuRow){
                    menuRow = newDIV(elm, "/toolSection");
                    var bt = newDIV(menuRow, cell.id);
                    bt.innerHTML = cell.label;
                    bt.style.float = "left";
                    bt.setAttribute("class", "toolLabel");
                }
                
                // メニュー・ボタン
                var bt = newDIV(menuRow, cell.id);
                bt.innerHTML = cell.label;
                bt.setAttribute("class", "blueButton");
                var action = "clickedToolMenu('"+cell.url+"','"+cell.window+"')";
                bt.setAttribute("onclick", action);
                bt.style.float = "left";
            } else {
                // label のみの表示
                var bt = newDIV(menuRow, cell.id);
                bt.innerHTML = cell.label;
                bt.setAttribute("class", "disabledButton");
                bt.innerHTML = cell.label;
            }
        }
    }
}

function openFloatTools(){
    // TOOL MENU を floating panel で開く
    var win = window.top.noa;
    var w = 250;
	var x = win.innerWidth - w - 30; // 表示するx座標
	var y = 35; // 表示するy座標
    var title = "TOOL MENU";
    var action = "openHelp('toolMenuHelp.html')";
    var panel = new FloatPanel("_floatPanel", x, y, w, title);
    if (!panel) return;
    var elm = panel.contents;
    
    makeToolMenu(elm);
}

function closeToolArea(status){
    // ProblemList と基本情報を開く
    elmFor("toolArea").innerHTML = ""; // toolArea を閉じる
    //console.log("closeToolArea", status); //##
    
    if (status) initBasicPage();
}

function openApp(url, isWindow){
    // url アプリを toolArea に iFrame として開く
    //console.log("openApp -- outputTarget",outputTarget()); //##

    if (isWindow){
        // ツールを外部ウインドウとして開く：サイズ指定で外部ウインドウが開く
        var win = window.open(url, "", "width=1000");
        win.focus();
    } else {
        // ツールを toolArea に開く
        var elm = elmFor("toolArea");
        elm.innerHTML = "";
        // iFrame のクローズ・アイコンを表示するバー
        var div = newDIV(elm, "/tool-handle");
        div.style.marginRight = "10px";
        div.style.paddingLeft = "10px";
        // CLOSE ICON
        var im = newIMAGE(div, "/expandIcon", "./close.png", "?");
        im.style.height = "10px";
        im.setAttribute("onclick", "closeTool()");
        // toggle button
        var bt = newDIV(div, "toggleButton/handleButton");
        bt.innerHTML = "ツールを開閉";
        bt.setAttribute("onclick", "toggleNode('iframeArea')");
        bt.style.marginLeft = "2px";
        // tools にツール・ネームを登録
        var tools = window.top.tools;
        tools.addToolName('iframeArea');
        
        // ### iframe は必ず window.top.noa と同じ window 上に置く必要あり ###
        // ### でないと、そこから派生したウインドウから parent() を取得できない ###
        var div = newDIV(elm, "iframeArea");
        var fr = newIFRAME(div, "iframe", url);
        fr.style.width = "100%";
        fr.style.height = "80%";

        // ProblemList を収縮
        foldProblem();
    }
}

function closeSubFrame(){
    // toolArea の subFrame を閉じる
    elmFor("subFrameArea").innerHTML = "";
}
function openSubFrame(url){
    // url アプリを toolArea の subFrameArea の iFrame に開く
    var elm = elmFor("subFrameArea");
    if (elm.innerHTML.length > 0){
        closeSubFrame();
        return;
    }
    elm.innerHTML = ""; 
    
    // ### iframe は必ず window.top.noa と同じ window 上に置く必要あり ###
    // ### でないと、そこから派生したウインドウから parent() を取得できない ###
    var fr = newIFRAME(elm, "iframe", url);
    fr.style.width = "100%";
    fr.style.height = "80%";
}

function openToolEditor(){
    // TOOL MENU 編集ツールを開く
    // NOA 本体側から呼ばれることがあるので tools を指定する必要あり
    var tools = window.top.tools;
    
    closeFloatPanel();
    tools.openApp("./toolEditor.php");
}

function checkedFloatBox(elm){
    // float チェックボックスが変更された
    setFloatToolMenu(elm);

    if (floatToolMenu()){  // localStorage.js
        elmFor("toolArea").innerHTML = "";
        parent().openFloatTools();
    } else {
        closeFloatPanel();
        
        var tools = window.top.tools;
        var elm = tools.document.getElementById("toolArea");
        elm.innerHTML = "";
        tools.makeToolMenu(elm);
    }
}

function gotTools(answer){
    // TOOL MENU 構造をサーバから受取り記憶
    //_debug("gotTools->"+answer); //##
    var obj = JSON.parse(answer);
    //_initDebug(true); //##
    _debug("gotTools->"+encodeObject(obj)); //##
    
    setToolMenus(obj);
    
    showToolMenu();
}
function makeToolMenu(elm){
    // TOOL MENU のコンテンツを生成
    elm.innerHTML = "";
    var pframe = new PictureFrame(elm, "70%", "45%");
    
    if (floatToolMenu()){
        pframe.header.style.display = "none"; // ヘッダー表示せず
    } else {
        // === HEADER =======================
        // --- LEFT SIDE ---
        var dv = pframe.headerLeft;
        var tl = newSPAN(dv, "");
        tl.innerHTML = "TOOL MENU";
        // --- RIGHT SIDE ---
        // HELP ICON
        var img = newIMAGE(pframe.headerRight, "/expandIcon", "./Help.png", "?");
        img.style.height = "17px";
        img.setAttribute("onclick", "toolMenutHelp()");
    }

    // === CONTENTS =====================
    var div = pframe.body;
    div.setAttribute("id", "toolMenuArea");
    div.style.padding = "5px";

    // === FOOTER =======================
    var div = pframe.footer;
    div.setAttribute("class", "clearfix");
    div.style.fontSize = "9pt";
    div.style.color = "#888";
    div.style.marginBottom = "5px";
    div.style.borderTop = "thin solid #ddd";
    // --- LEFT SIDE ---
    var dv = pframe.footerLeft;
    // check box
    var cb = newCHECKBOX(dv, "", "float", floatToolMenu());
    cb.setAttribute("onchange", "checkedFloatBox(this)");
    // HAMMER ICON
    if (isSuperUser()){
        var sp = newSPAN(dv, "");
        sp.style.paddingLeft = "5px";
        var img = newIMAGE(sp, "/expandIcon", "./hammer.png", "X");
        img.style.height = "14px";
        img.style.position = "relative";
        img.style.top = "2px";
        img.setAttribute("onclick", "openToolEditor()");
    }
    // --- RIGHT SIDE ---
    pframe.footerRight.innerHTML = toolVersion();
    
    var args = new Object();
    args["owner"] = owner();
    NRCall("GET_TOOL_MENU", args, gotTools);
}

function closeTool(){
    // TOOL AREA を閉じる：他のツールから使用
    var tools = window.top.tools;
    
    tools.closeToolArea();
}

function showTool(initTool){
    // toolArea に initTool で初期化される tool を開く
    var elm = document.getElementById("toolArea");
    elm.innerHTML = "";

    initTool(elm);
}

function initTools(){
    if (! floatToolMenu()){
        showTool(makeToolMenu);
    }
}

function toolVersion(){
    return "Ver.150728";
}

