
var _userObj;
function setUserObj(obj){
    _userObj = obj;
}
function user_names(){
    // 漢字氏名の配列を返す
    var array = new Array();
    for (logname in _userObj){
        var kanjiname = _userObj[logname];
        array.push(kanjiname);
    }
    return array;
}
function logname2kanjiname(name){
    // logname から漢字名を返す
    for (logname in _userObj){
        var kanjiname = _userObj[logname];
        if (logname == name) return kanjiname;
    }
    return null;
}
function kanjiname2logname(kanji){
    // 漢字氏名から logname を返す
    for (logname in _userObj){
        var kanjiname = _userObj[logname];
        if (kanjiname == kanji) return logname;
    }
    return null;
}

function makeMessagePopupMenu(obj){
    // メッセージ・ポップアップ・メニューを生成
    var items = [""];
    for (num in obj){
        var rec = obj[num];
        items.push(rec.menu);
    }
    items.push("...その他");
    
    var elm = document.getElementById("msgPopArea");
    elm.innerHTML = "";
    var pu = newPopupMenu(elm, "messagePopup", items, "");
    pu.setAttribute("onchange", "clickedMessageMenu(this)");
    
    // remove menu icon
    var sp = newSPAN(elm, "");
    sp.style.paddingLeft = "5px";
	var im = newIMAGE(sp, "", "./remove-field.png", "削除");
	im.style.height = "14px";
	im.style.verticalAlign = "middle";
	im.setAttribute("onclick", "removeMessageMenu()");
}

function gotMenuItems(answer){
    // 追加または削除後のメニューを受け取りポップアップメニューを更新
    //alert("== gotMenuItems->"+answer); //##
    var obj = eval('(' + answer + ')');
    //var obj = JSON.parse(answer);
    //alert("gotMenuItems->"+encodeObject(obj)); //##
    
    // obj を元にしたメッセージ・ポップアップ・メニューを作成
    makeMessagePopupMenu(obj);
}

function gotMessageMenu(answer){
    // メッセージ・メニューを受け取り表示
    var obj = eval('(' + answer + ')');
    //var obj = JSON.parse(answer);
    setUserObj(obj.userList);
    //console.log("== gotMessageMenu->"+encodeObject(obj)); //##
    
    // ===== メッセージ・ポップアップを生成 ======
    var elm = document.getElementById("messagePopupArea");
    elm.innerHTML = "";
    
    // SHELTER
	var sp = newSPAN(elm, "");
    sp.style.paddingLeft = "10px";
	var a = newA(sp, "縮小", "#", "");
	a.setAttribute("onclick", "takeShelter()");
    
    // 空欄にする
	var sp = newSPAN(elm, "");
    sp.style.paddingLeft = "10px";
	var a = newA(sp, "空欄にする", "#", "");
	a.setAttribute("onclick", "clearMessage()");
    
    // MESSAGE MENU
    var div = newDIV(elm, "msgPopArea"); // messagePopupMenu の構成基盤
    // obj を元にしたメッセージ・ポップアップ・メニューを作成
    makeMessagePopupMenu(obj.messageMenu);

    // ===== ユーザ・ポップアップを生成 =====
    var elm = document.getElementById("userPopArea");
    var sender = elm.innerText; // 安易な受け渡し方法
    var name = logname2kanjiname(sender);
    elm.innerHTML = "";
	var pu = newPopupMenu(elm, "userNamePopup", user_names(), name);
}

function removeMessageMenu(){
    // MESSAGE MENU の選択項目を削除
    var item = document.getElementById("messagePopup").value;
    if (item.length == 0) return;
    if (item == "...その他") return;
    
    if (confirm("「" + item + "」をメニューから削除していいですか？")){
		remove_menu(owner(), "MESSAGE_MENU", item , null, gotMenuItems);
    }
}

function clickedMessageMenu(elm){
    // MESSAGE MENU が選択された
    var item = elm.value;
    
    if (item == "...その他"){
		item = window.prompt("新規メニュー項目を入力してください", "");
		if (item.length == 0) return;
		// menuItem をサーバへ登録するために incrementFrequency() を使う
		put_menu(owner(), "MESSAGE_MENU", item , "", "", gotMenuItems);
    } else {
        var buff = trim(document.getElementById("messageText").value);
        if (buff.length == 0)
            document.getElementById("messageText").value = item;
        else
            document.getElementById("messageText").value = buff + "\n" + item;
    }
}

var _messageIsEmpty = true;
var _messageString;
function closeShelter(){
    // shelter モードを抜けパネルを開く

    // shelter の表示を削除
    document.getElementById("messageShelterArea").innerHTML = "";
    
    // メッセージ・パネルを可視にする
    var el = document.getElementById("_messenger");
    if (el) el.style.display = "block"; 
}
function takeShelter(){
    // メッセージ・パネルを退避
    _messageString = document.getElementById("messageText").value; // plan に格納
    if (_messageString.length){
        var elm = document.getElementById("messageShelterArea");
        if (!elm){
            // 本体に必ず messageShelterArea を用意
            alert("messageShelterArea がありません"); return;
        }
        // メッセージ・パネルを不可視にする
        var el = document.getElementById("_messenger");
        if (el) el.style.display = "none";
        
        // shelter に内容を表示
        elm.innerHTML = "message: " + _messageString;
        elm.setAttribute("onclick", "closeShelter()");
    }
}

function sendMessageDone(answer){
    //alert("sendMessageDone->"+answer); //##
    _messageIsEmpty = true;
    closeFloatPanel();
}
function sendMessage(){
    // メッセージを送付
    //_initDebug(true); //##
    _debug("== sendMessage"); //##
    
    var senderApp = document.getElementById("receiverApp").innerText;
    var elm = document.getElementById("userNamePopup");
    if (elm.value.length == 0){
        alert("送付先が指定されていません");
        return;
    } else {
        var kanji = elm.value;
        var receiver = kanjiname2logname(kanji);
    }
    
    var elm = document.getElementById("appNamePopup");
    var receiverApp = (elm) ? elm.value : "";
    var msg = document.getElementById("messageText").value;
    var docId = document.getElementById("docId").innerText;
    
    var args = new Object();
    args["sender"] = owner() + "@" + senderApp; // sender に格納
    args["receiver"] = receiver + "@" + receiverApp; // mishuu に格納
    args["message"] = msg; // plan に格納
    args["docId"] = docId; // rowid に相当
    
    NRCall("PUT_MESSAGE", args, sendMessageDone);
}

function clearMessage(){
    // メッセージ表示部分をクリア
	var elm = document.getElementById("messageText");
    elm.value = "";
    elm.focus();
}

function removeMessage(owner, docId){
    // 通信を終了しパネルを閉じる
    _messageIsEmpty = true;
    closeFloatPanel();

    var args = new Object();
    args["owner"] = owner;
    args["docId"] = docId;
    
    console.log("removeMessage", encodeObject(args)); //##
    
    NRCall("REMOVE_MESSAGE", args, docId);
}

function showMessenger(obj){
	// メッセンジャーを表示
    //console.log("showMessenger: obj", encodeObject(obj)); //##
    //console.log("_messageIsEmpty", _messageIsEmpty); //##

    // メッセージがすでに表示されていれば何もしない
    if (_messageIsEmpty == false) return;

    var array = obj.sender.split("@"); // ohashi@NOA 型式
    var sender = array[0];
    var senderApp = array[1];
    var array2 = obj.receiver.split("@"); // suzuki@FRONT 型式
    var receiver = array2[0];
    var receiverApp = array2[1];
    var message = obj.message;
    var docId = obj.docId; // rowId が入る
    var updateTime = obj.updateTime;
    
    // パネル・タイトルを生成：sender が後で変更される可能性あるのでここで生成しておく
	var title = "メッセージ伝達パネル";
    if (sender) title = sender + "@" + senderApp + " からメッセージ";

    var panel = new FloatPanel("_messenger", 10, 15, 350, title, "openHelp('messengerHelp.html')");
    if (!panel) return;
    var elm = panel.contents;
	
    _messageIsEmpty = false;
	elm.innerHTML = "";
    
	var tbl = newTABLE(elm, "");
	tbl.style.backgroundColor = "#ffc";
	tbl.style.fontSize = "9pt";
	tbl.style.width = "100%";
    
    // ===== HEADER =====
	var tr = newTR(tbl, "", "");
	tr.style.color = "#aaa";
    // === left side ===
	var td = newTD(tr, "", "");
	var sp = newSPAN(td, "receiverApp");
    sp.style.paddingLeft = "10px";
    sp.innerHTML = receiverApp;
	var sp = newSPAN(td, "docId");
    sp.style.paddingLeft = "10px";
    sp.innerHTML = docId;
    // === right side ===
	var td = newTD(tr, "", "");
	td.style.textAlign = "right";
	var sp = newSPAN(td, "");
    sp.style.paddingRight = "10px";
    sp.innerHTML = updateTime;
    
    // ===== MESSAGE POPUP =====
    var tr = newTR(tbl, "", "");
	var td = newTD(tr, "messagePopupArea", "");
	td.setAttribute("colspan", "2");
    
    // ===== TEXT AREA =====
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "", "");
	td.setAttribute("colspan","2");
    //    message = encodeObject(obj); //## for debug
	var fd = newTEXTAREA(td, "messageText", 40, 10, message);
    fd.style.padding = "5px 5px";
    
    // ===== FOOTER =====
	var tr = newTR(tbl, "", "");
    tr.style.color = "#aaa";
    tr.style.border = "thin solid #000"; //###
    // === left side ===
	var td = newTD(tr, "", "");
    if (sender){
        var sp = newSPAN(td, "");
        sp.style.paddingLeft = "10px";
        var a = newA(td, "通信終了", "#", "");
        var action = "removeMessage('" +owner()+"','"+ docId + "')";
        a.setAttribute("onclick", action);
        setMessageSender(sender); // localStorage.js
    } else {
        sender = messageSender(); // localStorage.js
    }
    // === right side ===
	var td = newTD(tr, "", "");
	td.style.textAlign = "right";
    // ユーザ選択ポップアップ
    var sp = newSPAN(td, "userPopArea");
    sp.innerHTML = sender; // 安易な受け渡し方法
    var sp = newSPAN(td, "");
    sp.style.paddingLeft = "2px";
    sp.innerHTML = "@";
    sp.style.fontSize = "10pt";
    // アプリ選択ポップアップ
    var appNames = ["","NOA","FRONT"];
	var pu = newPopupMenu(td, "appNamePopup", appNames, senderApp);
    var sp = newSPAN(td, "");
    sp.style.paddingRight = "10px";
    sp.innerHTML = "へ";
    // 送信ボタン
    var bt = newBUTTON(td, "", "送信");
    bt.setAttribute("onclick", "sendMessage()");
    
    // メッセージパネルのポップアップ内容をサーバへリクエスト
    var args = new Object();
    args["owner"] = owner();
    
    NRCall("GET_MESSAGE_AND_MENU", args, gotMessageMenu);
}


