
///// 画像ギャラリー //////

///////////////////////////////
///// DRAG and DROP for GALLERY 

var _galleryInfo;
var _homeDir;
function setTemplates(obj){
    // サーバから読み込んだ画像ファイル名の配列で _galleryInfo に含まれないものがあれば
    // _galleryInfo に追加する
    _homeDir = obj.path;
    var array = obj.files;
    for (num in array){
        var filename = array[num];
        
        // サーバから読み込んだギャラリー・オブジェクトに存在しない画像ファイルがあれば
        // ギャラリー・オブジェクトに新規レコードを追加
        if (!_galleryInfo[filename])
            _galleryInfo[filename] = new Object();
    }
}
function templates(){
    // テンプレート・ファイル名の配列を返す：この順番でギャラリー表示
    return allKeys(_galleryInfo);
}
function setGalleryInfo(array){
    // サーバからのデータで _galleryInfo を初期化
    var rec = array[0];
    var obj = decodeObject(rec.value);

    //console.log("setGalleryInfo", encodeObject(obj)); //##
    
    _galleryInfo = (obj) ? obj : new Object();
}
function galleryInfoForName(filename){
    // 画像ギャラリー関連情報を返す
    return _galleryInfo[filename];
}
function homeDir(){
    // サーバ上で画像の置いてある directory を返す
    return _homeDir;
}
function compareFreq(a, b){
    // frq でソート
    var arrayA = a.split(":");
    var arrayB = b.split(":");
    
    return (arrayA[0] * 1 > arrayB[0] * 1);
}
function labelOfGallery(filename){
    // 画像ギャラリーのコメント情報を返す：なければ filename を返す
    var st = _galleryInfo[filename].label;
    
    return (st) ? st : filename;
}
function hideOfGallery(filename){
    // 画像ギャラリーの表示情報を返す
    return (_galleryInfo[filename].hide * 1 > 0) ? 1 : 0;
}

function d_dragstart(event){
    // ドラッグ開始時の処理
    // ドラッグするデータのid名をDataTransferオブジェクトにセット
    event.dataTransfer.setData("text", event.target.id);
}

function d_dragover(event){
    // ドラッグ要素がドロップ要素に重なっている間の処理
    //　dragoverイベントをキャンセルして、ドロップ先の要素がドロップを受け付けるようにする
    event.preventDefault();
}

function d_drop(event, deleteFlag){
    // ドロップ時の処理
    // ドラッグされたデータのid名をDataTransferオブジェクトから取得
    var id_name = event.dataTransfer.getData("text"); // ラベル名
    
    if (deleteFlag){ // labelArray() から id_name のラベルを削除
    } else {
        //id名からドラッグされた要素を取得
        if (id_name == event.currentTarget.id) return;
        
        //ドロップ先にドラッグされた要素を追加
        move_to(id_name, event.currentTarget.id);
        
        //エラー回避のため、ドロップ処理の最後にdropイベントをキャンセルしておく
        event.preventDefault();
    }
}
function move_to(drop_name, target_name){
    // ドロップされたエレメントをドロップされたターゲット・エレメント位置へ移動
    var array = new Array();
    var files = templates();
    for (num in files){
        var filename = files[num];
        array.push(filename);
    }
    
    // drop_name に相当する tag を tags から一旦削除
    var pos1 = indexOfArray(array, drop_name);
    if (pos1 >= 0)
        array.splice(pos1, 1);
    
    // drop_name に相当する tag を target_name に相当する tag の前に挿入
    var pos2 = indexOfArray(array, target_name);
    if (pos2 >= 0){
        if (pos1 <= pos2) pos2++;
        array.splice(pos2, 0, drop_name);
    }
    
    // galleryInfo の freq 順番を打ち直す
    var obj = new Object();
    for (num in array){
        var filename = array[num];
        obj[filename] = galleryInfoForName(filename);
        obj[filename].freq = num;
    }
    _galleryInfo = obj;
    
    // 保存ボタンを表示
    toggleSaveButton(true);
    
    // テンプレートを再表示
    showTemplates();
}

///// DRAG and DROP for GALLERY 
///////////////////////////////

function isEditMode(){
    var elm = elmFor("editModeBox");
    
    return (elm && elm.checked) ? true : false;
}

function editModeChanged(elm){
    // 編集チェックボックスが変更された
    
    // 保存ボタンを消す
    elmFor("saveGalleryButtonArea").innerHTML = "";
    
    // 図譜を再表示
    showTemplates();
}
function toggleSaveButton(status){
    // 状態により保存ボタンを表示・非表示にする
    var sp = elmFor("saveGalleryButtonArea");
    sp.innerHTML = "";
    if (status){
        var bt = newDIV(sp, "/fixButton");
        bt.innerHTML = "保存";
        bt.setAttribute("onclick", "saveTemplates()");
        bt.style.marginLeft = "10px";
    }
}

function labelChanged(elm, filename){
    // elm.innerHTML をコメントとして保存
    var rec = galleryInfoForName(filename);
    rec.label = elm.innerHTML;
    
    // 保存ボタンを表示
    toggleSaveButton(true);
    
    // テンプレートを再表示
    showTemplates();
}

function hideBoxChanged(elm, filename){
    // hideBox が変更された
    var rec = galleryInfoForName(filename);
    rec.hide = (elm.checked) ? 1 : 0;
    
    // 保存ボタンを表示
    toggleSaveButton(true);
    
    // テンプレートを再表示
    showTemplates();
}

function removedGalleryRow(answer){
    // テンプレートを再表示
    if (paneType() == _patientImageType)
        showPatientImagePane();
    else if (paneType() == _galleryType)
        getGallery();
    else if (paneType() == _tempType)
        showTempPane();
}
function removeGalleryRow(filename){
    // 選択されたギャラリー行を削除
    var label = labelOfGallery(filename);
    //alert("removeGalleryRow->"+label); //##

    if (! confirm(label + "　の画像を削除します")){
        return;
    }
    
    var args = new Object();
    args["container"] = "TEMPLATES"; // 画像を拾い出す directory
    args["value"] = homeDir() + "/" + filename; // 削除する画像ファイルの full path
    
    _postServer("REMOVE_IMAGE", "pictServer.php", args, removedGalleryRow);
}

function showTemplates(){
    // テンプレート画像をリストアップ
    
    // 編集モードなら画像読込選択タブを表示
    if (isEditMode()){
        var status = (pictureUploadType()) ? "1" : "0";
        makeTabSelector(status);
    } else {
        elmFor("uploadArea").innerHTML = "";
    }

    // テンプレート画像を表示
    var elm = elmFor("thumbNailRow");
    elm.innerHTML = "";
    var div = newDIV(elm, "");
    var array = templates();
    for (num in array){
        var filename = array[num];
        var url = homeDir() + "/" + filename;
        
        // 通常表示モードで hide ステータスが立っていればスキップ
        if ((!isEditMode()) && (hideOfGallery(filename) * 1 > 0)) continue;
        
        // image のクリックで別パネルに image 表示
        var dv = newDIV(div, filename);
        if (isEditMode()){
            dv.setAttribute("class", "gallery-row");
            dv.setAttribute("draggable", "true"); // HTML5: ドラッグ可能にする
            dv.setAttribute("ondragstart", "d_dragstart(event)");
            dv.setAttribute("ondragover", "d_dragover(event)");
            dv.setAttribute("ondrop", "d_drop(event)");
            // CHECK BOX
            var sp = newSPAN(dv, "");
            var status = hideOfGallery(filename);
            var cb = newCHECKBOX(sp, "hideBox", "", status);
            cb.setAttribute("onchange", "hideBoxChanged(this,'" + filename + "')");
        }
        
        // THUMB NAIL
        var sp = newSPAN(dv, "");
        sp.setAttribute("onclick", "open_image('"+url+"')");
        if (pictureExpand())
            sp.setAttribute("class", "thumb-nail"); // マウスがのると画像が拡大
        var img = makeThumbnail(div, homeDir(), filename);
        sp.innerHTML = img;
        // label
        var sp = newSPAN(dv, filename + ".label");
        sp.style.marginLeft = "5px";
        sp.innerHTML = labelOfGallery(filename);
        if (isEditMode()){
            sp.contentEditable = true; // TEXT を編集可能状態にする
            sp.setAttribute("onblur", "labelChanged(this,'" + filename + "')");
            // 削除アイコン
            var sp = newSPAN(dv, "");
            sp.style.padding = "0 10px";
            var im = newIMAGE(sp, "helpB", "./remove-field.png", "?");
            im.setAttribute("onclick", "removeGalleryRow('" + filename + "')");
            im.style.height = "12px";
            im.setAttribute("class", "expandIcon");
            // freq
            var sp = newSPAN(dv, "");
            sp.innerHTML = galleryInfoForName(filename).freq;
            sp.style.fontSize = "9pt";
            sp.style.color = "#ccc";
        }
    }
}

function gotDirectory(answer){
    // サムネイルのリストを表示
    var obj = JSON.parse(answer);
    setTemplates(obj);
    //console.log("gotDirectory", encodeObject(obj)); //##
        
    // ペーン選択タブ ======================================
    setPaneType(_galleryType);

    var elm = elmFor("tabArea");
    elm.innerHTML = "";
    // --- ペーン選択タブ
    var div = newDIV(elm, "/left-side");
    div.style.width = "80%";
    div.style.paddingLeft = "0";
    div.style.fontSize = "9pt";
    var sp = newSPAN(div, "/gray-tab");
    sp.innerHTML = "カルテ";
    sp.setAttribute("onclick", "showPatientImagePane()");
    var sp = newSPAN(div, "/white-tab");
    sp.innerHTML = "図譜";
    var sp = newSPAN(div, "/gray-tab");
    sp.innerHTML = "臨時";
    sp.setAttribute("onclick", "showTempPane()");
    // --- ヘルプ・アイコン
    var dv = newDIV(elm, "/right-side");
    var im = newIMAGE(dv, "helpB", "./help.png", "?");
    im.setAttribute("onclick", "help()");
    im.style.height = "18px";
    im.style.position = "relative";
    im.style.top = "6px";
    im.setAttribute("class", "expandIcon");
    
    var elm = elmFor("contentsArea");
    elm.innerHTML = "";
    
    // 画像読込エリア ======================================
    var dv = newDIV(elm, "uploadArea");

    // 編集チェックボックス・保存ボタン =======================
    var div = newDIV(elm, "checkBoxArea/clearfix");
    div.style.fontSize = "9pt";
    div.style.textAlign = "right";
    div.style.backgroundColor = "#fff";
    // 画像拡大チェックボックス
    var sp = newSPAN(div, "expandCheckBox");
    var cb = newCHECKBOX(sp, "", "画像拡大", pictureExpand());
    cb.setAttribute("onchange", "_setPictureExpand(this)");
    setInfoTip("expandCheckBox", "マウスで画像拡大"); // INFO TIP
    // 編集モード・チェックボックス
    var cb = newCHECKBOX(div, "editModeBox", "編集", 0);
    cb.setAttribute("onchange", "editModeChanged(this)");
    // 保存ボタン・エリア
    var sp = newSPAN(div, "saveGalleryButtonArea");
    sp.style.paddingLeft = "10px";

    // サムネイル表示エリア =================================
    var dv = newDIV(elm, "thumbNailRow");

    showTemplates();
}
function gotGallery(answer){
    // サーバへ画像ファイル名の配列とパスをリクエスト
    var obj = JSON.parse(answer);
    setGalleryInfo(obj);

    var args = new Object();
    args["owner"] = parent().owner();
    args["folder"] = "TEMPLATES";
    args["filename"] = "";
    args["value"] = "";
    
    NRPost("GET_DIRECTORY", args, gotDirectory);
}
function getGallery(){
    // ギャラリーに表示する画像名の配列をサーバへリクエスト
    var owner = parent().owner();
    get_menu(owner, "PICTURE", gotGallery);
}

function showGalleryPane(){
    // 図譜を表示
    setPaneType(_galleryType);
    
    // TABS =====================================
    var div = elmFor("tabArea");
    div.innerHTML = "";
    
    var dv = newDIV(div, "/left-side");
    dv.style.width = "80%";
    // 画面選択タブ
    var sp = newSPAN(dv, "/gray-tab");
    sp.innerHTML = "カルテ";
    sp.setAttribute("onclick", "showPatientImagePane()");
    var sp = newSPAN(dv, "/white-tab");
    sp.innerHTML = "図譜";
    var sp = newSPAN(dv, "/gray-tab");
    sp.innerHTML = "臨時";
    sp.setAttribute("onclick", "showTempPane()");
    
    var dv = newDIV(div, "/right-side");
    // --- ヘルプ・アイコン
    var im = newIMAGE(dv, "helpB", "./help.png", "?");
    im.setAttribute("onclick", "help()");
    im.style.height = "18px";
    im.style.position = "relative";
    im.style.top = "6px";
    im.setAttribute("class", "expandIcon");
    
    // ギャラリー並びの index をサーバへリクエスト
    getGallery();
}
