
//////////////////////////
/// Grobal 変数
//////////////////////////

var _tabObjects = {"120":"約束","21":"内用","22":"屯用","23":"外用"};

function priceListServer(){
    return "./priceListServer.php";
}

var _tableArray = null;
var _youhouType = 0;
var _cellId = 100;

function setSelectedType(type){
    // 用法 radio button の選択により popupMenu を作成表示
    _youhouType = type;
    loadData(_youhouType); // type に該当するレコードを DB から読み込む
}
function selectedType(){
    return _youhouType; // function名と定数名は異なること
}

function setTableArray(ln){
    // 文字列形式でもらった ln を基に薬剤テーブルを生成
    _tableArray = new Array();
    var records = eval('(' + ln + ')');
    
    for (i in records){
        var recObj = records[i];
        if (recObj) _tableArray.push(recObj);
    }
    
    // "...その他" を追加
    var obj = new Object();
    obj.name = "...その他";
    _tableArray.push(obj);
}
function tableArray(){
    return _tableArray;
}
function tableNameArray(){
    var array = new Array();
    for (num in _tableArray){
        var obj = _tableArray[num];
        array[num] = obj.name;
    }
    return array;
}
function recordForPrescName(name){
    // 薬剤名からその薬剤レコードを返す
    for (num in _tableArray){
        var rec = _tableArray[num];
        for (key in rec){
            if (rec.name == name)
                return rec;
        }
    }
    return null;
}
function tableNameArrayForKey(type, key){
    // key に一致する薬剤テーブルを返す
    var array = new Array();
    var items = tableArray();
    var i, num, count = items.length;
    for (i=num=0; i < count; i++){
        var obj = items[i];
        switch (type){
            case 2: // 薬効がマッチすればリストに加える 
                if (obj.effect && (obj.effect.indexOf(key) >= 0))
                    array[num++] = obj.name;
                break;
            default: // 別名でも実名でも薬効でもマッチすればリストに加える 
                if (obj.name.indexOf(key) >= 0)
                    array[num++] = obj.name;
                if (obj.effect && (obj.effect.indexOf(key) >= 0))
                    array[num++] = obj.name;
                if (obj.alias && (obj.alias.indexOf(key) >= 0))
                    array[num++] = obj.name;
                break;
        }
    }
    return array;
}
function effectArray(){
    // type(約束、内用、屯用、外用) に応じた効能リストを返す
    var items = tableArray(); // 効能に応じたものがすでに入っていはず
    var effectObj = new Object();
    for (i=0,ct=items.length; i < ct; i++){
        var obj = items[i];
        var effects = obj.effect; // "鎮痛 解熱" 形式
        if (!effects || (effects.length == 0)) continue;
        
        var ary = effects.split(" ");
        for (j=0,ctj=ary.length; j < ctj; j++){
            var effect = ary[j]; // "鎮痛" 形式
            // 効能をユニークにするため object の添字として保存
            if (effect.length) effectObj[effect] = obj.name;
        }
    }
    
    // ユニークな効能を array に入れて返す
    var array = new Array();
    for (key in effectObj)
        array.push(key);
    array.sort();
    return array;
}

var _originalPrescLabel;
function setOriginalPrescLabel(label){
    _originalPrescLabel = label;
}
function originalPrescLabel(){
    // 処方を開いた CELL の ラベル名
    return _originalPrescLabel;
}

//////////////////////////////////////
// 用法のリストの作成管理 ///////////////

_naiyouItems = null;
_tonyouItems = null;
_gaiyouItems = null;

function naiyouItems(){
    return _naiyouItems;
}
function gaiyouItems(){
    return _gaiyouItems;
}
function tonyouItems(){
    return _tonyouItems;
}

function setYouhouItems(buff){
    _naiyouItems = new Array();
    _tonyouItems = new Array();
    _gaiyouItems = new Array();
    // 最初に空白アイテムを追加：「カルテ側から送られた処方の用法」にマッチする用法
    // がなかった場合、ポップアップメニューに空白アイテムが表示されたままになる。
    // default の用法が最初から表示されていると、修正忘れの起こる可能性あるため。
    _naiyouItems.push(""); 
    _tonyouItems.push("");
    _gaiyouItems.push("");
    
    var array = JSON.parse(buff);
    
    for (i in array){
        var obj = array[i];
        switch (obj.type * 1){
            case 21 : _naiyouItems.push(trim(obj.value)); break;
            case 22 : _tonyouItems.push(trim(obj.value)); break;
            case 23 : _gaiyouItems.push(trim(obj.value)); break;
        }
    }
}

// 用法のリストの作成管理 ///////////////
//////////////////////////////////////


/////////////////////////
///// カルテからの継承値 ///

function valueInNoa(tag){
    // NOA における tag 相当の値を返す
    var obj = valueForTag(tag, currentDate());
    return (obj && obj.value) ? obj.value : "";
}

var _receivedObj;
function initReceivedObj(answer){
    // NOA から継承する情報を記憶
    
    // サーバから得た保険情報で保険オブジェクトを生成
    var obj = JSON.parse(answer);
    //console.log("initReceivedObj", encodeObject(obj)); //###
    var hins = obj.healthInsurance;
    var pins = obj.publicInsurance;
    var date = currentDate();
    _receivedObj = new Object();
    _receivedObj.currentDate = date;
    _receivedObj.patientId = patientId();
    _receivedObj.loginName = userName();
    var hospInfo = hospitalInfo();
    
    _receivedObj.hospitalName = hospInfo.hospitalName;
    _receivedObj.hospitalAddress = hospInfo.hospitalAddress;
    _receivedObj.hospitalPhone = hospInfo.hospitalPhone;
    _receivedObj.todoufukenBangou = hospInfo.divisionNumber;
    _receivedObj.tensuuhyouBangou = hospInfo.tableNumber;
    _receivedObj.iryoukikanCode = hospInfo.hospitalCode;
    
    // 基本情報などに HTML 属性があるとエラーになるのでプレーン・テキストに変換しておくこと
    var st = htmlToPlain(valueInNoa("NameSection.patientKanjiName"));
    _receivedObj.kanjiName = st;
    var st = htmlToPlain(valueInNoa("NameSection.patientKanjiName"));
    _receivedObj.name = st;
    var st = htmlToPlain(valueInNoa("NameSection.patientKanaName"));
    _receivedObj.furigana = st;
    
    _receivedObj.sex = valueInNoa("PatientTable.sex");
    _receivedObj.birthDay = valueInNoa("PatientTable.birthDate");
    
    // サーバから読み込んだ最新の保険情報を使う
    _receivedObj.shubetsu = hins.shubetsu.val;
    _receivedObj.family = hins.kubun.val;
    _receivedObj.paymentRatio = hins.paymentRatio.val;
    _receivedObj.hokenshaBangou = hins.ownerNumber.val;
    _receivedObj.kigou = hins.kigou.val;
    _receivedObj.bangou = hins.bangou.val;
    _receivedObj.kouhiFutanBangou = pins.ownerNumber.val;
    _receivedObj.jyukyuuBangou = pins.recipientNumber.val;
    _receivedObj.kouhiMeishou = pins.ownerName.val;
    _receivedObj.kouhiKoufubi = pins.startDate.val;
    _receivedObj.kouhiYuukouKigen = pins.expiredDate.val;
    _receivedObj.kouhiFutanRatio = pins.paymentRatio.val;
    
    // 処方オブジェクト
    var buff = valueInNoa("ProgressSection.prescription");
    
    // buff に "=== 自費処方 ===" 行があれば別途処理
    if (buff.length > 0){
        var array = buff.split("\n");
        var firstRow = array[0];
        if (firstRow.indexOf("自費") >= 0){
            array.shift(); // ”自費" の文言の入った最初の行を削除
            buff = array.join("\n");
            _receivedObj.isOwn = "1";
        }
    }
    
    // 自費チェックボックスのステータスを表示
    if (! isReadOnly()){
        var sp = elmFor("isOwnArea");
        sp.innerHTML = "";
        var status = (_receivedObj.isOwn) ? 1 : 0; // NOA データの自費フラッグを反映
        var cb = newCHECKBOX(sp, "isOwn", "自費", status);
        cb.setAttribute("onchange", "setIsOwn(this)");
        setIsOwn(cb); // NOA データの自費フラッグを isOwn() として記憶
    }

    // NOA の処方欄の内容を取り込む
    var obj = prescription(buff);
    
    _receivedObj.prescription = obj;
    
    setPrescriptionObject(obj);
    
    showShohou(); // カルテ内の処方を表示：Ajax を呼んだ後のここで起動すること
}

function prescription(buff){
    if (buff.length == 0) return "";
    
    // ## 平文形式の処方を以下のような object に encode して返す
    // 　頭につく "0.0": などは、それぞれのオブジェクトを識別するための
    // 　階層化された ID で、これを元に挿入・削除などの操作を行える。
    // "prescription":{
    //	"0":{
    //		"0.0":{"code":"0","name":"アドナ 10mg","dose":"6","unit":"Cap"},
    //		"0.1":{"code":"121","name":"分3内服食後","dose":"5","unit":"日分"}},
    //	"1":{
    //		"1.0":{"code":"0","name":"アデスタン","dose":"1","unit":"回分"},
    //		"1.1":{"code":"123","name":"外用","dose":"1","unit":"回分"}},
    //	"2":{
    //		"2.0":{"code":"0","name":"ニューロタン錠","dose":"1","unit":"Tab"},
    //		"2.1":{"code":"122","name":"屯用 就寝前","dose":"5","unit":"日分"}}
    // }
    var prscObj = new Object();
    var groupObj = new Object();
    
    // '\n' または '<br>' や '<div>' で改行されていることがあるので全てに対応
    buff = transferToCR(buff);
    var records = buff.split('\n');
    
    var gId = 0;
    var num = 0;
    var code = "0"; // 用法種別を示すコード
    for (i in records){
        var ln = records[i];
        if (trim(ln).length == 0) continue;
        
        if (ln.indexOf("-") == 0){ // 行頭が - で始まれば用法行
            // ln: "----- 分3内服 ８時間毎(5 日分)" のような形式
            code = codeWithString(ln); // "121","122","123" いずれかを返す
            // ln: "分3内服 ８時間毎(5 日分)" だけを後の処理へ渡す
            //   - の数が違っていても、その後に空白区切りがあれば用法行として認める
            var pos = ln.indexOf(" ");
            ln = trim(ln.substr(pos + 1));
        } else {
            // ln: "トランサミンカプセル 250mg(6 Cap)" のような形式 あるいは
            code = "" + num++; // (code < 100) で用法行ではない
        }
        
        // ln を解析して、名前、投与量、単位、を記憶したオブジェクト:obj を生成
        var array1 = ln.split("(");
        if (array1.length > 1){
            var obj = new Object();
            var name = array1[0]; // "(" 以前は名称
            if (name.charAt(0) == "*"){ // generic へ変更禁止
                obj.name = trim(name.substr(1));
                obj.notGeneric = true;
            } else if (name.charAt(0) == " "){ // generic へ変換可
                obj.name = trim(name.substr(1));
            } else                    // 商品名
                obj.name = array1[0]; // "(" 以前は名称
            var ln2 = array1[1];
            var array2 = ln2.split(")");
            var ln3 = array2[0]; // ln3: "(...)"
            var array3 = ln3.split(" ");
            obj.dose = array3[0]; // (...) 中の空白区切り前が用量
            obj.unit = (array3.length > 1) ? array3[1] : ""; // 単位
            groupObj[code] = obj;
            //console.log(code+"->", encodeObject(obj)); //##
            
            if (code * 1 > 100){
                // 用法行に至ったので それを prscObj に記憶
                var _gid = ""+gId++;
                prscObj[_gid] = groupObj;
                // 次の用法のため環境を初期化
                num = 0; // group 内のレコード id を初期化
                groupObj = new Object(); // 新しい groupObj を生成
            }
        }
    }
    
    return prscObj;
    
    
    function codeWithString(ln){
        // ln: "----- 分3内服 ８時間毎(5 日分)" のような形式からコードを判別して返す
        // "----" を削除し "分3内服 ８時間毎(5 日分)" にする
        var ary = ln.split(' ');
        ary.splice(0, 1); 
        ln = ary.join(' ');
        // "(5 日分)" を削除し "分3内服 ８時間毎" にする
        ary = ln.split('(');
        ln = trim(ary[0]);
        
        if (ln.indexOf("内服", 0) >= 0)
            return "121";
        else if (ln.indexOf("内用", 0) >= 0)
            return "121";
        else if (hasMember(naiyouItems(), ln) > 0)
            return "121";
        else if (ln.indexOf("屯", 0) >= 0)
            return "122";
        else if (ln.indexOf("頓", 0) >= 0)
            return "122";
        else if (hasMember(tonyouItems(), ln) > 0)
            return "122";
        else if (ln.indexOf("外用", 0) >= 0)
            return "123";
        else if (ln.indexOf("塗布", 0) >= 0)
            return "123";
        else if (hasMember(gaiyouItems(), ln) > 0)
            return "123";
        else
            return "0";
    }
}

function receivedObj(){
    // NOA のデータを元にした処方に必要な情報オブジェクト
    return _receivedObj;
}

var _prescriptionObject;
function setPrescriptionObject(obj){
    // 処方内容の構造を記憶: 処方が編集された時に呼ばれる
    _prescriptionObject = obj;
}
function prescriptionObject(){
    // 編集中の処方オブジェクト
    // NOA の処方欄を元にした処方オブジェクトは _receivedObj.prescription に記憶
    return _prescriptionObject;
}

///// カルテからの継承値 ///
/////////////////////////


///////////////////////////
/// Ajax による処理

function getRecords(answer){
    if (answer && (answer.length > 0))
        setTableArray(answer);
    makePopupItems(tableNameArray());
}
function loadData(type){
    // PHPサーバへリクエストを送り、データが返送されたら func() で受ける
    var args = new Object();
    args['code'] = type;
    
    //console.log("loadData", args); //##
    
    _callServer("GET_LIST", "priceListServer.php", args, getRecords);
}

function closePrescMessage(){
    // 注意事項を消す
    elmFor("pr_editorArea").innerHTML = "";
}
function prescMessage(message){
    // 注意事項やアラートなどを表示
    var div = elmFor("pr_editorArea");
    var sp = newSPAN(div, "");
    sp.innerHTML = message;
    sp.style.backgroundColor = "#f00";
    sp.style.color = "#fff";
    sp.style.marginLeft = "15px";
    sp.style.padding = "3px";
    sp.setAttribute("onMouseOver", "closePrescMessage()");
}

var _nameOfselectedRow;
function openManual(answer){
    // サーバから得られたレコード情報を元に添付書類を開く
    var array = JSON.parse(answer);
    if (!array || (array.length == 0)){
        prescMessage(_nameOfselectedRow + " は PriceList にないので添付書類を探せません");
        return;
    }
    // 添付書類の URL あれば表示
    var memo = array[0].memo; // キー（薬剤名）にヒットするものが複数あっても、とりあえず最初のレコードのみ使用
    var array = memo.split(" ");
    for (i=0,ct=array.length; i < ct; i++){
        var st = array[i];
        if (st.indexOf("URL:") >= 0){
            var ary = st.split(":");
            if (ary.length > 1){
                var url = ary[1];
                url = "../Medicine/medicine/" + url;
                window.open(url,"添付書類","left=50,top=20,width=900,height=1000,resizable=yes");
                return;
            }
        }
    }
    
    // 登録された添付書類がなかったので、マニュアル取込ツールを開く
    console.log("openManual name(", _nameOfselectedRow,")"); //##
    openManTool(_nameOfselectedRow);
}
function openDocument(name){
    console.log("openDocument name(", name,")"); //##
    // name の添付書類を開く
    var args = new Object();
    args['name'] = name; // 「処方ツール」と「薬剤選択パネル」とでは name の出所が違う

    // name に関する薬剤レコードをサーバへリクエストし、その添付書類を開く
    _nameOfselectedRow = name; // openManual() へ引き渡すため薬剤名を記憶
    _callServer("GET_RECORD", "priceListServer.php", args, openManual);
}
function openDoc(){
    // 薬剤選択パネルで選択しつつある薬剤の添付書類を開く
    var name = selectedMedicine();
    openDocument(name);
}

function setUsageList(answer){
    // PriceList から用法リストを load
    setYouhouItems(answer); // 用法リストを作成

    // サーバから最新の保険情報を得る
    get_page(owner(), patientId(), currentDate(), initReceivedObj);
}
function getUsageList(){
    // 用法リストをサーバへリクエスト
    _callServer("GET_USAGE_LIST", "./priceListServer.php", null, setUsageList);
}

function gotGeneric(answer){
    // 対応する generic のテーブルがサーバから返ってきた
    
    // genObj = ["商品名":"一般名",,,]
    // 対応する一般名がない場合、一般名は ""
    var genObj = JSON.parse(answer);
    var obj = prescriptionObject();
    var newObj = new Object();
    var number = 0;
    for (num in obj){
        var group = obj[num];
        for (n in group){
            if (n > 100) continue;
            var rec = group[n];
            var generic = genObj[rec.name];
            
            // rec に generic 属性を追加
            // これを基に NOA で generic の有無を判断
            rec.generic = (generic && (generic.length > 0)) ? generic : "";
            group[n] = rec;
        }
        if (encodeObject(group).length)
        {
            newObj[number++] = group;
        }
    }

    doSendPrescription(newObj);
}
function getGeneric(obj){
    // generic のテーブルをサーバへ要求した後に処方箋を印刷
    var args = new Array();
    for (num in obj){
        var group = obj[num];
        for (n in group){
            var rec = group[n];
            if (rec.code > 100) continue;
            args.push(rec.name);
        }
    }

    _callServer("GET_GENERIC", "priceListServer.php", args, gotGeneric);
}


/// Ajax による処理
///////////////////////////

var _insertInfo;
function setInsertInfo(obj){
    // 挿入すべきレコードの情報を object として記憶
    _insertInfo = obj;
}
function insertInfo(){
    return _insertInfo;
}

var _isOwn;
function setIsOwn(elm){
    // 自費チェックボックスの状態を保存
    _isOwn = (elm.checked) ? 1 : 0;
}
function isOwn(){
    return (_isOwn) ? _isOwn : 0;
}

function firstCodeOf(ln){
    // "21,22" のような形式から最初のコードだけを取り出し数値として返す
    var array = ln.split(",");
    return trim(array[0]) * 1;
}

function narrowsItems(type, key){
    // 絞り込みキーを基に popupMenu のコンテンツを作成
    if (key.length == 0) return;
    
    // 薬剤選択 popupMenu のコンテンツを作成
    var array = tableNameArrayForKey(type, key);
    makePopupItems(array);
}
function autoNarrowsItems(){
    // searchKey フィールドに文字が入力されるごとに作動
    var key = document.getElementById("searchKey").value;
    narrowsItems(0, key);
}

function recWithName(popupName, isGroup){
    // 薬剤名 popupName に相当する recObj を返す
    // (isGroup > 0) なら約束処方
    var records = tableArray();
    for (i in records){
        var recObj = records[i];
        var name = recObj.name;
        // code:"22,21"の場合の対応
        var code = firstCodeOf(recObj.code);
        if ((isGroup > 0) && (code < 100)) continue;
        if ((isGroup == 0) && (code > 100)) continue;
        if (isGroup > 0){
            if (name == popupName) return recObj;
        } else {
            if (name.indexOf(popupName) == 0) return recObj;
        }
    }
    return null;
}

function openManTool(name){
    // マニュアル取込ツールを開く
    window.open("./manTool.php?name="+name,"_blank");
}

function selectedMedicine(){
    // ポップアップメニューから選択された薬剤名を返す
    var popup = elmFor("namePopup");
    return (popup) ? popup.value : "";
}

function clearPrefHelp(){
    // HELP を消去
    document.getElementById("message").innerHTML = "";
}

function makePopupItems(menus){
    // 薬剤選択 popupMenu のコンテンツを作成
    var div = document.getElementById("popupMenuArea");
    if (div == null){
        console.log("popupMenuArea の存在する画面ではありません");
        return;
    }
    div.innerHTML = "";
    
    // 薬剤名ポップアップ・メニュー
    var popup = newPopupMenu(div, "namePopup", menus, "");
    popup.setAttribute("onchange", "checkIfNew()");
    
    // INFO ICON
    var im = newIMAGE(div, "infoIcon", "./info.png", "?");
    im.setAttribute("onclick", "openDoc()");
    im.style.height = "18px";
    im.setAttribute("class", "expandIcon");
    im.style.position = "relative";
    im.style.top = "3px";
    im.style.marginLeft = "2px";
    //setInfoTip("infoIcon", "添付文書を開く"); // ClearPanel の下に隠れ殆ど見えない
    
    // 挿入ボタン
    var bt = newDIV(div, "/whiteButton");
    bt.innerHTML = "挿入";
    bt.setAttribute("onclick", "insertRecord('" + popup.id + "')");
    bt.style.position = "relative";
    bt.style.bottom = "1px";
    bt.style.marginLeft = "5px";
    
    clearPrefHelp(); // HELP を消去
}

function prescriptionToString(obj){
    // prescription オブジェクトを処方箋記述様式のテキストへ変換
    var buff = "";
    for (key in obj){
        var val = obj[key];
        if (typeof(val) == "object"){
            // グループの中を処理
            buff +=  prescriptionToString(val);
        }
        else if (obj.code == 999)
            continue; // コメントは無視
        else {
            // レコードの処理
            if (obj.code > 100) buff += "----- "; // 用法行の場合
            var mark = "";
            if (obj.code * 1 > 99){ // 用法行
                var name = obj.name;
            } else { // 薬剤行
                var isGeneric = (obj.generic && (obj.generic.length > 0));
                var name = (isGeneric) ? obj.generic : obj.name;
                
                // generic にチェック入らないものは行頭に '*' 印をつける：セパレータは除く
                if (obj.notGeneric) mark = "*";
            }
            if (obj.generic && (obj.generic.length > 0)) mark += "[般] ";
            buff += mark + name + " ( " + obj.dose + " " + obj.unit + " )<BR/>";
            return buff;
        }
    }
    return buff;
}

function printPrescription(){
    // 処方箋の印刷パネルを生成して開く
    var robj = receivedObj();
    var obj = prescriptionObject();

    robj.inquiry = (withInquiry()) ? 1 : 0;
    robj.info = (withInformation()) ? 1 : 0;
    
    // 自費の場合 obj 中の保険情報を自費情報に置換
    if (isOwn()) robj = nullInrance(robj);
    
    // 確認パネルを閉じる
    if (prescClosePanel()) closeFloatPanel();
    
    // info は JSON 形式
    var ln = prescriptionToString(obj);
    ln += "- - - - - - - - - - 以 下 余 白 - - - - - - - - - -";
    
    var st = "./printPDF.php?"
    + "&info=" + JSON.stringify(robj)
    + "&doctorName=" + robj.doctorName
    + "&value=" + ln;
    
    window.open(st, "PDF", "dependent=yes");
    
    function nullInrance(obj){
        // obj 中の保険情報を自費情報に置換して返す
        obj.shubetsu = "";
        obj.family = "";
        obj.paymentRatio = "10";
        obj.hokenshaBangou = "";
        obj.kigou = "";
        obj.bangou = "";
        obj.kouhiFutanBangou = "";
        obj.jyukyuuBangou = "";
        return obj;
    }
}

function printShohou(){
    // 作成した処方箋を 印刷
    var preObj = prescriptionObject();
    // 処方に genric が含まれることを意味するフラッグ
    var hasGeneric = (isIncludeOfGeneric(preObj));
    // 薬局での generic へ交換禁止のフラッグ
    var noGeneric = (isNotGeneric(preObj));
    var doctorName = (noGeneric) ? receivedObj().loginName : "";
    
    if (!prefConfirmPanel()) return;
    
    // 処方情報の確認パネルを生成
    var title = "処方内容 確認パネル";
    var panel = new FloatPanel("_confirm", 5, 5, 350, title);
    var elm = panel.contents;
    
    var tbl = newTABLE(elm, "");
    tbl.style.width = "100%";
    
    var obj = receivedObj();
    
    obj.doctorName = doctorName;
    makeLine(tbl, "処方日", obj.currentDate.substr(0, 10));
    makeLine(tbl, "医療機関", obj.hospitalName);
    makeLine(tbl, "", obj.hospitalAddress);
    makeLine(tbl, "", obj.hospitalPhone);
    makeLine(tbl, "取扱者", obj.loginName);
    
    makeLine(tbl, "受診者", obj.kanjiName);
    makeLine(tbl, "", obj.sex);
    makeLine(tbl, "保険", obj.hokenshaBangou);
    makeLine(tbl, "保険種別", obj.shubetsu);
    makeLine(tbl, "区分", obj.family);
    makeLine(tbl, "割引(%)", obj.paymentRatio);
    makeLine(tbl, "記号", obj.kigou);
    makeLine(tbl, "番号", obj.bangou);
    makeLine(tbl, "公費負担番号", obj.kouhiFutanBangou);
    makeLine(tbl, "受給番号", obj.jyukyuuBangou);
    var status = (noGeneric) ? "==== 後発品へ変更不可 ====" : "可";
    makeLine(tbl, "後発品へ変更", status);
    makeLine(tbl, "処方医", obj.doctorName);
    
    // 処方内容
    var obj = prescriptionObject();
    var buff = prescriptionToString(obj);
    var array = buff.split("<BR/>");
    for (i in array){
        var ln = trim(array[i]);
        if (ln.length == 0) continue;
        if (i == 0)
            makeLine(tbl, "処方", ln);
        else
            makeLine(tbl, "", ln);
    }
    
    if (hasGeneric)
        makeLine(tbl, "一般名処方", "generic");
    else 
        makeLine(tbl, "一般名処方", "なし");
    
    if (isOwn()) makeLine(tbl, "費用負担", "自費"); //####

    // FOOTER
    var tr = newTR(tbl, "", "");
    var td = newTD(tr, "float-footer", "");
    td.style.textAlign = "right";
    td.setAttribute("colspan", "2");
    td.style.fontSize = "9pt";
    // チェックボックス
    var sp = newSPAN(td, "");
    sp.style.position = "relative";
    sp.style.top = "4px";
    sp.style.marginRight = "10px";
    var cb = newCHECKBOX(sp, "", "確認パネルを閉じ印刷", prescClosePanel());
    cb.setAttribute("onclick", "setPrescClosePanel(this)");
    // とりやめボタン
    var bt = newDIV(td, "/whiteButton");
    bt.style.position = "relative";
    bt.style.top = "2px";
    bt.innerHTML = "とりやめ";
    bt.setAttribute("onclick", "closeFloatPanel()");
    // 印刷ボタン
    var bt = newDIV(td, "/fixButton");
    bt.innerHTML = "処方箋を印刷";
    bt.setAttribute("onclick", "printPrescription()");

    
    function makeLine(tbl, key, val){
        var tr = newTR(tbl, "", "");
        var td = newTD(tr, "", key);
        td.style.fontSize = "9pt";
        td.style.color = "#333";
        td.style.width = "80px";
        td.style.backgroundColor = "#caecdc"; // light green
        val = "" + val;  // paymentRatio などは数値の可能性あり文字列へ変換
        val = trim(val);
        if (val == "generic"){
            var td = newTD(tr, "", "＊＊ 一般名処方せん加算 ＊＊");
            td.style.fontSize = "10pt";
            td.style.padding = "0px 5px";
            td.style.fontWeight = "bold";
            td.style.color = "#00f"; //red
            // 一般名が処方内にあれば再計算を促す
        } else if (val && (val == "undefined")){
            var td = newTD(tr, "", "　");
            td.style.backgroundColor = "#fff";
        } else if (val && val.length){
            var td = newTD(tr, "", val);
            td.style.fontSize = "11pt";
            td.style.padding = "0px 5px";
            td.style.fontWeight = "bold";
            td.style.color = "#333";
            td.style.backgroundColor = "#fff";
        } else {
            var td = newTD(tr, "", "* データがありません *");
            td.style.fontSize = "10pt";
            td.style.padding = "0px 5px";
            td.style.fontWeight = "bold";
            td.style.color = "#f03"; //red
        }
    }
    
    function isIncludeOfGeneric(obj){
        // obj の中に genric が含まれるかどうかをチェック
        for (key in obj){
            var val = obj[key];
            if (typeof(val) == "object"){
                // グループの中を処理
                if (isIncludeOfGeneric(val)) return true;
            } else if (obj.code > 100)
                continue; // コメントは無視
            else {
                // レコードの処理
                if (obj.generic && (obj.generic.length > 0)){
                    return true;
                }
            }
        }
        return false;
    }
    
    function isNotGeneric(obj){
        // obj の中に generic に変換拒否の薬剤が有るかどうかをチェック
        for (key in obj){
            var val = obj[key];
            if (typeof(val) == "object"){
                // グループの中を処理
                if (isNotGeneric(val)) return true;
            } else if (obj.code > 100)
                continue; // コメントは無視
            else {
                // レコードの処理
                if (obj.notGeneric){
                    return true;
                }
            }
        }
        return false;
    }
}

function checkIfNew(){
    // "...その他"が選択されたらグローバル辞書登録パネルを開く
    var name = selectedMedicine();
    if (name == "...その他"){
        // PriceListGlobal から薬剤を探す
        if (selectedType() == "23")
            var code = "23"; // 外用薬
        else
            var code = "21"; // 内服薬
        
        // ### globalList(VIN) からのメッセージは putGlobal() で受ける
        var url = "../NOA/globalList.php?code=" + code + "&owner=" + owner();
        window.open(url, "globalList", "scrollbars=yes,width=800,height=700");
    }
    clearPrefHelp();
}

function selectedPrescRadio(){
    // ラジオボタンで選択された code を _youhouType として記憶
    var label = checkedRADIO("_radioArea");
    var type = keyForValueIn(_tabObjects, label);
    setSelectedType(type);
    loadData(type); // type に該当するレコードを DB から読み込む
}
function openSelectMedicinePanel(groupId, recId, targetRecId, tailFlag){
   // 薬剤選択パネルを開く
    var elm = elmFor(groupId+"."+recId+"row");
    var pos = getPosition(elm);
    var w = 500;
    var x = pos.x + 25; // テンプレート・パネルを表示するx座標
    var y = pos.y; // テンプレート・パネルを表示するy座標

    // 薬剤追加パネルを生成 ===============================
    var panel = new ClearPanel("_floatPanel", x, y, w, "この行に薬剤追加", "openHelp('prescInsertHelp.html')");
    if (!panel) return;
    
    panel.header.style.backgroundColor = "#eda"; // ベージュ
    panel.base.style.opacity = "1"; // 1.0:不透明
    panel.base.style.backgroundColor = "#ffc";
    panel.base.style.borderRadius = "10px 10px 10px 10px";
    panel.base.style.boxShadow = "5px 5px 15px 0px #999";
    var elm = panel.contents;
    elm.style.padding = "10px";
    elm.style.fontSize = "9pt";
    // ラジオボタン ---------------------------------
    var codeName = getCodeName(insertInfo().records, groupId); // "内用" など
    if (tailFlag){ // 最下段に追加する場合は "約束" を含め、すべての用法を選択できる
        var labels = allValues(_tabObjects);
    } else { // それ以外の行に挿入する場合、その領域の用法が決まっているので、他の用法は選択できない
        // 挿入位置領域の薬剤コードに応じた用法をラジオボタンに設定
        var labels = [];
        labels.push(codeName);
    }
    var bt = newRADIO(elm, "_radioArea", "modeButtons", labels, codeName);
    bt.setAttribute("onchange", "selectedPrescRadio()");
    // ラジオボタンの横に注意書きを表示
    if (! tailFlag){
        var sp = newSPAN(elm, "");
        sp.innerHTML = "他の用法を使いたい場合は一番下の ";
        sp.style.marginLeft = "10px"
        sp.style.color = "#777";
        var im = newIMAGE(elm, "", "./add-field.png", "X");
        im.style.height = "15px";
        var sp = newSPAN(elm, "");
        sp.innerHTML = " で追加してください";
    }
    // 絞り込み欄 -----------------------------------
    var div = newDIV(elm, "");
    div.style.marginTop = "10px";
    var bt = newDIV(div, "/whiteButton");
    bt.innerHTML = "薬効で絞込";
    bt.style.marginRight = "5px";
    bt.setAttribute("onclick", "showYakkouList()");
    // 検索フィールド --------------------------------
    var fd = newFIELD(div, "searchKey", "", 20, "");
    fd.setAttribute("placeholder", "文字で絞込み");
    fd.setAttribute("onkeyup","autoNarrowsItems()");
    fd.setAttribute("autocomplete","on");
    fd.focus();
    // 薬効リスト表示エリア  -------------------------
    var div = newDIV(elm, "yakkouListArea");
    div.style.marginTop = "10px";
    // 薬剤選択ポップアップメニュー表示エリア  -----------
    var dv = newDIV(elm, "popupMenuArea");

    selectedPrescRadio(); // 選択されたラジオボタンの用法に応じたデータを load

    function getCodeName(records, gid){
        // 現在対象となっている行の gid を元に、その領域の属する薬剤コード名を調べて返す
        var gobj = records[gid];
        for (cd in gobj){
            var rec = gobj[cd];
            switch(cd * 1){
                case 121: return "内用";
                case 122: return "屯用";
                case 123: return "外用";
            }
        }
        return "内用"; // 何も指定する情報が得られなければとりあえず内用を指定
    }
}
function insertRecord(popupMenuId){
    // 薬剤追加編集パネルの「挿入」ボタンのクリックにより起動
    
    // 挿入条件を取り出す
    var infoObj = insertInfo();
    var gid = infoObj.groupId;
    var rid = infoObj.recordId;
    var resultObj = infoObj.records;
    var insertId = infoObj.insertId;
    var isTail = infoObj.isTail;
    var gobj = resultObj[gid];
    if (!gobj){
        gobj = new Object(); // 最後尾に追加する場合は新規のグループ・オブジェクトを生成
        resultObj[gid] = gobj;
    }
    
    // rec を insertId 位置に挿入 -------------------------
    var name = elmFor(popupMenuId).value;
    var rec = recordForPrescName(name); // priceList から name に対応するレコードを取得
    var isYakusoku = (selectedType()*1 > 100) ? true : false; // 約束処方か否か
    if (isYakusoku){ // 約束処方を追加
        var rc = recWithName(name, 1);
        if (rc == null) return;
        // memo の " が '&quot;' に encode されているので decode する
        var ary = rc.memo.split("&quot;");
        rc.memo = ary.join("\"");

        resultObj = addYakusokuShohou(rc, resultObj); // insertId 位置に約束処方を追加
    } else {
        // rec を仮置きの "新規薬剤" と置換 ---------------------
        console.log("rec.standard (", rec.standard, ")"); //###
        rec.dose = (rec.standard) ? rec.standard : ""; // dose 属性を新たに追加
        for (gid in resultObj){
            var gp = resultObj[gid];
            for (rid in gp){
                var rc = gp[rid];
                if (rc.name == "新規薬剤"){
                    gp[rid] = rec; // 選択された薬剤に置換
                }
            }
       }
        // 末尾に挿入する場合は用法行を追加 -----------------------
        if (isTail){
            // 新規用法グループを生成
            gid++;
            gobj = new Object();
            // 新規レコードを追加
            var cd = firstCodeOf(rec.code); // rec.code は "23,48" 形式のことがある
            gobj[cd] = rec;
            resultObj[gid] = gobj;
            // 用法行を追加
            var rec = youhouObject();
            gobj[rec.code] = rec;
            resultObj[gid] = gobj;
        }
    }
    // 更新された情報を記憶
    infoObj.records = resultObj;
    setInsertInfo(infoObj);
    setPrescriptionObject(resultObj);
    
    showShohou(); // 新規レコードが挿入された画面に書き直す
    closeFloatPanel(); // 薬剤追加編集パネルを消す
    
    
    function addYakusokuShohou(yakusokuObj, obj){
        // 約束処方オブジェクトを処方末尾に追加
        var resultObj = new Object();
        var gid = 0; // obj が空の場合に使われる
        for (groupId in obj){
            var groupObj = obj[groupId];
            resultObj[groupId] = groupObj;
            gid++; // 既存の処方オブジェクトの最後の groupId を記憶
        }
        
        // 既存の処方に約束処方を追加
        var yakuObj = eval('(' + yakusokuObj.memo + ')');
        for (_groupId in yakuObj){
            var groupObj = yakuObj[_groupId];
            resultObj[gid++] = groupObj;
        }
        
        return resultObj;
    }

    function youhouObject(){
        // 選択されている投与区分に応じた default の用法オブジェクトを生成して返す
        var youhouObj = new Object();
        var cd = selectedType() * 1;
        switch (cd){
            case 21: {
                youhouObj.code = "121";
                youhouObj.name = "";
                youhouObj.dose = 5;
                youhouObj.unit = "日分"; // default 値
            } break;
            case 22: {
                youhouObj.code = "122";
                youhouObj.name = "";
                youhouObj.dose = 5;
                youhouObj.unit = "回分"; // default 値
            } break;
            case 23: {
                youhouObj.code = "123"
                youhouObj.name = "";
                youhouObj.dose = 1;
                youhouObj.unit = "回分"; // default 値
            } break;
        }
        return youhouObj;
    }
}
function prepareForInsert(groupId, recId, tailFlag){
    // 指定位置に新規薬剤用の行を挿入し、新規薬剤選択パネルを開く
    var obj = prescriptionObject();
    var resultObj = new Object();
    var targetRecId = recId; // 新規挿入するレコードの ID：用法行の場合は特別扱いが必要
    
    // 最後尾の追加アイコンがクリックされた場合、そこに相当するオブジェクトを生成
    if (! obj[groupId]){
        obj[groupId] = new Object();
        if (! obj[groupId][recId]){
            var rec = [groupId][recId] = new Object();
        }
    }
    
    // prescriptionObject に新規レコードを挿入したものを resultObj へコピー
    var newRec = new Object();
    newRec.name = "新規薬剤";
    var hasNewRecord = false;
    for (gid in obj){
        var groupObj = obj[gid];
        var newGroupObj = new Object();
        var lastRecId;
        for (rid in groupObj){
            var rec = groupObj[rid];
            if (gid != groupId){
                newGroupObj[rid] = groupObj[rid];
            } else {
                if (rec.code * 1 > 100){ // 新規レコード未挿入でかつ用法行
                    targetRecId = lastRecId * 1 + 1;
                    if (! hasNewRecord)
                        newGroupObj[targetRecId] = newRec; // 新規レコードを挿入
                    //console.log("新規レコードを用法位置に挿入", rid, targetRecId); //######
                    newGroupObj[rid] = groupObj[rid];
                } else {
                   if (rid * 1 < recId * 1){ // 同じ recordId をそのままコピー
                        newGroupObj[rid] = groupObj[rid];
                    } else if (rid == recId){ // 新規レコード挿入し、既存レコードの recordId を後へシフト
                        newGroupObj[rid] = newRec; // 新規レコードを挿入
                        hasNewRecord = true; // 新規レコードが挿入された
                        //console.log("新規レコードを薬剤位置に挿入", rid, targetRecId); //######
                        newGroupObj[rid*1+1] = groupObj[rid];
                    } else {
                        newGroupObj[rid*1+1] = groupObj[rid];
                    }
                }
            }
            lastRecId = rid;
        }
        resultObj[gid] = newGroupObj;
    }

    // 挿入情報として groupId, recId, targetRecId を記憶
    var obj = new Object();
    obj.records = resultObj;
    obj.groupId = groupId;
    obj.recordId = recId;
    obj.insertId = targetRecId; // 挿入すべきレコードの ID
    obj.isTail = (tailFlag) ? true : false; // 挿入すべき位置が「最終の空行」か否かのフラッグ
    setInsertInfo(obj);

    // 新規薬剤選択パネルを開く
    openSelectMedicinePanel(groupId, recId, targetRecId, tailFlag);
}

function removeRecord(groupId, recId, code){
    // 表示された処方箋を削除（DB 内容は変更しない）
    var obj = prescriptionObject();
    if (groupId == "all"){
        setPrescriptionObject(new Object()); // 全ての行を削除
    } else if (code > 100){ // 削除対象が用法行
        // 用法グループをまとめて削除
        delete obj[groupId];
    } else { // 削除対象が薬剤行
        var groupObj = obj[groupId];
        if (objectCount(groupObj) <= 2){ // objectCount(): lib.js
            // 削除対象のグループが 対象行と用法行だけ ならグループごと削除
            delete obj[groupId];
        } else {
            // 削除対象の薬剤行のみ削除
            delete groupObj[recId];
        }
    }
    showShohou();
}

function markeToNameIfNotGeneric(obj){
    // generic 変換不可の薬剤名行頭に * をつける
    var newObj = new Object();
    for (key in obj){
        var val = obj[key];
        if (typeof(val) == "object"){
            // グループの中を処理
            newObj[key] =  markeToNameIfNotGeneric(val);
        } else if (obj.code == 999){
            // コメントはそのまま
            newObj[key] =  val;
        } else {
            // レコードの処理
            if (key == "name"){
                if (obj.notGeneric)
                    newObj[key] = "*" + obj.name; // generic へ変更禁止
                else if (obj.name != obj.generic)
                    newObj[key] = " " + obj.name; // generic
                else 
                    newObj[key] = obj.name;       // 商品名
            } else
                newObj[key] =  val;
        }
    }
    return newObj;
}
function doSendPrescription(obj){
    // 処方箋データを電子カルテ・クライアントへ送る
    var robj = receivedObj(); // NOA 側から送られた情報
    robj.isOwn = isOwn(); // 自費フラッグをつける
    robj.prescription = obj; // こちら側で作成した処方を挿入

    // 処方内容を確認・印刷
    printShohou();

    // 処方箋を電子カルテ・クライアントへ返送
    var preObj = markeToNameIfNotGeneric(robj.prescription);
    robj.prescription = preObj;
    var value = encodeObject(robj); // NOA 形式の方が簡潔・確実な処理

    // NOA へ結果を返送し保存
    getPrescription(value, true);
}
function sendPrescription(){
    // 「確定」ボタン：処方箋データを電子カルテ・クライアントへ送る === CellEditor.js から使われる ===
    if (currentLabel() != originalPrescLabel()){
        alert("「 " + originalPrescLabel() + " 」欄を開き「確定」しなおしてください");
        return;
    }

    var obj = prescriptionObject();
    
    // obj に generic を加えるようサーバへ依頼
    // サーバからの返答により doSendPrescription(obj) を起動
    getGeneric(obj);
}

function youhouChanged(cellId){
    // 用法行が変更された時に呼ばれ、変更結果を prescriptionObject に反映
    var obj = prescriptionObject();
    var array = cellId.split(".");
    var gid = array[0]; // group ID
    var rid = array[1]; // row ID
    var groupObj = obj[gid];
    var rowObj = groupObj[rid];
    
    // prescriptionObject の値を更新
    var item = document.getElementById("usage"+cellId).value;
    rowObj.name = item; // 変更された用法を更新
    
    setPrescriptionObject(obj);
}

function dose_changed(cellId, code, name){
    // 投与量が変更された時に呼ばれ、変更結果を prescriptionObject に反映
    // 用法行が変更された時に呼ばれ、変更結果を prescriptionObject に反映
    var obj = prescriptionObject();
    var array = cellId.split(".");
    var gid = array[0]; // group ID
    var rid = array[1]; // row ID
    var groupObj = obj[gid];
    var rowObj = groupObj[rid];
    
    // prescriptionObject の値を更新
    var item = document.getElementById("dose"+cellId).value;
    rowObj.dose = item; // 変更された用法を更新
    
    //console.log("dose_changed", encodeObject(obj)); //##
    
    setPrescriptionObject(obj);
}

function unitChanged(cellId){
    // 投与量が変更された時に呼ばれ、変更結果を prescriptionObject に反映
    var obj = prescriptionObject();
    var array = cellId.split(".");
    var gid = array[0]; // group ID
    var rid = array[1]; // row ID
    var groupObj = obj[gid];
    var rowObj = groupObj[rid];
    
    // prescriptionObject の値を更新
    var item = document.getElementById("unit"+cellId).value;
    rowObj.unit = item; // 変更された単位を更新
    
    setPrescriptionObject(obj);
}

function changeGeneric(groupId, recId){
    // recId のチェックボックスが変更された
    var obj = prescriptionObject();
    var groupObj = obj[groupId];
    var recObj = groupObj[recId];
    var cb = document.getElementById(groupId+"."+recId+"generic");
    recObj.notGeneric = (cb.checked) ? 1 : 0;
}

function showShohou(){
    // obj:処方オブジェクトを HTML として展開表示
    var elm = elmFor("prescContentsArea");
    elm.innerHTML = "";
    
    var tbl = newTABLE(elm,"contentsTable/no-frame-table"); // cell-space の無いテーブル
    tbl.style.fontSize = "9pt";
    var no=0;
    var groupId = -1; // obj が空の場合に使われる
    var obj = prescriptionObject();
    for (groupId in obj){
        var groupObj = obj[groupId];
        for (recId in groupObj){
            var recObj = groupObj[recId];
            recObj.code = recId; // recId をコードとして recObj に記憶
            var tr = newTR(tbl,"");
            
            // 追加アイコン
            if (! isReadOnly()){
                var td = newTD(tr, groupId+"."+recId+"row");
                td.style.padding = "0 10px";
                var im = newIMAGE(td, groupId+"."+recId+"add/expandIcon", "./add-field.png", "X");
                im.setAttribute("onclick", "prepareForInsert('"+groupId+"','"+recId+"')");
                im.style.height = "14px";
                setInfoTip(groupId+"."+recId+"add", "この行に薬剤を挿入"); // INFO
            }

            no++;
            
            // code:"22,21"の場合の対応
            var code = firstCodeOf(recObj.code);
            var cid = groupId+"."+recId;
            
            if (code < 100){ // === 薬剤行 ======================
                // 後発品へ変更不可チェックボックス
                var td = newTD(tr,"","");
                td.style.paddingRight = "10px";
                var status = (recObj.notGeneric) ? 1 : 0;
                var cb = newCHECKBOX(td, groupId+"."+recId+"generic", "", status);
                var action = "changeGeneric('"+groupId+"','"+recId+"')";
                cb.setAttribute("onchange", action);
                setInfoTip(groupId+"."+recId+"generic", "後発品へ変更不可"); // INFO

                // 薬剤名
                newTEXT(td, recObj.name);
                
                // 投与量
                var td = newTD(tr,"","");
                var dose = (recObj.dose) ? recObj.dose : "";
                var fd = newFIELD(td, "dose"+cid, "", 3, dose);
                var args = cid + "','" + recObj.code + "','"+ recObj.name;
                var action = "dose_changed('" + args + "')";
                fd.setAttribute("onchange", action);
                
                // 単位 / 投与回数
                var td = newTD(tr,"",recObj.unit);

                // 削除アイコン
                if(! isReadOnly()){
                    var td = newTD(tr,"");
                    td.style.padding = "0 10px";
                    var im = newIMAGE(td, groupId+"."+recId+"remove/expandIcon", "./remove-field.png", "X");
                    im.setAttribute("onclick", "removeRecord('"+groupId+"','"+recId+"','"+code+"')");
                    im.style.height = "12px";
                    im.style.marginLeft = "10px";
                    setInfoTip(groupId+"."+recId+"remove", "この行を削除"); // INFO
                }
                
                // 添付文書アイコン
                var td = newTD(tr,"");
                var im = newIMAGE(td, groupId+"."+recId+"info/expandIcon", "./info.png", "X");
                im.setAttribute("onclick", "openDocument('"+recObj.name+"')");
                im.style.height = "14px";
                im.style.marginLeft = "10px";
                setInfoTip(groupId+"."+recId+"info", "添付文書を参照"); // INFO
            } else { // === isSeparator：用法行 =======================
                tr.setAttribute("class", "yellow-bar");
                
                // 用法選択ポップアップ・メニュー
                var td = newTD(tr,"");
                var youhouArray = setYouhouArray(code * 1); // 用法行を見て用法を判定
                var pu = newPopupMenu(td, "usage"+cid, youhouArray, recObj.name);
                var action = "youhouChanged('"+ cid + "')";
                pu.setAttribute("onchange", action);
                
                // 投与回数
                var td = newTD(tr,"");
                var fd = newFIELD(td, "dose"+cid, "", 3, recObj.dose);
                // recObj.name は dose_changed()中でポップアップ値から取得しなおすこと
                var args = cid + "','" + recObj.code + "','"+ recObj.name;
                var action = "dose_changed('" + args + "')";
                fd.setAttribute("onchange", action);
                
                // 投与単位名
                var td = newTD(tr,"");
                // 用法行の前の薬剤に freq(回数、個など) が設定されていればそれを使う
                var fd = newFIELD(td, "unit"+cid, "", 3, recObj.unit);
                var action = "unitChanged('" + cid + "')";
                fd.setAttribute("onchange", action);
                
                // 削除アイコン
                if (! isReadOnly()){
                    var td = newTD(tr,"");
                    td.style.padding = "0 10px";
                    var im = newIMAGE(td, groupId+"."+recId+"remove/expandIcon", "./remove-field.png", "X");
                    im.setAttribute("onclick", "removeRecord('"+groupId+"','"+recId+"','"+code+"')");
                    im.style.height = "12px";
                    im.style.marginLeft = "10px";
                    setInfoTip(groupId+"."+recId+"remove", "この用法の関連行を一括削除"); // INFO
                }
           }
        }
    }
    
    // === terminator：最終行 ====================================
    // 選択されたラジオボタン位置に薬剤が挿入されるので、これがないと最終行に追加できない
    // 最終行の削除で、すべてを一括削除できる
    var tr = newTR(tbl,"record","");
    
    // 追加アイコン
    groupId = (groupId == (-1)) ? 0 : groupId*1 + 1;
    recId = 0;
    var td = newTD(tr, groupId+"."+recId+"row");
    td.style.padding = "0 10px";
    
    if (! isReadOnly()){
        var im = newIMAGE(td, "addTail/expandIcon", "./add-field.png", "X");
        im.setAttribute("onclick", "prepareForInsert('"+groupId+"','"+recId+"','tail')");
        im.style.height = "14px";
        setInfoTip("addTail", "この行に薬剤を挿入：約束処方も挿入できます"); // INFO
    }

    var td = newTD(tr,""); // 薬剤名
    var td = newTD(tr,""); // 投与量
    var td = newTD(tr,""); // 投与単位

    // 削除アイコン
    if ((! isReadOnly()) && (objectCount(obj) > 0)){
        var td = newTD(tr,"");
        td.style.padding = "0 10px";
        var im = newIMAGE(td, "removeAll/expandIcon", "./remove-field.png", "X");
        im.setAttribute("onclick", "removeRecord('all')");
        im.style.height = "12px";
        im.style.marginLeft = "10px";
        setInfoTip("removeAll", "処方すべてを一括削除"); // INFO
    }

    
    function setYouhouArray(cd){
        switch (cd){
            case 121: return naiyouItems();
            case 122: return tonyouItems();
            case 123: return gaiyouItems();
        }
    }
}

function yakkouClicked(elm){
    // 薬効が選択されたら、それに一致した薬剤ポップアップを生成表示
    
    // 薬効リストを閉じる
    elmFor("yakkouListArea").innerHTML = "";
    
    // 絞込欄に選択された薬効を入れる
    var yakkou = elm.innerHTML;
    elmFor("searchKey").value = yakkou;

    // 選択された薬効で絞込み
    narrowsItems(2, yakkou);
}
function showYakkouList(key){
    // 薬効リストを表示
    var elm = elmFor("yakkouListArea");
    elm.innerHTML = "";
    var div = newDIV(elm, "");
    div.style.padding = "5px";
    var array = effectArray();
    for (num in array){
        var item = array[num];
        if (key && key.length){
            if (item.indexOf(key) < 0) continue;
        }
        
        var sp = newDIV(div, "");
        sp.setAttribute("class", "blueButton");
        sp.innerHTML = item;
        var action = "yakkouClicked(this)";
        sp.setAttribute("onclick", action);
    }
}

///////////////////////////
/// Dtag and Drop /////////

function f_dragstart(event){
    // ドラッグ開始時の処理
    // ドラッグするデータのid名をDataTransferオブジェクトにセット
    event.dataTransfer.setData("text", prescriptionText());
    
    function prescriptionText(){
        var obj = prescriptionObject(); // 処方オブジェクト
        return "Rp)\n" + objectToShohouText(obj);
        
        function objectToShohouText(obj){
            // object をこの電子カルテの処方表示フォーマットへ変換
            // ## この関数は NOA の parts.js でも同じものが解凍用に使われている ##
            var buff = "";
            for (key in obj){
                var val = obj[key];
                if (typeof(val) == "object"){
                    // グループの中を処理
                    buff +=  objectToShohouText(val);
                }
                else {
                    // レコードの処理
                    if (obj.code > 100) buff += "----- "; // 用法行の場合
                    buff += obj.name + "(" + obj.dose + " " + obj.unit + ")\n";
                    return buff;
                }
            }
            return buff;
        }
    }
}

function f_dragover(event){
    // ドラッグ要素がドロップ要素に重なっている間の処理
    //　dragoverイベントをキャンセルして、ドロップ先の要素がドロップを受け付けるようにする
    event.preventDefault();
}

/// Dtag and Drop /////////
///////////////////////////

function openPliceList(){
    // PriceList を開く
    window.open("../NOAManager/priceList.php?mode=NOA","PriceList");
}

function showHistory(){
    // 処方箋の過去履歴を表示
    window.open("./history.php?patientId=" + patientId()
                ,"History"
                ,"width=600,height=1000,scrollbars=yes,resizable=yes");
}

function checkDisplayStatusForPrescText(elm){
    // 「入力欄を表示」チェックボックスの状態により入力テキストの表示・非表示を切替える
    var div = elmFor(currentTag() + ".value");
    if (elm.checked)
        div.style.display = "block"; // 入力テキストを表示する
    else
        div.style.display = "none"; // 入力テキストを非表示にする
    setShowPrescText(elm); // チェックボックスの状態を localStorage に記憶s
}

function initPrescription(elm){
    // 処方パネルを初期化
    var base = newDIV(elm, "");
    var cont = newDIV(base, "prescContents");

    // === MESSAGE AREA ===================
    var dv = newDIV(cont, "message");
    
    // === HEADER =========================
    var div = newDIV(cont, "/clearfix");
    // --- HEADER LEFT -------------------------
    var left = newDIV(div, "/left-side");
    left.style.width = "60%";
    // --- HEADER RIGHT ------------------------
    var right = newDIV(div, "/right-side");
    
    var sp = newSPAN(right, "prescHelpIcon");
    var im = newIMAGE(sp, "", "./help.png", "?");
    im.setAttribute("onclick", "openHelp('./prescHelp.html')");
    im.style.height = "18px";
    im.setAttribute("class", "expandIcon");
    im.style.position = "relative";
    im.style.bottom = "2px";
    setInfoTip("prescHelpIcon", "HELP"); // INFO

    // === 薬剤絞込・選択エリア ===============
    var div = newDIV(cont, "");
    div.style.borderTop = "thin solid #ddd";
    div.style.paddingLeft = "5px";

    // 処方内容の表示・編集エリア ======================
    var div = newDIV(cont, "prescContentsArea/tool-body");
    div.style.padding = "5px";
    div.style.marginBottom = "5px";
    div.setAttribute("draggable", "true"); // Drag out できるように設定
    div.setAttribute("ondragstart", "f_dragstart(event)");
    div.setAttribute("ondragover", "f_dragover(event)");
    
    // 注意事項行 ------------------------------------
    var div = newDIV(cont, "cautionArea");
    div.style.fontSize = "11pt";
    div.style.marginBottom = "3px";
   var obj = valueForTag("BasicSection.allergy", currentDate());
    if (obj && obj.value){
        var sp = newSPAN(div, "");
        sp.style.paddingLeft = "10px";
        sp.style.color = "#aaa";
        sp.innerHTML = "注意" ;
        var sp = newSPAN(div, "");
        sp.style.color = "#f00";
        sp.style.fontWeight = "bold";
        sp.style.paddingLeft = "5px";
        sp.innerHTML = obj.value ;
    }
    
    // === FOOTER ====================================
    if (! isReadOnly()){
        var footer = newDIV(cont, "");
        var div = newDIV(footer, "/clearfix");
        div.style.fontSize = "9pt";
        
        // --- FOOTER LEFT --------------------
        var dv = newDIV(div, "/left-side");
        dv.style.width = "60%";
        var cb = newCHECKBOX(dv, "withInquiry", "医療機関へ疑義照会し調剤 ", withInquiry());
        cb.setAttribute("onchange", "setWithInquiry(this)");
        var cb = newCHECKBOX(dv, "withInformation", "医療機関へ情報提供 ", withInformation());
        cb.setAttribute("onchange", "setWithInformation(this)");
        var sp = newSPAN(dv, "isOwnArea");
        var cb = newCHECKBOX(sp, "isOwn", "自費", isOwn());
        cb.setAttribute("onchange", "setIsOwn(this)");
        // --- FOOTER RIGHT -------------------
        var dv = newDIV(div, "/right-side");
        var cb = newCHECKBOX(dv, "", "入力欄を表示", showPrescText());
        cb.setAttribute("onclick", "checkDisplayStatusForPrescText(this)");
        checkDisplayStatusForPrescText(cb); // チェック状態によりテキストの表示・非表示を設定
        var status = isTouchAndGo();
        var cb = newCHECKBOX(dv, "prefConfirmCheck", "確認して印刷", prefConfirmPanel());
        cb.setAttribute("onchange", "setPrefConfirmPanel(this)");
        
        var div = newDIV(footer, "/clearfix");
        
        // === メンテナンス用アンカーを置くエリア ================
        // --- LEFT SIDE ---------------------
        var dv = newDIV(div, "/left-side");
        dv.style.width = "60%";
        var ul = newUL(dv, "");
        ul.setAttribute("class", "listMembers");
        ul.style.padding= "0 0 8px 0";
        var li = newLI(ul, "過去履歴");
        li.setAttribute("class", "listMember");
        li.setAttribute("onclick", "showHistory()");
        if (isSuperUser()){
            var li = newLI(ul, "PriceList 編集");
            li.setAttribute("class", "listMember");
            li.setAttribute("onclick", "openPliceList()"); // source: usgeEditor.js
        }
        var li = newLI(ul, "用法編集");
        li.setAttribute("class", "listMember");
        li.setAttribute("onclick", "showUsageEditor()"); // source: usgeEditor.js
        var li = newLI(ul, "約束処方");
        li.setAttribute("class", "listMember");
        li.setAttribute("onclick", "showGroupEditor()"); // source: groupEditor.js
        // --- RIGHT SIDE ----------------------
        var dv = newDIV(div, "/right-side");
        var sp = newSPAN(dv, "");
        sp.innerHTML = version();
        sp.style.color = "#ccc";
        sp.style.fontSize = "9pt";
        
        // 約束処方登録エリア：usageEditor.js groupEditor.js で使う
        var dv = newDIV(cont, "pr_editorArea");
    }

     // 伝票を開いた CELL の ラベル名 を記憶
    var label = currentLabel();
    setOriginalPrescLabel(label);

    //console.log("initPrescription -- hospInfo", encodeObject(hospitalInfo())); //##

    // 処方内容を表示
    getUsageList();
}

function version(){
    return "Ver.180404";
}

