var _itemArray; // = new Array(); // Global 変数
var _groupCode; // = new Array(); // Global 変数

function initItemArray(){
    _itemArray = new Array();
}
function setItemArray(array){
    _itemArray = array;
}
function itemArray(){
    return _itemArray;
}
function addItemArray(item){
    _itemArray.push(item);
}
function removeItemArray(number){
    for (var i=_itemArray.length-1; i >= 0; i--){
        var _item = _itemArray[i];
        if (number == _item.number) _itemArray.splice(i, 1);
    }
}
function countOfItemArray(){
    return _itemArray.length;
}
function itemAtIndexOf(ix){
    // itemArray の ix 番目の item を返す
    return (ix < _itemArray.length) ? _itemArray[ix] : null;
}
function itemWithId(number){
    // number を ID とする item を返す
    var count = _itemArray.length;
    for (var i=0; i < count; i++){
        var item = _itemArray[i];
        if (item.number == number) return item;
    }
    return null;
}

var _currentRecords; // = new Array(); // Global 変数
function setCurrentRecords(array){
    // 現在選択されているレコードの値を記憶
    _currentRecords = array;
}
function currentRecords(){
    return _currentRecords;
}

function groupCode(){
    // 診療行為のコード番号を返す
    return _groupCode;
}
function setGroupCode(code){
    // 診療行為の種類が選択された
    if (_groupCode){
        var elm = document.getElementById("item:"+_groupCode);
        elm.style.backgroundColor="#bfe";
        elm.style.color="#000";
    }
    
    _groupCode = code;
    var elm = document.getElementById("item:"+code);
    elm.style.backgroundColor="#00f";
    elm.style.color="#ffa";
    
    //console.log("setGroupCode", code); //##
    
    getItemList(code);
}

var _medicalActions;
function setMedicalActions(obj){
    //console.log("== setMedicalActions->"+encodeObject(obj)); //##
    //console.log("== itemMatrix("+encodeObject(obj.itemMatrix)+")"); //##
    
    _medicalActions = obj;
}
function medicalActions(){
    // 診療行為メニュー・オブジェクトを返す
    return _medicalActions;
}

//////////////////////////////////
///// HospitalTable からの継承値 ///

var _round; // Global 変数
var _ownRate; // Global 変数
function vin_setHospitalInfo(obj){
    // obj = "round(5)ownRate(20)"
    _round = obj.round;
    _ownRate = obj.ownRage;
}

function ownRate(){
    // 自費料金を計算するための点数への掛け率
    return _ownRate;
}

///// HospitalTable からの継承値 ///
//////////////////////////////////



/////////////////////////
///// カルテからの継承値 ///

function parameters(){
    // patientId, ageOfTheMoon
    // を vinServer へ渡すための変数パッケージ
    var array = new Array();
    array['owner'] = owner();
    array['hospitalId'] = hospitalId();
    array['patientId'] = patientId();
    array['entryDate'] = currentDate();
    array['age'] = ageOfTheMoon();
    var elm = elmFor("timeZone");
    array['timeZone'] = (elm) ? elm.value : "";
    if (vin_hasTax()) array['taxRate'] = taxRate() / 100; // 消費税
    array['isInTime'] = (currentTimeZone() == "時間内") ? 1 : 0;
    array['isHoliday'] = (todayIsHoliday()) ? 1 : 0;
    
    return array;
    
    function ageOfTheMoon(){
        // patientId と本日の年月日から年齢を計算して返す
        var pid = patientId();
        var yy = pid.substr(4,2) * 1;
        var yyyy = (yy > 25) ? 1900 + yy : 2000 + yy;
        var mm = pid.substr(0,2) * 1;
        var dd = pid.substr(2,2) * 1;
        var birthDate = yyyy + "-" + mm + "-" + dd;
        
        return ageAtDate(birthDate, currentDate());
    }
}

///// カルテからの継承値 ///
/////////////////////////

///////////////////////////////////////
///// レコードの文字列化はここで管理     ///
///// vin.php 側では newItem() で管理 ///

function archives(){
    // itemArray を 診療行為の表示行 に変換して返す
    // 「テンプレート登録」に使う
    _debug("== archives =="); //##
    var results = new Array();
    var array = treatmentArray();
    if (array.length > 0){
        for (num in array){
            var rec = array[num];
            var ln = treatmentFormat(rec);
            results.push(ln);
        }
    }
    return results.join("\n");
}

function treatmentArray(){
    // itemArray を 診療行為オブジェクトの配列 に変換して返す
    // 「サーバへ計算依頼」に使う
    var array = new Array();
    var count = countOfItemArray();
    if (count > 0){
        var items = itemArray();
        for (num in items){
            var item = items[num];
            if (item.code % 10 == 9) continue; // 自動付加行はスキップ
            if (item.code * 1 == 13) continue; // 自動付加行はスキップ
            
            array.push(encodeItemObj(item));
        }
    }
    //console.log("treatmentArray", encodeObject(array)); //##
    
    return array;
    
    
    function encodeItemObj(item){
        // item を 診療行為オブジェクト に変換して返す
        //alert("encodeItem->"+encodeObject(item)); //##
        
        var rec = new Object();
        rec.number = item.number;
        rec.isOwn = (item.isOwn * 1 > 0) ? 1 : 0;
        rec.code = item.code;
        rec.alias = item.alias;
        rec.name = item.name;
        rec.dose = item.dose;
        rec.standard = item.dose;
        if ((rec.standard.length == 0) || (rec.standard * 1 == 0))
            rec.standard = 1;
        rec.unitName = item.unitName;
        rec.freq = item.freq;
        rec.point = item.point; // 空データの場合は calc() 時にサーバ側で PriceList から補完
        rec.isMix = item.isMix;
        rec.editable = 0;
        
        // 名前の頭に "+ " があれば混注
        if (item.name.indexOf("+ ") >= 0){
            rec.isMix = "1";
            rec.name = item.name.substr(2);
        }
        
        return rec;
    }
}

function codeArray(){
    // コード番号の配列を返す
    return [11,12,13,21,22,23,29,31,32,33,41,48,51,52,58,60,69,70,80,90,91];
}
function codeName(code){
    // ### vinServer.js の codeName() と同じであること ###
    switch (code * 1){
        case 11: return "初診";
        case 12: return "再診";
        case 13: return "診他";
        case 21: return "内服";
        case 22: return "屯服";
        case 23: return "外用";
        case 29: return "薬加";
        case 31: return "皮注";
        case 32: return "静注";
        case 33: return "点滴";
        case 41: return "処置";
        case 48: return "処薬";
        case 51: return "手術";
        case 52: return "麻酔";
        case 58: return "手薬";
        case 60: return "検査";
        case 69: return "判断";
        case 70: return "画像";
        case 80: return "其他";
        case 90: return "入院";
        case 91: return "入他";
        default: return "";
    }
}
function codeForName(name){
    // name に対応する code を返す
    var array = codeArray();
    for (num in array){
        var code = array[num];
        var nm = codeName(code);
        if (name == nm) return code;
    }
    return 0;
}

function newItem(rec){
    // rec = isOwnFee(0)code(11)alias()name(初診)dose()unitName()freq(1)point(270)isMix()
    // アイテム属性を記憶した Item Class を生成し itemArray に保存
    //_debug("== newItem->"+encodeObject(rec)); //##
    
    var item = new Object();
    var number = countOfItemArray();
    
    item.number = number; // item の ID (必ずしも itemArray 中の順番ではない)
    item.subItems = new Array();
    item.isOwn = rec.isOwn; // ####
    item.code = rec.code;
    item.alias = rec.alias;
    item.name = rec.name;
    item.dose = (rec.dose * 1 > 0) ? rec.dose : 1;;
    item.standard = (rec.standard * 1 > 0) ? rec.standard : 1;
    item.unitName = rec.unitName;
    item.freq = (rec.freq * 1 > 0) ? rec.freq : 1;;
    item.point = rec.point; // 空データの場合は calc() 時にサーバ側で PriceList から補完
    item.isMix = rec.isMix;
    item.editable = 0;
    
    // 名前の頭に "+ " があれば混注
    if (item.name.indexOf("+ ") >= 0){
        item.isMix = "1";
        item.name = item.name.substr(2);
    }
    
    addItemArray(item); // number を取り出した後で実行すること
    
    return item;
}

function doseChanged(row){
    // row 行目のレコードの単位数が変更された
    var item = itemAtIndexOf(row);
    item.dose = document.getElementById(row + ".dose").value;
}

function freqChanged(row){
    // row 行目のレコードの回数が変更された
    var item = itemAtIndexOf(row);
    item.freq = document.getElementById(row + ".freq").value;
}

///// レコードの文字列化はここで管理 ///
///////////////////////////////////

///////////////////////////////////
/// vinHistory に関する処理 /////////

function putHistory(records){
    // 過去履歴から選択された内容を診療行為へセット
    var array = new Array();
    var no = 0;
    for (num in records){
        var ln = records[num]; // 内服[アドナ錠１０ｍｇ(3 錠)] 2 x 5 自費
        //console.log("putHistory", ln); //##
        if (ln.length == 0) continue;
        
        var ary = ln.split("[");
        var codest = trim(ary[0]); // 内服
        if (codest == "合計") continue;
        
        var rec = new Object();
        rec.code = codeForName(codest);
        if (rec.code % 10 == 9) continue; // code の下一桁が 9 は自動追加項目
        
        //console.log("putHistory", ln); //##
        
        ln = ary[1]; // アドナ錠１０ｍｇ(3 錠)] 2 x 5 自費
        ary = ln.split("]");
        ln = ary[0]; // アドナ錠１０ｍｇ(3 錠)
        var right = ary[1]; //  2 x 5 自費
        
        rec.dose = "";
        rec.isMix = "";
        rec.alias = ""; // records からは検出できない
        rec.unitName = "";
        
        ary = ln.split("(");
        var st = ary[0]; // アドナ３０ｍｇ
        //console.log("---", rec.name, "("+ln+")"); //##
        if (ary.length > 1){ // name(dose unit) 型式
            var st2 = ary[1]; // 1 錠)
            var ary2 = st.split("+ ");
            if (ary2.length > 1){
                rec.name = ary2[1];
                rec.isMix = "1";
                st = ary[1]; // 3 錠) ...
            } else {
                rec.name = ary[0];
            }
            var ary3 = st2.split(")");
            st = ary3[0]; // 3 錠
            console.log("-->", "("+st+")"); //##
            var ary4 = st.split(" ");
            if (ary4.length > 1){ // 3 錠
                rec.dose = ary4[0];
                rec.unitName = ary4[1];
            } else { // 3錠　のように間に空白がない形式
                rec.dose = "";
                rec.unitName = "";
                for (i=0,len=st.length; i < len; i++){
                    var ch = st.substr(i,1);
                    if (isDigit(ch)){
                        rec.dose += ch;
                    } else {
                        rec.unitName = st.substr(i);
                        break;
                    }
                }
            }
            //console.log("--->", "dose("+rec.dose+")", "unitName("+rec.unitName+")"); //##
        } else { // name 型式
            rec.name = ary[0];
        }
        rec.number = no++; // records からは検出できない
        
        // "2 x 5 自費" の処理
        ary = right.split("自費");
        if (ary.length > 1)
            rec.isOwn = "1";
        else
            rec.isOwn = "";
        // 点数
        ln = ary[0];
        ary = ln.split("x");
        rec.point = trim(ary[0]); // 点数空白の場合は数値に変換せず文字列そのまま
        // 投与回数
        rec.freq = 1;
        if (ary.length > 1)
            rec.freq = trim(ary[1]) * 1;
        
        console.log("rec", encodeObject(rec)); //##
        array.push(rec);
    }
    
    // records を診療入力ツールに入力
    setItemArray(array);
    
    showItemList();
}

/// vinHistory に関する処理 /////////
///////////////////////////////////

///////////////////////////////////
///// Ajax による処理 ///////////////

function getTimeZone(buff){
    // buff を解析して時間区分を返す
    if (arrayHasItem(_timeArray, buff)) // buff が timeZone そのものである場合
        return buff;
    
    // ",,0000,0600,深夜^,,2200,2400,深夜^,日,0000,2400" 形式を解析して時間区分を返す
    var year = currentDate().substr(0, 4);
    var month = currentDate().substr(5, 2);
    var day = currentDate().substr(8, 2);
    var date = new Date(year, month - 1, day);
    var d = date.getDay();
    var week = _weeks[d];
    var weekNum = Math.ceil(day / 7);
    var hour = currentDate().substr(11, 2);
    var min = currentDate().substr(14, 2);
    var time = hour + min;
    
    // 指定した日時の時間区分をチェックする
    var array = decodeCSV(buff);
    for (row in array){
        var obj = array[row];
        var result = timeZone(obj,weekNum,week,time);
        
        if (result.length > 0){
            return result;
        }
    }
    return "時間外";
    
    function timeZone(obj, weekNum, week, time){
        // 時間区分を返す
        if (obj.num)
            if (obj.weekNum != weekNum) return "";
        if (obj.week)
            if (obj.week != week) return "";
        if (obj.from > time)
            return "";
        if (obj.to < time)
            return "";
        return obj.timeZone;
    }
    
    function decodeCSV(csv){
        // csv を conditions オブジェクトへ変換
        var results = new Array();
        var array = csv.split("^");
        for (row in array){
            var ln = trim(array[row]);
            
            var ary = ln.split(",");
            if (ary.length == 5){
                var obj = new Object();
                obj.weekNum = ary[0];
                obj.week = ary[1];
                obj.from = ary[2];
                obj.to = ary[3];
                obj.timeZone = ary[4];
                results.push(obj);
            }
        }
        
        if (results.length == 0){
            // csv に解析できるものがなければ default 条件を生成定
            var obj = new Array();
            obj.from = "0000";
            obj.to = "0600";
            obj.timeZone = "深夜";
            results.push(obj);
            
            var obj = new Array();
            obj.from = "2200";
            obj.to = "2400";
            obj.timeZone = "深夜";
            results.push(obj);
            
            var obj = new Array();
            obj.week = "日";
            obj.from = "0000";
            obj.to = "2400";
            obj.timeZone = "休日";
            results.push(obj);
            
            var obj = new Array();
            obj.from = "0900";
            obj.to = "1200";
            obj.timeZone = "時間内";
            results.push(obj);
        }
        
        return results;
    }
}

/////////////////////////////////////////////////////////////
///// Ajax: VIN は独立して動くので LOGIC:neuron.js の部分を内部に持つ

function setItemMatrix(elm, action){
    // 診療行為マトリックスを生成：vinCalcChecker.js からも利用される
    // obj = 一括(00) 初診(11) 再診(12) 診他(13) 内服(21) 屯服(22) 外用(23) 薬加(29) 皮注(31) 静注(32) 点滴(33) 処置(41) 処薬(48) 手術(51) 麻酔(52) 手薬(58) 検査(60) 判断(69) 画像(70) 其他(80) 入院(90) 入他(91)
    var obj = medicalActions().itemMatrix;
    //console.log("setItemMatrix --("+encodeObject(medicalActions().itemMatrix)+")"); //##
    var ul = newUL(elm, "");
    ul.setAttribute("class", "listMembers");
    for (key in obj){
        var code = obj[key];
        var li = newLI(ul, key);
        li.setAttribute("id", "item:"+code);
        li.setAttribute("class", "blueButton");
        li.setAttribute("onclick", action + "('" + code + "')");
    }
}

var _timeArray = ["時間内","時間外","休日","深夜"];
var _currentTimeZone;
function setCurrentTimeZone(timeZone){
    _currentTimeZone = getTimeZone(timeZone);
}
function currentTimeZone(){
    // 現在のタイムゾーンを返す
    return _currentTimeZone;
}
function timeZonePopChanged(elm){
    // タイムゾーン・ポップアップメニューの status が変更された
    setCurrentTimeZone(elm.value);
}
function showTimeZonePopup(){
    var elm = elmFor("timeZoneArea");
    elm.innerHTML = "";
    // 内服や注射 なら INFO ICON を表示する
    var array = [11, 12];
    var code = groupCode(); // 診療行為のコード番号
    if (indexOfArray(array, code) >= 0){
        // 診療行為ポップアップメニューを生成
        var pu = newPopupMenu(elm, "timeZone", _timeArray, currentTimeZone());
        pu.setAttribute("onchange", "timeZonePopChanged(this)");
    } else {
        var sp = newSPAN(elm, "timeZoneLabel", currentTimeZone());
        sp.style.padding = "3px 2px 0 0";
        setInfoTip("timeZoneLabel", "時間区分は初診か再診で変更可"); // INFO
    }
}

function gotCheckList(answer){
    // 病名チェックリストを読み込んだ
    var obj = JSON.parse(answer);
    //console.log("gotCheckList===", encodeObject(obj)); //###
    setCheckList(obj); // vinCalcChecker.js
    
    getFiter(); // フィルター・接頭語・設備後を読み込んでおく
}
function putHeader(answer){
    // サーバから返されたヘッダー部分を表示
    initItemArray();
    var obj = JSON.parse(answer);
    setMedicalActions(obj);
    
    if (! isReadOnly()){
        // 診療行為マトリックスを表示
        var elm = document.getElementById("matrixArea");
        elm.innerHTML = "";
        setItemMatrix(elm, "setGroupCode");
    }
    
    // 診療時間帯を記憶
    setCurrentTimeZone(obj.timeZone);
    
    // hospitalTable などから施設固有値を得る: まるめ係数・自費係数
    vin_setHospitalInfo(obj.hospitalInfo);
    
    // カルテが記憶していた診療行為セットを itemArray にセット
    var itemList = obj.itemList;
    if (itemList.length > 0){
        for (num in itemList){
            var rec = itemList[num];
            // この中の point はカルテの treatment フィールドから
            // 読み出されたものなので point * dose 処理がされている
            // ln:静注[ピドキサール注１０ｍｇ(1 管) 混注] 6
            newItem(rec);
        }
        showItemList();
    }
    
    // 病名チェッカーのチェックリストを読み込む
    NRCall("GET_DISEASE_FROM_PRICELIST", [], gotCheckList);
}
function getHeader(){
    // onload で起動されるアクション：サーバにヘッダー部分の生成を依頼し表示
    var args = new Object();
    args['owner'] = owner();
    args['hospitalId'] = hospitalId();
    args['patientId'] = patientId();
    args['entryDate'] = currentDate();
    args['age'] = ageOfTheMoon();
    var elm = elmFor("timeZone");
    args['timeZone'] = (elm) ? elm.value : "";
    
    NRCallVin("GET_VIN_HEADER", args, putHeader);
    
    function ageOfTheMoon(){
        // patientId と本日の年月日から年齢を計算して返す
        var pid = patientId();
        var yy = pid.substr(4,2) * 1;
        var yyyy = (yy > 25) ? 1900 + yy : 2000 + yy;
        var mm = pid.substr(0,2) * 1;
        var dd = pid.substr(2,2) * 1;
        var birthDate = yyyy + "-" + mm + "-" + dd;
        
        return ageAtDate(birthDate, currentDate());
    }
}

///// Ajax: VIN は独立して動くので LOGIC:neuron.js の部分を内部に持つ
/////////////////////////////////////////////////////////////

var _items;
function setItems(array){
    _items = array;
}
function items(){
    return _items;
}

var _aliases;
function setAliases(array){
    _aliases = array;
}
function aliasForTitle(title){
    return _aliases[title];
}

//////////////////////////////////////////////////////////////
///// 添付書類表示 /////////////////////////////////////////////

var _manName;
function gotMan(answer){
    // 添付書類の URL あれば表示
    if (trim(answer).length > 0){
        var obj = JSON.parse(answer);
        var memo = obj.memo;
        var array = memo.split("URL:");
        if (array.length > 1){
            var st = array[1];
            var ary = st.split(" ");
            var url = ary[0];
            url = "../Medicine/medicine/" + url;
            window.open(url,"添付書類","width=1000,height=800,resizable=yes");
            return;
        }
    }
    // マニュアル取込ツールを開く
    window.open("./manTool.php?name="+_manName,"_blank");
}
function man(){
    // 添付書類をサーバへ要求
    var item = selectedLimitedMenu();
    if (item.length > 0){
        _manName = item;
        var args = new Object();
        args["code"] = groupCode(); // 診療行為のコード番号
        args["name"] = item;
        NRCall("GET_PRICE_LIST", args, gotMan);
    }
}
function showInfoIcon(){
    // 内服や注射 なら INFO ICON を表示する
    var array = [21, 22, 23, 31, 32, 33];
    var elm = elmFor("infoIconArea");
    elm.innerHTML = "";
    var code = groupCode(); // 診療行為のコード番号
    if (indexOfArray(array, code) >= 0){
        // 添付書類表示アイコンを表示
        var im = newIMAGE(elm, "/expandIcon", "./info.png", "?");
        im.setAttribute("onclick", "man()");
        im.style.height = "18px";
        im.style.position = "relative";
        im.style.top = "3px";
        im.style.marginRight = "5px";
    }
}

///// 添付書類表示 /////////////////////////////////////////////
//////////////////////////////////////////////////////////////

function putItemList(answer){
    // アイテムリストを表示する
    var obj = JSON.parse(answer);
    
    // "itemSelectorArea" の上に item 選択ポップアップメニュー生成
    var elm = elmFor("itemSelectorArea");
    elm.innerHTML = "";
    var items = new Array();
    var aliases = new Array();
    var item = "";
    
    // obj は {"再診料":"saishin",,} のようなオブジェクトの配列
    for (title in obj){
        var value = obj[title];
        if (title.length == 0) continue;
        if (title == "_date_check_") continue;
        
        items.push(title);  // title:"再診料"
        aliases[title] = value; // value:"saishin"
        if (isSame(value, "shoshin"))
            item = title;
        else if (isSame(value, "saishin"))
            item = title;
    }
    items.splice(0, 0, "");
    items.push("...その他");
    setItems(items);
    setAliases(aliases);
    
    // item 選択ポップアップを表示
    makeLimitedMenu(elm, items, item, 20, "itemSelected()");
    itemSelected();
    
    // INFO アイコンを表示
    showInfoIcon();

    // 時間区分ポップアップメニューを生成
    showTimeZonePopup();

    // 絞り込みフィールドを生成
    makeForcusOnArea();
    
    document.getElementById("_message").innerHTML = "";
}
function getItemList(num){
    // 診療行為マトリックスの選択で起動され、該当アイテムリストをリクエスト
    // 「一括」の場合 num は "00"
    var args = new Object();
    args.code = num;
    NRCallVin("GET_CHILD_SELECTOR", args, putItemList);
}

function putItem(){
    // 選択されたアイテムの入力欄を再描画
    if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
        var value = xmlHttpObject.responseText;
        //alert("putItem->"+value); //##
        
        var array = value.split("<SEPARATOR>");
        if (array.length > 1){
            // array[1] = "_|_21_|_pill_|_低用量ピル_|_28_|_Tab_|_53_|_0"
            // 一括テンプレートの場合は複数レコード
            var records = JSON.parse(array[1]);
            //console.log("== putItem", encodeObject(records)); //##
            
            // ここでは選択されたアイテムに対するレコードをサーバの PriceList から得たもの
            // なので point * dose 処理がされていない。従って point は全て空にしておく。
            // 空 point だと calc() の時に PriceList の点数で補完される。
            records = pointToEmpty(records);
            
            // code に応じて「数量」「頻度」入力欄を表示
            // records[0] = "1_|_21_|_pill_|_低用量ピル_|_28_|_Tab_|_1060_|_0" 形式
            setCurrentRecords(records);
            showDoseAndFreqField(records[0]);
            
            document.getElementById("_message").innerHTML = "";
        } else
            document.getElementById("_message").innerHTML = value;
    } else
        document.getElementById("_message").innerHTML = "Loading...";
    
    function pointToEmpty(records){
        // record 中の point を全て空にする。
        // 空 point だと calc() の時に PriceList の点数で補完される。
        for (num in records){
            // "0_|_21_|_adona30mg_|_アドナ30mg_|_3_|_Tab_|_1_|_12.9_|_0" 形式のレコード
            var rec = records[num];
            if (rec) rec.point = "";
        }
        return records;
    }
}
function getItem(){
    // itemSelector（薬剤名など）が選択された時に作動
    var args = new Object();
    args.isOwn = (document.getElementById("isOwn").checked) ? 1 : 0;
    args.code = groupCode();
    
    var item = selectedLimitedMenu();
    args.alias = aliasForTitle(item);
    args.owner = owner();
    
    NRCallVin("GET_ITEM", args, putItem);
}

function overlappedItem(){
    // 重複した診療行為があればそれを返し、なければ null を返す
    var obj = new Object();
    var array = itemArray();
    for (num in array){
        var rec = array[num];
        var item = rec.code + ":" + rec.name;
        
        // item の重複をチェックするため obj の引数にする
        if (obj[item]) return item;
        
        obj[item] = "dummy";
    }
    return false;
}

function treatmentFormat(obj){
    // NOA へ返送する 診療行為フォーマット に変換
    // "外用[ホーリンV錠 (2 錠)] 220 x 2 自費" のような形式の一行を生成
    var own = (obj.isOwn * 1) ? " 自費" : "";
    
    if (obj.code * 1 == 99){
        return obj.name;
    } else {
        var freq = (obj.freq * 1 > 1) ? " x " + obj.freq : "";
        var cd = codeName(obj.code);
        
        // 混注の子の場合は名称の先頭に "+ " をつける
        var name = (obj.isMix * 1 > 0) ? "+ " + obj.name : obj.name;
        
        // 単位がある場合は (単位数 単位) を表示
        var doseUnit = (obj.unitName.length > 0)
        ? "(" + obj.dose + " " + obj.unitName + ")" : "";
        
        if (obj.name.length == 0)
            return cd + "" + obj.point + freq + own;
        else
            return cd + "[" + name + doseUnit + "] " + obj.point + freq + own;
    }
}

function putResultOfCalc(answer){
    initItemArray();
    var parentRow = (-1);
    var parentPoint;
    var records = JSON.parse(answer);
    
    for (num in records){
        var rec = records[num];
        if (rec) {
            var obj = newItem(rec); // ここでレコードを itemArray() に追加
            // obj = "isOwn(0)code(11)alias()name(初診)standard(1)unitName()freq(1)point(270)isMix()"
            
            // 混注に関する処理を行う
            if (obj.isMix == "0"){ // 混注の親レコード
                parentRow = num;
                parentPoint = obj.point * 1;
            } else if (obj.isMix * 1 > 0){ // 混注の子レコード
                parentPoint += obj.point * 1; // 親の点数に子の点数を加算
                obj.point = ""; // 子の点数は空白にする
            } else { // 混注ではない
                if (parentRow >= 0){ // 過去に混注があった
                    var parentObj = itemArray()[parentRow];
                    parentObj.point = parentPoint;
                    parentRow = (-1);
                }
            }
        }
    }
    
    if (parentRow >= 0){ // 過去に混注があった
        var parentObj = itemArray()[parentRow];
        parentObj.point = parentPoint;
    }
    
    // 静注の親の点数は、その後の子供の点数が加算されてゆき書き換えられるので、その変化を
    // 記録した itemArray():オブジェクトの配列 から転送用 rows:文字列行 を生成する
    var rows = new Array(); // NOA へ返送する文字列レコードを格納
    for (num in itemArray()){
        var rec = itemArray()[num];
        rows.push(treatmentFormat(rec)); // NOA へ返送する文字列
    }
    
    // VIN の内容を再表示
    showItemList();
    
    document.getElementById("_message").innerHTML = ""; // Ajax に渡す前に実行
    
    // NOA へ結果を返送：Ajax
    var buff = rows.join("<br>");
    //console.log("putResultOfCalc:", rows.join("\n")); //##
    
    gotValueFromTool(buff, vinTouchAndGo(), vinTouchAndPrint());
}

function timeStamped(answer){
    // 「計算せず」モードで受診レコードの endTime のみが更新された
    var rows = new Array(); // NOA へ返送する文字列レコードを格納
    var array = treatmentArray();
    for (num in array){
        var obj = array[num];
        if (obj)
            rows.push(treatmentFormat(obj)); // NOA へ返送する文字列
    }
    var buff = rows.join("<br>");
    
    // NOA へ結果を返送：Ajax
    gotValueFromTool(buff, vinTouchAndGo(), vinTouchAndPrint());
}

function calc(){
    // アイテム・リストの計算を vinServer へリクエスト
    var cDate = currentDate();
    if (isSameDate(todayAndTime(), cDate) == 0){
        if (!confirm("本日のページではありません。書き換えていいですか？"))
            return;
    }
    
    var array = treatmentArray();
    if (array.length == 0){
        if (!confirm("本日も前回と同じ診療行為ですか？"))
            return;
    }
    
    if (checkDiseases()){
        // 病名チェック：病名チェッカーが活きていれば診療行為・病名の対応チェックを行う
        doCheckDiseases(); // 診療行為と病名の突き合わせ処理を実行
    }
    
    // 現在入力されている診療行為で treatmentHistory() を更新後、フィルタリング
    var rows = new Array(); // NOA へ返送する文字列レコードを格納
    for (num in itemArray()){
        var rec = itemArray()[num];
        rows.push(treatmentFormat(rec)); // NOA へ返送する文字列
    }
    var val = rows.join("\n"); // 診療欄の内容
    setTreatmentHistoryForDateTime(val, currentDate());
    
    // もしフィルター拡張機能があればフィルタリングを行う
    if (hasFilter()){ // vinFilter.js
        var ary = filter(itemArray());
        setItemArray(ary);
    }

    var item = overlappedItem();
    if (item){
        if (!confirm(item + " が重複しています。このまま計算していいですか？"))
            return;
    }
    
    if (omitCalculate()){
        // 「集計」ボタンで計算せず FRONT に診療終了の刻印のみ
        var patientId = patientId();
        var entryDate = currentDate();
        
        // FRONT の patientId,entryDate レコードの endTime を現時刻に更新
        var args = new Object();
        args["hospitalId"] = hospitalId();
        args["patientId"] = patientId;
        args["entryDate"] = entryDate;
        args["endTime"] = "OMITCALC";
        
        NRCall("PUT_FRONT_END_TIME", args, timeStamped);
    } else {
        var args = new Object();
        args.arguments = parameters();
        args.records = treatmentArray();
        NRCallVin("CALC", args, putResultOfCalc);
    }
}

function toggleTaxRate(has_tax){
    // チェックの更新で税率入力欄を表示/非表示
    var div = elmFor("taxRateArea");
    div.innerHTML = "";
    
    if (has_tax){
        div.style.fontSize = "10pt";
        
        var rate = (taxRate()) ? taxRate() : "";
        var fd = newFIELD(div, "taxRateF", "消費税率", 5, rate);
        fd.setAttribute("onchange", "saveTaxRate(this)");
        fd.style.textAlign = "right";
        var sp = newSPAN(div, "");
        sp.innerHTML = "%";
        sp.style.paddingLeft = "5px";
    }
}

function savedHasTax(answer){
    //alert("savedHasTax->"+answer); //##
}
function saveHasTax(elm){
    // 外税付加の status をサーバへ保存
    // 初期設定パネルのチェックの更新で税率入力欄を表示/非表示
    var status = (elm.checked) ? true : false;
    toggleTaxRate(status);
    
    var tag = "VIN_PREFERENCE";
    var item = "HAS_TAX";
    var val = (status) ? "1" : "0";
    
    setPrefForKey(item, val); // medicalActions() を更新
    
    put_menu(owner(), tag, item , "", val, savedHasTax);
}

function savedTaxRate(answer){
    //alert("savedTaxRate->"+answer); //##
}
function saveTaxRate(elm){
    // 消費税率をサーバへ保存
    var rate = elm.value;
    var tag = "VIN_PREFERENCE";
    var item = "TAX_RATE";
    
    setPrefForKey(item, rate); // medicalActions() を更新
    
    put_menu(owner(), tag, item , "", rate, savedTaxRate);
}

///// Ajax による処理 ///////////////
///////////////////////////////////


function forcusOn(){
    // key に一致するメニューだけを表示
    var key = document.getElementById("focusOnF").value;
    
    // key を含むメニューのみに絞り込む
    // ## items() はメニュー表示内容なので alias も保持しておき
    // ## alias も検索対象にできるようにする
    var menuItems = new Array();
    var array = items();
    for (num in array){
        var name = array[num]; // 診療行為の実名
        var alias = aliasForTitle(name); // 実名に対応する alias
        
        // 実名か alias に部分一致したものだけを menuItems に取り込む
        if (alias && (alias.indexOf(key) >= 0)){
            menuItems.push(name);
        } else if (name.indexOf(key) >= 0){
            menuItems.push(name);
        }
    }
    
    // ポップアップメニューを表示
    var elm = document.getElementById("itemSelectorArea");
    elm.innerHTML = "";
    makeLimitedMenu(elm, menuItems, "", 20, "itemSelected()");
    itemSelected();

    // INFO アイコンを表示
    showInfoIcon();
}
function makeForcusOnArea(){
    // アイテムを絞り込みを行うフィールドを生成
    var elm = document.getElementById("focusOnArea");
    elm.innerHTML = "";
    var fd = newFIELD(elm, "focusOnF", "", 10, "");
    fd.focus();
    fd.setAttribute("onkeyup", "forcusOn()");
    fd.setAttribute("type", "search");
    fd.setAttribute("placeholder", "絞込みキー"); // 入力ヒントを表示
}

function putGlobal(answer){
    // globalList.js から返されるレスポンス
    alert("putGlobal は使われないので無処理"); //##
}
function itemSelected(){
    // itemSelector（薬剤名など）が選択された時に作動
    // ポップアップメニューに表示されたアイテムを default テンプレート名として表示
    var itemName = selectedLimitedMenu();
    
    if (itemName == ""){
        hideItemAddButton();
        return;
    } else if (itemName == "...その他"){
        // グローバル辞書からの選択パネルを表示
        // ### globalList からのメッセージは putGlobal() で受ける
        var url = "./globalList.php?code=" + groupCode();
        url += "&owner=" + owner();
        window.open(url, "globalList"
                    , "scrollbars=yes,width=900,height=500");
        return;
    }
    
    // itemSelector がアクティブの時のみ挿入ボタンを表示
    showItemAddButton();
    
    var fd = elmFor("setNameF");
    if (fd) fd.value = itemName; // 一括メニューの場合は fd 存在しない
    
    // info icon を表示
    
    getItem();
}

function showDoseAndFreqField(rec){
    // 数量・頻度入力欄を表示
    // rec: "1_|_21_|_pill_|_低用量ピル_|_28_|_Tab_|_1_|_1060_|_0" 形式のレコード
    // から default 値を表示
    if (! rec) return;
    
    var code = groupCode() * 1;
    if (code == 0) return; // 一括メニュー
    
    // 数量・頻度入力欄を表示
    var elm = document.getElementById("doseAndFreqArea");
    elm.innerHTML = "";
    // PriceList で standard が設定されていなければ dose を使う
    if (!rec.standard) rec.standard = rec.dose;
    switch (code){
        case 21: case 22: case 23:
            showDose(elm, rec.standard, rec.unitName);
            showFeq(elm, code);
            break;
        case 31: case 32: case 33:
            showDose(elm, rec.standard, rec.unitName);
            var cb = newCHECKBOX(elm, "isMix", "混注に追加", 0);
            break;
    }
    
    function showDose(elm, dose, unitName){
        var fd = newFIELD(elm, "dose", "", 3, dose);
        var tx = newTEXT(elm, unitName);
    }
    
    function showFeq(elm, code){
        var freq = 5; // ５日分に決め打ち
        var fd = newFIELD(elm, "freq", "", 2, freq);
        var tx = newTEXT(elm, freqName(code));
    }
}

function freqName(code){
    switch (code){
        case 21:
        case 22:
            return "日";
        default:
            return "回";
    }
}

function compareCode(a, b){
    // isOwn code isMix でソート： (a > b) のような比較では正しく動作しない
    return (sortString(a) * 1) - (sortString(b) * 1);
    
    function sortString(obj){
        // obj からソート用文字列を生成
        // 先頭が "0" だと正しくソートされない
        var isOwn = (obj.isOwn * 1 > 0) ? "2" : "1";
        var isMix = (obj.isMix && (obj.isMix * 1 > 0)) ? "1" : "0";
        
        return isOwn + obj.code + isMix + ""; // 数値として加算されないよう末尾に ""
    }
}
function showItemList(){
    // アイテム・リストを表示
    var elm = elmFor("resultArea");
    elm.innerHTML = "";

    // タイトル
    var tbl = newTABLE(elm, "/base-table");
    tbl.style.width = "100%";
    tbl.style.fontSize = "10pt";

    var tr = newTR(tbl, "", "");
    tr.style.color = "#777";
    tr.style.backgroundColor = "#eda"; // 薄いベージュ
    tr.style.fontSize = "10pt";
    var td = newTD(tr, "/codeCol", "code"); // コード
    var td = newTD(tr, "", "診療行為");
    var td = newTD(tr, "/doseCol", "数量");
    var td = newTD(tr, "/pointCol", "点数");
    var td = newTD(tr, "/freqCol", "頻度");
    if (! isReadOnly()){
        var td = newTD(tr, "", ""); // 削除アイコン
        var img = newIMAGE(td, "reveAllRecods/expandIcon", "./remove-field.png", "remove");
        img.setAttribute("onclick", "clearItems()");
        img.style.height = "12px";
        img.style.position = "relative";
        img.style.bottom = "1px";
        setInfoTip("reveAllRecods", "全行を一括消去"); // INFO
    }

    // 診療行為コンテンツ
    var sumItem;
    var records = itemArray();
    
    // records を isOwn,code,isMix 順でソート
    records.sort(compareCode);
    
    for (num in records){
        var item = records[num];
        //console.log("showItemList", encodeObject(item)); //##
        
        if (item.code == "0")
            continue;
        if (item.code == "99")
            sumItem = item;
        else {
            // 自費か健保かにより背景色を変える
            var trId = (item.isOwn > 0) ? "jihi" : "record";
            var tr = newTR(tbl, trId, "");
            // 自費の場合は背景色を変える
            tr.style.backgroundColor = (item.isOwn*1 == 0) ? "#ffe" : "#caecdc";

            // コード
            var td = newTD(tr, "/codeCol", ""+item.code);

            // 診療行為名（自動付加のものは背景色を変える）
            var tdId = ((item.code % 10 == 9) || (item.code * 1 == 13))
            ? "subRecord" : "";
            var td = newTD(tr, "/nameCol", "");
            var sp = newSPAN(td, tdId);
            sp.innerHTML = (item.isMix > 0) ? "+ " + item.name : item.name;
            // コード種別ごとに背景色を変える
            switch (String(item.code).substr(0, 1) * 1){
                case 4: sp.setAttribute("class", "shochi"); break;
                case 6: sp.setAttribute("class", "kensa"); break;
            }
            
            // 数量・単位
            var td = newTD(tr, "/doseCol", "");
            if ((item.code != 60) && (item.unitName.length)){
                var ary = item.unitName.split(" ");
                var fd = newFIELD(td, num + ".dose", "", 2, "" + item.dose);
                fd.setAttribute("onchange", "doseChanged('" + num +"')");
                fd.style.textAlign = "right";
                var tx = newTEXT(td, item.unitName);
            }

            // 点数：ここに表示されるものは、薬価 * 数量なので注意
            // addItem() で PriceList を元に挿入されたものは空 point
            // calc() や getHeader() で取り込まれたものは point * dose 処理済み
            var td = newTD(tr, "/pointCol", "" + item.point); // 数値のことがあるので文字列へ

            // 頻度
            var td = newTD(tr, "freqF/freqCol", "");
            var fname = freqName(item.code * 1);
            var freq = (item.isMix > 0) ? "" : item.freq;
            var fd = newFIELD(td, num + ".freq", "", 2, freq);
            fd.setAttribute("onchange", "freqChanged('" + num +"')");
            fd.style.textAlign = "right";
            var tx = newTEXT(td, fname);
            
            // 削除アイコン
            if (! isReadOnly()){
                var td = newTD(tr, "", "");
                var img = newIMAGE(td, num+"row/expandIcon", "./remove-field.png", "remove");
                var action = "removeItem('" + item.number + "')";
                img.setAttribute("onclick", action);
                img.style.height = "12px";
                setInfoTip(num+"row", "この行を削除"); // INFO
            }
        }
    }
    // 合計
    if (sumItem){
        // 合計についてはフォーマットが異なり item.name の中に入っている
        // "_|_99_|__|_合計[健保(686 x 3 = 2050)自費(5400)] 7450_|__|__|__|_"
        var tr = newTR(tbl, "sum", "");
        var td = newTD(tr, "", sumItem.name);
        td.setAttribute("colspan", "5");
    }
    
    // 絞込みフィールドをフォーカス
    var fd = document.getElementById("focusOnF");
    if (fd) fd.focus();
}

function clearItems(){
    // アイテム・リストをクリアする
    initItemArray();
    showItemList();
}

function removeItem(number){
    // number 番目の診療行為を削除
    //console.log("removeItem", number); //##
    
    removeItemArray(number);
    showItemList();
}

function hideItemAddButton(){
    elmFor("itemAddButtonArea").innerHTML = "";
}
function showItemAddButton(){
    var sp = elmFor("itemAddButtonArea");
    sp.innerHTML = "";
    // 自費チェックボックス
    var cb = newCHECKBOX(sp, "isOwn", "自費", 0);
    // 挿入ボタン
    var bt = newDIV(sp, "/whiteButton");
    bt.innerHTML = "挿入";
    bt.setAttribute("onclick","addItem()");
    bt.style.marginLeft = "3px";
}
function addItem(){
    // 選択・編集されたアイテムを診療行為リストに追加する
    // "1_|_21_|_pill_|_低用量ピル_|_28_|_Tab_|_1_|_1060_|_日分_|_" 形式のレコード
    // これを元に item オブジェクトを生成し currentItem に記憶
    var isOwnChecked = (document.getElementById("isOwn").checked) ? 1 : 0;
    console.log("== addItem groupCode(", groupCode(), ") 自費チェック(", isOwnChecked,")"); //##
    var isNotLump = (groupCode() * 1 > 0) ? true : false; // groupCode() が "00" なら一括メニュー
    console.log("単独メニュー(", isNotLump, ")"); //##
    
    var records = currentRecords();
    if (isNotLump){ // 一括メニューでない場合
        var rec = records[0];
        rec.isOwn = isOwnChecked; // 診療行為入力パネル上の自費チェックボックス値
        var elm = document.getElementById("dose");
        rec.dose = (elm) ? elm.value : "1";
        var elm = document.getElementById("isMix");
        rec.isMix = (elm && elm.checked) ? 1 : 0;
        var elm = document.getElementById("freq");
        rec.freq = (elm) ? elm.value : "1";
        // まだ rec.point は計算処理されていないので見せない
    }
    
    for (num in records){
        // 一括メニュー(約束処方)の場合を考慮し診療行為に複数を追加する
        var rec = records[num];
        if (isNotLump) // 一括メニューでない場合
            rec.isOwn = isOwnChecked; // 診療行為入力パネル上の自費チェックボックス値
        console.log("name:", rec.name, "isOwn(after):", rec.isOwn); //##
        var item = newItem(rec);
    }
    
    closeFloatPanel(); // 文字パネルを閉じる
    console.log("== addItem", encodeObject(records)); //##
    
    showItemList();
}

function printBill(){
    // 領収明細書を発行
    var obj = new Object();
    obj.currentDate = currentDate();
    obj.publishedDate = today();
    obj.patientId = patientId();
    obj.patientName = patientKanjiName();
    obj.insuranceClass = _valueForTag("HealthInsurance.shubetsu");
    obj.paymentRatio = _valueForTag("HealthInsurance.paymentRatio");
    var st = _valueForTag("PatientTable.unpaid"); // "timeStamp,unpaid" 形式
    
    var array = st.split(",");
    obj.unpaidFee = (array.length > 1) ? array[1] : "0";
    obj.discountRatio = _valueForTag("HealthInsurance.discountRatio");
    
    // VIN の医事計算レコードをスキャン
    var point = 0;
    var ownFee = 0;
    var count = countOfItemArray();
    if (count > 0){
        obj.ins = new Object();
        obj.own = new Object();
        for (var i=0; i < count; i++){
            var item = itemAtIndexOf(i);
            var code = Math.floor(item.code / 10) * 10; // "12" を "10" にする
            var freq = (item.freq) ? item.freq : 1;
            if (item.isOwn > 0){
                if (!obj.own[code]) obj.own[code] = 0;
                // code 毎の自費点数を加算
                obj.own[code] += item.point * freq;
                ownFee += item.point * freq;
            } else {
                if (!obj.ins[code]) obj.ins[code] = 0;
                // code 毎の健保点数を加算
                obj.ins[code] += item.point * freq;
                point += item.point * freq;
            }
        }
    }
    var hospInfo = hospitalInfo();
    obj.round = hospInfo.round;
    obj.ownRate = hospInfo.ownRate;
    obj.hospitalAddress = hospInfo.hospitalAddress;
    obj.hospitalName = hospInfo.hospitalName;
    obj.hospitalPhone = hospInfo.hospitalPhone;
    obj.point = point;
    obj.insFee = point * obj.paymentRatio + obj.round;
    obj.insFee = Math.floor(obj.insFee / 10) * 10;
    obj.ownFee = ownFee;
    
    if (vin_hasTax() && (taxRate() * 1 > 0)){
        // 消費税額を HospitalInfo の設定により丸め処理
        //console.log("taxRate", taxRate(), "round", obj.round); //##
        obj.tax = Math.floor(((ownFee * (taxRate()/100)) + obj.round) / 10) * 10;
    }
    //console.log("== obj->"+encodeObject(obj)); //##
    
    var url = "./printBill.php?value=" + JSON.stringify(obj);
    window.open(url, "BILL", "width=650,height=800,dependent=yes");
    
    function _valueForTag(tag){
        var obj = valueForTag(tag);
        
        // obj.value は null のことあり
        return (obj && obj.value) ? obj.value : "";
    }
}

/////////////////////////////////////////////////////
///// 初期設定 ///////////////////////////////////////

function setPrefForKey(key, value){
    // key に対応する value で medicalActions() を更新
    var array = medicalActions().preferences;
    for (num in array){
        var rec = array[num];
        if (rec.menu == key) {
            rec.value = value;
            return;
        }
    }
}
function prefForKey(key){
    // key に対応する初期設定値を返す
    var array = medicalActions().preferences;
    for (num in array){
        var rec = array[num];
        if (rec.menu == key) return rec.value;
    }
    return null;
}

function vin_hasTax(){
    // DB に記憶した消費税加算の有無を返す
    var val = prefForKey("HAS_TAX");
    
    return (val && (val * 1 > 0)) ? 1 : 0;
}
function taxRate(){
    // 外税なら消費税率を返す、そうでなければ null を返す
    var val = prefForKey("TAX_RATE");
    
    return (val) ? val : "";
}

function openVinPreference(elm){
    // 初期設定パネルを開く
    closeFloatPanel();
    
    var pos = getPosition(elm);
    var w = 300;
    var x = pos.x - w + 40; // 表示するx座標
    var y = pos.y + 18; // 表示するy座標
    var title = "診療費計算設定";
    var help = "openHelp('vinPrefHelp.html')";
    var panel = new FloatPanel("_floatPanel", x, y, w, title, help);
    if (!panel) return;
    var elm = panel.contents;
    elm.style.padding = "5px";
    elm.style.fontSize = "10pt";
    
    // 消費税
    var div = newDIV(elm, "");
    var cb = newCHECKBOX(div, "", "自費料金に外税を加算", vin_hasTax());
    cb.setAttribute("onchange", "saveHasTax(this)");
    // 税率
    var div = newDIV(elm, "taxRateArea");
    div.style.marginLeft = "20px";
    toggleTaxRate(vin_hasTax()); // 税率入力欄をチェックボックスの状態により表示・非表示
    // 領収書を発行
    var div = newDIV(elm, "");
    var st = "集計とともに領収書を発行";
    var cb = newCHECKBOX(div, "", st, hasReceipt());
    cb.setAttribute("onchange", "setHasReceipt(this)");
   // 確定保存
    var div = newDIV(elm, "");
    var st = "集計とともに「診療欄」へ結果転記・保存";
    var cb = newCHECKBOX(div, "", st, vinTouchAndGo());
    cb.setAttribute("onchange", "setVinTouchAndGo(this)");
    // 確定印刷
    var div = newDIV(elm, "");
    var st = "集計とともにカルテ・ページを印刷";
    var cb = newCHECKBOX(div, "", st, vinTouchAndPrint());
    cb.setAttribute("onchange", "setVinTouchAndPrint(this)");
    // 計算せず
    var div = newDIV(elm, "");
    var sp = newSPAN(div, "");
    var st = "集計で計算せず「診療」欄へ転記のみ";
    var cb = newCHECKBOX(sp, "", st, omitCalculate());
    cb.setAttribute("onchange", "setOmitCalculate(this)");
}

///// 初期設定 ///////////////////////////////////////
/////////////////////////////////////////////////////


function checkDisplayStatusForTreatmentText(elm){
    // 「入力欄を表示」チェックボックスの状態により入力テキストの表示・非表示を切替える
    var div = elmFor(currentTag() + ".value");
    if (elm.checked)
        div.style.display = "block"; // 入力テキストを表示する
    else
        div.style.display = "none"; // 入力テキストを非表示にする
    setShowTreatmentText(elm); // チェックボックスの状態を localStorage に記憶s
}

function openPliceList(){
    // PriceList を開く
    window.open("../NOAManager/priceList.php?mode=NOA","PriceList");
}

function openVinHistory(){
    // 過去履歴ツールを開く
    var url = "vinHistory.php?patientId=" + patientId();
    window.open(url, "vinHistory", "left=100,width=600,height=1000,scrollbars=yes");
}

function checkDilayStatusForTreatmentText(elm){
    // 「入力欄を表示」チェックボックスの状態により入力テキストの表示・非表示を切替える
    var div = elmFor(currentTag() + ".value");
    if (elm.checked)
        div.style.display = "block"; // 入力テキストを表示する
    else
        div.style.display = "none"; // 入力テキストを非表示にする
    setShowTreatmentText(elm); // チェックボックスの状態を localStorage に記憶s
}

function initVin(base){
    // 診療費計算ツールを base 上に生成
    var elm = newDIV(base);
    
    // === HEADER ============================
    var div = newDIV(base, "/clearfix");
    
    // HEADER LEFT ====================
    var dv = newDIV(div, "/left-side");
    // ヘッダー・ラベル ------------------
    var bt = newSPAN(dv, "");
    bt.innerHTML = "診療入力";
    bt.style.fontSize = "10pt";

    // HEADER RIGHT ===================
    var dv = newDIV(div, "/right-side");
    // サブ・メニュー -------------------
    if (! isReadOnly()){
        var img = newIMAGE(dv, "menuIcon/expandIcon", "./menu3.png", "remove");
        img.setAttribute("onclick", "openVinPreference(this)");
        img.style.height = "10px";
        img.style.marginRight = "5px";
        setInfoTip("menuIcon", "診療費計算設定"); // INFO
    }
    // HELP --------------------------
    var im = newIMAGE(dv, "helpIcon/expandIcon", "./help.png", "?");
    im.setAttribute("onclick", "openHelp('vinHelp.html')");
    im.setAttribute("verticalAlign", "middle");
    im.style.height = "16px";
    im.style.position = "relative";
    im.style.top = "3px";
    setInfoTip("helpIcon", "HELP"); // INFO

    // CONTENTS =====================================
    var cont = newDIV(base, "vinContentArea");
    cont.style.backgroundColor = "#ffe";
    cont.style.padding = "5px";
    cont.style.border = "thin solid #ccc";
    
    if (! isReadOnly()){
        // === 診療マトリックス表示・エリア ==================
        var div = newDIV(cont, "matrixArea");
        
        // === 入力作業エリア ========================
        var div = newDIV(cont, "");
        div.style.padding = "0 0 0 2px";
        div.style.fontSize = "9pt";
        var tbl = newTABLE(div, "base-table");
        tbl.style.fontSize = "8pt";
        var tr = newTR(tbl, "", "");
        // 時間外ポップアップメニュー
        var td = newTD(tr, "timeZoneArea", "");
        td.style.padding = "5px 0";
        // 初期状態の場合のみバージョンを表示
        var sp = newSPAN(td, "");
        sp.innerHTML = vin_version();
        sp.style.color = "#aaa";
        // 処置内容選択エリア
        var td = newTD(tr, "itemSelectorArea", "");
        td.style.padding = "5px 0";
        // 絞り込みキー入力エリア
        var td = newTD(tr, "focusOnArea", "");
        td.style.padding = "5px 0";
        // info icon エリア
        var td = newTD(tr, "infoIconArea", "");
        // 診療行為名・挿入ボタン
        var td = newTD(tr, "", "");
        td.style.padding = "5px 0";
        var sp = newSPAN(td, "doseAndFreqArea");
        sp.style.marginRight = "3px";
        var td = newTD(tr, "", "");
        var sp = newSPAN(td, "itemAddButtonArea");
    }

    // === 診療行為表示・エリア：診療行為行を列記するエリア =====
    var div = newDIV(cont, "resultArea");

    // === FOOTER ======================================
    if (! isReadOnly()){
        var footer = newDIV(base, "/clearfix");
        footer.style.fontSize = "9pt";
        footer.style.padding = "5px 0";
        footer.style.margin = "0";
        
        // LEFT SIDE ---------------------------
        var div = newDIV(footer, "/left-side");
        div.style.width = "60%";
        div.style.padding = "0 0 0 5px";
        var sp = newSPAN(div, "/listMember");
        sp.innerHTML = "セット登録";
        sp.setAttribute("onclick", "openSetEditor(this)");
        var sp = newSPAN(div, "/listMember");
        sp.innerHTML = "フィルター";
        sp.setAttribute("onclick", "openFilter(this)");
        var sp = newSPAN(div, "/listMember");
        sp.innerHTML = "病名チェッカー";
        sp.setAttribute("onclick", "openCalcChecker(this)");
        var sp = newSPAN(div, "/listMember");
        sp.innerHTML = "PriceList";
        sp.setAttribute("onclick", "openPliceList()");
        var sp = newSPAN(div, "/listMember");
        sp.innerHTML = "過去履歴";
        sp.setAttribute("onclick", "openVinHistory()");
        
        // RIGHT SIDE --------------------------
        var div = newDIV(footer, "/right-side");
        div.style.padding = "0 10px 0 0";
        // 入力欄を非表示チェックボックス ------------
        var cb = newCHECKBOX(div, "", "入力欄を表示", showTreatmentText());
        cb.setAttribute("onclick", "checkDisplayStatusForTreatmentText(this)");
        checkDisplayStatusForTreatmentText(cb); // チェック状態によりテキストの表示・非表示を設定
    }

    // VIN 用フォローとパネルの基盤エリア
    var div = newDIV(base, "templateArea");
    
    getHeader();
}

function vin_version(){
    return "Ver.180405";
}


