
////////////////////////////////
/// neuron.js による処理 /////////

function addedTemplateValue(answer){
    // テンプレートを再度読込み表示
    showCast(answer);
}
function addTemplateValue(slipName, labels){
	// テンプレートに新規メニューを追加
    var title = window.prompt("この入力値セットのタイトルをつけてください", "");
    if (!title) return;
    
    var obj = new Object();
    for (num in labels){
        var label = labels[num]; // 伝票の各フィールド名
        var fid = fieldId(slipName, label);
        var field = document.getElementById(fid); // 伝票の各フィールド
        
        if (field && field.value.length)
            obj[label] = field.value;
    }
    
    // template 起動時に template を再度読み込ませるため
    setTemplateArray(slipName, null);
    
    // ## 頻度更新にもこれを使う
    // ## そうしないと public を元にしている場合 ohashi に val="" を書きこんでしまう
	var val = encodeSTRING(encodeObject(obj));
    //alert("val->"+val); //return; //##
    
    // 伝票では第２引数が cell.tag テンプレートでは第２引数が cell.label
    var args = new Object();
    args["owner"] = owner();
    args["tag"] = cellLabel();
    args["menuItem"] = encodeSTRING(slipName); // 伝票タイトル名
    args["tempName"] = encodeSTRING(title); // テンプレート・タイトル名
    args["freq"] = "";
    args["val"] = encodeSTRING(val);

    NRCall("PUT_MENU_TEMPLATE", args, addedTemplateValue);
}

function removedTemplateMenu(answer){
    // テンプレートを再度読込み表示
    showCast(answer);
}
function removeTemplateMenu(slipName, menu){
    // slipName テンプレートから menu を削除
    if (confirm("「" + menu + "」メニューを削除します")){
        // template 起動時に template を再度読み込ませるため
        setTemplateArray(slipName, null);
        
        // 伝票では第２引数が tag テンプレートでは第２引数が label
        var args = new Object();
        args["owner"] = owner();
        args["tag"] = cellLabel();
        args["menuItem"] = encodeSTRING(slipName); // 伝票タイトル名
		args["tempName"] = encodeSTRING(menu); // テンプレート・タイトル名
        NRCall("REMOVE_MENU_TEMPLATE", args, removedTemplateMenu);
    }
}

/// neuron.js による処理 /////////
////////////////////////////////

/////////////////////////////////////////////////////
///// テンプレート・メニュー ////////////////////////////

var _slipName;
var _castX;
var _castY;
var _castW = 100;

var _templateArray;
function setTemplateArray(slipName, array){
    // array: "owner(ohashi)tag(検査)value(ut.size^[^normal^]^adnex^[^不明^]^)public(0)freq(140)menu(超音波所見)template(初期値)" 型式
    if (!_templateArray) _templateArray = new Object();
    
    _templateArray[slipName] = array;
    
    //alert("setTemplateArray->"+encodeObject(array)); //##
}
function templateArray(slipName){
    // テンプレートの入った配列を返す
    return (_templateArray) ? _templateArray[slipName] : null;
}
function templateFor(slipName, tempName){
    // slipName, tempName に対するテンプレートを返す
    for (num in _templateArray[slipName]){
        var rec = _templateArray[slipName][num];
        if ((rec.menu == slipName) && (rec.template == tempName)){
            return rec;
        }
    }
    return "";
}

function showCellContents(tr, cellId, label, val){
	// テンプレートの CELL 一個を表示
	tr.innerHTML = "";
    
    // LABEL =======================================
	var td = newTD(tr, "formRecordLeft", label); // 名称
    
    // VALUE =======================================
	var td = newTD(tr, "formRecordRight", ""); // 値
	var unit = unitOfRecord(val);
	var size = (unit.length > 0) ? 10 : 20;
	var type = typeOfRecord(val);
    if (type == "dateType"){
        var yyyy = "";
        var mm = "";
        var dd = "";
        var date = valueOfRecord(val);
        if (date.length > 0){
            var array = date.split("-");
            if (array.length > 2){
                yyyy = array[0];
                mm = array[1];
                dd = array[2].substr(0, 2);
            }
        }
        var dp = newDatePopUp(td, cellId+".value", "平成", yyyy, mm, dd, false, null);
    } else {
        // ポップアップメニューがあれば表示
        var menu = menuOfRecord(val);
        if ((menu != null) && (menu.length > 0)){
            showPopUp(cellId, menu, valueOfRecord(val));
            size = 10;
        } else {
            // テンキーを表示
            var tr = document.getElementById(cellId);
            var td = tr.childNodes[1]; // right side FORM
        }
        // 入力欄を表示
        var hd = newHIDDEN(td, cellId+".range", rangeOfRecord(val));
        var fd = newFIELD(td, cellId+".value", "", size, valueOfRecord(val));
        var action = "checkValue('"+cellId+"')";
        fd.setAttribute("onchange", action);
        
        // UNIT ==========================================
        var sp = newSPAN(td, cellId+".unit"); // 単位
        sp.innerHTML = unit;
        
        // 入力された値のチェックを行う
        checkValue(cellId);
    }
}

function childrenForId(parentObj, targetId){
    // targetId に相当するオブジェクトの children を返す
    if (parentObj.id && (parentObj.id == targetId)){
        return parentObj.children;
    }
    
    for (key in parentObj){
        // parentObj の子供オブジェクトを検索
        var obj = parentObj[key];
        
        if (typeof obj == "object"){
            var array = childrenForId(obj, targetId);
            if (array) return array;
        }
    }
    return null;
}

function selectTemplate(button, slipName){
    // テンプレート・ポップアップが選択された
    // 伝票ラベル名の配列を生成
    var labels = new Array();
    var slipObj = currentForms()[slipName]; // 伝票オブジェクト
    for (label in slipObj){
        labels.push(label);
    }
    
    var menu = button.innerHTML;
    if (menu == "空欄") {
        // すべてのフィールドを空欄にする
        emptyAll(labels, slipName);
    } else if (menu == "...その他"){
        addTemplateValue(slipName, labels);
    } else {
        // テンプレートを転記する前に すべてのフィールドを空欄にしておく
        emptyAll(labels, slipName);
        
        // template: "owner(ohashi)tag(検査)value(心拍^[^+^]^尿蛋白^[^-^]^尿潜血^[^-^]^尿糖^[^-^]^浮腫^[^-^]^)freq(2)menu(妊婦健診)template(初期値)" 型式
        var records = templateArray(slipName);
        for (num in records){
            var rec = records[num];
            
            if (!rec.template) continue;

            if ((rec.menu == slipName) && rec.template.length){
                var tempObj = decodeObject(rec.value);
                for (label in tempObj){
                    // label のフィールドに val を埋め込む
                    var fid = field_id(slipName, label);
                    var field = document.getElementById(fid); // 伝票の各フィールド
                    if (field){ // フィールドをテンプレート値で上書きする
                        var val = tempObj[label];
                        field.value = (val) ? val : "";
                    }
                }
            }
        }
    }
    closeFloatPanel();
    
    function emptyAll(labels, slipName){
        // すべてのフィールドを空欄にする
        for (num in labels){
            var label = labels[num];
            var fid = field_id(slipName, label);
            var field = document.getElementById(fid);
            
            if (field){
                var rec = slipObj[label];
                if (rec.type == "dateType"){
                    // 年月日を空にする
                    var dv = document.getElementById(fid+".dateArea");
                    dv.innerHTML = "";
                    var dp = newDatePopUp(dv, fid, "平成", "", "", "", false, null);
                } else {
                    field.value = "";
                }
            }
        }
    }
}

function showTemplate(slipName){
    // テンプレートを表示
    var templates = new Array();
    var records = templateArray(slipName);
    for (num in records){
        var rec = records[num];
        if (!rec.template) continue;
        
        if ((rec.menu == slipName) && rec.template.length){
            templates.push(rec.template); // テンプレート・メニュー項目
        }
    }
    templates.splice(0, 0, "空欄");
    templates.push("...その他");
    
    var panel = new ClearPanel("_floatPanel", _castX, _castY, _castW, null, "openHelp('formTemplateHelp.html')");
    if (!panel) return;
    var elm = panel.contents;
    var action = "selectTemplate(this,'" + slipName + "')";
    for (num in templates){
        var menu = templates[num];
        var div = newDIV(elm, "/clearfix");
        // --- LEFT ---
        var dv = newDIV(div, "/left-side-button");
        dv.style.width = "60px";
        dv.innerHTML = menu;
        dv.setAttribute("onclick", action);
        // --- RIGHT ---
        var dv = newDIV(div, "/right-side");
        dv.style.padding = "2px 0px";
        if ((0 < num) && (num < templates.length - 1)){
            var img = newIMAGE(dv, "icon", "./remove-field.png", "X");
            var act = "removeTemplateMenu('" + slipName + "','" + menu + "')";
            img.setAttribute("onclick", act);
            img.style.marginRight = "2px";
        }
    }
}
function showCast(answer){
    // 鋳型テンプレートを開く
    var records = JSON.parse(answer);

    setTemplateArray(_slipName, records);
    
    showTemplate(_slipName);
    
    // 選択されたアイテムの頻度をインクリメント：Ajax が混線しないよう最後に実行
    updateSlipMenuFreq(_slipName); 
}
function getTemplateMenu(slipName){
    //console.log("getTemplateMenu", slipName); //####
    
    // テンプレート・メニューをサーバへリクエスト
    var button = elmFor(slipName + ".templateArea");
    
    _slipName = slipName;
    
    var pos = getPosition(button);
	_castX = pos.x - _castW + 8; // テンプレート・パネルを表示するx座標
	_castY = pos.y + 18; // テンプレート・パネルを表示するy座標
    
    if (templateArray(slipName)){
        // すでにテンプレートが記憶されていればサーバにアクセスしない
        showTemplate(slipName);
    } else {
        // cellLabel():検査（CELL ラベル） label:妊婦健診（伝票名）
        // 伝票では第２引数が cell.tag テンプレートでは第２引数が cell.label
        get_menu(owner(), cellLabel(), showCast); //##
    }
}

///// テンプレート・メニュー ////////////////////////////
/////////////////////////////////////////////////////
