
// ### 注意 ###
// ### prescription.js, usageEditor.jp, groupEditor.js でメソッド名が重複しないこと
// ###########

/*function priceListServer(){
    return "./priceListServer.php";
}*/

var _groupName; // Global 変数
var _effect; // Global 変数

var _groupTableArray; // Global 変数
function setGroupTableArray(ln){
	// 文字列形式でもらった ln を基に薬剤テーブルを生成
	_groupTableArray = new Array();
	var records = eval('(' + ln + ')');
    for (i in records){
		var obj = records[i];
        if (obj.code * 1 == 120){ // 約束処方のみに絞る
            var recObj = new GroupRecordObj(obj);
            if (recObj) _groupTableArray.push(recObj);
        }
	}
}
function groupTableArray(){
	return _groupTableArray;
}
function groupNameArray(){
	// 約束処方名の配列を返す
	var array = new Array();
	var i, count = _groupTableArray.length;
	for (i=0; i < count; i++){
		var obj = _groupTableArray[i];
		array[i] = obj.name;
	}
	return array;
}
function groupObjectForName(key){
	// 約束処方名:key に一致する薬剤オブジェクトを返す
	var array = new Array();
	var i, num, count = _groupTableArray.length;
	for (i=0; i < count; i++){
		var obj = _groupTableArray[i];
		if (isSame(obj.name, key))
			return obj;
	}
	return null;
}
function GroupRecordObj(obj){ // Record Object のコンストラクタ
	var newObj = new Object();
	newObj.code = obj.code; // 21,22,23
	newObj.alias = obj.alias;
	newObj.name = obj.name;
	newObj.generic = obj.generic;
	newObj.dose = obj.dose; // "6"
	if (obj.standard) newObj.dose = obj.standard;
	newObj.unit = obj.unit; // obj.unit = "Tab 日分"
	newObj.handan = obj.handan;
	newObj.min = obj.min;
	newObj.standard = obj.standard;
	newObj.max = obj.max;
	newObj.width = obj.width;
	newObj.effect = obj.effect;
	newObj.memo = obj.memo;
	return newObj;
}

var _selectedName;
function setSelectedGroupName(name){
	_selectedName = name;
}
function selectedGroupName(){
	return _selectedName;
}

///////////////////////////
/// Ajax による処理

function groupRemoved(answer){
	// サーバから約束処方を削除したレスポンスを表示
    showGroupList(); // 約束処方リストを表示
}
function removeGroup(){
	// 約束処方の削除
	var groupName = elmFor("groupPop").value;
	if (confirm("約束処方( "+groupName+" )を削除していいですか")){
        var args = new Object();
        args['groupName'] = groupName;
        
        _callServer("REMOVE_GROUP", priceListServer(), args, groupRemoved);
	}
}

function savedGroup(answer){
	// 約束処方の本格登録依頼に対するサーバからのレスポンスを処理
    showGroupList(); // 約束処方リストを表示
}
function saveGroups(){
	// 約束処方の本格登録依頼
    // saveData() がセットされる時点で groupName, effect などはまだ入力されて
    // いないので、saveData() が呼ばれてからここで生成する必要がある。
    if (trim(_groupName).length == 0){
        alert("処方名がないので登録できません");
        return;
    }
    
    var obj = prescriptionObject();
    if (! obj){
        alert("処方内容がないので登録できません");
        return;
    }
    
    var args = new Object();
    args['groupName'] = _groupName;
    args['effect'] = _effect;
    args['records'] = object2json(obj);
    
    _callServer("PUT_GROUP", priceListServer(), args, savedGroup);
}

function editAsGroup(){
	// 約束処方の名称や薬効を訂正
    // saveData() がセットされる時点で groupName, effect などはまだ入力されて
    // いないので、saveData() が呼ばれてからここで生成する必要がある。
    var args = new Object();
    _groupName = document.getElementById("groupName").value;
    _effect = document.getElementById("effect").value;
    var sourceObj = groupObjectForName();
    if (sourceObj){ // 登録済みの約束処方を編集
        args['groupName'] = _groupName;
        args['effect'] = _effect;
        args['records'] = contentsOfShohou(_groupName);
        
        _initDebug(true); //##
        _debug("editAsGroup PUT_GROUP->"+encodeObject(args)); //##
        _debug("selectedGroupName->"+selectedGroupName()); //##
        
        _callServer("PUT_GROUP", priceListServer(), args, savedGroup);
    } else { // 新規に約束処方を登録
        putAsGroup();
    }

	
	function contentsOfShohou(){
		// 選択された約束処方の内容を JSON 文字列として返す
		// memo の " が '&quot;' に encode されているので decode する
		var ary = sourceObj.memo.split("&quot;");
		var memo = ary.join("\"");
		var buff = '{';
		var yakusokuObj = eval('(' + memo + ')');
		for (groupId in yakusokuObj){
			var youhouObj = yakusokuObj[groupId]; // 同じ用法セット
			buff += '"'+groupId+'":{'; // グループID
			var num = 0;
			for (cId in youhouObj){
				var obj = youhouObj[cId]; // 薬剤または用法オブジェクト
				var cd = (obj.code > 120) ? obj.code : num++;
				buff += '"'+cId+'":{'; // 薬剤・用法ID
				buff += '"code":"' + cd + '",';
				buff += '"name":"' + obj.name + '",';
				buff += '"dose":"' + obj.dose + '",';
				buff += '"unit":"' + obj.unit + '"},';
			}
			if (buff.charAt(buff.length - 1) == ",")
				buff = buff.substr(0, buff.length-1);
			buff += '},';
		}
		if (buff.charAt(buff.length - 1) == ",")
			buff = buff.substr(0, buff.length-1);
		buff += '}';
		return buff;
	}
}

function registerdAsGroup(answer){
	// 約束処方の登録依頼に対するサーバからのレスポンスを処理
    var st = trim(answer);
    if (st.length > 0){
        if (! confirm("この約束処方名は登録済みです。上書きしますか？"))
            return;
    }
    saveGroups(); // ここで登録動作を行う
}
function putAsGroup(){
	// 約束処方の登録を依頼
    // putAsGroup() がセットされる時点で groupName, effect などは
    // まだ入力されていないので、putAsGroup() が呼ばれてから
    // ここで Global 変数に記憶保持しておく必要がある
    _groupName = elmFor("groupName").value;
    _effect = elmFor("effect").value;
    
    var args = new Object();
    args['groupName'] = _groupName;
    
    _callServer("HAS_GROUP", priceListServer(), args, registerdAsGroup);
}

function loadedGroupList(answer){
    // 約束処方ポップアップメニューを生成
    setGroupTableArray(answer); // groupList() を生成
    var array = groupList();
    
    // 約束処方ポップアップメニュー
    var elm = elmFor("groupPopupArea");
    if (! elm) return; // 登録モードの場合 groupPopupArea が存在せずポップアップメニュー表示不要
    
    elm.innerHTML = "";
    var sp = newSPAN(elm);
    sp.innerHTML = "約束処方";
    sp.style.marginRight = "3px";
    var pm = newPopupMenu(elm, "groupPop", array, "");
    pm.setAttribute("onchange", "groupSelected(this)");
    
    // 削除アイコン
    var im = newIMAGE(elm, "removeGroup/expandIcon", "./remove-field.png", "X");
    im.setAttribute("onclick", "removeGroup()");
    im.style.height = "12px";
    im.style.marginLeft = "5px";
    setInfoTip("removeGroup", "この約束処方を削除"); // INFO
    
    // 選択された約束処方内容を表示
    groupSelected(pm);

    
	function groupList(){
		// 用法リストを HTML 形式にして返す
		var array = groupNameArray();
		var results = new Array();
		var i, j, count = array.length;
		for (i=j=0; i < count; i++){
			var name = array[i];
            results[j++] = name;
		}
        return results;
	}
}
function showGroupList(){
    // 約束処方リストを表示
    var args = new Object();
    args['code'] = "120"; // code:120 は約束処方
    
    _callServer("GET_LIST", priceListServer(), args, loadedGroupList);
}

/// Ajax による処理
///////////////////////////


function groupSelected(elm){
	// 約束処方ポップアップメニューが選択された
    var item = elm.value;
    setSelectedGroupName(item); // 編集用に選択された約束処方名を記憶

    // 役職処方名・薬効を入力フィールドに表示
	var obj = groupObjectForName(item);
    console.log("groupSelected", obj.effect); //#####
    
    // 選択された約束処方内容を表示
	// memo の " が '&quot;' に encode されているので decode する
	var ary = obj.memo.split("&quot;");
	var memo = ary.join("\"");
	var recs = new Array();
	var yakusokuObj = eval('(' + memo + ')');
	for (groupId in yakusokuObj){
		var subObj = yakusokuObj[groupId];
		for (cId in subObj){
			var recObj = subObj[cId];
			if (recObj.code > 120)
				var ln = "--- "+recObj.name+" ("+recObj.dose+" "+recObj.unit+")";
			else
				var ln = recObj.name+" ("+recObj.dose+" "+recObj.unit+")";
			recs.push(ln);
		}
	}
    
    // 選択された処方内容を表示
    var div = elmFor("displayArea");
    div.innerHTML = "";
    div.style.padding = "5px";

    // 薬効を表示
    var dv = newDIV(div, "");
    dv.innerHTML = "薬効 ( " + obj.effect + " )";
    dv.style.fontWeight = "bold";
    dv.style.marginBottom = "3px";
    // 処方内容を表示
    var dv = newDIV(div, "");
	dv.innerHTML = recs.join("</BR>");
}

function showRegistPane(){
    // 登録ペーンを表示
    var elm = elmFor("groupContentsArea");
    elm.innerHTML = "";

    // 約束処方名入力
    var div = newDIV(elm, "");
    var fd = newFIELD(div, "groupName", "約束処方名", 15, "");
    var fd = newFIELD(div, "effect", "薬効", 15, "");
    var bt = newDIV(div, "groupAddButton/fixButton");
    bt.style.marginLeft = "5px";
    bt.innerHTML = "登録";
    bt.setAttribute("onclick", "putAsGroup()");
    setInfoTip("groupAddButton", "上に表示された処方を約束処方として登録"); // INFO
}
function showEditortPane(){
    // 編集ペーンを表示
    var elm = elmFor("groupContentsArea");
    elm.innerHTML = "";

    // ポップアップメニュー・エリア
    var div = newDIV(elm, "groupPopupArea");
    
    // 約束処方内容の表示エリア
    var div = newDIV(elm, "displayArea");
    div.style.padding = "5px";
    
    showGroupList(); // 約束処方リストを表示
}
function selectedEditorRadio(){
    // 登録/閲覧・編集ボタンが選択された
    var label = checkedRADIO("_radioArea");
    if (label == "登録")
        showRegistPane();
    else
        showEditortPane();
}

function closeGroupEditor(){
	elmFor("pr_editorArea").innerHTML = "";
    closeInfoTip();
}

function showGroupEditor(){
	// 約束処方編集ペーンを開く
	var elm = document.getElementById("pr_editorArea");
	if (elm.innerHTML.length > 0){
		elm.innerHTML = "";
		return;
	}
    
    var frame = newDIV(elm, "templateFrame");
    frame.style.backgroundColor = "#ffe";
    frame.style.padding = "20px 20px 0 20px";
    frame.style.fontSize = "9pt";

    // HEADER =================================================
    var header = newDIV(frame, "/yellow-bar");
    header.style.padding = "2px 0 0 5px";
    var div = newDIV(header, "/clearfix");
    // --- HEADER LEFT -------------------------
    var left = newDIV(div, "/left-side");
    left.style.width = "60%";
    // クローズ・アイコン
	var im = newIMAGE(left,"closeGroupIcon","./close.png","close");
    im.style.height = "12px";
    im.style.position = "relative";
    im.style.top = "2px";
	im.setAttribute("onclick", "closeGroupEditor()");
    im.setAttribute("class", "expandIcon");
    setInfoTip("closeGroupIcon", "約束処方編集を閉じる"); // INFO
    // ヘッダー・ラベル
    var sp = newSPAN(left, "");
    sp.style.padding = "0 5px 0 5px";
    sp.innerHTML = "約束処方";
    var labels = ["登録", "閲覧・削除"];
    var sp = newSPAN(left, "");
    var bt = newRADIO(sp, "_radioArea", "modeButtons", labels, "登録");
    bt.setAttribute("onchange", "selectedEditorRadio()");

    // --- HEADER RIGHT ------------------------
    var right = newDIV(div, "/right-side");
    right.style.paddingRight = "10px";
    var im = newIMAGE(right, "groupHelpIcon", "./help.png", "?");
    im.setAttribute("onclick", "openHelp('./PrescGroupHelp.html')");
    im.style.height = "18px";
    im.setAttribute("class", "expandIcon");
    setInfoTip("groupHelpIcon", "HELP"); // INFO

    // コンテンツ表示エリア =======================================
    var div = newDIV(frame, "groupContentsArea");
    div.style.padding = "8px 0 10px 5px";
    
    // ラジオボタンを選択状態にする
    selectedEditorRadio();
}
