

/////////////////////////////////////////////
///// NOA からの継承値 /////////////////////////

// NOA 組込みの場合は patientId() などを直接取得できるが
// 外付けツールにも出来るようあえて以下の仕組みを使う

function _owner(){
    // owner() は neuron.js で定義されていてカブる
    var val = document.getElementById("_value").value;
    
    if (val){
        var obj = decodeObject(val);
        return obj.owner;
    } else if (parent()){
        return parent().owner();
    }
}

///// NOA からの継承値 /////////////////////////
//////////////////////////////////////////////

var _patientList;
function setPatientList(obj){
    _patientList = new Object();
    var subId = 0; // patientId 末尾２桁
    for (num in obj){
        var rec = obj[num];
        var newRec = new Object();
        newRec.id = rec.patientId;
        subId = rec.patientId.substr(6, 2) * 1 + 1; // patientId 末尾２桁の未来値
        newRec.name = rec.patientKanjiName;
        newRec.sex = rec.sex;
        newRec.lvd = rec.lastVisitDate;
        _patientList[rec.patientId] = newRec;
    }
    // 生年月日から生成した patientId の最初の６桁：obj が無い場合もあるのでここで生成
    var date = document.getElementById("birthDatePop").value;
    var partOfPid = patientIdWithBirthdate(date); // カルテIDの最初の６桁
    
    // '...その他' のレコードを生成
    var st = (subId < 10) ? "0" + subId : "" + subId;
    var newId = partOfPid + st;
    var newRec = new Object();
    newRec.id = newId;
    newRec.name = '...その他';
    newRec.sex = '';
    newRec.lvd = '';
    _patientList[newId] = newRec;
}
function patientList(){
    return _patientList;
}

////////////////////////////////
/// Ajax ///////////////////////

function gotPatientList(answer){
    var obj = eval('(' + answer + ')'); //## old Mac 用に必要: FRONT から使われる
	//var obj = JSON.parse(answer);
    
	setPatientList(obj); // id,name,sex,lvd を記憶
	showPatientList();
}
function getPatientList(){
    // 生年月日に該当する患者リストをサーバへリクエスト
    var date = document.getElementById("birthDatePop").value;
    var partOfPid = patientIdWithBirthdate(date); // カルテIDの最初の６桁
    
    get_patients(partOfPid, gotPatientList);
}

function puttedPatient(answer){
    document.getElementById("_debug").innerHTML = answer;
}
function putPatient(){
    // 新患をサーバへ登録
    var own = _owner();
    var bdate = document.getElementById("birthDatePop").value;
    
    var popup = document.getElementById("mainId");
    if (popup){
        var mainId = popup.value;
        var subId = document.getElementById("subId").value;
        var pid = mainId + subId;
    } else {
        var pid = document.getElementById("patientId").innerHTML;
    }
    
    var attending = document.getElementById("attending").value;
    var sex = document.getElementById("sex").value;
    var kanji = document.getElementById("kanjiName").value;
    var kana = document.getElementById("kanaName").value;
    var roma = document.getElementById("romajiName").value;
    var aid = document.getElementById("anotherId").value;
    var rid = document.getElementById("orcaId").value;
    
    var elm = document.getElementById("entryDate");
    if (elm){
        var date = elm.innerHTML;
    } else {
        var dt = document.getElementById("datePop2").value;
        var hour = document.getElementById("hour").value;
        var min = document.getElementById("min").value;
        var sec = document.getElementById("sec").value;
        var date = dt + " " + hour + ":" + min + ":" + sec;
    }
    
    var args = new Object();
    args["owner"] = own;
    args["patientId"] = pid;
    args["anotherId"] = aid;
    args["receiptId"] = rid;
    args["entryDate"] = date;
    args["birthDate"] = bdate;
    args["attending"] = attending;
    args["sex"] = sex;
    args["kanjiName"] = kanji;
    args["kanaName"] = kana;
    args["romajiName"] = roma;
    
    NRCall("PUT_NEW_PATIENT", args, puttedPatient);
}

/// Ajax ///////////////////////
////////////////////////////////

function _makeArray(max){
	// firstItem から count 数の配列を作成して返す
    // 数は２桁の文字列とする
	var array = new Array();
    for (i=0; i < max; i++){
        var st = (i < 10) ? "0" + i : "" + i;
        array.push(st);
    }
    
	return array;
}

function subIdEditable(){
    // patientId 下２桁を編集可能にする
    var elm = document.getElementById("patientId");
    var patientId = elm.innerHTML;
    elm.innerHTML = "";
    
    var array = new Array;
    array.push(patientId.substr(0, 6)); // patientId 行頭から６桁
    var pm = newPopupMenu(elm, "mainId", array, "");
    
    var val = patientId.substr(6, 2); // patientId 行末の２桁
    var pm = newPopupMenu(elm, "subId", _makeArray(100), val);
    pm.focus();
    
    document.getElementById("idComment").innerHTML = "";
}

function dateEditable(){
    // 登録年月日を変更可能にする
    var elm = document.getElementById("entryDateArea");
    elm.innerHTML = "";
    var array = todayAndTime().split(" ");
    
    // 年月日ポップアップ
    var array2 = array[0].split("-");
    var yyyy = array2[0];
    var mm = array2[1];
    var dd = array2[2];
    var dp = newDatePopUp(elm, "datePop2", "平成", yyyy, mm, dd, false, null);
    
    // 時分秒ポップアップ
    var array3 = array[1].split(":");
    var hour = array3[0];
    var min = array3[1];
    var sec = array3[2];
    newBR(elm);
    var hours = new Array();
    var pm = newPopupMenu(elm, "hour", _makeArray(24), hour);
    var tx = newTEXT(elm, "時");
    var pm = newPopupMenu(elm, "min", _makeArray(60), min);
    var tx = newTEXT(elm, "分");
    var pm = newPopupMenu(elm, "sec", _makeArray(60), sec);
    var tx = newTEXT(elm, "秒");
}

function newPatientRegister(pid){
    // 新患情報登録
    
    var elm = document.getElementById("listArea");
    elm.innerHTML = "";

    var tbl = newTABLE(elm, "/base-table");
    tbl.style.fontSize = "9pt";
    
    var tr = newTR(tbl, "", "");
    var td = newTD(tr, "leftColumn", "カルテID");
    var td = newTD(tr, "patientIdArea", "");
    var sp = newSPAN(td, "patientId");
    sp.innerHTML = pid;
    var sp = newSPAN(td, "idComment");
    sp.style.paddingLeft = "10px";
    var a = newA(sp, "末尾２桁を変更可能にする", "#", "");
    a.setAttribute("onclick", "subIdEditable()")
    
    var tr = newTR(tbl, "", "");
    var td = newTD(tr, "leftColumn", "担当医");
    var td = newTD(tr, "", "");
    if (window.opener){ // FRONT から使う場合
        var array = window.opener.users();
        var name = window.opener.localAttending(); // localStorage に記憶された担当医名
    } else { // NOA から使う場合
        var array = users();
        var name = parent().localAttending(); // localStorage に記憶された担当医名
    }
    var pm = newPopupMenu(td, "attending", array, name);
    
    var tr = newTR(tbl, "", "");
    var td = newTD(tr, "leftColumn", "性別");
    var td = newTD(tr, "", "");
    var array = ["", "女", "男", "不明"];
    var pm = newPopupMenu(td, "sex", array, "女");
    
    makeLine(tbl, "漢字氏名", "kanjiName");
    makeLine(tbl, "ふりがな", "kanaName");
    makeLine(tbl, "ローマ字", "romajiName");
    makeLine(tbl, "anotherId", "anotherId");
    makeLine(tbl, "ORCA ID", "orcaId");
    
    var tr = newTR(tbl, "", "");
    var td = newTD(tr, "leftColumn", "登録年月日");
    var td = newTD(tr, "entryDateArea", "");
    var sp = newSPAN(td, "entryDate");
    sp.innerHTML = todayAndTime();
    var sp = newSPAN(td, "");
    sp.style.paddingLeft = "10px";
    var a = newA(sp, "変更可能にする", "#", "");
    a.setAttribute("onclick", "dateEditable()")
    
    // FOOTER
    elmFor("footerLeft").innerHTML = version();
    var dv = elmFor("footerRight");
    dv.innerHTML = "";
    dv.style.paddingRight = "5px"; // TOOL AREA 幅が小さいと登録ボタンがカラム落ちになるのを防ぐ
    var bt = newDIV(dv, "/fixButton");
    bt.innerHTML = "登録";
    bt.setAttribute("onclick", "putPatient()");
    bt.style.position = "relative";
    bt.style.top = "2px";
    
    function makeLine(tbl, label, fieldId){
        // 一行分の入力欄を生成
        var tr = newTR(tbl, "", "");
        var td = newTD(tr, "leftColumn", label);
        var td = newTD(tr, "", "");
        var fd = newFIELD(td, fieldId, "", 40, "");
    }
}

function listSelected(pid, name){
    // 患者リストが選択された
    if (name == "...その他"){
        // 新患情報登録
        newPatientRegister(pid);
    } else {
        // カルテを開く
        parent().openChart(pid);
    }
}

function showPatientList(){
    var elm = document.getElementById("listArea");
    elm.innerHTML = "";
    var tbl = newTABLE(elm, "");
    tbl.style.width = "100%";
    tbl.style.fontSize = "9pt";
    tbl.style.fontFamily = "arial, Helvetica";
    
    // タイトル
    var tr = newTR(tbl, "", "");
    var td = newTD(tr, "/titleCol", "カルテID");
    td.style.paddingLeft = "5px";
    var td = newTD(tr, "/titleCol", "氏名");
    var td = newTD(tr, "/titleCol", "性別");
    var td = newTD(tr, "/titleCol", "最終受診日");
    
    // 患者リスト
    var obj = patientList();
    for (id in obj){
        var rec = obj[id];
        var tr = newTR(tbl, "/record", "");
        tr.setAttribute("onclick", "listSelected('"+id+"','"+rec.name+"')");
        var td = newTD(tr, "/listCol", rec.id);
        var td = newTD(tr, "/listCol", rec.name);
        var td = newTD(tr, "/listCol", rec.sex);
        var td = newTD(tr, "/listCol", rec.lvd);
    }
    
    var tr = newTR(tbl, "", "");
    var td = newTD(tr, "", "どれか一つを選択してください");
    td.setAttribute("colspan", "4");
    td.style.padding = "3px 10px";

    var elm = document.getElementById("footerLeft");
    elm.innerHTML = "＊登録リストになければ「...その他」を選択";
}

function initPatientRegister(){
	var base = document.getElementById("base");
    base.innerHTML = "";
    var pframe = new PictureFrame(base, "100%", "80%");
    
    // HEADER =======================
    var div = pframe.headerLeft;
    var sp = newSPAN(div, "");
    sp.style.padding = "2px 3px";
    sp.style.fontSize = "9pt";
    sp.innerHTML = "生年月日";
    // 現在から２０年前の年月日を設定
    var array = dateBefore(20);
    var yyyy = array[0];
    var mm = array[1];
    var dd = array[2];
    var dp = newDatePopUp(div, "birthDatePop", "昭和", yyyy, mm, dd, false, null);
    var bt = newDIV(div, "/whiteButton");
    bt.innerHTML = "検索";
    bt.setAttribute("onclick", "getPatientList()");
    bt.style.marginLeft = "5px";
    // HELP
    var sp = newSPAN(div, "");
    sp.style.padding = "3px 5px";
	var im = newIMAGE(sp, "", "./help.png", "?");
	im.setAttribute("onclick", "openHelp('patientRegisterHelp.html')");
	im.style.height = "18px";
	im.style.verticalAlign = "bottom";
    
    // BODY:LIST AREA ================
    var div = pframe.body;
    div.setAttribute("id", "listArea");

    // FOOTER ========================
    var div = pframe.footerLeft;
    div.setAttribute("id", "footerLeft");
    div.style.position = "relative";
    div.style.top = "5px";
    div.style.fontSize = "10pt";
    div.innerHTML = version();
    var div = pframe.footerRight;
    div.setAttribute("id", "footerRight");
    
    // iFrame なら toggleButton にツール名を表示
    var bt = tools().elmFor("toggleButton");
    if (bt) bt.innerHTML = "新患登録ツール";
    
    // dataCenter でユーザ・リストを読み込んでおく
    getUsers();

    function dateBefore(year){
        // 現在から year 年前の年月日を配列で返す
        var array = new Array();
        var date = new Date();
        var yy = date.getYear();
        var mm = date.getMonth() + 1;
        var dd = date.getDate();
        if (yy < 2000) { yy += 1900; }
        yy -= year * 1; // year 年前を default とする
        array.push(yy); array.push(mm); array.push(dd);
        
        return array;
    }
}

function version(){
    return "Ver.180306";
}
