#!/usr/bin/env ruby
# This software is a part of NOODLYBOX.
# This software is distributed under the terms of the new BSD License.
# Copyright (c) 2008, molelord
# All rights reserved.

# This script creates a package and a component declaration
# from a VHDL file.
# Usually, This script is called by "make" command.
#
# Usage : compo.rb FOOBAR.vhd > FOOBAR_PKG.vhd

print "-- Do not modify.\n"
print "-- This file is created automatically.\n"

remove_is = false

while line = gets()
    if line =~ /^\s*--/
        if line =~ /^\s*--\s*synthesis\s*translate_o[nf]f*/
            print line
        end
        next
    end

    if line =~ /^\s*entity/i
        line.sub!(/entity/i, "component")
        remove_is = true

        name = line.sub(/^.*component\s*/, "")
        name =~ /^\S+/
        name = $&
        printf "package %s_PKG is\n\n", name
    end

    if remove_is
        line.sub!(/\s*\bis\b/i, "")
        remove_is = false
    end

    if (line.sub!(/\bend\s*\w*\s*;/i, "end component;"))
       print line
       break
    end

    print line
end

print "\n"
print "end; -- package\n"
print "\n"
printf "package body %s_PKG is\n", name
print "end; -- package body\n"
