#ifndef CMPU_H_
#define CMPU_H_
// This software is a part of NOODLYBOX.
// This software is distributed under the terms of the new BSD License.
// Copyright (c) 2009, molelord
// All rights reserved.

#include "cMpuIf.h" // MpuIf

namespace nbox {

    class Mpu : virtual public MpuIf {
    public:
        static const uint32_t RESET_X;
    protected:
        const int    mpu_id;
        s_vpi_vecval a;
        s_vpi_vecval din;
        s_vpi_vecval dout;
        s_vpi_vecval ctrli;
        s_vpi_vecval ctrlo;
        bool read_success;

    protected:
        Mpu(int mpu_id);
    private:
        // privateかつ未定義にして、コピーと代入を禁止する
        Mpu(const Mpu &obj);
        Mpu &operator=(const Mpu &rhs);
    public:
        virtual ~Mpu();
        virtual int getId() const;
        virtual void startup();
        virtual bool reset(const s_vpi_vecval* ctrli);
        virtual void reflect(
            svLogicVecVal* a,
            const svLogicVecVal* din,
            svLogicVecVal* dout,
            const svLogicVecVal* ctrli,
            svLogicVecVal* ctrlo,
            int clk) = 0;

        virtual bool readSuccess() const;

        virtual void       nop(uint32_t clocks) = 0;
        virtual uint8_t  readB(uint32_t addr) = 0;
        virtual uint16_t readH(uint32_t addr) = 0;
        virtual uint32_t readW(uint32_t addr) = 0;
        virtual void    writeB(uint32_t addr, uint8_t  data) = 0;
        virtual void    writeH(uint32_t addr, uint16_t data) = 0;
        virtual void    writeW(uint32_t addr, uint32_t data) = 0;

        static Mpu *getInstance(int mpu_id);

    // addInstance()が静的メンバでremoveInstance()が動的メンバである理由は、
    // addはコンストラクタの中で、つまりオブジェクトが
    // 出来上がる前に呼び出す必要があるのに対し、
    // removeはデストラクタの中で、つまりオブジェクトが
    // 存在するときに呼び出すため。
    protected:
        static void addInstance(int mpu_id, Mpu *target);
        virtual void removeInstance();
    };

} // namespace nbox

#endif
