#ifndef CMPUIF_H_
#define CMPUIF_H_
// This software is a part of NOODLYBOX.
// This software is distributed under the terms of the new BSD License.
// Copyright (c) 2009, molelord
// All rights reserved.

#include "svdpi.h" // uint??_t

namespace nbox {

    class MpuIf {
    protected:
        MpuIf()
        {}
    private:
        // private`ɂāARs[Ƒ֎~
        MpuIf(const MpuIf &obj);
        MpuIf &operator=(const MpuIf &rhs);
     public:
        virtual ~MpuIf()
        {}
        virtual int getId() const = 0;
        virtual void startup() = 0;

        virtual bool readSuccess() const = 0;

        virtual void       nop(uint32_t clocks) = 0;
        virtual uint8_t  readB(uint32_t addr) = 0;
        virtual uint16_t readH(uint32_t addr) = 0;
        virtual uint32_t readW(uint32_t addr) = 0;
        virtual void    writeB(uint32_t addr, uint8_t  data) = 0;
        virtual void    writeH(uint32_t addr, uint16_t data) = 0;
        virtual void    writeW(uint32_t addr, uint32_t data) = 0;
    };

} // namespace nbox

#endif
