#ifndef CSH7751_H_
#define CSH7751_H_
// This software is a part of NOODLYBOX.
// This software is distributed under the terms of the new BSD License.
// Copyright (c) 2009, molelord
// All rights reserved.

#include "cMpu.h" // Mpu

namespace nbox {

    class Sh7751 : virtual public Mpu {
    private:
        // read, write\bhƁAfh???\bh܂op???\bhƂ̊Ԃ
        // 邽߂̏
        struct Pack {
            uint32_t addr;
            uint32_t data;
            uint32_t count;
        } pack;
    public:
        void (Sh7751::*phase)();
        void (Sh7751::*execAtRise)();
        void (Sh7751::*execAtFall)();

        static const uint32_t CS_X;
        static const uint32_t OE_X;
        static const uint32_t WE_X;
        static const uint32_t HIZ;
        static const uint32_t BS_X;
        static const uint32_t RDWR;
    protected:
        Sh7751(int mpu_id);
    private:
        // private`ɂāARs[Ƒ֎~
        Sh7751(const Sh7751 &obj);
        Sh7751 &operator=(const Sh7751 &rhs);
    public:
        virtual ~Sh7751();
        virtual void reflect(
            svLogicVecVal* a,
            const svLogicVecVal* din,
            svLogicVecVal* dout,
            const svLogicVecVal* ctrli,
            svLogicVecVal* ctrlo,
            int clk);

        virtual uint32_t readGeneric(uint32_t addr, int bits);

        virtual void       nop(uint32_t clocks);
        virtual uint8_t  readB(uint32_t addr);
        virtual uint16_t readH(uint32_t addr);
        virtual uint32_t readW(uint32_t addr);
        virtual void    writeB(uint32_t addr, uint8_t  data);
        virtual void    writeH(uint32_t addr, uint16_t data);
        virtual void    writeW(uint32_t addr, uint32_t data);

        // M(w肷Ȃ|ŋ؂)^ƁA
        // activate()ł̓ANeBuɂAdeactivate()ł̓fBANeBuɂ
        // Ăяoł͐__͍lȂĂ悢
        virtual void activate(uint32_t x, bool act = true);
        virtual void deactivate(uint32_t x);

    protected:
        // phŎn܂郁\bh́Aphaseɑ
        virtual void phFetch();
        virtual void phNop();
        virtual void phNopTail();
        virtual void phRead();
        virtual void phReadBody();
        virtual void phReadTail();
        virtual void phWrite();
        virtual void phWriteBody();
        virtual void phWriteTail();

        // exŎn܂郁\bh́AexecAt????ɑ
        virtual void exEmpty();
        virtual void exEndOfReadT1();
        virtual void exEndOfReadT2();
        virtual void exActivateWE();
        virtual void exDeactivateWE();
        virtual void exEndOfWriteT1();
        virtual void exEndOfWriteT2();

        // phñ\bhĂяo
        virtual void changeAtPhNop();
        virtual void changeAtPhRead();
        virtual void changeAtPhReadBody();
        virtual void changeAtPhReadTail();
        virtual void changeAtPhWrite();
        virtual void changeAtPhWriteBody();
        virtual void changeAtPhWriteTail();

    public:
        static Mpu *create(int mpu_id, const char *mpu_name);
    };
 
} // namespace nbox

#endif
