// This software is a part of NOODLYBOX.
// This software is distributed under the terms of the new BSD License.
// Copyright (c) 2009, molelord
// All rights reserved.

#include <cstdlib> // abort()

#include "MPU_dpi.h" // vlogコマンドを使って、MPU.vから自動生成
//#include "svdpi.h" svdpi.hはMPU_dpi.hでincludeされるので、ここでは不要
#include "cMpu.h"        // Mpu
#include "cMpuFactory.h" // MpuFactory

// どちら側で実装されているのかわかりやすいように、
// 'v_'で始まる関数 は Verilog-HDL による実装、
// 'c_'で始まる関数 は C++         による実装にしてある。

// exportしているtask v_waitClock(), v_write()は、
// vlogが自動生成するヘッダにプロトタイプ宣言が吐き出されるので、
// Cからの呼び出しができるようになる
// また、importしているtask c_startup(), c_exchange()は、Cで実装できる


// initial beginで呼び出される関数
// マルチプロセッサ構成に対応するため、mpu_idを引数にとる。
// returnする前にdeleteしないとメモリリークする。
int c_startup(int mpu_id, const char *mpu_name)
{
    nbox::Mpu *mpu = 0;

    nbox::MpuFactory *factory = nbox::MpuFactory::getInstance();
    mpu = factory->create(mpu_id, mpu_name);

    // ユーザプログラムの開始
    mpu->startup();

    delete mpu;
    return 0;
}

// シミュレータとC++実装との情報交換を行う関数
int c_exchange(
    int mpu_id,
    svLogicVecVal* a,
    const svLogicVecVal* din,
    svLogicVecVal* dout,
    const svLogicVecVal* ctrli,
    svLogicVecVal* ctrlo,
    int clk)
{
    // 呼び出されたことを画面に出す、デバッグ情報
    //v_write(0x00ca11ed);

    nbox::Mpu *mpu = nbox::Mpu::getInstance(mpu_id);
    mpu->reflect(a, din, dout, ctrli, ctrlo, clk);

    return 0;
}
