# Defining echo canceller.
proc silent args {
}

silent [package require cmdline]

set dbg 0
set starttime 0

# Put the debug information.
proc putdbg {str} {
    if {$::dbg} { puts stderr $str }
}

# Interpret all specified options.
proc interpretOptions {} {
    set specified ""

    global 1
    while {$::argc > 0} {
        append specified " " $1
        shift
    }

    putdbg "-- $specified --"

    while {[::cmdline::getopt specified {q t} optvar valvar]} {
        if {$optvar eq "q"} {
            onbreak { quit -force }
        } elseif {$optvar eq "t"} {
            set ::starttime [clock clicks -milliseconds]
            onbreak { puts stdout \
                "time : [expr [clock clicks -milliseconds] - $::starttime] ms"}
        }
    }
}

# main ----

interpretOptions

#                           dpi dll  top module
vsim -L unisims_ver -sv_lib c_side   tDPI
add wave -r -hex /*
run 100 us
