// This software is a part of NOODLYBOX.
// This software is distributed under the terms of the new BSD License.
// Copyright (c) 2009, molelord
// All rights reserved.

`timescale 1 ns / 1 ns

module MPU # (
    parameter MPU_ID   = 0,
    parameter MPU_NAME = "")
(
    output reg  [31:0] A,
    input  wire [31:0] DIN,
    output reg  [31:0] DOUT,
    input  wire [31:0] CTRLI,
    output reg  [31:0] CTRLO,
    input  wire        CLK);

    import "DPI-C" context task c_startup(
        input  int    mpu_id,
        input  string mpu_name);

    import "DPI-C" context task c_exchange(
        input  int    mpu_id,
        output [31:0] a,
        input  [31:0] din,
        output [31:0] dout,
        input  [31:0] ctrli,
        output [31:0] ctrlo,
        input  int    clk);

    export "DPI-C" task v_stop;
    export "DPI-C" task v_write;
    export "DPI-C" task v_waitClock;

    task v_stop;
        $stop;
    endtask

    task v_write(input int x);
        $display("%h", x);
    endtask

    task v_waitClock();
        @(posedge CLK);
        c_exchange(MPU_ID, A, DIN, DOUT, CTRLI, CTRLO, 1);
        @(negedge CLK);
        c_exchange(MPU_ID, A, DIN, DOUT, CTRLI, CTRLO, 0);
    endtask

    initial begin
        c_startup(MPU_ID, MPU_NAME);
        $stop;
    end

endmodule
