#!/bin/sh
. settings.sh

make clean

make msimproj-vhdl
( cd msim && \
vsim -gui -do "project open noodlybox.mpf; source ../s; do fsm.tcl -c ../c/accessfpga.exe -q" )
diff golden/accessfpga.log msim/accessfpga.log > regression.log 2>&1

make clean

make msimproj-verilog
( cd msimv && \
vsim -gui -do "project open noodlybox.mpf; source ../s; do fsm.tcl -c ../c/accessfpga.exe -q" )
diff golden/accessfpga.log msimv/accessfpga.log >> regression.log 2>&1

make clean

make iseproj-vhdl
( cd ise && \
echo 'project open samplefpga.ise; process run "Generate Programming File"' > gp.tcl ; \
xtclsh gp.tcl )
[ -f ise/samplefpga.bit ] || echo ise-vhdl Fail >> regression.log 2>&1

make clean

make iseproj-verilog
( cd isev && \
echo 'project open samplefpga.ise; process run "Generate Programming File"' > gp.tcl ; \
xtclsh gp.tcl )
[ -f isev/samplefpga.bit ] || echo ise-verilog Fail >> regression.log 2>&1

make clean

make isesimproj-vhdl
( cd isesim && make accessfpga.xwv )
diff golden/accessfpga.log isesim/accessfpga.log >> regression.log 2>&1

make clean

make isesimproj-verilog
( cd isesimv && make accessfpga.xwv )
diff golden/accessfpga.log isesimv/accessfpga.log >> regression.log 2>&1
