//  P:\SF_NOODLYBOX\SAMPLE\RTL\ACCESS_SM.v
//  Verilog created by Xilinx's StateCAD 9.2i
//  Mon Nov 03 15:42:27 2008

//  This Verilog code (for use with Xilinx XST) was generated using: 
//  binary encoded state assignment with structured code format.
//  Minimization is enabled,  implied else is enabled, 
//  and outputs are manually optimized.

`timescale 1s/1s

module access_sm(CLK,BS_X,CS_X,RDWR,RESET_X,ADDR_VALID,OE,WE);

	input CLK;
	input BS_X,CS_X,RDWR,RESET_X;
	output ADDR_VALID,OE,WE;
	reg ADDR_VALID,next_ADDR_VALID,OE,next_OE,WE,next_WE;
	reg [1:0] sreg;
	reg [1:0] next_sreg;

	`define GET 2'b00
	`define IDLE 2'b01
	`define PUT 2'b10


	always @(posedge CLK or negedge RESET_X)
	begin
		if ( ~RESET_X ) begin
			sreg=`IDLE;
			OE = 0;
			WE = 0;
			ADDR_VALID = 1;
		end else
		begin
			sreg = next_sreg;
			ADDR_VALID = next_ADDR_VALID;
			OE = next_OE;
			WE = next_WE;
		end
	end

	always @ (sreg or BS_X or CS_X or RDWR)
	begin
		next_ADDR_VALID = 0; next_OE = 0; next_WE = 0; 

		next_sreg=`GET;

		case (sreg)
			`GET : begin
				next_sreg=`IDLE;
				next_OE=0;
				next_WE=0;
				next_ADDR_VALID=1;
			end
			`IDLE : begin
				if ( CS_X | BS_X ) begin
					next_sreg=`IDLE;
					next_OE=0;
					next_WE=0;
					next_ADDR_VALID=1;
				end
				if ( ~CS_X & ~BS_X & RDWR ) begin
					next_sreg=`PUT;
					next_ADDR_VALID=0;
					next_WE=0;
					next_OE=1;
				end
				if ( ~CS_X & ~BS_X & ~RDWR ) begin
					next_sreg=`GET;
					next_ADDR_VALID=0;
					next_OE=0;
					next_WE=1;
				end
			end
			`PUT : begin
				next_sreg=`IDLE;
				next_OE=0;
				next_WE=0;
				next_ADDR_VALID=1;
			end
		endcase
	end
endmodule
