# コンフィグレーションでできること
# 変数の値を変える procを再定義する
# 新しい変数を追加する etc.

# シミュレータ上でのデバッグ出力をOn/Off
#set (dbg) 1

# OEおよびWEの幅を変更する
set     (readBodyWidth)  1
set     (writeBodyWidth) 1

# clkRise,Fall内で使うために、新しい変数を追加
# TransParent Delay
set (tpd)    "6 ns"
set (tpdmin) "1.5 ns"

# Fsmの持つprocの上書き
proc changeAtOpNop {} {
    simForceNbox i_CS_X 1 $(tpd)
}

# Read T1
proc changeAtOpRead {addr} {
    simForceNbox i_A    $addr $(tpd)
    simForceNbox i_CS_X 0 $(tpd)
    simForceNbox i_BS_X 0 $(tpd)
    simForceNbox i_RDWR 1 $(tpd)
    set (execAtNextRise) endOfReadT1
}
proc endOfReadT1 {} {
    simForceNbox i_OE_X 0 $(tpd)
    simForceNbox i_BS_X 1 $(tpd)
}

# Read Tw
proc changeAtOpRead_body {} {
}

# Read T2
proc changeAtOpRead_tail {} {
    set (execAtNextRise) endOfReadT2

    # Because dataLatch is called at next Rise.
    set (syncRequired) 1
}
proc endOfReadT2 {} {
    simForceNbox i_OE_X 1 $(tpd)
    dataLatch
}

# Write T1
proc changeAtOpWrite {addr data} {
    simForceNbox i_A    $addr $(tpd)
    simForceNbox i_CS_X 0 $(tpd)
    simForceNbox i_BS_X 0 $(tpd)
    simForceNbox i_RDWR 0 $(tpd)
    set (execAtNextFall) activateWE
    set (execAtNextRise) "endOfWriteT1 $data"
}
proc activateWE {} {
    simForceNbox i_WE_X 0 $(tpd)
}
proc endOfWriteT1 {data} {
    simForceNbox i_D    $data $(tpd)
    simForceNbox i_HIZ  0 $(tpd)
    simForceNbox i_BS_X 1 $(tpd)
}

# Write Tw
proc changeAtOpWrite_body {} {
}

# Write T2
proc changeAtOpWrite_tail {} {
    set (execAtNextFall) deactivateWE
    set (execAtNextRise) endOfWriteT2
}
proc deactivateWE {} {
    simForceNbox i_WE_X 1 $(tpd)
}
proc endOfWriteT2 {} {
    simForceNbox i_HIZ  1 $(tpdmin)
}
