# This software is a part of NOODLYBOX.
# This software is distributed under the terms of the new BSD License.
# Copyright (c) 2009, molelord
# All rights reserved.

# LED classes for ModelSIM

package require Itcl

load tk84

# スクリプトを再読み込みしても問題を起こさないように、
# クラスが定義済みなら削除しておく
if {[itcl::find class Led] ne ""} {
    itcl::delete class Led
}
itcl::class Led {
    private variable name_
    private variable color_
    private variable wire_

    public method redraw {} {
        set value [examine -radix 2 $wire_]
        #puts stdout $value
        for {set i 0} {$i <= 7} {incr i} {
 	    set bit [string index $value [expr 7 - $i]]
            .c_ledpanel itemconfigure ${name_}${i} -fill $color_($bit)
        }
    }
    constructor {x y name fillcolor outcolor wire} {
	set name_ $name
        array set color_ [list 0 black 1 $fillcolor x black]
	set wire_ $wire
	set width 10
        for {set i 7} {$i >= 0} {incr i -1} {
            .c_ledpanel create text [expr $x + 5] [expr $y - 5] \
	        -text $i -fill white
            .c_ledpanel create oval $x $y \
	        [expr $x + $width] [expr $y + $width] \
                -fill "black" -outline $outcolor -width 1 -tag ${name_}${i}
            incr x 20
        }
	# evalを使うのは、変数が展開された状態でwhenを呼び出したいため
        eval "when -label Kick${name_} { $wire_ } { $name_ redraw }"

	# 現在の信号状態を表示に反映させる
	redraw
    }
}

if {[itcl::find class SevenSeg] ne ""} {
    itcl::delete class SevenSeg
}
itcl::class SevenSeg {
    private variable name_
    private variable color_
    private variable wire_
    common pos_
    array set pos_ {0 a 1 b 2 c 3 d 4 e 5 f 6 g 7 dot}

    private method yoko {x y name outcolor} {
        .c_ledpanel create polygon $x $y [incr x  5] [incr y -5] [incr x  20] $y \
            [incr x 5] [incr y 5]   [incr x -5] [incr y  5] [incr x -20] $y \
            -fill "black" -outline $outcolor -tag $name
    }
    private method tate {x y name outcolor} {
        .c_ledpanel create polygon $x $y [incr x 5] [incr y 5] \
	    [incr x -3] [incr y 20] [incr x -5] [incr y 5] \
	    [incr x -5] [incr y -5] [incr x 3] [incr y -20] \
            -fill "black" -outline $outcolor -tag $name
    }
    private method dot {x y name outcolor} {
        .c_ledpanel create oval $x $y [expr $x + 10] [expr $y + 10] \
            -fill "black" -outline $outcolor -width 1 -tag $name
    }
    public method redraw {} {
        set value [examine -radix 2 $wire_]
        #puts stdout $value

        for {set i 0} {$i <= 7} {incr i} {
	    set bit [string index $value [expr 7 - $i]]
            .c_ledpanel itemconfigure ${name_}$pos_($i) -fill $color_($bit)
        }
    }
    constructor {x y name fillcolor outcolor wire} {
	set name_ $name
        array set color_ [list 0 black 1 $fillcolor x black]
	set wire_ $wire
        yoko       $x             $y       ${name_}a   $outcolor
        tate [expr $x + 31] [expr $y +  2] ${name_}b   $outcolor
        tate [expr $x + 28] [expr $y + 35] ${name_}c   $outcolor
        yoko [expr $x -  7] [expr $y + 66] ${name_}d   $outcolor
        tate [expr $x -  6] [expr $y + 35] ${name_}e   $outcolor
        tate [expr $x -  2] [expr $y +  2] ${name_}f   $outcolor
        yoko [expr $x -  4] [expr $y + 34] ${name_}g   $outcolor
	dot  [expr $x + 28] [expr $y + 66] ${name_}dot $outcolor
        eval "when -label Kick${name_} { $wire_ } { $name_ redraw }"
	redraw
    }
}
