/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

class TcvWavePanel
extends JPanel {
    private List<TcvSignal> signalList;
    private String filename;
    private int namelen_max = 0;
    private int wavelen_max = 0;
    private int num_of_waves = 0;
    private static final int PhaseLine = 1;
    private static final int FactorX = 50;
    private static final int FactorY = 30;
    private static final Color Brown = new Color(128, 0, 0);
    private static final Color LightGray = new Color(192, 192, 192);
    private static final Pattern Header = Pattern.compile("TimingChart");
    private static final Pattern Footer = Pattern.compile("TimingChartEnd");
    private static final Pattern Vhdlcomment = Pattern.compile("\\s*--\\s*");
    private static final Pattern Verilogcomment = Pattern.compile("\\s*//\\s*");
    private static final Pattern Shellcomment = Pattern.compile("\\s*#\\s*");
    private static final Pattern Trail = Pattern.compile("\\\\$");
    private static final Pattern Syntax = Pattern.compile("(\\S+)\\s+(\\S[^:]*)(.*)");
    private static final Pattern Ext = Pattern.compile("\\.[^\\/\\.]*?$");

    TcvWavePanel(String string) {
        this.filename = string;
        this.setBackground(Color.WHITE);
        this.setLayout(new FlowLayout(0));
        this.parse();
    }

    public void parse() {
        try {
            String string;
            this.signalList = new ArrayList<TcvSignal>();
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.filename));
            String string2 = "";
            boolean bl = false;
            while ((string = bufferedReader.readLine()) != null && !Footer.matcher(string).find()) {
                if (Header.matcher(string).find()) {
                    bl = true;
                }
                if (!bl) continue;
                string = Vhdlcomment.matcher(string).replaceFirst("");
                string = Verilogcomment.matcher(string).replaceFirst("");
                if (Trail.matcher(string = Shellcomment.matcher(string).replaceFirst("")).find()) {
                    string2 = string = Trail.matcher(string).replaceFirst("");
                    continue;
                }
                string = string2 + string;
                string2 = "";
                Matcher matcher = Syntax.matcher(string);
                if (!matcher.find()) continue;
                String string3 = matcher.group(1);
                String object = matcher.group(2).trim();
                String string4 = matcher.group(3);
                if (string4.length() > 2) {
                    string4 = string4.substring(2);
                }
                this.signalList.add(new TcvSignal(string3, object, string4));
            }
            bufferedReader.close();
            this.namelen_max = 0;
            this.wavelen_max = 0;
            this.num_of_waves = 0;
            for (TcvSignal tcvSignal : this.signalList) {
                int n = tcvSignal.name.length();
                if (n > this.namelen_max) {
                    this.namelen_max = n;
                }
                if ((n = tcvSignal.wave.length()) > this.wavelen_max) {
                    this.wavelen_max = n;
                }
                ++this.num_of_waves;
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            System.exit(1);
        }
        this.setSize(((this.wavelen_max + 1) / 2 + 1) * 50 + 25, (this.num_of_waves + 1) * 30);
    }

    private static int posy(char c) {
        int n = 0;
        switch (c) {
            case '0': {
                n = 20;
                break;
            }
            case '1': {
                n = 0;
                break;
            }
            case 'z': {
                n = 10;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    private void putClock(Graphics graphics, int n, int n2) {
        int[] nArray = new int[]{n, n, n + 25, n + 25, n + 50};
        int[] nArray2 = new int[]{n2 + TcvWavePanel.posy('0') + 1, n2 + TcvWavePanel.posy('1') + 1, n2 + TcvWavePanel.posy('1') + 1, n2 + TcvWavePanel.posy('0') + 1, n2 + TcvWavePanel.posy('0') + 1};
        graphics.setColor(Color.BLACK);
        for (int i = 0; i < nArray.length - 1; ++i) {
            graphics.drawLine(nArray[i], nArray2[i], nArray[i + 1], nArray2[i + 1]);
        }
    }

    private void putWave_sub(Graphics graphics, char c, int n, int n2, int n3) {
        boolean bl = false;
        n2 += TcvWavePanel.posy(c);
        if (c == 'x') {
            graphics.setColor(LightGray);
            graphics.fillRect(n, n2, n3 - n, 20);
            graphics.setColor(Color.BLACK);
            graphics.drawLine(n, n2 + 20, n3, n2 + 20);
        } else if ('A' <= c && c <= 'Z') {
            graphics.setColor(Color.BLACK);
            graphics.drawLine(n, n2 + 20, n3, n2 + 20);
        }
        graphics.setColor(Color.BLACK);
        if (c == 'z') {
            graphics.setColor(Brown);
        }
        graphics.drawLine(n, n2, n3, n2);
    }

    private void borderedPolygon(Graphics graphics, int[] nArray, int[] nArray2, int n) {
        graphics.setColor(LightGray);
        graphics.fillPolygon(nArray, nArray2, n);
        graphics.setColor(Color.BLACK);
        graphics.drawPolygon(nArray, nArray2, n);
    }

    private void putWave(Graphics graphics, char c, char c2, char c3, int n, int n2, String string) {
        n *= 50;
        n2 *= 30;
        if (c == '/') {
            this.putClock(graphics, n, n2);
            return;
        }
        int[] nArray = new int[]{n, n + 10, n + 16, n + 50};
        this.putWave_sub(graphics, c, nArray[0], n2, nArray[1]);
        this.putWave_sub(graphics, c3, nArray[2], n2, nArray[3]);
        if (string != null) {
            if (c == c3) {
                this.putWave_sub(graphics, c, nArray[1], n2, nArray[2]);
            } else {
                int[] nArray2;
                int[] nArray3;
                if (c == 'x' || c3 == 'x') {
                    nArray3 = new int[]{c == 'x' ? nArray[1] : nArray[2], nArray[1] + 3, c == 'x' ? nArray[1] : nArray[2]};
                    nArray2 = new int[]{n2, n2 + 10, n2 + 20};
                    graphics.setColor(LightGray);
                    graphics.fillPolygon(nArray3, nArray2, nArray3.length);
                    graphics.setColor(Color.BLACK);
                    graphics.drawLine(nArray[1], n2 + 0, nArray[2], n2 + 20);
                    graphics.drawLine(nArray[1], n2 + 20, nArray[2], n2 + 0);
                } else {
                    graphics.setColor(Color.WHITE);
                    graphics.drawLine(nArray[1] - 3, n2 + 0, nArray[2] + 3, n2 + 0);
                    graphics.drawLine(nArray[1] - 3, n2 + 20, nArray[2] + 3, n2 + 20);
                    graphics.setColor(Color.BLACK);
                    graphics.drawLine(nArray[1] - 3, n2 + 0, nArray[1] + 0, n2 + 10);
                    graphics.drawLine(nArray[1] + 0, n2 + 10, nArray[1] - 3, n2 + 20);
                    nArray3 = new int[]{nArray[1] + 3, nArray[1] + 0, nArray[1] + 3, nArray[1] + 6};
                    nArray2 = new int[]{n2, n2 + 10, n2 + 20, n2 + 10};
                    this.borderedPolygon(graphics, nArray3, nArray2, nArray3.length);
                    graphics.setColor(Color.BLACK);
                    graphics.drawLine(nArray[2] + 3, n2 + 0, nArray[2] + 0, n2 + 10);
                    graphics.drawLine(nArray[2] + 0, n2 + 10, nArray[2] + 3, n2 + 20);
                }
                if (c3 != 'x') {
                    int n3 = n + 23;
                    int n4 = n2 + 15;
                    int n5 = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".indexOf(c3);
                    String[] stringArray = string.split(" ");
                    graphics.setColor(Color.BLACK);
                    graphics.drawString(stringArray[n5], n3, n4);
                }
            }
            return;
        }
        if (c2 == 'v' || c2 == '^') {
            char c4 = c == '1' ? (char)'0' : '1';
            int[] nArray4 = new int[]{nArray[1], nArray[1] + 3, nArray[2]};
            int[] nArray5 = new int[]{n2 + TcvWavePanel.posy(c), n2 + TcvWavePanel.posy(c4), n2 + TcvWavePanel.posy(c3)};
            this.borderedPolygon(graphics, nArray4, nArray5, nArray4.length);
        } else if (c == c3) {
            this.putWave_sub(graphics, c, nArray[1], n2, nArray[2]);
        } else if (c == '0' && c3 == '1' || c == '1' && c3 == '0') {
            int[] nArray6 = new int[]{nArray[1], nArray[2], nArray[2] + 6, nArray[2]};
            int[] nArray7 = new int[]{n2 + TcvWavePanel.posy(c), n2 + TcvWavePanel.posy(c), n2 + TcvWavePanel.posy(c3), n2 + TcvWavePanel.posy(c3)};
            this.borderedPolygon(graphics, nArray6, nArray7, nArray6.length);
        } else if ((c == 'z' || c3 == 'z') && c != 'x' && c3 != 'x') {
            graphics.setColor(Brown);
            graphics.drawLine(nArray[1], n2 + TcvWavePanel.posy(c), nArray[2], n2 + TcvWavePanel.posy(c3));
        } else if (c == 'x') {
            int[] nArray8 = new int[]{nArray[1], nArray[1], nArray[2]};
            int[] nArray9 = new int[]{n2, n2 + 20, n2 + TcvWavePanel.posy(c3)};
            graphics.setColor(LightGray);
            graphics.fillPolygon(nArray8, nArray9, nArray8.length);
            graphics.setColor(Color.BLACK);
            graphics.drawLine(nArray[1], n2 + 0, nArray[2], n2 + TcvWavePanel.posy(c3));
            graphics.drawLine(nArray[1], n2 + 20, nArray[2], n2 + TcvWavePanel.posy(c3));
        } else if (c3 == 'x') {
            int[] nArray10 = new int[]{nArray[1], nArray[2], nArray[2]};
            int[] nArray11 = new int[]{n2 + TcvWavePanel.posy(c), n2, n2 + 20};
            graphics.setColor(LightGray);
            graphics.fillPolygon(nArray10, nArray11, nArray10.length);
            graphics.setColor(Color.BLACK);
            graphics.drawLine(nArray[1], n2 + TcvWavePanel.posy(c), nArray[2], n2 + 0);
            graphics.drawLine(nArray[1], n2 + TcvWavePanel.posy(c), nArray[2], n2 + 20);
        }
    }

    private void putGrid(Graphics graphics, int n, int n2) {
        n *= 50;
        n2 *= 30;
        int n3 = (this.wavelen_max + 1) / 2;
        graphics.setColor(LightGray);
        for (int i = 0; i < n3; ++i) {
            graphics.drawLine(n + i * 50, n2, n + i * 50, n2 + this.num_of_waves * 30);
        }
    }

    private void putWaveline(Graphics graphics, int n, TcvSignal tcvSignal) {
        graphics.setColor(Color.BLACK);
        graphics.drawString(tcvSignal.name, 0 * 50, n * 30 + 30 / 2);
        int n2 = tcvSignal.wave.length();
        int n3 = 0;
        while (n3 * 2 + 2 < n2) {
            int n4;
            char c = tcvSignal.wave.charAt(n3 * 2 + 0);
            char c2 = tcvSignal.wave.charAt(n3 * 2 + 1);
            char c3 = tcvSignal.wave.charAt(n3 * 2 + 2);
            boolean bl = true;
            char[] cArray = new char[]{c, c3};
            if (tcvSignal.comment.equals("")) {
                block10: for (n4 = 0; n4 < cArray.length; ++n4) {
                    switch (cArray[n4]) {
                        case '/': 
                        case '0': 
                        case '1': 
                        case 'x': 
                        case 'z': {
                            continue block10;
                        }
                        default: {
                            System.err.println("Invalid charactor : " + cArray[n4]);
                            bl = false;
                        }
                    }
                }
                switch (c2) {
                    case ' ': 
                    case '^': 
                    case 'v': 
                    case '|': {
                        break;
                    }
                    default: {
                        System.err.println("Invalid charactor : " + c2);
                        bl = false;
                    }
                }
                if (bl) {
                    this.putWave(graphics, c, c2, c3, n3 + 2, n, null);
                }
            } else {
                for (n4 = 0; n4 < cArray.length; ++n4) {
                    if (cArray[n4] == 'x' || cArray[n4] >= 'A' && 'Z' >= cArray[n4]) continue;
                    System.err.println("Invalid charactor : " + cArray[n4]);
                    bl = false;
                }
                switch (c2) {
                    case ' ': 
                    case '|': {
                        break;
                    }
                    default: {
                        System.err.println("Invalid charactor : " + c2);
                        bl = false;
                    }
                }
                if (bl) {
                    this.putWave(graphics, c, c2, c3, n3 + 2, n, tcvSignal.comment);
                }
            }
            ++n3;
        }
    }

    private void render(Graphics graphics, int n) {
        this.putGrid(graphics, 2, n + 1);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setStroke(new BasicStroke(2.0f));
        FontMetrics fontMetrics = graphics.getFontMetrics();
        graphics.setColor(Color.BLACK);
        int n2 = (this.wavelen_max + 1) / 2;
        for (int i = 0; i < n2; ++i) {
            String object = "T" + i;
            int n3 = fontMetrics.stringWidth(object);
            graphics.drawString(object, (i + 2) * 50 - n3 / 2, n * 30 + 30 / 2);
        }
        for (TcvSignal tcvSignal : this.signalList) {
            this.putWaveline(graphics2D, n + 1, tcvSignal);
            ++n;
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.render(graphics, 0);
    }

    public BufferedImage getOffscreenImage() {
        int n = ((this.wavelen_max + 1) / 2 + 1) * 50 + 25;
        int n2 = (this.num_of_waves + 1) * 30;
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        this.render(graphics, 0);
        graphics.dispose();
        return bufferedImage;
    }

    public void copy() {
        BufferedImage bufferedImage = this.getOffscreenImage();
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        TcvImageSelection tcvImageSelection = new TcvImageSelection(bufferedImage);
        clipboard.setContents(tcvImageSelection, null);
    }

    public void save() {
        String string = Ext.matcher(this.filename).replaceFirst("");
        try {
            File file = new File(string + ".png");
            BufferedImage bufferedImage = this.getOffscreenImage();
            ImageIO.write((RenderedImage)bufferedImage, "PNG", file);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            System.exit(1);
        }
    }
}

