/*
 * Decompiled with CFR 0.152.
 */
package nor.core.proxy;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.List;
import nor.core.proxy.filter.EditingByteFilter;
import nor.core.proxy.filter.ReadonlyByteFilter;

class FilteringByteInputStream
extends InputStream {
    private final ReadableByteChannel in;
    private final List<EditingByteFilter> editingFilters;
    private final List<ReadonlyByteFilter> readonlyFilters;
    private ByteBuffer buffer;
    private boolean isEOF = false;

    public FilteringByteInputStream(InputStream in, List<EditingByteFilter> editingFilters, List<ReadonlyByteFilter> readonlyFilters) {
        this.in = Channels.newChannel(in);
        this.editingFilters = editingFilters;
        this.readonlyFilters = readonlyFilters;
        this.buffer = ByteBuffer.allocate(65536);
        this.buffer.limit(0);
    }

    @Override
    public int read() throws IOException {
        if (this.isEOF) {
            return -1;
        }
        if (this.available() == 0 && !this.reload()) {
            return -1;
        }
        return this.buffer.get() & 0xFF;
    }

    @Override
    public void close() throws IOException {
        for (ReadonlyByteFilter readonlyByteFilter : this.readonlyFilters) {
            readonlyByteFilter.close();
        }
        for (EditingByteFilter editingByteFilter : this.editingFilters) {
            editingByteFilter.close();
        }
        this.in.close();
    }

    @Override
    public int available() throws IOException {
        return this.buffer.limit() - this.buffer.position();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (off < 0) {
            throw new IndexOutOfBoundsException("off\u304c\u8ca0");
        }
        if (len < 0) {
            throw new IndexOutOfBoundsException("len\u304c\u8ca0");
        }
        if (len > b.length - off) {
            throw new IndexOutOfBoundsException("len\u304cb.length - off\u3088\u308a\u3082\u5927\u304d\u3044");
        }
        if (this.isEOF) {
            return -1;
        }
        if (this.available() == 0 && !this.reload()) {
            return -1;
        }
        int available = this.available();
        if (len > available) {
            this.buffer.get(b, off, available);
            return available;
        }
        this.buffer.get(b, off, len);
        return len;
    }

    private boolean reload() throws IOException {
        this.buffer.clear();
        if (this.in.read(this.buffer) < 0) {
            this.isEOF = true;
            return false;
        }
        this.buffer.flip();
        for (ReadonlyByteFilter readonlyByteFilter : this.readonlyFilters) {
            readonlyByteFilter.update(this.buffer);
            this.buffer.rewind();
        }
        for (EditingByteFilter editingByteFilter : this.editingFilters) {
            this.buffer = editingByteFilter.update(this.buffer);
            this.buffer.flip();
        }
        return true;
    }
}

