/*
 * Decompiled with CFR 0.152.
 */
package nor.core.proxy;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.List;
import nor.core.proxy.filter.EditingStringFilter;
import nor.core.proxy.filter.ReadonlyStringFilter;
import nor.util.SequentialInputStream;

class FilteringCharacterInputStream
extends SequentialInputStream {
    private final List<EditingStringFilter> editingFilters;
    private final List<ReadonlyStringFilter> readonlyFilters;
    private final Charset charset;
    private final BufferedReader rin;
    private ByteBuffer buffer;
    private boolean isEOF = false;

    protected FilteringCharacterInputStream(InputStream in, Charset charset, List<EditingStringFilter> editingFilters, List<ReadonlyStringFilter> readonlyFilters) {
        super(in);
        this.charset = charset;
        this.rin = this.charset == null ? new BufferedReader(new InputStreamReader(in)) : new BufferedReader(new InputStreamReader(in, charset));
        this.editingFilters = editingFilters;
        this.readonlyFilters = readonlyFilters;
    }

    @Override
    public int read() throws IOException {
        if (this.isEOF) {
            return -1;
        }
        if (this.available() == 0 && !this.reload()) {
            return -1;
        }
        return this.buffer.get() & 0xFF;
    }

    @Override
    public void close() throws IOException {
        for (ReadonlyStringFilter readonlyStringFilter : this.readonlyFilters) {
            readonlyStringFilter.close();
        }
        for (EditingStringFilter editingStringFilter : this.editingFilters) {
            editingStringFilter.close();
        }
        this.in.close();
    }

    @Override
    public int available() throws IOException {
        if (this.buffer == null) {
            return 0;
        }
        return this.buffer.limit() - this.buffer.position();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (off < 0) {
            throw new IndexOutOfBoundsException("off\u304c\u8ca0");
        }
        if (len < 0) {
            throw new IndexOutOfBoundsException("len\u304c\u8ca0");
        }
        if (len > b.length - off) {
            throw new IndexOutOfBoundsException("len\u304cb.length - off\u3088\u308a\u3082\u5927\u304d\u3044");
        }
        if (this.isEOF) {
            return -1;
        }
        if (this.available() == 0 && !this.reload()) {
            return -1;
        }
        int available = this.available();
        if (len > available) {
            this.buffer.get(b, off, available);
            return available;
        }
        this.buffer.get(b, off, len);
        return len;
    }

    private boolean reload() throws IOException {
        String line = this.rin.readLine();
        if (line == null) {
            this.isEOF = true;
            return false;
        }
        for (ReadonlyStringFilter readonlyStringFilter : this.readonlyFilters) {
            readonlyStringFilter.update(line);
        }
        for (EditingStringFilter editingStringFilter : this.editingFilters) {
            line = editingStringFilter.update(line);
        }
        line = String.valueOf(line) + "\n";
        this.buffer = this.charset != null ? ByteBuffer.wrap(line.getBytes(this.charset)) : ByteBuffer.wrap(line.getBytes());
        return true;
    }
}

