/*
 * Decompiled with CFR 0.152.
 */
package nor.http.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import nor.http.io.HeaderInputStream;
import nor.util.SequentialInputStream;

public class ChunkedInputStream
extends SequentialInputStream {
    private int size = 0;
    private byte[] buffer = new byte[0];
    private int counter = 0;
    private int remains = 0;
    private int readed = 0;
    private boolean isEOF = false;
    private final Map<String, String> trailers = new HashMap<String, String>();

    public ChunkedInputStream(InputStream in) {
        super(in);
    }

    @Override
    public int read() throws IOException {
        if (this.isEOF) {
            return -1;
        }
        if (this.available() == 0 && !this.reload()) {
            return -1;
        }
        ++this.size;
        return this.buffer[this.counter++] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (off < 0) {
            throw new IndexOutOfBoundsException("off\u304c\u8ca0");
        }
        if (len < 0) {
            throw new IndexOutOfBoundsException("len\u304c\u8ca0");
        }
        if (len > b.length - off) {
            throw new IndexOutOfBoundsException("len\u304cb.length - off\u3088\u308a\u3082\u5927\u304d\u3044");
        }
        if (this.isEOF) {
            return -1;
        }
        if (this.available() == 0 && !this.reload()) {
            return -1;
        }
        int available = this.available();
        if (len > available) {
            int i = 0;
            while (i != available) {
                ++this.size;
                b[off + i] = this.buffer[this.counter++];
                ++i;
            }
            return available;
        }
        int i = 0;
        while (i != len) {
            ++this.size;
            b[off + i] = this.buffer[this.counter++];
            ++i;
        }
        return len;
    }

    @Override
    public int available() {
        return this.readed - this.counter;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n > 0L) {
            int available = this.available();
            if (n > (long)available) {
                if (this.reload()) {
                    return this.skip(n - (long)available) + (long)available;
                }
                return available;
            }
            this.counter = (int)((long)this.counter + n);
            return n;
        }
        return 0L;
    }

    public int size() {
        return this.size;
    }

    public Map<String, String> getTrailers() {
        return this.trailers;
    }

    private boolean reload() throws IOException {
        if (this.remains == 0) {
            this.analyze();
            if (this.isEOF) {
                return false;
            }
        }
        this.readed = this.in.read(this.buffer, 0, this.remains);
        this.remains -= this.readed;
        this.counter = 0;
        return true;
    }

    private void analyze() throws IOException {
        try {
            ArrayList<Byte> head = new ArrayList<Byte>();
            block8: while (true) {
                int buf = this.in.read();
                switch (buf) {
                    case 13: {
                        continue block8;
                    }
                    case 10: {
                        if (head.size() == 0) continue block8;
                        break block8;
                    }
                    case -1: {
                        this.isEOF = true;
                        return;
                    }
                    default: {
                        head.add((byte)buf);
                        continue block8;
                    }
                }
                break;
            }
            byte[] bhead = new byte[head.size()];
            int i = 0;
            while (i != head.size()) {
                bhead[i] = (Byte)head.get(i);
                ++i;
            }
            String shead = new String(bhead, "UTF-8");
            String[] sp = shead.split(";");
            String size = sp[0].trim();
            this.remains = Integer.parseInt(size, 16);
            this.buffer = new byte[this.remains];
            if (this.remains == 0) {
                String buf;
                BufferedReader input = new BufferedReader(new InputStreamReader(new HeaderInputStream(this.in)));
                while ((buf = input.readLine()) != null) {
                    if (buf.equals("")) break;
                    String[] kv = buf.split(":");
                    if (kv.length == 1) continue;
                    String key = kv[0].trim().toLowerCase();
                    String value = kv[1].trim();
                    this.trailers.put(key, value);
                }
                this.isEOF = true;
            }
        }
        catch (IOException e) {
            System.err.println("ChunkedStream.decode: " + e.getLocalizedMessage() + "(" + e.hashCode() + ")");
            throw e;
        }
        catch (NumberFormatException e) {
            System.err.println("ChunkedStream.decode: " + e.getLocalizedMessage() + "(" + e.hashCode() + ")");
            throw new IOException("\u4e0d\u6b63\u306a\u30c7\u30fc\u30bf\u3092\u53d7\u4fe1\u3057\u307e\u3057\u305f");
        }
    }
}

