/*
 * Decompiled with CFR 0.152.
 */
package nor.http.io;

import java.io.BufferedWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;

public class ChunkedOutputStream
extends FilterOutputStream {
    public static final int DefaultBufferSize = 4096;
    private final byte[] buffer;
    private int counter;
    private final Map<String, String> trailer = new HashMap<String, String>();

    public ChunkedOutputStream(OutputStream out) {
        this(out, 4096);
    }

    public ChunkedOutputStream(OutputStream out, int buffer_size) {
        super(out);
        this.buffer = new byte[buffer_size];
        this.counter = 0;
    }

    @Override
    public void write(int b) throws IOException {
        this.buffer[this.counter++] = (byte)b;
        if (this.counter == this.buffer.length) {
            this.flush();
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.flush();
        String size = Integer.toHexString(len);
        this.out.write(size.getBytes());
        this.out.write(13);
        this.out.write(10);
        this.out.write(b, off, len);
        this.out.write(13);
        this.out.write(10);
        this.out.flush();
    }

    @Override
    public void flush() throws IOException {
        if (this.counter != 0) {
            String size = Integer.toHexString(this.counter);
            this.out.write(size.getBytes());
            this.out.write(13);
            this.out.write(10);
            this.out.write(this.buffer, 0, this.counter);
            this.out.write(13);
            this.out.write(10);
            this.out.flush();
            this.counter = 0;
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.writeEOF();
        super.close();
    }

    public void writeEOF() throws IOException {
        this.out.write(48);
        this.out.write(13);
        this.out.write(10);
        this.out.flush();
        BufferedWriter output = new BufferedWriter(new OutputStreamWriter(this.out));
        for (String key : this.trailer.keySet()) {
            output.append(key);
            output.append(": ");
            output.append(this.trailer.get(key));
            output.append("\n");
        }
        output.append("\n");
        output.flush();
    }

    public String getTrailer(String key) {
        return this.trailer.get(key);
    }

    public void setTrailer(String key, String value) {
        this.trailer.put(key.toLowerCase(), value);
    }

    public boolean containsTrailer(String key) {
        return this.trailer.containsKey(key);
    }

    public void removeTrailer(String key) {
        this.trailer.remove(key);
    }
}

