/*
 * Decompiled with CFR 0.152.
 */
package nor.http.server.proxyserver;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.util.regex.Pattern;
import nor.http.HeaderName;
import nor.http.HttpHeader;
import nor.http.HttpRequest;
import nor.http.HttpResponse;
import nor.http.Status;
import nor.http.error.HttpException;
import nor.http.server.HttpRequestHandler;
import nor.http.server.proxyserver.Router;
import nor.util.log.EasyLogger;

public class ProxyRequestHandler
implements HttpRequestHandler {
    private final String name;
    private final String version;
    private final Router router = new Router();
    private static final String Close = "close";
    private static final String VIA_FORMAT = "%s %s";
    private static final EasyLogger LOGGER = EasyLogger.getLogger(ProxyRequestHandler.class);

    public ProxyRequestHandler(String name, String version) {
        LOGGER.entering("<init>", name, version);
        assert (name != null && name.length() != 0);
        assert (version != null);
        this.name = name;
        this.version = version;
        HttpURLConnection.setFollowRedirects(false);
        LOGGER.exiting("<init>");
    }

    @Override
    public HttpResponse doRequest(HttpRequest request) {
        LOGGER.entering("doRequest", request);
        assert (request != null);
        LOGGER.finest(request.getHeadLine());
        HttpResponse response = null;
        try {
            if ("CONNECT".equals(request.getMethod())) {
                throw new HttpException(Status.NotImplemented);
            }
            this.cleanHeader(request);
            URL url = new URL(request.getPath());
            Proxy proxy = this.router.query(request.getPath());
            HttpURLConnection con = (HttpURLConnection)url.openConnection(proxy);
            response = request.createResponse(con);
        }
        catch (IOException e) {
            LOGGER.warning(String.format("IOException [%s]", e.getLocalizedMessage()));
            StringWriter body = new StringWriter();
            e.printStackTrace(new PrintWriter(body));
        }
        catch (HttpException e) {
            response = e.createResponse(request);
        }
        this.cleanHeader(response);
        LOGGER.info(String.valueOf(request.getHeadLine()) + " > " + response.getHeadLine() + " (" + response.getHeader().get(HeaderName.ContentLength) + " bytes)");
        LOGGER.exiting("doRequest", response);
        return response;
    }

    public void addRouting(Pattern pat, URL extProxyHost) {
        LOGGER.entering("addRouting", pat, extProxyHost);
        assert (pat != null);
        assert (extProxyHost != null);
        InetSocketAddress extProxyAddr = new InetSocketAddress(extProxyHost.getHost(), extProxyHost.getPort());
        this.router.put(pat, new Proxy(Proxy.Type.HTTP, extProxyAddr));
        LOGGER.info("\u5916\u90e8\u30d7\u30ed\u30ad\u30b7\u3092\u4f7f\u7528 [" + extProxyAddr + "]");
        LOGGER.exiting("addRouting");
    }

    public void removeRouting(Pattern pat) {
        LOGGER.entering("removeRouting", pat);
        assert (pat != null);
        this.router.remove(pat);
        LOGGER.exiting("removeRouting");
    }

    private void cleanHeader(HttpRequest request) {
        String value;
        int n;
        int n2;
        String[] stringArray;
        LOGGER.entering("cleanHeader", request);
        assert (request != null);
        HttpHeader header = request.getHeader();
        header.set(HeaderName.AcceptEncoding, "gzip, identity");
        String timeout = null;
        boolean close = false;
        if (header.containsKey(HeaderName.KeepAlive)) {
            timeout = header.get(HeaderName.KeepAlive);
        } else if (header.containsValue(HeaderName.Connection, Close)) {
            close = true;
        }
        if (header.containsKey(HeaderName.Connection)) {
            stringArray = header.get(HeaderName.Connection).split(",");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                value = stringArray[n];
                header.remove(value.trim());
                ++n;
            }
            header.remove(HeaderName.Connection);
        }
        if (this.router.query(request.getPath()) == null && header.containsKey(HeaderName.ProxyConnection)) {
            stringArray = header.get(HeaderName.ProxyConnection).split(",");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                value = stringArray[n];
                header.remove(value.trim());
                ++n;
            }
            header.remove(HeaderName.ProxyConnection);
        }
        if (timeout != null) {
            header.set(HeaderName.Connection, HeaderName.KeepAlive.toString());
            header.set(HeaderName.KeepAlive, timeout);
        } else if (close) {
            header.set(HeaderName.Connection, Close);
        }
        header.add(HeaderName.Via, String.format(VIA_FORMAT, this.version, this.name));
        LOGGER.exiting("cleanHeader");
    }

    private void cleanHeader(HttpResponse response) {
        int n;
        LOGGER.entering("cleanHeader", response);
        assert (response != null);
        HttpHeader header = response.getHeader();
        if (header.containsKey(HeaderName.Connection)) {
            boolean isClose = false;
            String[] stringArray = header.get(HeaderName.Connection).split(",");
            int n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                String value = stringArray[n];
                String tvalue = value.trim();
                if (Close.equalsIgnoreCase(tvalue)) {
                    isClose = true;
                } else {
                    header.remove(value.trim());
                }
                ++n;
            }
            header.remove(HeaderName.Connection);
            if (isClose) {
                header.set(HeaderName.Connection, Close);
            }
        }
        if (header.containsKey(HeaderName.ProxyConnection)) {
            String[] stringArray = header.get(HeaderName.ProxyConnection).split(",");
            n = stringArray.length;
            int n3 = 0;
            while (n3 < n) {
                String value = stringArray[n3];
                header.remove(value.trim());
                ++n3;
            }
            header.remove(HeaderName.ProxyConnection);
        }
        header.add(HeaderName.Via, String.format(VIA_FORMAT, this.version, this.name));
        LOGGER.exiting("cleanHeader");
    }
}

