/*
 * Decompiled with CFR 0.152.
 */
package nor.http.server.rest;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Logger;
import nor.http.ContentType;
import nor.http.HeaderName;
import nor.http.HttpHeader;
import nor.http.HttpRequest;
import nor.http.HttpResponse;
import nor.http.Status;
import nor.http.error.HttpException;
import nor.http.error.NotFoundException;
import nor.http.server.rest.Resource;

public class FileResource
extends Resource {
    private final String name;
    private final File file;
    private final ContentType type;
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss zzz", Locale.US);
    private static final Logger LOGGER = Logger.getLogger(FileResource.class.getName());

    public FileResource(String name, File file, ContentType type) {
        LOGGER.entering(FileResource.class.getName(), "<init>", new Object[]{name, file, type});
        assert (name != null);
        assert (file != null);
        assert (type != null);
        this.name = name;
        this.file = file;
        this.type = type;
        LOGGER.exiting(FileResource.class.getName(), "<init>");
    }

    public FileResource(String name, File file, String type) {
        this(name, file, new ContentType(type));
    }

    public FileResource(String name, String file, ContentType type) {
        this(name, new File(file), type);
    }

    public FileResource(String name, String file, String type) {
        this(name, new File(file), new ContentType(type));
    }

    public FileResource(File file, ContentType type) {
        this(file.getName(), file, type);
    }

    public FileResource(File file, String type) {
        this(file.getName(), file, new ContentType(type));
    }

    public FileResource(String file, ContentType type) {
        LOGGER.entering(FileResource.class.getName(), "<init>", new Object[]{file, type});
        assert (file != null);
        assert (type != null);
        this.file = new File(file);
        this.name = this.file.getName();
        this.type = type;
        LOGGER.exiting(FileResource.class.getName(), "<init>");
    }

    public FileResource(String file, String type) {
        this(file, new ContentType(type));
    }

    @Override
    public HttpResponse toGet(String path, HttpRequest request) throws HttpException {
        LOGGER.entering(FileResource.class.getName(), "toGet", new Object[]{path, request});
        assert (path != null);
        assert (request != null);
        HttpResponse ret = null;
        if (this.file.canRead()) {
            try {
                ret = request.createResponse(Status.OK, new FileInputStream(this.file));
                HttpHeader header = ret.getHeader();
                header.add(HeaderName.ContentType, this.type.toString());
                header.add(HeaderName.LastModified, DATE_FORMAT.format(new Date(this.file.lastModified())));
                header.add(HeaderName.Server, System.getProperty("app.name"));
                header.add(HeaderName.ContentLength, Long.toString(this.file.length()));
                header.add(HeaderName.Date, DATE_FORMAT.format(Calendar.getInstance().getTime()));
            }
            catch (FileNotFoundException e) {
                throw new NotFoundException();
            }
        }
        if (ret == null) {
            throw new NotFoundException();
        }
        LOGGER.exiting(FileResource.class.getName(), "toGet", ret);
        return ret;
    }

    @Override
    public String getName() {
        LOGGER.entering(FileResource.class.getName(), "getName");
        String ret = this.name;
        LOGGER.exiting(FileResource.class.getName(), "getName", ret);
        return ret;
    }
}

