/*
 * Decompiled with CFR 0.152.
 */
package nor.http.server.rest;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import nor.http.ContentType;
import nor.http.HeaderName;
import nor.http.HttpHeader;
import nor.http.HttpRequest;
import nor.http.HttpResponse;
import nor.http.Status;

public class SimpleResponseBuilder {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss zzz", Locale.US);

    public static HttpResponse create(HttpRequest request, String body, ContentType contentType) {
        HttpResponse ret = request.createResponse(Status.OK, body);
        HttpHeader header = ret.getHeader();
        header.add(HeaderName.ContentType, contentType.toString());
        header.add(HeaderName.LastModified, DATE_FORMAT.format(Calendar.getInstance().getTime()));
        header.add(HeaderName.Server, System.getProperty("app.name"));
        header.add(HeaderName.ContentLength, Integer.toString(body.getBytes().length));
        header.add(HeaderName.Date, DATE_FORMAT.format(Calendar.getInstance().getTime()));
        return ret;
    }

    public static HttpResponse create(HttpRequest request) {
        HttpResponse ret = request.createResponse(Status.OK);
        HttpHeader header = ret.getHeader();
        header.add(HeaderName.LastModified, DATE_FORMAT.format(Calendar.getInstance().getTime()));
        header.add(HeaderName.Server, System.getProperty("app.name"));
        header.add(HeaderName.Date, DATE_FORMAT.format(Calendar.getInstance().getTime()));
        header.add(HeaderName.Connection, "close");
        return ret;
    }
}

